/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDAxisPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDBar;
import fr.esrf.tangoatk.widget.util.jdraw.JDBarPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDBrowserPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipsePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDExtensionPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDGlobalPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroupEditorView;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDImagePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabelPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDLinePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDObjectPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolylinePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectanglePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDSlider;
import fr.esrf.tangoatk.widget.util.jdraw.JDSliderPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDTransformPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueMappingPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDValuePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueProgram;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JDUtils {
    static boolean modified;
    private static Insets bMargin;
    private static Insets zMargin;
    private static Class theClass;
    static Font labelFont;
    static Font labelFontBold;
    static Color labelColor;
    private static JDialog nonModalPropDlg;
    private static JDrawEditor lastInvoker;
    private static Component lastSelectedPanel;
    private static boolean updatingProp;
    private static JTabbedPane innerPane;
    private static JDObjectPanel objectPanel;
    private static JDLabelPanel labelPanel;
    private static JDLinePanel linePanel;
    private static JDPolylinePanel polylinePanel;
    private static JDEllipsePanel ellipsePanel;
    private static JDRoundRectanglePanel roundRectanglePanel;
    private static JDImagePanel imagePanel;
    private static JDSwingPanel swingPanel;
    private static JDAxisPanel axisPanel;
    private static JDBarPanel barPanel;
    private static JDSliderPanel sliderPanel;
    private static JDValuePanel valuePanel;
    private static JDExtensionPanel extensionPanel;

    JDUtils() {
    }

    private static void init() {
        block2: {
            if (theClass != null) break block2;
            String string = "fr.esrf.tangoatk.widget.util.jdraw.JDUtils";
            try {
                theClass = Class.forName(string);
            }
            catch (Exception exception) {
                System.out.println("JDUtils.init() Class not found: " + string);
            }
        }
    }

    private static JDialog buildDialog(JComponent jComponent, boolean bl) {
        Container container = jComponent.getRootPane().getParent();
        JDialog jDialog = container instanceof JDialog ? new JDialog((Dialog)((JDialog)container), bl) : (container instanceof JFrame ? new JDialog((Frame)((JFrame)container), bl) : new JDialog((Frame)null, bl));
        return jDialog;
    }

    private static JDialog buildModalDialog(JComponent jComponent) {
        return JDUtils.buildDialog(jComponent, true);
    }

    public static void updatePropertyDialog(Vector vector) {
        Object object;
        if (nonModalPropDlg == null) {
            return;
        }
        if (vector.size() == 0) {
            nonModalPropDlg.setTitle("Properties [None selected]");
            objectPanel.updatePanel(null);
            labelPanel.updatePanel(null);
            linePanel.updatePanel(null);
            polylinePanel.updatePanel(null);
            ellipsePanel.updatePanel(null);
            roundRectanglePanel.updatePanel(null);
            imagePanel.updatePanel(null);
            swingPanel.updatePanel(null);
            axisPanel.updatePanel(null);
            barPanel.updatePanel(null);
            valuePanel.updatePanel(null);
            extensionPanel.updatePanel(null);
            return;
        }
        updatingProp = true;
        JDObject[] jDObjectArray = new JDObject[vector.size()];
        boolean bl = true;
        int n = 1;
        jDObjectArray[0] = (JDObject)vector.get(0);
        Class<?> clazz = jDObjectArray[0].getClass();
        n = 1;
        while (n < jDObjectArray.length) {
            jDObjectArray[n] = (JDObject)vector.get(n);
            bl &= clazz.equals(jDObjectArray[n].getClass());
            ++n;
        }
        innerPane.removeAll();
        innerPane.add((Component)objectPanel, "Graphics");
        objectPanel.updatePanel(jDObjectArray);
        if (bl && jDObjectArray[0] instanceof JDLabel) {
            object = new JDLabel[jDObjectArray.length];
            n = 0;
            while (n < jDObjectArray.length) {
                object[n] = (JDLabel)jDObjectArray[n];
                ++n;
            }
            labelPanel.updatePanel((JDLabel[])object);
            innerPane.add((Component)labelPanel, "Text");
        }
        if (bl && jDObjectArray[0] instanceof JDLine) {
            object = new JDLine[jDObjectArray.length];
            n = 0;
            while (n < jDObjectArray.length) {
                object[n] = (JDLine)jDObjectArray[n];
                ++n;
            }
            linePanel.updatePanel((JDLine[])object);
            innerPane.add((Component)linePanel, "Line");
        }
        if (bl && jDObjectArray[0] instanceof JDPolyline) {
            object = new JDPolyline[jDObjectArray.length];
            n = 0;
            while (n < jDObjectArray.length) {
                object[n] = (JDPolyline)jDObjectArray[n];
                ++n;
            }
            polylinePanel.updatePanel((JDPolyline[])object);
            innerPane.add((Component)polylinePanel, "Polyline");
        }
        if (bl && jDObjectArray[0] instanceof JDEllipse) {
            object = new JDEllipse[jDObjectArray.length];
            n = 0;
            while (n < jDObjectArray.length) {
                object[n] = (JDEllipse)jDObjectArray[n];
                ++n;
            }
            ellipsePanel.updatePanel((JDEllipse[])object);
            innerPane.add((Component)ellipsePanel, "Ellipse");
        }
        if (bl && jDObjectArray[0] instanceof JDRoundRectangle) {
            object = new JDRoundRectangle[jDObjectArray.length];
            n = 0;
            while (n < jDObjectArray.length) {
                object[n] = (JDRoundRectangle)jDObjectArray[n];
                ++n;
            }
            roundRectanglePanel.updatePanel((JDRoundRectangle[])object);
            innerPane.add((Component)roundRectanglePanel, "Corner");
        }
        if (bl && jDObjectArray[0] instanceof JDImage) {
            object = new JDImage[jDObjectArray.length];
            n = 0;
            while (n < jDObjectArray.length) {
                object[n] = (JDImage)jDObjectArray[n];
                ++n;
            }
            imagePanel.updatePanel((JDImage[])object);
            innerPane.add((Component)imagePanel, "Image");
        }
        if (bl && jDObjectArray[0] instanceof JDSwingObject) {
            object = new JDSwingObject[jDObjectArray.length];
            n = 0;
            while (n < jDObjectArray.length) {
                object[n] = (JDSwingObject)jDObjectArray[n];
                ++n;
            }
            swingPanel.updatePanel((JDSwingObject[])object);
            innerPane.add((Component)swingPanel, "Swing");
        }
        if (bl && jDObjectArray[0] instanceof JDAxis) {
            object = new JDAxis[jDObjectArray.length];
            n = 0;
            while (n < jDObjectArray.length) {
                object[n] = (JDAxis)jDObjectArray[n];
                ++n;
            }
            axisPanel.updatePanel((JDAxis[])object);
            innerPane.add((Component)axisPanel, "Axis");
        }
        if (bl && jDObjectArray[0] instanceof JDBar) {
            object = new JDBar[jDObjectArray.length];
            n = 0;
            while (n < jDObjectArray.length) {
                object[n] = (JDBar)jDObjectArray[n];
                ++n;
            }
            barPanel.updatePanel((JDBar[])object);
            innerPane.add((Component)barPanel, "Bar");
        }
        if (bl && jDObjectArray[0] instanceof JDSlider) {
            object = new JDSlider[jDObjectArray.length];
            n = 0;
            while (n < jDObjectArray.length) {
                object[n] = (JDSlider)jDObjectArray[n];
                ++n;
            }
            sliderPanel.updatePanel((JDSlider[])object);
            innerPane.add((Component)sliderPanel, "Slider");
        }
        valuePanel.updatePanel(jDObjectArray);
        innerPane.add((Component)valuePanel, "Value");
        extensionPanel.updatePanel(jDObjectArray);
        innerPane.add((Component)extensionPanel, "Extensions");
        object = "Properties";
        JDObject jDObject = (JDObject)vector.get(0);
        object = bl ? (String)object + " [" + vector.size() + " " + jDObject.toString() + " selected]" : (String)object + " [" + vector.size() + " objects selected]";
        nonModalPropDlg.setTitle((String)object);
        try {
            innerPane.setSelectedComponent(lastSelectedPanel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        innerPane.getSelectedComponent().setVisible(true);
        updatingProp = false;
    }

    public static void showPropertyDialog(JDrawEditor jDrawEditor, Vector vector) {
        if (nonModalPropDlg != null && lastInvoker != jDrawEditor) {
            nonModalPropDlg.dispose();
            nonModalPropDlg = null;
        }
        if (nonModalPropDlg == null) {
            nonModalPropDlg = JDUtils.buildDialog(jDrawEditor, false);
            lastInvoker = jDrawEditor;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            jPanel2.setLayout(flowLayout);
            JButton jButton = new JButton("Dismiss");
            jButton.setFont(labelFont);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    nonModalPropDlg.setVisible(false);
                }
            });
            jPanel2.add(jButton);
            jPanel.add((Component)jPanel2, "South");
            innerPane = new JTabbedPane();
            objectPanel = new JDObjectPanel(null, jDrawEditor, null);
            labelPanel = new JDLabelPanel(null, jDrawEditor);
            linePanel = new JDLinePanel(null, jDrawEditor);
            polylinePanel = new JDPolylinePanel(null, jDrawEditor);
            ellipsePanel = new JDEllipsePanel(null, jDrawEditor);
            roundRectanglePanel = new JDRoundRectanglePanel(null, jDrawEditor);
            imagePanel = new JDImagePanel(null, jDrawEditor);
            swingPanel = new JDSwingPanel(null, jDrawEditor);
            axisPanel = new JDAxisPanel(null, jDrawEditor);
            barPanel = new JDBarPanel(null, jDrawEditor);
            sliderPanel = new JDSliderPanel(null, jDrawEditor);
            valuePanel = new JDValuePanel(null, jDrawEditor, null);
            extensionPanel = new JDExtensionPanel(null, jDrawEditor);
            jPanel.add((Component)innerPane, "Center");
            nonModalPropDlg.setContentPane(jPanel);
            nonModalPropDlg.setResizable(false);
            innerPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (innerPane.getSelectedComponent() != null && !updatingProp) {
                        lastSelectedPanel = innerPane.getSelectedComponent();
                    }
                }
            });
        }
        JDUtils.updatePropertyDialog(vector);
        if (!nonModalPropDlg.isVisible()) {
            ATKGraphicsUtils.centerDialog(nonModalPropDlg);
        }
        nonModalPropDlg.setVisible(true);
    }

    public static boolean showBrowserDialog(JDrawEditor jDrawEditor, Vector vector) {
        if (vector.size() == 0) {
            return false;
        }
        if (nonModalPropDlg != null) {
            nonModalPropDlg.setVisible(false);
        }
        JDialog jDialog = JDUtils.buildModalDialog(jDrawEditor);
        JDObject[] jDObjectArray = new JDObject[vector.size()];
        int n = 0;
        while (n < jDObjectArray.length) {
            jDObjectArray[n] = (JDObject)vector.get(n);
            ++n;
        }
        JDBrowserPanel jDBrowserPanel = new JDBrowserPanel(jDObjectArray, jDrawEditor);
        jDialog.setContentPane(jDBrowserPanel);
        jDBrowserPanel.postInit();
        ATKGraphicsUtils.centerDialog(jDialog);
        jDialog.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                JDialog jDialog = (JDialog)componentEvent.getSource();
                jDialog.setSize(Math.max(460, jDialog.getWidth()), Math.max(400, jDialog.getHeight()));
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        modified = false;
        jDialog.setVisible(true);
        jDialog.dispose();
        jDrawEditor.unselectAll();
        jDrawEditor.selectObjects(jDObjectArray);
        jDrawEditor.fireSelectionChange();
        return modified;
    }

    public static boolean showGroupEditorDialog(JDrawEditor jDrawEditor, JDGroup jDGroup) {
        if (nonModalPropDlg != null) {
            nonModalPropDlg.setVisible(false);
        }
        JDialog jDialog = JDUtils.buildModalDialog(jDrawEditor);
        JDGroupEditorView jDGroupEditorView = new JDGroupEditorView(jDGroup, jDrawEditor);
        jDialog.setContentPane(jDGroupEditorView);
        jDialog.setTitle("Group Editor [" + jDGroup.getName() + "]");
        jDialog.setResizable(true);
        ATKGraphicsUtils.centerDialog(jDialog);
        jDialog.setVisible(true);
        jDialog.dispose();
        return modified;
    }

    public static boolean showTransformDialog(JComponent jComponent, Vector vector) {
        if (vector.size() == 0) {
            return false;
        }
        if (nonModalPropDlg != null) {
            nonModalPropDlg.setVisible(false);
        }
        JDialog jDialog = JDUtils.buildModalDialog(jComponent);
        JDObject[] jDObjectArray = new JDObject[vector.size()];
        int n = 0;
        while (n < jDObjectArray.length) {
            jDObjectArray[n] = (JDObject)vector.get(n);
            ++n;
        }
        jDialog.setContentPane(new JDTransformPanel(jDObjectArray, jComponent));
        String string = "Transformation";
        JDObject jDObject = (JDObject)vector.get(0);
        if (vector.size() == 1) {
            string = string + ": " + jDObject.getName();
        }
        jDialog.setTitle(string);
        ATKGraphicsUtils.centerDialog(jDialog);
        jDialog.setResizable(false);
        modified = false;
        jDialog.setVisible(true);
        jDialog.dispose();
        return modified;
    }

    public static boolean showGlobalDialog(JDrawEditor jDrawEditor) {
        if (nonModalPropDlg != null) {
            nonModalPropDlg.setVisible(false);
        }
        JDialog jDialog = JDUtils.buildModalDialog(jDrawEditor);
        jDialog.setContentPane(new JDGlobalPanel(jDrawEditor));
        String string = "Global graph properties";
        jDialog.setTitle(string);
        ATKGraphicsUtils.centerDialog(jDialog);
        jDialog.setResizable(false);
        modified = false;
        jDialog.setVisible(true);
        jDialog.dispose();
        return modified;
    }

    public static JDValueProgram showValueMappingDialog(JComponent jComponent, JDObject[] jDObjectArray, String string, int n, JDValueProgram jDValueProgram) {
        if (jDObjectArray.length == 0) {
            return null;
        }
        JDialog jDialog = JDUtils.buildModalDialog(jComponent);
        JDValueMappingPanel jDValueMappingPanel = new JDValueMappingPanel(jDObjectArray, jComponent, string, n, jDValueProgram);
        jDialog.setContentPane(jDValueMappingPanel);
        String string2 = "Mapping for " + string;
        string2 = string2 + " [" + jDObjectArray.length + " objects selected]";
        jDialog.setTitle(string2);
        ATKGraphicsUtils.centerDialog(jDialog);
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        jDialog.dispose();
        if (jDValueMappingPanel.hasChanged()) {
            return jDValueMappingPanel.getMapper();
        }
        return null;
    }

    static boolean showBooleanDialog(JComponent jComponent, String string, boolean bl) {
        JDialog jDialog = JDUtils.buildModalDialog(jComponent);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setFont(labelFont);
        jComboBox.addItem("False");
        jComboBox.addItem("True");
        jComboBox.setSelectedIndex(bl ? 1 : 0);
        jPanel.add(jComboBox);
        jComboBox.setBounds(10, 10, 150, 25);
        jPanel.setPreferredSize(new Dimension(170, 40));
        jDialog.setContentPane(jPanel);
        jDialog.setTitle(string);
        ATKGraphicsUtils.centerDialog(jDialog);
        jDialog.setVisible(true);
        jDialog.dispose();
        return jComboBox.getSelectedIndex() == 1;
    }

    static int showIntegerDialog(JComponent jComponent, String string, int n) {
        int n2;
        block2: {
            String string2 = JOptionPane.showInputDialog(jComponent, "Integer value", string, 1);
            n2 = n;
            if (string2 == null) break block2;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {}
        }
        return n2;
    }

    public static Point getTopLeftCorner(JDObject[] jDObjectArray) {
        int n = 65536;
        int n2 = 65536;
        int n3 = 0;
        while (n3 < jDObjectArray.length) {
            Rectangle rectangle = jDObjectArray[n3].getBoundRect();
            if (rectangle.x < n) {
                n = rectangle.x;
            }
            if (rectangle.y < n2) {
                n2 = rectangle.y;
            }
            ++n3;
        }
        return new Point(n, n2);
    }

    public static Point getTopLeftCorner(Vector vector) {
        int n = 65536;
        int n2 = 65536;
        int n3 = 0;
        while (n3 < vector.size()) {
            Rectangle rectangle = ((JDObject)vector.get(n3)).getBoundRect();
            if (rectangle.x < n) {
                n = rectangle.x;
            }
            if (rectangle.y < n2) {
                n2 = rectangle.y;
            }
            ++n3;
        }
        return new Point(n, n2);
    }

    public static Point getCenter(Vector vector) {
        int n = 65536;
        int n2 = 65536;
        int n3 = -65536;
        int n4 = -65536;
        int n5 = 0;
        while (n5 < vector.size()) {
            Rectangle rectangle = ((JDObject)vector.get(n5)).getBoundRect();
            if (rectangle.x < n) {
                n = rectangle.x;
            }
            if (rectangle.x + rectangle.width > n3) {
                n3 = rectangle.x + rectangle.width;
            }
            if (rectangle.y < n2) {
                n2 = rectangle.y;
            }
            if (rectangle.y + rectangle.height > n4) {
                n4 = rectangle.y + rectangle.height;
            }
            ++n5;
        }
        return new Point((n + n3) / 2, (n2 + n4) / 2);
    }

    public static Point getCenter(JDObject[] jDObjectArray) {
        int n = 65536;
        int n2 = 65536;
        int n3 = -65536;
        int n4 = -65536;
        int n5 = 0;
        while (n5 < jDObjectArray.length) {
            Rectangle rectangle = jDObjectArray[n5].getBoundRect();
            if (rectangle.x < n) {
                n = rectangle.x;
            }
            if (rectangle.x + rectangle.width > n3) {
                n3 = rectangle.x + rectangle.width;
            }
            if (rectangle.y < n2) {
                n2 = rectangle.y;
            }
            if (rectangle.y + rectangle.height > n4) {
                n4 = rectangle.y + rectangle.height;
            }
            ++n5;
        }
        return new Point((n + n3) / 2, (n2 + n4) / 2);
    }

    public static Point getBottomRightCorner(Vector vector) {
        int n = -65536;
        int n2 = -65536;
        int n3 = 0;
        while (n3 < vector.size()) {
            Rectangle rectangle = ((JDObject)vector.get(n3)).getBoundRect();
            if (rectangle.x + rectangle.width > n) {
                n = rectangle.x + rectangle.width;
            }
            if (rectangle.y + rectangle.height > n2) {
                n2 = rectangle.y + rectangle.height;
            }
            ++n3;
        }
        return new Point(n, n2);
    }

    public static JButton createIconButton(String string, boolean bl, String string2, ActionListener actionListener) {
        JDUtils.init();
        if (theClass != null) {
            JButton jButton = new JButton(new ImageIcon(theClass.getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/" + string + ".gif")));
            jButton.setPressedIcon(new ImageIcon(theClass.getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/" + string + "_push.gif")));
            if (bl) {
                jButton.setDisabledIcon(new ImageIcon(theClass.getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/" + string + "_disa.gif")));
            }
            jButton.setToolTipText(string2);
            jButton.setMargin(bMargin);
            jButton.setBorder(null);
            jButton.addActionListener(actionListener);
            return jButton;
        }
        return new JButton(string);
    }

    public static JButton createSetButton(ActionListener actionListener) {
        JButton jButton = new JButton("...");
        jButton.setMargin(zMargin);
        jButton.setForeground(Color.BLACK);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        return jButton;
    }

    public static JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(labelFont);
        jLabel.setForeground(labelColor);
        return jLabel;
    }

    public static Border createTitleBorder(String string) {
        return BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string, 1, 0, labelFontBold, labelColor);
    }

    public static JCheckBox createCheckBox(String string, ActionListener actionListener) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setFont(labelFont);
        jCheckBox.setForeground(labelColor);
        if (actionListener != null) {
            jCheckBox.addActionListener(actionListener);
        }
        return jCheckBox;
    }

    static String buildFontName(Font font) {
        String string = font.getName();
        String string2 = Integer.toString(font.getSize());
        String string3 = "";
        switch (font.getStyle()) {
            case 0: {
                string3 = "Plain";
                break;
            }
            case 2: {
                string3 = "Italic";
                break;
            }
            case 1: {
                string3 = "Bold";
                break;
            }
            case 3: {
                string3 = "Italic Bold";
            }
        }
        return string + "," + string3 + "," + string2;
    }

    static String[] makeStringArray(String string) {
        while (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string.split("\n");
    }

    static String buildShortClassName(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    static void computeSpline(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, int n, boolean bl, int n2, Vector vector, int[] nArray, int[] nArray2) {
        double d9 = 1.0 / (double)n;
        double d10 = 0.0;
        int n3 = 0;
        while (n3 <= n) {
            double d11 = d10 * d10;
            double d12 = d11 * d10;
            double d13 = (1.0 - 3.0 * d10 + 3.0 * d11 - d12) * d + 3.0 * (d10 - 2.0 * d11 + d12) * d3 + 3.0 * (d11 - d12) * d5 + d12 * d7;
            double d14 = (1.0 - 3.0 * d10 + 3.0 * d11 - d12) * d2 + 3.0 * (d10 - 2.0 * d11 + d12) * d4 + 3.0 * (d11 - d12) * d6 + d12 * d8;
            if (bl || n3 < n) {
                if (vector != null) {
                    double[] dArray = new double[]{(int)(d13 + 0.5), (int)(d14 + 0.5)};
                    vector.add(dArray);
                } else {
                    nArray[n2 + n3] = (int)(d13 + 0.5);
                    nArray2[n2 + n3] = (int)(d14 + 0.5);
                }
            }
            d10 += d9;
            ++n3;
        }
    }

    static {
        bMargin = new Insets(3, 3, 3, 3);
        zMargin = new Insets(0, 0, 0, 0);
        theClass = null;
        labelFont = new Font("Dialog", 0, 12);
        labelFontBold = new Font("Dialog", 1, 12);
        labelColor = new Color(85, 87, 140);
        nonModalPropDlg = null;
        lastInvoker = null;
        lastSelectedPanel = null;
        updatingProp = false;
        innerPane = null;
        objectPanel = null;
        labelPanel = null;
        linePanel = null;
        polylinePanel = null;
        ellipsePanel = null;
        roundRectanglePanel = null;
        imagePanel = null;
        swingPanel = null;
        axisPanel = null;
        barPanel = null;
        sliderPanel = null;
        valuePanel = null;
        extensionPanel = null;
    }
}

