/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JDPolylinePanel
extends JPanel
implements ActionListener,
ChangeListener {
    JCheckBox closedCheckBox;
    private JLabel stepLabel;
    private JSpinner stepSpinner;
    private JDPolyline[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDPolylinePanel(JDPolyline[] jDPolylineArray, JDrawEditor jDrawEditor) {
        this.invoker = jDrawEditor;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel jPanel = new JPanel(null);
        jPanel.setBorder(JDUtils.createTitleBorder("Polyline"));
        jPanel.setBounds(5, 5, 370, 85);
        this.closedCheckBox = new JCheckBox("Closed");
        this.closedCheckBox.setFont(JDUtils.labelFont);
        this.closedCheckBox.setBounds(5, 20, 100, 24);
        this.closedCheckBox.addActionListener(this);
        jPanel.add(this.closedCheckBox);
        this.stepLabel = new JLabel("Interpolation step");
        this.stepLabel.setFont(JDUtils.labelFont);
        this.stepLabel.setForeground(JDUtils.labelColor);
        this.stepLabel.setBounds(10, 50, 100, 25);
        jPanel.add(this.stepLabel);
        this.stepSpinner = new JSpinner();
        this.stepSpinner.addChangeListener(this);
        this.stepSpinner.setBounds(115, 50, 60, 25);
        jPanel.add(this.stepSpinner);
        this.add(jPanel);
        this.updatePanel(jDPolylineArray);
    }

    public void updatePanel(JDPolyline[] jDPolylineArray) {
        this.allObjects = jDPolylineArray;
        this.isUpdating = true;
        if (jDPolylineArray == null || jDPolylineArray.length <= 0) {
            this.closedCheckBox.setSelected(false);
            this.stepSpinner.setModel(new SpinnerNumberModel(0, 0, 0, 0));
        } else {
            JDPolyline jDPolyline = jDPolylineArray[0];
            this.closedCheckBox.setSelected(jDPolyline.isClosed());
            Integer n = new Integer(jDPolyline.getStep());
            Integer n2 = new Integer(1);
            Integer n3 = new Integer(256);
            Integer n4 = new Integer(1);
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
            this.stepSpinner.setModel(spinnerNumberModel);
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        int n = 1;
        while (n < this.allObjects.length) {
            this.oldRect = this.oldRect.union(this.allObjects[n].getRepaintRect());
            ++n;
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle rectangle = this.allObjects[0].getRepaintRect();
        int n = 1;
        while (n < this.allObjects.length) {
            rectangle = rectangle.union(this.allObjects[n].getRepaintRect());
            ++n;
        }
        this.invoker.repaint(rectangle.union(this.oldRect));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object object = actionEvent.getSource();
        if (object == this.closedCheckBox) {
            int n = 0;
            while (n < this.allObjects.length) {
                this.allObjects[n].setClosed(this.closedCheckBox.isSelected());
                ++n;
            }
            this.invoker.setNeedToSave(true, "Change closed");
        }
        this.repaintObjects();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object object = changeEvent.getSource();
        if (object == this.stepSpinner) {
            Integer n = (Integer)this.stepSpinner.getValue();
            int n2 = 0;
            while (n2 < this.allObjects.length) {
                this.allObjects[n2].setStep(n);
                ++n2;
            }
            this.invoker.setNeedToSave(true, "Change step");
        }
        this.repaintObjects();
    }
}

