/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDAxisPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDBar;
import fr.esrf.tangoatk.widget.util.jdraw.JDBarPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipsePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDExtensionPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDImagePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabelPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDLinePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDObjectPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolylinePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectanglePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDTreeNode;
import fr.esrf.tangoatk.widget.util.jdraw.JDTreeNodeRenderer;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDValuePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class JDBrowserPanel
extends JPanel
implements TreeSelectionListener,
ActionListener {
    private JDObject[] allObjects;
    private JDrawEditor invoker;
    private JTree theTree;
    private JScrollPane treeView;
    private JDTreeNode rootNode;
    private DefaultTreeModel mainTreeModel;
    private JDTreeNodeRenderer treeRenderer;
    private JDTreeNode selectedNode;
    private JPanel btnPanel;
    private JButton dismissBtn;
    private JTabbedPane tabbedPane;
    private JDObjectPanel objectPanel;
    private JDValuePanel valuePanel;
    private JDExtensionPanel extensionPanel;
    private JDLabelPanel labelPanel;
    private JDLinePanel linePanel;
    private JDPolylinePanel polylinePanel;
    private JDEllipsePanel ellipsePanel;
    private JDRoundRectanglePanel roundRectanglePanel;
    private JDImagePanel imagePanel;
    private JDSwingPanel swingPanel;
    private JDAxisPanel axisPanel;
    private JDBarPanel barPanel;
    private Component lastSelectedPanel = null;
    private boolean updatingProp = false;

    public JDBrowserPanel(JDObject[] jDObjectArray, JDrawEditor jDrawEditor) {
        this.setLayout(new BorderLayout());
        this.allObjects = jDObjectArray;
        this.invoker = jDrawEditor;
        this.rootNode = new JDTreeNode();
        this.selectedNode = null;
        int n = 0;
        while (n < this.allObjects.length) {
            this.rootNode.add(new JDTreeNode(this.allObjects[n]));
            ++n;
        }
        this.mainTreeModel = new DefaultTreeModel(this.rootNode);
        this.treeRenderer = new JDTreeNodeRenderer();
        this.theTree = new JTree(this.mainTreeModel);
        this.theTree.setCellRenderer(this.treeRenderer);
        this.theTree.setEditable(false);
        this.theTree.getSelectionModel().setSelectionMode(1);
        this.theTree.setShowsRootHandles(false);
        this.theTree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeView = new JScrollPane(this.theTree);
        this.treeView.setMinimumSize(new Dimension(20, 290));
        this.add((Component)this.treeView, "Center");
        this.tabbedPane = new JTabbedPane();
        this.objectPanel = new JDObjectPanel(null, this.invoker, this);
        this.valuePanel = new JDValuePanel(null, this.invoker, this);
        this.extensionPanel = new JDExtensionPanel(null, this.invoker);
        this.labelPanel = new JDLabelPanel(null, this.invoker);
        this.linePanel = new JDLinePanel(null, this.invoker);
        this.polylinePanel = new JDPolylinePanel(null, this.invoker);
        this.ellipsePanel = new JDEllipsePanel(null, this.invoker);
        this.roundRectanglePanel = new JDRoundRectanglePanel(null, this.invoker);
        this.imagePanel = new JDImagePanel(null, this.invoker);
        this.swingPanel = new JDSwingPanel(null, this.invoker);
        this.axisPanel = new JDAxisPanel(null, this.invoker);
        this.barPanel = new JDBarPanel(null, this.invoker);
        this.tabbedPane.add((Component)this.objectPanel, "Graphics");
        this.tabbedPane.add((Component)this.valuePanel, "Value");
        this.tabbedPane.add((Component)this.extensionPanel, "Extensions");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (JDBrowserPanel.this.tabbedPane.getSelectedComponent() != null && !JDBrowserPanel.this.updatingProp) {
                    JDBrowserPanel.this.lastSelectedPanel = JDBrowserPanel.this.tabbedPane.getSelectedComponent();
                }
            }
        });
        this.add((Component)this.tabbedPane, "East");
        this.btnPanel = new JPanel();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(2);
        this.btnPanel.setLayout(flowLayout);
        this.dismissBtn = new JButton("Dismiss");
        this.dismissBtn.setFont(JDUtils.labelFont);
        this.dismissBtn.addActionListener(this);
        this.btnPanel.add(this.dismissBtn);
        this.add((Component)this.btnPanel, "South");
    }

    public void postInit() {
        this.theTree.addTreeSelectionListener(this);
        this.theTree.setSelectionRow(1);
    }

    public void updateNode() {
        if (this.selectedNode != null) {
            this.mainTreeModel.nodeChanged(this.selectedNode);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.dismissBtn) {
            ATKGraphicsUtils.getWindowForComponent(this).setVisible(false);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        if (treePath != null) {
            this.updatingProp = true;
            JDTreeNode jDTreeNode = (JDTreeNode)treePath.getLastPathComponent();
            this.invoker.unselectAll();
            this.invoker.selectObject(jDTreeNode.getObject());
            JDObject jDObject = jDTreeNode.getObject();
            if (jDObject != null) {
                Object object;
                this.tabbedPane.removeAll();
                this.tabbedPane.add((Component)this.objectPanel, "Graphics");
                JDObject[] jDObjectArray = new JDObject[]{jDObject};
                this.objectPanel.updatePanel(jDObjectArray);
                this.valuePanel.updatePanel(jDObjectArray);
                this.extensionPanel.updatePanel(jDObjectArray);
                if (jDObject instanceof JDLabel) {
                    object = new JDLabel[]{(JDLabel)jDObject};
                    this.labelPanel.updatePanel((JDLabel[])object);
                    this.tabbedPane.add((Component)this.labelPanel, "Text");
                }
                if (jDObject instanceof JDLine) {
                    object = new JDLine[]{(JDLine)jDObject};
                    this.linePanel.updatePanel((JDLine[])object);
                    this.tabbedPane.add((Component)this.linePanel, "Line");
                }
                if (jDObject instanceof JDPolyline) {
                    object = new JDPolyline[]{(JDPolyline)jDObject};
                    this.polylinePanel.updatePanel((JDPolyline[])object);
                    this.tabbedPane.add((Component)this.polylinePanel, "Polyline");
                }
                if (jDObject instanceof JDEllipse) {
                    object = new JDEllipse[]{(JDEllipse)jDObject};
                    this.ellipsePanel.updatePanel((JDEllipse[])object);
                    this.tabbedPane.add((Component)this.ellipsePanel, "Ellipse");
                }
                if (jDObject instanceof JDRoundRectangle) {
                    object = new JDRoundRectangle[]{(JDRoundRectangle)jDObject};
                    this.roundRectanglePanel.updatePanel((JDRoundRectangle[])object);
                    this.tabbedPane.add((Component)this.roundRectanglePanel, "Corner");
                }
                if (jDObject instanceof JDImage) {
                    object = new JDImage[]{(JDImage)jDObject};
                    this.imagePanel.updatePanel((JDImage[])object);
                    this.tabbedPane.add((Component)this.imagePanel, "Image");
                }
                if (jDObject instanceof JDSwingObject) {
                    object = new JDSwingObject[]{(JDSwingObject)jDObject};
                    this.swingPanel.updatePanel((JDSwingObject[])object);
                    this.tabbedPane.add((Component)this.swingPanel, "Swing");
                }
                if (jDObject instanceof JDAxis) {
                    object = new JDAxis[]{(JDAxis)jDObject};
                    this.axisPanel.updatePanel((JDAxis[])object);
                    this.tabbedPane.add((Component)this.axisPanel, "Axis");
                }
                if (jDObject instanceof JDBar) {
                    object = new JDBar[]{(JDBar)jDObject};
                    this.barPanel.updatePanel((JDBar[])object);
                    this.tabbedPane.add((Component)this.barPanel, "Bar");
                }
                this.tabbedPane.add((Component)this.valuePanel, "Value");
                this.tabbedPane.add((Component)this.extensionPanel, "Extensions");
                this.selectedNode = jDTreeNode;
                object = "Selection browser [" + jDObject + " " + jDObject.getName() + " selected]";
                ((JDialog)ATKGraphicsUtils.getWindowForComponent(this)).setTitle((String)object);
                try {
                    this.tabbedPane.setSelectedComponent(this.lastSelectedPanel);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                this.objectPanel.updatePanel(null);
                this.valuePanel.updatePanel(null);
                this.extensionPanel.updatePanel(null);
                this.labelPanel.updatePanel(null);
                this.linePanel.updatePanel(null);
                this.polylinePanel.updatePanel(null);
                this.ellipsePanel.updatePanel(null);
                this.roundRectanglePanel.updatePanel(null);
                this.imagePanel.updatePanel(null);
                this.swingPanel.updatePanel(null);
                this.axisPanel.updatePanel(null);
                this.selectedNode = null;
                String string = "Selection browser [none selected]";
                ((JDialog)ATKGraphicsUtils.getWindowForComponent(this)).setTitle(string);
            }
            this.tabbedPane.getSelectedComponent().setVisible(true);
            this.updatingProp = false;
        }
    }
}

