/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import fr.esrf.tangoatk.widget.util.interlock.NetEditor;
import fr.esrf.tangoatk.widget.util.interlock.NetObject;
import java.awt.Font;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class NetFileLoader {
    private static final int NUMBER = 1;
    private static final int STRING = 2;
    private static final int COMA = 3;
    private static final int COLON = 4;
    private static final int OPENBRACE = 5;
    private static final int CLOSEBRACE = 6;
    private static final int OPENBRACKET = 7;
    private static final int CLOSEBRACKET = 8;
    private static final int BUBBLE_KW = 9;
    private static final int TEXT_KW = 10;
    private static final int LABEL_KW = 11;
    private static final int CHILDREN_KW = 12;
    private static final int LABELOFFSET_KW = 13;
    private static final int JUSTIFY_KW = 14;
    private static final int EXTENSIONS_KW = 15;
    private static final int SIZE_KW = 16;
    private static final int SHAPE_KW = 17;
    private static final int EDSHAPE_KW = 18;
    private static final int FONT_KW = 19;
    private static final int NETFILE_KW = 20;
    private static final int GLOBALPARAM_KW = 21;
    private static final int LABELFONT_KW = 22;
    private static final int SMALLFONT_KW = 23;
    private static final int USEAAFONT_KW = 24;
    private static final int DRAWARROW_KW = 25;
    private final String[] lexical_word = new String[]{"NULL", "NUMBER", "STRING", ",", ":", "{", "}", "(", ")", "Bubble", "Text", "label", "children", "label_offset", "justify", "extensions", "size", "shape", "editable_shape", "font", "NetFile", "GlobalParam", "label_font", "small_font", "use_aa_font", "draw_arrow"};
    private FileReader f;
    private String fileName;
    private int CrtLine;
    private int StartLine;
    private char CurrentChar;
    private char NextChar;
    private boolean firstWarning;
    private int objIdx;
    private String word;
    private Font smallFont = NetEditor.defaultSmallFont;
    private Font labelFont = NetEditor.defaultLabelFont;
    private boolean useAAFont = false;
    private boolean drawArrow = true;

    public NetFileLoader(FileReader fileReader, String string) throws IOException {
        this.CrtLine = 1;
        this.NextChar = (char)32;
        this.CurrentChar = (char)32;
        this.firstWarning = true;
        this.fileName = string;
        this.f = fileReader;
    }

    public NetFileLoader(FileReader fileReader, String string, int n) throws IOException {
        this.CrtLine = n;
        this.NextChar = (char)32;
        this.CurrentChar = (char)32;
        this.firstWarning = true;
        this.fileName = string;
        this.f = fileReader;
    }

    private void read_char() throws IOException {
        this.CurrentChar = this.NextChar;
        this.NextChar = this.f.ready() ? (char)this.f.read() : (char)'\u0000';
        if (this.CurrentChar == '\n') {
            ++this.CrtLine;
        }
    }

    private void jump_space() throws IOException {
        while (this.CurrentChar <= ' ' && this.CurrentChar > '\u0000') {
            this.read_char();
        }
    }

    /*
     * Unable to fully structure code
     */
    private String read_word() throws IOException {
        var1_1 = new StringBuffer();
        this.jump_space();
        this.StartLine = this.CrtLine;
        if (this.CurrentChar == ':' || this.CurrentChar == '{' || this.CurrentChar == '}' || this.CurrentChar == ',' || this.CurrentChar == '(' || this.CurrentChar == ')') {
            var1_1.append(this.CurrentChar);
            this.read_char();
            return var1_1.toString();
        }
        if (this.CurrentChar != '\"') ** GOTO lbl24
        this.read_char();
        while (this.CurrentChar != '\"' && this.CurrentChar != '\u0000' && this.CurrentChar != '\n') {
            var1_1.append(this.CurrentChar);
            this.read_char();
        }
        if (this.CurrentChar == '\u0000' || this.CurrentChar == '\n') {
            var2_2 = new IOException("String too long at line " + this.StartLine);
            throw var2_2;
        }
        this.read_char();
        return var1_1.toString();
lbl-1000:
        // 1 sources

        {
            var1_1.append(this.CurrentChar);
            this.read_char();
lbl24:
            // 2 sources

            ** while (this.CurrentChar > ' ' && this.CurrentChar != '{' && this.CurrentChar != '}' && this.CurrentChar != ',' && this.CurrentChar != ':' && this.CurrentChar != '(' && this.CurrentChar != ')')
        }
lbl25:
        // 1 sources

        if (var1_1.length() == 0) {
            return null;
        }
        return var1_1.toString();
    }

    /*
     * Unable to fully structure code
     */
    private int class_lex(String var1_1) {
        var2_2 = 3;
        var3_3 = false;
        if (var1_1 == null) {
            return 0;
        }
        if (var1_1.length() != 0) ** GOTO lbl10
        return 2;
lbl-1000:
        // 1 sources

        {
            var3_3 = var1_1.equalsIgnoreCase(this.lexical_word[var2_2]);
            if (var3_3) continue;
            ++var2_2;
lbl10:
            // 3 sources

            ** while (var2_2 < this.lexical_word.length && !var3_3)
        }
lbl11:
        // 1 sources

        if (var3_3) {
            return var2_2;
        }
        var4_4 = var1_1.charAt(0);
        if (var4_4 >= '0' && var4_4 <= '9' || var4_4 == '-') {
            return 1;
        }
        return 2;
    }

    private void CHECK_LEX(int n, int n2) throws IOException {
        if (n != n2) {
            throw new IOException("Error at line " + this.StartLine + ", '" + this.lexical_word[n2] + "' expected");
        }
    }

    private void jump_lexem(int n) throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), n);
        this.word = this.read_word();
    }

    private int parseInteger() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 1);
        int n = 0;
        try {
            n = Integer.parseInt(this.word);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Invalid number at line " + this.StartLine);
        }
        this.word = this.read_word();
        return n;
    }

    private String parseParamString() throws IOException {
        String string = this.word;
        int n = this.class_lex(this.word);
        if (n != 2 && n != 1 && n < 9) {
            throw new IOException("Error at line " + this.StartLine + ", '" + this.lexical_word[1] + "' or '" + this.lexical_word[2] + "' expected");
        }
        this.word = this.read_word();
        return string;
    }

    private int[] parseIntegerList() throws IOException {
        boolean bl = false;
        Vector<Integer> vector = new Vector<Integer>();
        do {
            vector.add(new Integer(this.parseInteger()));
            boolean bl2 = bl = this.class_lex(this.word) != 3;
            if (bl) continue;
            this.word = this.read_word();
        } while (!bl);
        int[] nArray = new int[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            nArray[n] = (Integer)vector.get(n);
            ++n;
        }
        return nArray;
    }

    private String[] parseStringList() throws IOException {
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        do {
            vector.add(this.parseParamString());
            boolean bl2 = bl = this.class_lex(this.word) != 3;
            if (bl) continue;
            this.word = this.read_word();
        } while (!bl);
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.get(n);
            ++n;
        }
        return stringArray;
    }

    private Font parseFont() throws IOException {
        String string = this.word;
        this.word = this.read_word();
        this.jump_lexem(3);
        int n = this.parseInteger();
        this.jump_lexem(3);
        int n2 = this.parseInteger();
        return new Font(string, n, n2);
    }

    private void parseObjectExtension(NetObject netObject) throws IOException {
        int n = this.class_lex(this.word);
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        while (this.word != null && n != 6) {
            vector.add(this.parseParamString());
            this.jump_lexem(4);
            vector2.add(this.parseParamString());
            n = this.class_lex(this.word);
        }
        int n2 = vector.size();
        if (n2 > 0) {
            String[] stringArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                stringArray[n3] = (String)vector.get(n3);
                ++n3;
            }
            netObject.setExtensionList(stringArray);
            n3 = 0;
            while (n3 < n2) {
                netObject.setExtendedParam(n3, (String)vector2.get(n3));
                ++n3;
            }
        }
    }

    private void parseObjectParam(NetObject netObject) throws IOException {
        int n = this.class_lex(this.word);
        while (this.word != null && n != 6) {
            switch (n) {
                case 11: {
                    this.jump_lexem(11);
                    this.jump_lexem(4);
                    netObject.setLabel(this.parseStringList());
                    break;
                }
                case 13: {
                    this.jump_lexem(13);
                    this.jump_lexem(4);
                    int[] nArray = this.parseIntegerList();
                    if (nArray.length != 2) {
                        throw new IOException("Error at line " + this.StartLine + ", 2 values expected for label_offset");
                    }
                    netObject.labelOffset.x = nArray[0];
                    netObject.labelOffset.y = nArray[1];
                    break;
                }
                case 14: {
                    this.jump_lexem(14);
                    this.jump_lexem(4);
                    netObject.justify = this.parseInteger();
                    break;
                }
                case 16: {
                    this.jump_lexem(16);
                    this.jump_lexem(4);
                    netObject.bSize = this.parseInteger();
                    break;
                }
                case 17: {
                    this.jump_lexem(17);
                    this.jump_lexem(4);
                    netObject.shape = this.parseInteger();
                    break;
                }
                case 18: {
                    this.jump_lexem(18);
                    this.jump_lexem(4);
                    netObject.editableShape = this.parseInteger() == 1;
                    break;
                }
                case 19: {
                    this.jump_lexem(19);
                    this.jump_lexem(4);
                    netObject.setTextFont(this.parseFont());
                    break;
                }
                case 12: {
                    this.jump_lexem(12);
                    this.jump_lexem(4);
                    netObject.setChildrenIdList(this.parseIntegerList());
                    break;
                }
                case 15: {
                    this.jump_lexem(15);
                    this.jump_lexem(5);
                    this.parseObjectExtension(netObject);
                    this.jump_lexem(6);
                    break;
                }
                default: {
                    if (n == 6) break;
                    this.warningMessage("Warning: Unknown param name '" + this.word + "' at line " + this.CrtLine + "... Ignoring.");
                    this.jump_lexem(2);
                    this.jump_lexem(4);
                    this.parseStringList();
                }
            }
            n = this.class_lex(this.word);
        }
    }

    private NetObject parseObject(int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        this.word = this.read_word();
        int n4 = this.parseInteger();
        this.jump_lexem(7);
        int n5 = this.parseInteger();
        this.jump_lexem(3);
        int n6 = this.parseInteger();
        this.jump_lexem(8);
        if (n == 1) {
            n2 = this.parseInteger();
            this.jump_lexem(3);
            n3 = this.parseInteger();
        }
        NetObject netObject = new NetObject(n, n4, n2, n3, n5, n6);
        netObject.setIndex(this.objIdx);
        ++this.objIdx;
        this.jump_lexem(5);
        this.parseObjectParam(netObject);
        this.jump_lexem(6);
        return netObject;
    }

    private void parseGlobalParam() throws IOException {
        this.jump_lexem(21);
        this.jump_lexem(5);
        int n = this.class_lex(this.word);
        while (this.word != null && n != 6) {
            switch (n) {
                case 22: {
                    this.jump_lexem(22);
                    this.jump_lexem(4);
                    this.labelFont = this.parseFont();
                    break;
                }
                case 23: {
                    this.jump_lexem(23);
                    this.jump_lexem(4);
                    this.smallFont = this.parseFont();
                    break;
                }
                case 24: {
                    this.jump_lexem(24);
                    this.jump_lexem(4);
                    this.useAAFont = this.parseInteger() == 1;
                    break;
                }
                case 25: {
                    this.jump_lexem(25);
                    this.jump_lexem(4);
                    this.drawArrow = this.parseInteger() == 1;
                    break;
                }
                default: {
                    if (n == 6) break;
                    this.warningMessage("Warning: Unknown global param name '" + this.word + "' at line " + this.CrtLine + "... Ignoring.");
                    this.jump_lexem(2);
                    this.jump_lexem(4);
                    this.parseStringList();
                }
            }
            n = this.class_lex(this.word);
        }
        this.jump_lexem(6);
    }

    public Vector parseNetFile() throws IOException {
        boolean bl = false;
        Vector<NetObject> vector = new Vector<NetObject>();
        this.objIdx = 0;
        this.word = this.read_word();
        if (this.word == null) {
            throw new IOException("File empty !");
        }
        int n = this.class_lex(this.word);
        if (n != 20) {
            throw new IOException("Invalid net file header !");
        }
        this.word = this.read_word();
        this.jump_lexem(2);
        this.jump_lexem(5);
        if (this.class_lex(this.word) == 21) {
            this.parseGlobalParam();
        }
        n = this.class_lex(this.word);
        while (!bl) {
            switch (n) {
                case 9: {
                    vector.add(this.parseObject(1));
                    break;
                }
                case 10: {
                    vector.add(this.parseObject(2));
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    throw new IOException("Invalid keyword at line " + this.StartLine);
                }
            }
            n = this.class_lex(this.word);
            boolean bl2 = bl = this.word == null || n == 6;
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file.");
        }
        this.CHECK_LEX(this.class_lex(this.word), 6);
        int n2 = 0;
        while (n2 < vector.size()) {
            NetObject netObject = (NetObject)vector.get(n2);
            int[] nArray = netObject.getChildrenIdList();
            if (nArray != null) {
                int n3 = 0;
                while (n3 < nArray.length) {
                    NetObject netObject2 = this.findFromIndex(vector, nArray[n3]);
                    if (netObject2 == null) {
                        throw new IOException("Invalid index '" + nArray[n3] + "' in children list of object #" + netObject.getIndex());
                    }
                    netObject.addChild(netObject2);
                    ++n3;
                }
            }
            ++n2;
        }
        return vector;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public Font getSmallFont() {
        return this.smallFont;
    }

    public boolean getUseAAFont() {
        return this.useAAFont;
    }

    public boolean getDrawArrow() {
        return this.drawArrow;
    }

    private void warningMessage(String string) {
        if (this.firstWarning) {
            System.out.println("Warning while parsing: " + this.fileName);
            this.firstWarning = false;
        }
        System.out.println(string);
    }

    private NetObject findFromIndex(Vector vector, int n) {
        int n2 = 0;
        int n3 = vector.size();
        boolean bl = false;
        NetObject netObject = null;
        while (n2 < n3 && !bl) {
            netObject = (NetObject)vector.get(n2);
            boolean bl2 = bl = netObject.getIndex() == n;
            if (bl) continue;
            ++n2;
        }
        if (bl) {
            return netObject;
        }
        return null;
    }
}

