/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import com.braju.format.Format;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import java.awt.Color;
import java.util.Vector;

public class JLDataView {
    public static final int MARKER_NONE = 0;
    public static final int MARKER_DOT = 1;
    public static final int MARKER_BOX = 2;
    public static final int MARKER_TRIANGLE = 3;
    public static final int MARKER_DIAMOND = 4;
    public static final int MARKER_STAR = 5;
    public static final int MARKER_VERT_LINE = 6;
    public static final int MARKER_HORIZ_LINE = 7;
    public static final int MARKER_CROSS = 8;
    public static final int MARKER_CIRCLE = 9;
    public static final int MARKER_SQUARE = 10;
    public static final int STYLE_SOLID = 0;
    public static final int STYLE_DOT = 1;
    public static final int STYLE_DASH = 2;
    public static final int STYLE_LONG_DASH = 3;
    public static final int STYLE_DASH_DOT = 4;
    public static final int TYPE_LINE = 0;
    public static final int TYPE_BAR = 1;
    public static final int METHOD_FILL_FROM_TOP = 0;
    public static final int METHOD_FILL_FROM_ZERO = 1;
    public static final int METHOD_FILL_FROM_BOTTOM = 2;
    public static final int FILL_STYLE_NONE = 0;
    public static final int FILL_STYLE_SOLID = 1;
    public static final int FILL_STYLE_LARGE_RIGHT_HATCH = 2;
    public static final int FILL_STYLE_LARGE_LEFT_HATCH = 3;
    public static final int FILL_STYLE_LARGE_CROSS_HATCH = 4;
    public static final int FILL_STYLE_SMALL_RIGHT_HATCH = 5;
    public static final int FILL_STYLE_SMALL_LEFT_HATCH = 6;
    public static final int FILL_STYLE_SMALL_CROSS_HATCH = 7;
    public static final int FILL_STYLE_DOT_PATTERN_1 = 8;
    public static final int FILL_STYLE_DOT_PATTERN_2 = 9;
    public static final int FILL_STYLE_DOT_PATTERN_3 = 10;
    private JLAxis parentAxis = null;
    private Color lineColor = Color.red;
    private Color fillColor = Color.lightGray;
    private Color markerColor = Color.red;
    private int lineStyle = 0;
    private int lineWidth = 1;
    private int markerType = 0;
    private int markerSize = 6;
    private int barWidth = 10;
    private int fillStyle = 0;
    private int fillMethod = 2;
    private int type = 0;
    private double A0 = 0.0;
    private double A1 = 1.0;
    private double A2 = 0.0;
    private DataList theData = null;
    private int dataLength = 0;
    private DataList theDataEnd = null;
    private double max = -1.7976931348623157E308;
    private double min = Double.MAX_VALUE;
    private String name = "";
    private String unit = "";
    private boolean clickable = true;
    private boolean labelVisible = true;
    private String userFormat = null;

    public void setViewType(int n) {
        this.type = n;
    }

    public int getViewType() {
        return this.type;
    }

    public void setFillStyle(int n) {
        this.fillStyle = n;
    }

    public int getFillStyle() {
        return this.fillStyle;
    }

    public void setFillMethod(int n) {
        this.fillMethod = n;
    }

    public int getFillMethod() {
        return this.fillMethod;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setColor(Color color) {
        this.lineColor = color;
    }

    public Color getColor() {
        return this.lineColor;
    }

    public boolean isFill() {
        return this.fillStyle != 0;
    }

    public void setFill(boolean bl) {
        if (!bl) {
            this.setFillStyle(0);
        } else {
            this.setFillStyle(1);
        }
    }

    public void setClickable(boolean bl) {
        this.clickable = bl;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setLabelVisible(boolean bl) {
        this.labelVisible = bl;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setBarWidth(int n) {
        this.barWidth = n;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void setMarkerColor(Color color) {
        this.markerColor = color;
    }

    public Color getMarkerColor() {
        return this.markerColor;
    }

    public void setStyle(int n) {
        this.lineStyle = n;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerSize(int n) {
        this.markerSize = n;
    }

    public int getStyle() {
        return this.lineStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getExtendedName() {
        String string = "";
        if (this.hasTransform()) {
            String string2 = this.name + " [";
            if (this.A0 != 0.0) {
                string2 = string2 + Double.toString(this.A0);
                string = " + ";
            }
            if (this.A1 != 0.0) {
                string2 = string2 + string + Double.toString(this.A1) + "*y";
                string = " + ";
            }
            if (this.A2 != 0.0) {
                string2 = string2 + string + Double.toString(this.A2) + "*y^2";
            }
            string2 = string2 + "]";
            return string2;
        }
        return this.name;
    }

    public int getMarker() {
        return this.markerType;
    }

    public void setMarker(int n) {
        this.markerType = n;
    }

    public double getA0() {
        return this.A0;
    }

    public double getA1() {
        return this.A1;
    }

    public double getA2() {
        return this.A2;
    }

    public void setA0(double d) {
        this.A0 = d;
    }

    public void setA1(double d) {
        this.A1 = d;
    }

    public void setA2(double d) {
        this.A2 = d;
    }

    public boolean hasTransform() {
        return this.A0 != 0.0 || this.A1 != 1.0 || this.A2 != 0.0;
    }

    public void setAxis(JLAxis jLAxis) {
        this.parentAxis = jLAxis;
    }

    public JLAxis getAxis() {
        return this.parentAxis;
    }

    public double getMinimum() {
        return this.min;
    }

    public double getMaximum() {
        return this.max;
    }

    public double getMinTime() {
        if (this.theData != null) {
            return this.theData.x;
        }
        return Double.MAX_VALUE;
    }

    public double getPositiveMinTime() {
        DataList dataList = this.theData;
        boolean bl = false;
        while (dataList != null && !bl) {
            boolean bl2 = bl = dataList.x > 0.0;
            if (bl) continue;
            dataList = dataList.next;
        }
        if (dataList != null) {
            return dataList.x;
        }
        return Double.MAX_VALUE;
    }

    public double getMaxTime() {
        if (this.theDataEnd != null) {
            return this.theDataEnd.x;
        }
        return -1.7976931348623157E308;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public DataList getData() {
        return this.theData;
    }

    public void commitChange() {
        this.computeMin();
        this.computeMax();
    }

    public void add(double d, double d2) {
        DataList dataList = new DataList(d, d2);
        if (dataList == null) {
            System.out.println("Warning: Cannot add data to the chart (may be a memory problem...)");
            return;
        }
        this.theDataEnd = this.theData == null ? (this.theData = dataList) : (this.theDataEnd.next = dataList);
        if (d2 < this.min) {
            this.min = d2;
        }
        if (d2 > this.max) {
            this.max = d2;
        }
        ++this.dataLength;
    }

    public int garbagePointTime(double d) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        if (this.theData != null) {
            double d2 = this.theDataEnd.x;
            while (this.theData != null && !bl3) {
                boolean bl4 = bl3 = this.theData.x > d2 - d - 3000.0;
                if (bl3) continue;
                bl = bl || this.theData.y == this.max;
                bl2 = bl2 || this.theData.y == this.min;
                this.theData = this.theData.next;
                --this.dataLength;
                ++n;
            }
        }
        if (this.theData == null) {
            this.reset();
        } else {
            if (bl) {
                this.computeMax();
            }
            if (bl2) {
                this.computeMin();
            }
        }
        return n;
    }

    public void garbagePointLimit(int n) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = this.dataLength - n;
        int n3 = 0;
        while (n3 < n2) {
            bl = bl || this.theData.y == this.max;
            bl2 = bl2 || this.theData.y == this.min;
            this.theData = this.theData.next;
            --this.dataLength;
            ++n3;
        }
        if (bl) {
            this.computeMax();
        }
        if (bl2) {
            this.computeMin();
        }
    }

    private void computeMin() {
        this.min = Double.MAX_VALUE;
        DataList dataList = this.theData;
        while (dataList != null) {
            if (dataList.y < this.min) {
                this.min = dataList.y;
            }
            dataList = dataList.next;
        }
    }

    private void computeMax() {
        this.max = -1.7976931348623157E308;
        DataList dataList = this.theData;
        while (dataList != null) {
            if (dataList.y > this.max) {
                this.max = dataList.y;
            }
            dataList = dataList.next;
        }
    }

    public double[] computeTransformedMinMax() {
        double[] dArray = new double[2];
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        DataList dataList = this.theData;
        while (dataList != null) {
            double d3 = this.A0 + this.A1 * dataList.y + this.A2 * dataList.y * dataList.y;
            if (d3 < d) {
                d = d3;
            }
            if (d3 > d2) {
                d2 = d3;
            }
            dataList = dataList.next;
        }
        if (d == Double.MAX_VALUE) {
            d = 0.0;
        }
        if (d2 == -1.7976931348623157E308) {
            d2 = 99.0;
        }
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }

    public double computePositiveMin() {
        double d = Double.MAX_VALUE;
        DataList dataList = this.theData;
        while (dataList != null) {
            if (dataList.y > 0.0 && dataList.y < d) {
                d = dataList.y;
            }
            dataList = dataList.next;
        }
        return d;
    }

    public double getTransformedValue(double d) {
        return this.A0 + this.A1 * d + this.A2 * d * d;
    }

    public DataList getLastValue() {
        return this.theDataEnd;
    }

    public void reset() {
        this.theData = null;
        this.theDataEnd = null;
        this.dataLength = 0;
        this.computeMin();
        this.computeMax();
    }

    public void applyConfiguration(String string, CfFileReader cfFileReader) {
        Vector vector = cfFileReader.getParam(string + "_linecolor");
        if (vector != null) {
            this.setColor(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam(string + "_linewidth")) != null) {
            this.setLineWidth(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_linestyle")) != null) {
            this.setStyle(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_fillcolor")) != null) {
            this.setFillColor(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam(string + "_fillmethod")) != null) {
            this.setFillMethod(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_fillstyle")) != null) {
            this.setFillStyle(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_viewtype")) != null) {
            this.setViewType(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_barwidth")) != null) {
            this.setBarWidth(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_markercolor")) != null) {
            this.setMarkerColor(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam(string + "_markersize")) != null) {
            this.setMarkerSize(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_markerstyle")) != null) {
            this.setMarker(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_A0")) != null) {
            this.setA0(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_A1")) != null) {
            this.setA1(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_A2")) != null) {
            this.setA2(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_labelvisible")) != null) {
            this.setLabelVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_clickable")) != null) {
            this.setClickable(OFormat.getBoolean(vector.get(0).toString()));
        }
    }

    public String getConfiguration(String string) {
        String string2 = "";
        string2 = string2 + string + "_linecolor:" + OFormat.color(this.getColor()) + "\n";
        string2 = string2 + string + "_linewidth:" + this.getLineWidth() + "\n";
        string2 = string2 + string + "_linestyle:" + this.getStyle() + "\n";
        string2 = string2 + string + "_fillcolor:" + OFormat.color(this.getFillColor()) + "\n";
        string2 = string2 + string + "_fillmethod:" + this.getFillMethod() + "\n";
        string2 = string2 + string + "_fillstyle:" + this.getFillStyle() + "\n";
        string2 = string2 + string + "_viewtype:" + this.getViewType() + "\n";
        string2 = string2 + string + "_barwidth:" + this.getBarWidth() + "\n";
        string2 = string2 + string + "_markercolor:" + OFormat.color(this.getMarkerColor()) + "\n";
        string2 = string2 + string + "_markersize:" + this.getMarkerSize() + "\n";
        string2 = string2 + string + "_markerstyle:" + this.getMarker() + "\n";
        string2 = string2 + string + "_A0:" + this.getA0() + "\n";
        string2 = string2 + string + "_A1:" + this.getA1() + "\n";
        string2 = string2 + string + "_A2:" + this.getA2() + "\n";
        string2 = string2 + string + "_labelvisible:" + this.isLabelVisible() + "\n";
        string2 = string2 + string + "_clickable:" + this.isClickable() + "\n";
        return string2;
    }

    public double getYValueByIndex(int n) {
        if (n < 0 || n >= this.getDataLength()) {
            return Double.NaN;
        }
        int n2 = 0;
        DataList dataList = this.theData;
        while (dataList != null && n2 < n) {
            dataList = dataList.next;
            ++n2;
        }
        if (dataList != null) {
            return dataList.y;
        }
        return Double.NaN;
    }

    public double getXValueByIndex(int n) {
        if (n < 0 || n >= this.getDataLength()) {
            return Double.NaN;
        }
        int n2 = 0;
        DataList dataList = this.theData;
        while (dataList != null && n2 < n) {
            dataList = dataList.next;
            ++n2;
        }
        if (dataList != null) {
            return dataList.x;
        }
        return Double.NaN;
    }

    public void setUserFormat(String string) {
        if (string != null && string.length() > 0) {
            this.userFormat = string;
            return;
        }
        this.userFormat = null;
    }

    public String getUserFormat() {
        return this.userFormat;
    }

    public String formatValue(double d) {
        if (this.userFormat != null) {
            Object[] objectArray = new Object[]{new Double(d)};
            return Format.sprintf((String)this.userFormat, (Object[])objectArray);
        }
        if (this.parentAxis == null) {
            return Double.toString(d);
        }
        return this.parentAxis.formatValue(d, 0.0);
    }
}

