/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.image.IImageViewer;
import fr.esrf.tangoatk.widget.image.IRasterConverter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class GrayscaleColorConverter
implements IRasterConverter {
    final int IMAGE_DEPTH = 256;
    final int INCREASE = 0;
    final int DECREASE = 1;
    public static final int _256_COLORS = 0;
    final int GRAY_SCALE = 1;
    final int CONTRASTED_COLOR = 2;
    public int[][] raster = null;
    private int[] colormap = new int[256];
    private BufferedImage image;
    private IImageViewer imgviewer;
    private final int NB_MAIN_COLORS = 8;
    private final int BLACK = 0;
    private final int BLUE = 32;
    private final int CYAN = 64;
    private final int GREEN = 96;
    private final int YELLOW = 128;
    private final int WHITE = 160;
    private final int MAGENTA = 192;
    private final int RED = 224;
    private final int BG_MAX = 64;
    private Rectangle roi = null;

    public GrayscaleColorConverter(int n) {
        switch (n) {
            case 0: {
                this.set256ColorsLookUpTable();
                break;
            }
            case 1: {
                this.setGrayScaleLookUpTable();
            }
        }
    }

    public void changeLookUpTable(int n) {
        switch (n) {
            case 0: {
                this.set256ColorsLookUpTable();
                break;
            }
            case 1: {
                this.setGrayScaleLookUpTable();
            }
        }
        if (this.image == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.image.getHeight()) {
            int n3 = 0;
            while (n3 < this.image.getWidth()) {
                this.image.setRGB(n3, n2, this.colormap[this.raster[n3][n2]]);
                ++n3;
            }
            ++n2;
        }
        this.imgviewer.repaint();
    }

    private void setGrayScaleLookUpTable() {
        int n = 0;
        while (n < 256) {
            Color color = new Color(n, n, n);
            this.colormap[n] = color.getRGB();
            ++n;
        }
    }

    private void set256ColorsLookUpTable() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 4;
        int n5 = 0;
        while (n5 < 256) {
            if (n5 == 0) {
                n3 = 0;
                n2 = 0;
                n = 0;
            } else if (n5 == 32) {
                n = 0;
                n2 = 127;
                n3 = 255;
            } else if (n5 == 64) {
                n = 0;
                n2 = 255;
                n3 = 255;
            } else if (n5 == 96) {
                n = 127;
                n2 = 255;
                n3 = 0;
            } else if (n5 == 128) {
                n = 255;
                n2 = 255;
                n3 = 127;
            } else if (n5 == 160) {
                n = 255;
                n2 = 255;
                n3 = 255;
            } else if (n5 == 192) {
                n = 255;
                n2 = 0;
                n3 = 255;
            } else if (n5 == 224) {
                n = 255;
                n2 = 0;
                n3 = 0;
            } else if (n5 < 32) {
                n3 += n4;
            } else if (n5 < 64) {
                n2 += n4;
            } else if (n5 < 96) {
                n3 -= n4;
            } else if (n5 < 128) {
                n += n4;
            } else if (n5 < 160) {
                n3 += n4;
            } else if (n5 < 192) {
                n2 -= n4;
            } else if (n5 < 224) {
                n3 -= n4;
            } else {
                n -= n4;
            }
            Color color = new Color(n, n2, n3);
            this.colormap[n5] = color.getRGB();
            ++n5;
        }
    }

    public void createColormapImage() {
        int n = 100;
        int n2 = 256;
        this.raster = new int[n][n2];
        this.image = new BufferedImage(n, n2, 1);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                this.raster[n4][n3] = n2 - n3 - 1;
                this.image.setRGB(n4, n3, this.colormap[this.raster[n4][n3]]);
                ++n4;
            }
            ++n3;
        }
    }

    public void setModel(IImageViewer iImageViewer) {
        this.imgviewer = iImageViewer;
    }

    public void setImageViewer(IImageViewer iImageViewer) {
        this.imgviewer = iImageViewer;
    }

    public BufferedImage convertRaster(double[][] dArray) {
        this.createImage(dArray);
        return this.image;
    }

    public void rasterChanged(double[][] dArray) {
        BufferedImage bufferedImage = this.convertRaster(dArray);
        this.imgviewer.setImage(bufferedImage);
        this.imgviewer.setSize(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    public void rasterChanged() {
        this.imgviewer.setImage(this.image);
        this.imgviewer.setSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
    }

    public void createImage(double[][] dArray) {
        int n = dArray[0].length;
        int n2 = dArray.length;
        this.raster = new int[n][n2];
        this.image = new BufferedImage(n, n2, 1);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                this.raster[n4][n3] = 0xFF & (int)dArray[n3][n4];
                this.image.setRGB(n4, n3, this.colormap[this.raster[n4][n3]]);
                ++n4;
            }
            ++n3;
        }
    }

    public void createImage(int[][] nArray) {
        this.raster = nArray;
        int n = this.raster.length;
        int n2 = this.raster[0].length;
        this.image = new BufferedImage(n, n2, 1);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                this.image.setRGB(n4, n3, this.colormap[this.raster[n4][n3]]);
                ++n4;
            }
            ++n3;
        }
    }

    private Rectangle calculateROI() {
        int n = this.image.getWidth();
        int n2 = this.image.getHeight();
        Point point = new Point(0, 0);
        Point point2 = new Point(n - 1, n2 - 1);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        int n7 = 0;
        int n8 = 5;
        while (n8 < n2) {
            int n9 = 5;
            while (n9 < n) {
                n7 = 0xFF & this.raster[n9][n8];
                if (n7 > n3) {
                    n3 = n7;
                    n4 = n9;
                    n5 = n8;
                }
                if ((n8 == 0 || n8 == n2 - 1 || n9 == 0 || n9 == n - 1) && n7 > n6 && n7 < 64) {
                    n6 = n7;
                }
                ++n9;
            }
            ++n8;
        }
        System.out.println(n4 + ", " + n5 + " -> " + n3 + " Bg = " + n6);
        point.x = point.y - 0;
        point2.x = n - 1;
        point2.y = n2 - 1;
        int n10 = n4;
        while (n10 > 0) {
            n7 = 0xFF & this.raster[n10][n5];
            if (n7 <= n6) {
                point.x = n10;
                break;
            }
            --n10;
        }
        int n11 = n4;
        while (n11 < n) {
            n7 = 0xFF & this.raster[n11][n5];
            if (n7 <= n6) {
                point2.x = n11;
                break;
            }
            ++n11;
        }
        int n12 = n5;
        while (n12 > 0) {
            n7 = 0xFF & this.raster[n4][n12];
            if (n7 <= n6) {
                point.y = n12;
                break;
            }
            --n12;
        }
        int n13 = n5;
        while (n13 < n2) {
            n7 = 0xFF & this.raster[n4][n13];
            if (n7 <= n6) {
                point2.y = n13;
                break;
            }
            ++n13;
        }
        return new Rectangle(point, new Dimension(point2.x - point.x, point2.y - point.y));
    }

    public void drawROI(boolean bl) {
        if (bl) {
            this.roi = this.calculateROI();
        }
        Graphics graphics = this.image.getGraphics();
        graphics.setXORMode(Color.blue);
        graphics.drawRect(this.roi.x, this.roi.y, this.roi.width, this.roi.height);
    }
}

