/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.widget.attribute.IAttributeViewer;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.properties.PropertyListViewer2;
import fr.esrf.tangoatk.widget.util.ButtonBar;
import fr.esrf.tangoatk.widget.util.IApplicable;
import fr.esrf.tangoatk.widget.util.IControlee;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PropertyFrame
extends JFrame {
    IEntity model;
    boolean added = false;
    SetPanel setPanel = new SetPanel();
    private JTabbedPane jTabbedPane2;
    private JScrollPane jScrollPane1;
    private PropertyListViewer2 propertyListViewer1;
    private Trend trend;
    private ButtonBar buttonBar1;

    public PropertyFrame() {
        this.initComponents();
        this.jTabbedPane2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PropertyFrame.this.tabChanged(changeEvent);
            }
        });
    }

    void tabChanged(ChangeEvent changeEvent) {
        Component component = this.jTabbedPane2.getSelectedComponent();
        if (component == this.jScrollPane1) {
            this.buttonBar1.setControlee(this.propertyListViewer1.getControlee());
            return;
        }
        this.buttonBar1.setControlee((IControlee)((Object)component));
    }

    public void setEditable(boolean bl) {
        this.propertyListViewer1.setEditable(bl);
    }

    public boolean isEditable() {
        return this.propertyListViewer1.isEditable();
    }

    public void setModel(IAttribute iAttribute) {
        this.model = iAttribute;
        this.propertyListViewer1.setModel(this.model.getPropertyMap());
        this.jTabbedPane2.remove(this.setPanel);
        if (!(iAttribute instanceof INumberScalar)) {
            this.jTabbedPane2.remove(this.trend);
        } else {
            this.trend.addAttribute((INumberScalar)iAttribute);
        }
        this.buttonBar1.setControlee(this.propertyListViewer1.getControlee());
    }

    public void setModel(IAttributeViewer iAttributeViewer) {
        this.model = iAttributeViewer.getModel();
        this.propertyListViewer1.setModel(this.model.getPropertyMap());
        this.trend.setSelectionTreeVisible(false);
        if (iAttributeViewer.isValueEditable() && ((IAttribute)this.model).isWritable()) {
            if (this.model instanceof INumberScalar) {
                this.setPanel.setModel((INumberScalar)this.model);
                this.jTabbedPane2.add("Set value", this.setPanel);
            } else if (this.model instanceof IStringScalar) {
                this.setPanel.setModel((IStringScalar)this.model);
                this.jTabbedPane2.add("Set value", this.setPanel);
            }
        }
        if (this.model instanceof INumberScalar) {
            this.trend.addAttribute((INumberScalar)this.model);
        }
        this.buttonBar1.setControlee(this.propertyListViewer1.getControlee());
    }

    private void initComponents() {
        this.jTabbedPane2 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.propertyListViewer1 = new PropertyListViewer2();
        this.trend = new Trend();
        this.buttonBar1 = new ButtonBar();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PropertyFrame.this.exitForm(windowEvent);
            }
        });
        this.jTabbedPane2.setTabPlacement(3);
        this.propertyListViewer1.setBackground(new Color(204, 204, 204));
        this.jScrollPane1.setViewportView(this.propertyListViewer1);
        this.jTabbedPane2.addTab("Properties", this.jScrollPane1);
        this.jTabbedPane2.addTab("Trend", this.trend);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.getContentPane().add((Component)this.jTabbedPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.getContentPane().add((Component)this.buttonBar1, gridBagConstraints);
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
    }

    private void addTrendButtonActionPerformed(ActionEvent actionEvent) {
    }

    private void exitForm(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public static void main(String[] stringArray) {
        new PropertyFrame().show();
    }

    class SetPanel
    extends JPanel
    implements IApplicable {
        IStringScalar string;
        INumberScalar number;
        JTextField valueField = new JTextField();
        JLabel labelField;
        JLabel unitField;

        public SetPanel() {
            this.valueField.setColumns(10);
            this.labelField = new JLabel();
            this.unitField = new JLabel();
            this.add(this.labelField);
            this.add(this.valueField);
            this.add(this.unitField);
        }

        public void ok() {
            this.apply();
            this.cancel();
        }

        public void apply() {
            if (this.number != null) {
                try {
                    this.number.setNumber((Number)new Double(this.valueField.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, this.number + "value should be " + "a numeric value", "Error", 0);
                }
                return;
            }
            this.string.setString(this.valueField.getText());
        }

        public void cancel() {
            this.getRootPane().getParent().setVisible(false);
        }

        void setUp(IAttribute iAttribute) {
            this.labelField.setText(iAttribute.getLabel());
            this.unitField.setText(iAttribute.getUnit());
        }

        public void setModel(INumberScalar iNumberScalar) {
            this.number = iNumberScalar;
            this.valueField.setText(this.number.getNumber().toString());
            this.valueField.setHorizontalAlignment(4);
            this.setUp((IAttribute)this.number);
        }

        public void setModel(IStringScalar iStringScalar) {
            this.string = iStringScalar;
            this.valueField.setText(this.string.getString());
            this.setUp((IAttribute)this.string);
        }
    }
}

