/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.TangoHost;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PropListDialog
extends JDialog {
    private JFrame parent;
    private String selectedItem = null;
    private JTextArea pathText = null;
    private String[] props;
    private JPanel jPanel1;
    private JButton addBtn;
    private JButton dismissBtn;
    private JScrollPane jScrollPane1;
    private JList jList;

    private void setList() throws DevFailed {
        this.jList.setListData(this.props);
    }

    public PropListDialog(JFrame parent, String[] props) {
        super((Frame)parent, true);
        this.parent = parent;
        this.props = props;
        this.initComponents();
        this.buildlist();
    }

    public PropListDialog(JFrame parent, JTextArea pathText, TangoHost[] hosts) {
        super((Frame)parent, true);
        this.parent = parent;
        this.pathText = pathText;
        this.initComponents();
        this.hosts2path(hosts);
        this.buildlist();
    }

    private boolean alreadyIn(Vector vect, String s) {
        for (int i = 0; i < vect.size(); ++i) {
            if (!vect.elementAt(i).equals(s)) continue;
            return true;
        }
        return false;
    }

    private void hosts2path(TangoHost[] hosts) {
        try {
            int i;
            Vector<String> vect = new Vector<String>();
            for (i = 0; i < hosts.length; ++i) {
                String devname = "tango/admin/" + hosts[i].getName();
                DeviceProxy dev = new DeviceProxy(devname);
                DbDatum data = dev.get_property("StartDsPath");
                if (data.is_empty()) continue;
                String[] path = data.extractStringArray();
                for (int p = 0; p < path.length; ++p) {
                    if (this.alreadyIn(vect, path[p])) continue;
                    vect.add(path[p]);
                }
            }
            this.props = new String[vect.size()];
            for (i = 0; i < vect.size(); ++i) {
                this.props[i] = (String)vect.elementAt(i);
            }
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.parent, e);
        }
    }

    private void buildlist() {
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                PropListDialog.this.listSelectionPerformed(e);
            }
        };
        this.jList.addMouseListener(mouseListener);
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.addBtn = new JButton();
        this.dismissBtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList = new JList();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PropListDialog.this.closeDialog(evt);
            }
        });
        this.addBtn.setText("Add");
        this.addBtn.setHorizontalAlignment(4);
        this.addBtn.setFont(new Font("Dialog", 0, 12));
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropListDialog.this.addBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.addBtn);
        this.dismissBtn.setHorizontalTextPosition(4);
        if (this.pathText == null) {
            this.dismissBtn.setText("Cancel");
        } else {
            this.dismissBtn.setText("Dismiss");
        }
        this.dismissBtn.setHorizontalAlignment(4);
        this.dismissBtn.setFont(new Font("Dialog", 0, 12));
        this.dismissBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropListDialog.this.dismissBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.dismissBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jList.setFont(new Font("Courier", 1, 12));
        this.jScrollPane1.setPreferredSize(new Dimension(450, 300));
        this.jScrollPane1.setMinimumSize(new Dimension(450, 300));
        this.jScrollPane1.setViewportView(this.jList);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
    }

    private void dismissBtnActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        this.retreiveSelectedItem();
    }

    private void listSelectionPerformed(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.retreiveSelectedItem();
        }
    }

    private void retreiveSelectedItem() {
        this.selectedItem = (String)this.jList.getSelectedValue();
        if (this.pathText != null) {
            this.pathText.append(this.selectedItem + "\n");
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void showDialog() {
        try {
            this.setList();
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.parent, e);
        }
        Point p = this.parent.getLocationOnScreen();
        p.x += (this.parent.getWidth() - this.getWidth()) / 2 + 50;
        p.y += (this.parent.getHeight() - this.getHeight()) / 2 + 50;
        this.setLocation(p);
        this.setVisible(true);
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }
}

