/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.TangoServer;
import app_util.PopupError;
import app_util.PopupMessage;
import app_util.PopupText;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ManagePollingDialog
extends JDialog
implements TangoConst {
    private JFrame root_frame;
    private String[] commands;
    private String[] attributes;
    private TangoServer server;
    private JPanel jPanel1;
    private JLabel jLabel1;
    private JRadioButton cmdBtn;
    private JRadioButton attrBtn;
    private JLabel jLabel7;
    private JPanel jPanel2;
    private JButton jButton1;
    private JPanel jPanel3;
    private JComboBox devicesBox;
    private JComboBox cmdBox;
    private JLabel jLabel2;
    private JLabel cmdLabel;
    private JButton addBtn;
    private JLabel jLabel3;
    private JButton removeBtn;
    private JButton statusBtn;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;

    private void setCmdAttrBox() {
        String[] strArray;
        if (this.cmdBtn.getSelectedObjects() != null) {
            this.cmdLabel.setText("Command Selection");
            strArray = this.commands;
        } else {
            this.cmdLabel.setText("Attribute Selection");
            strArray = this.attributes;
        }
        this.cmdBox.removeAllItems();
        for (int i = 0; i < strArray.length; ++i) {
            this.cmdBox.addItem(strArray[i]);
        }
        this.pack();
    }

    private void initComponentsFromDevices() {
        try {
            String[] devices = this.server.queryDevice();
            for (int i = 0; i < devices.length; ++i) {
                this.devicesBox.addItem(devices[i]);
            }
            this.devicesBox.addItem("*");
            this.devicesBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ManagePollingDialog.this.devSelectionActionPerformed(evt);
                }
            });
            this.cmdBtn.setSelected(false);
            this.attrBtn.setSelected(true);
            this.getAttrCmdLists(devices[0]);
        }
        catch (DevFailed e) {
            PopupError.show((Component)this, e);
        }
    }

    private void getAttrCmdLists(String devname) {
        try {
            int i;
            DeviceProxy dev = new DeviceProxy(devname);
            CommandInfo[] cmd_list = dev.command_list_query();
            int nb = 0;
            for (i = 0; i < cmd_list.length; ++i) {
                if (cmd_list[i].in_type != 0 || cmd_list[i].cmd_name.equals("Init")) continue;
                ++nb;
            }
            this.commands = new String[nb];
            int j = 0;
            for (i = 0; i < cmd_list.length; ++i) {
                if (cmd_list[i].in_type != 0 || cmd_list[i].cmd_name.equals("Init")) continue;
                this.commands[j++] = cmd_list[i].cmd_name;
            }
            this.attributes = dev.get_attribute_list();
            this.setCmdAttrBox();
        }
        catch (DevFailed e) {
            PopupError.show((Component)this, e);
            return;
        }
    }

    private void devSelectionActionPerformed(ActionEvent evt) {
        String devname = this.devicesBox.getSelectedItem().toString();
        System.out.println(devname);
        if (!devname.equals("*")) {
            this.getAttrCmdLists(devname);
        }
    }

    public ManagePollingDialog(JFrame frame, JDialog parent, TangoServer server, Point p) {
        super((Dialog)parent, true);
        this.root_frame = frame;
        this.server = server;
        this.setTitle("Device Polling Management Window");
        this.initComponents();
        this.initComponentsFromDevices();
        this.setLocation(p);
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.cmdBtn = new JRadioButton();
        this.attrBtn = new JRadioButton();
        this.jLabel7 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jPanel3 = new JPanel();
        this.devicesBox = new JComboBox();
        this.cmdBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.cmdLabel = new JLabel();
        this.addBtn = new JButton();
        this.jLabel3 = new JLabel();
        this.removeBtn = new JButton();
        this.statusBtn = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ManagePollingDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Polling  on   ");
        this.jLabel1.setForeground(Color.black);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 2;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints2);
        this.cmdBtn.setText("Command");
        this.cmdBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.cmdBtnActionPerformed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        this.jPanel1.add((Component)this.cmdBtn, gridBagConstraints2);
        this.attrBtn.setText("Attribute");
        this.attrBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.attrBtnActionPerformed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 2;
        this.jPanel1.add((Component)this.attrBtn, gridBagConstraints2);
        this.jLabel7.setText("   ");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 5;
        this.jPanel1.add((Component)this.jLabel7, gridBagConstraints2);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jButton1.setText("Dismiss");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 2;
        this.jPanel3.add((Component)this.devicesBox, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 5;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 2;
        this.jPanel3.add((Component)this.cmdBox, gridBagConstraints1);
        this.jLabel2.setText("Device Selection");
        this.jLabel2.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints1);
        this.cmdLabel.setText("command :");
        this.cmdLabel.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 5;
        gridBagConstraints1.gridy = 1;
        this.jPanel3.add((Component)this.cmdLabel, gridBagConstraints1);
        this.addBtn.setText("Add / Update");
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.addBtnActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 5;
        this.jPanel3.add((Component)this.addBtn, gridBagConstraints1);
        this.jLabel3.setText("  ");
        this.jLabel3.setFont(new Font("Dialog", 0, 36));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 3;
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints1);
        this.removeBtn.setText("Remove");
        this.removeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.removeBtnActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 5;
        this.jPanel3.add((Component)this.removeBtn, gridBagConstraints1);
        this.statusBtn.setText("Polling Status");
        this.statusBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.statusBtnActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 5;
        gridBagConstraints1.gridy = 5;
        this.jPanel3.add((Component)this.statusBtn, gridBagConstraints1);
        this.jLabel4.setText("  ");
        this.jLabel4.setFont(new Font("Dialog", 0, 36));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 8;
        this.jPanel3.add((Component)this.jLabel4, gridBagConstraints1);
        this.jLabel5.setText("   ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 5;
        this.jPanel3.add((Component)this.jLabel5, gridBagConstraints1);
        this.jLabel6.setText("   ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 4;
        gridBagConstraints1.gridy = 5;
        this.jPanel3.add((Component)this.jLabel6, gridBagConstraints1);
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.pack();
    }

    private String[] selectedDevices() {
        String[] names;
        String item = this.devicesBox.getSelectedItem().toString();
        if (item.equals("*")) {
            int nb = this.devicesBox.getItemCount() - 1;
            names = new String[nb];
            for (int i = 0; i < nb; ++i) {
                names[i] = this.devicesBox.getItemAt(i).toString();
            }
        } else {
            names = new String[]{item};
        }
        return names;
    }

    private void statusBtnActionPerformed(ActionEvent evt) {
        String[] devnames = this.selectedDevices();
        StringBuffer message = new StringBuffer("        Polling Status\n\n");
        for (int i = 0; i < devnames.length; ++i) {
            try {
                message.append("=============================================\n");
                message.append(devnames[i] + " :\n\n");
                DeviceProxy dev = new DeviceProxy(devnames[i]);
                String[] status = dev.polling_status();
                for (int st = 0; st < status.length; ++st) {
                    message.append(status[st] + "\n");
                    if (st >= status.length - 1) continue;
                    message.append("   ---------------------------------\n");
                }
                if (status.length <= 0) continue;
                message.append("\n\n");
                continue;
            }
            catch (DevFailed e) {
                PopupError.show((Component)this, e);
                return;
            }
        }
        if (devnames.length == 1) {
            PopupMessage.show((Component)this, message.toString());
        } else {
            PopupText ppt = new PopupText((Frame)this.root_frame, true);
            ppt.show(message.toString());
        }
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        String[] devnames = this.selectedDevices();
        String polled_obj_name = this.cmdBox.getSelectedItem().toString();
        StringBuffer message = new StringBuffer(polled_obj_name + " polling has been removed for:\n");
        for (int i = 0; i < devnames.length; ++i) {
            try {
                DeviceProxy dev = new DeviceProxy(devnames[i]);
                if (this.cmdBtn.getSelectedObjects() != null) {
                    dev.stop_poll_command(polled_obj_name);
                } else {
                    dev.stop_poll_attribute(polled_obj_name);
                }
                message.append(devnames[i] + "\n");
                continue;
            }
            catch (DevFailed e) {
                PopupError.show((Component)this, e);
                return;
            }
        }
        PopupMessage.show((Component)this, message.toString());
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        String[] devnames = this.selectedDevices();
        boolean ok = false;
        String strval = "";
        int polling_period = 0;
        while (!ok) {
            if ((strval = (String)JOptionPane.showInputDialog(this, "Polling period (ms)  ?", "Polling period", 1, null, null, strval)) == null) {
                return;
            }
            try {
                polling_period = Integer.parseInt(strval);
                if (polling_period < 20) {
                    PopupError.show((Component)this, "The polling period minimum value is 20ms");
                    continue;
                }
                ok = true;
            }
            catch (NumberFormatException e) {
                PopupError.show((Component)this, e.toString() + "\n\nBad Value in Polling period field !");
            }
        }
        String polled_obj_name = this.cmdBox.getSelectedItem().toString();
        StringBuffer message = new StringBuffer(polled_obj_name + " polling has been added for:\n");
        for (int i = 0; i < devnames.length; ++i) {
            try {
                DeviceProxy dev = new DeviceProxy(devnames[i]);
                if (this.cmdBtn.getSelectedObjects() != null) {
                    dev.poll_command(polled_obj_name, polling_period);
                } else {
                    dev.poll_attribute(polled_obj_name, polling_period);
                }
                message.append(devnames[i] + "\n");
                continue;
            }
            catch (DevFailed e) {
                PopupError.show((Component)this, e);
            }
        }
        PopupMessage.show((Component)this, message.toString());
    }

    private void attrBtnActionPerformed(ActionEvent evt) {
        if (this.attrBtn.getSelectedObjects() != null) {
            this.cmdBtn.setSelected(false);
        }
        this.setCmdAttrBox();
    }

    private void cmdBtnActionPerformed(ActionEvent evt) {
        if (this.cmdBtn.getSelectedObjects() != null) {
            this.attrBtn.setSelected(false);
        }
        this.setCmdAttrBox();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

