/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import app_util.PopupError;
import app_util.PopupMessage;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.logviewer.DetailPanel;
import fr.esrf.logviewer.MyTableModel;
import fr.esrf.logviewer.XMLFileHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Level;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class LoggingDialog
extends JDialog {
    private TangoHost host;
    private XMLFileHandler mHandler;
    private XMLReader mParser;
    private MyTableModel model;
    private JPanel jPanel1;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel titleLabel;

    public LoggingDialog(JFrame parent, TangoHost host) throws DevFailed {
        super((Frame)parent, true);
        this.host = host;
        this.initComponents();
        this.initMyComponents();
        this.titleLabel.setText("Starter logging for  " + host.getName());
        this.pack();
        AstorUtil.centerDialog((JDialog)this, parent);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LoggingDialog.this.closeDialog(evt);
            }
        });
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoggingDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    private void initMyComponents() throws DevFailed {
        try {
            this.model = new MyTableModel();
            this.mHandler = new XMLFileHandler(this.model);
            this.mParser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            this.mParser.setContentHandler((ContentHandler)this.mHandler);
            JTable table = new JTable((TableModel)this.model);
            table.setRowSelectionAllowed(true);
            table.setColumnSelectionAllowed(true);
            table.setDragEnabled(true);
            table.setSelectionMode(0);
            Enumeration<TableColumn> cenum = table.getColumnModel().getColumns();
            LogTableRowRenderer dtcr = new LogTableRowRenderer();
            int i = 0;
            int[] col_width = new int[]{0, 155, 50, 155, 300};
            while (cenum.hasMoreElements()) {
                TableColumn tc = cenum.nextElement();
                tc.setCellRenderer(dtcr);
                tc.setPreferredWidth(col_width[i++]);
            }
            JScrollPane scrollPane = new JScrollPane(table);
            scrollPane.setBorder(BorderFactory.createTitledBorder("Logs"));
            scrollPane.setMinimumSize(new Dimension(150, 150));
            scrollPane.setPreferredSize(new Dimension(600, 350));
            DetailPanel details = new DetailPanel(table, this.model);
            details.setMinimumSize(new Dimension(0, 0));
            details.setPreferredSize(new Dimension(600, 0));
            this.getContentPane().add((Component)scrollPane, "Center");
            new LoadFile(this).start();
        }
        catch (Exception e) {
            Except.throw_exception((String)"INIT_ERROR", (String)e.toString(), (String)"LoggingDialog.initMyComponents()");
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public class LogTableRowRenderer
    extends DefaultTableCellRenderer {
        private final Color _scolor = new Color(204, 204, 255);
        private final Color _color = new Color(230, 230, 230);
        private final JCheckBox _true = new JCheckBox("", true);
        private final JCheckBox _false = new JCheckBox("", false);

        LogTableRowRenderer() {
            this.setHorizontalAlignment(0);
            this._true.setHorizontalAlignment(0);
            this._false.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            String col_header = (String)table.getColumnModel().getColumn(col).getHeaderValue();
            if (isSelected) {
                this.setBackground(this._scolor);
            } else if (col_header.equals("Level")) {
                Level level = (Level)value;
                if (level == Level.FATAL) {
                    this.setBackground(Color.black);
                    this.setForeground(Color.white);
                } else if (level == Level.ERROR) {
                    this.setBackground(Color.red);
                    this.setForeground(Color.black);
                } else if (level == Level.WARN) {
                    this.setBackground(Color.orange);
                    this.setForeground(Color.black);
                } else if (level == Level.INFO) {
                    this.setBackground(Color.green);
                    this.setForeground(Color.black);
                } else if (level == Level.DEBUG) {
                    this.setBackground(Color.cyan);
                    this.setForeground(Color.black);
                }
            } else {
                if (row % 2 == 0) {
                    this.setBackground(this._color);
                } else {
                    this.setBackground(Color.white);
                }
                this.setForeground(Color.black);
            }
            if (col_header.equals("Trace")) {
                JCheckBox cb = (Boolean)value == Boolean.TRUE ? this._true : this._false;
                return cb;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        }
    }

    class LoadFile
    extends Thread {
        private JDialog parent;

        LoadFile(JDialog parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String filename = "";
            try {
                String tmp = "/tmp";
                if (!AstorUtil.osIsUnix()) {
                    tmp = "c:/temp";
                }
                File f = new File(tmp);
                System.out.println("Check " + tmp);
                if (!f.exists()) {
                    f.mkdir();
                }
                int random_value = new Random().nextInt(30000);
                filename = tmp + "/astor." + random_value;
                String logs = LoggingDialog.this.host.readLogFile("starter/" + LoggingDialog.this.host.getName());
                FileOutputStream fidout = new FileOutputStream(filename);
                fidout.write(logs.getBytes());
                fidout.close();
                XMLReader xMLReader = LoggingDialog.this.mParser;
                synchronized (xMLReader) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
                    buf.append("<!DOCTYPE log4j:eventSet ");
                    buf.append("[<!ENTITY data SYSTEM \"file:///");
                    buf.append(filename);
                    buf.append("\">]>\n");
                    buf.append("<log4j:eventSet xmlns:log4j=\"Claira\">\n");
                    buf.append("&data;\n");
                    buf.append("</log4j:eventSet>\n");
                    StringReader sr = new StringReader(buf.toString());
                    InputSource is = new InputSource(sr);
                    LoggingDialog.this.mParser.parse(is);
                    String message = new Integer(LoggingDialog.this.mHandler.getNumEvents()).toString() + " events found !";
                    PopupMessage.show((Component)this.parent, message);
                }
            }
            catch (DevFailed e) {
                PopupError.show((Component)this.parent, e);
            }
            catch (Exception e) {
                PopupError.show((Component)this.parent, e);
                e.printStackTrace();
            }
            try {
                File f = new File(filename);
                if (f.exists()) {
                    f.delete();
                }
            }
            catch (Exception e) {
                PopupError.show((Component)this.parent, e);
            }
        }
    }
}

