/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ListDialog
extends JDialog {
    private static String str_filter = "*";
    private static String previous_item = null;
    private JFrame parent;
    private String selectedItem = null;
    private JPanel jPanel1;
    private JButton startBtn;
    private JButton cancelBtn;
    private JScrollPane jScrollPane1;
    private JList jList;
    private JPanel jPanel2;
    private JLabel jLabel1;
    private JTextField filterTxt;

    private void setList() throws DevFailed {
        str_filter = this.filterTxt.getText();
        String[] servlist = ApiUtil.get_db_obj().get_server_list(str_filter);
        this.jList.setListData(servlist);
        for (int i = 0; i < servlist.length; ++i) {
            if (!servlist[i].equals(previous_item)) continue;
            this.jList.setSelectedIndex(i);
        }
    }

    public ListDialog(JFrame parent) {
        super((Frame)parent, true);
        this.parent = parent;
        this.initComponents();
        this.filterTxt.setText(str_filter);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ListDialog.this.listSelectionPerformed(e);
            }
        };
        this.jList.addMouseListener(mouseListener);
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.startBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList = new JList();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.filterTxt = new JTextField();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ListDialog.this.closeDialog(evt);
            }
        });
        this.startBtn.setText("Start");
        this.startBtn.setHorizontalAlignment(4);
        this.startBtn.setFont(new Font("Dialog", 0, 12));
        this.startBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListDialog.this.startBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.startBtn);
        this.cancelBtn.setHorizontalTextPosition(4);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.setHorizontalAlignment(4);
        this.cancelBtn.setFont(new Font("Dialog", 0, 12));
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jScrollPane1.setPreferredSize(new Dimension(250, 300));
        this.jScrollPane1.setMinimumSize(new Dimension(250, 300));
        this.jList.setFont(new Font("Courier", 1, 12));
        this.jScrollPane1.setViewportView(this.jList);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jLabel1.setText("Filter : ");
        this.jLabel1.setForeground(Color.black);
        this.jLabel1.setFont(new Font("Courier", 1, 12));
        this.jPanel2.add(this.jLabel1);
        this.filterTxt.setPreferredSize(new Dimension(100, 19));
        this.filterTxt.setMinimumSize(new Dimension(100, 19));
        this.filterTxt.setText("*");
        this.filterTxt.setFont(new Font("Courier", 1, 12));
        this.filterTxt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListDialog.this.filterTxtActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.filterTxt);
        this.getContentPane().add((Component)this.jPanel2, "North");
    }

    private void filterTxtActionPerformed(ActionEvent evt) {
        try {
            this.setList();
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.parent, e);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void startBtnActionPerformed(ActionEvent evt) {
        this.retreiveSelectedItem();
    }

    private void listSelectionPerformed(MouseEvent evt) {
        previous_item = new String((String)this.jList.getSelectedValue());
        if (evt.getClickCount() == 2) {
            this.retreiveSelectedItem();
        }
    }

    private void retreiveSelectedItem() {
        String servname = (String)this.jList.getSelectedValue();
        try {
            String devname = new String("dserver/" + servname);
            DeviceProxy dev = new DeviceProxy(devname);
            try {
                dev.ping();
                PopupError.show((Component)this.parent, new String(servname + "  is Already Running  !!  "));
                return;
            }
            catch (DevFailed e) {
            }
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.parent, e);
            return;
        }
        this.selectedItem = servname;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void showDialog() {
        try {
            this.setList();
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.parent, e);
        }
        this.setVisible(true);
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }
}

