/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.ListDialog;
import admin.astor.RemoteLoginThread;
import admin.astor.ServerCmdThread;
import admin.astor.ServerPopupMenu;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import jive.DevWizard;

public class HostInfoDialog
extends JDialog
implements AstorDefs {
    String name;
    private Astor astor;
    private TangoHost host;
    private static String servname;
    private JButton notifydBtn;
    private JButton[] btn;
    private short nbStartupLevels = 0;
    private JPanel[] levelPanel;
    private Vector[] serverLevel;
    private ServerThread thread = null;
    private static int returnStatus;
    private ServerPopupMenu pMenu;
    private JPanel hostPanel;
    private JPanel jPanel1;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JLabel title;
    private JPanel jPanel3;
    private JButton startNewBtn;
    private JButton startAllBtn;
    private JButton stopAllBtn;
    private JRadioButton displayAllBtn;
    private JSeparator jSeparator1;

    public HostInfoDialog(Astor astor, TangoHost host) {
        super((Frame)astor, false);
        this.initComponents();
        this.nbStartupLevels = AstorUtil.getStarterNbStartupLevels();
        this.astor = astor;
        this.host = host;
        this.name = host.getName();
        this.myInitComponents();
    }

    private void myInitComponents() {
        JButton btn = new JButton("Dismiss");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.dismissBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(btn);
        this.createStartupLevelPanels();
        this.buildPanel();
        this.pMenu = new ServerPopupMenu(this.astor, this, this.host);
        this.thread = new ServerThread();
        this.thread.start();
        this.setTitle((Object)((Object)this.host) + "  Control");
        this.pack();
    }

    private void initComponents() {
        this.hostPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.title = new JLabel();
        this.jPanel3 = new JPanel();
        this.startNewBtn = new JButton();
        this.startAllBtn = new JButton();
        this.stopAllBtn = new JButton();
        this.displayAllBtn = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.setTitle("Host Info Window");
        this.setBackground(new Color(198, 178, 168));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                HostInfoDialog.this.closeDialog(evt);
            }
        });
        this.hostPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.hostPanel, "Center");
        this.jLabel1.setText("         ");
        this.jPanel1.add(this.jLabel1);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new BorderLayout());
        this.title.setFont(new Font("Dialog", 1, 18));
        this.title.setHorizontalAlignment(0);
        this.title.setText("jLabel2");
        this.jPanel2.add((Component)this.title, "South");
        this.startNewBtn.setFont(new Font("Dialog", 1, 10));
        this.startNewBtn.setText("Start New");
        this.startNewBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.startNewBtnActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.startNewBtn);
        this.startAllBtn.setFont(new Font("Dialog", 1, 10));
        this.startAllBtn.setText("Start All");
        this.startAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.startAllBtnActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.startAllBtn);
        this.stopAllBtn.setFont(new Font("Dialog", 1, 10));
        this.stopAllBtn.setText("Stop All");
        this.stopAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.stopAllBtnActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.stopAllBtn);
        this.displayAllBtn.setFont(new Font("Dialog", 1, 10));
        this.displayAllBtn.setText("Display All");
        this.displayAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.displayAllBtnActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.displayAllBtn);
        this.jPanel2.add((Component)this.jPanel3, "North");
        this.jPanel2.add((Component)this.jSeparator1, "Center");
        this.getContentPane().add((Component)this.jPanel2, "North");
    }

    private void displayAllBtnActionPerformed(ActionEvent evt) {
        boolean bl = this.host.all_servers = this.displayAllBtn.getSelectedObjects() != null;
        if (this.host.use_events) {
            this.checkUpdatePanel(true);
            this.thread.updateData(true);
        } else {
            this.host.updateData();
        }
    }

    private void stopAllBtnActionPerformed(ActionEvent evt) {
        boolean[] levelUsed = new boolean[this.nbStartupLevels];
        for (int level = 0; level < this.nbStartupLevels; ++level) {
            levelUsed[level] = this.serverLevel[level].size() != 0;
        }
        new ServerCmdThread(this, this.host, 1, levelUsed).start();
    }

    private void startAllBtnActionPerformed(ActionEvent evt) {
        boolean[] levelUsed = new boolean[this.nbStartupLevels];
        for (int level = 0; level < this.nbStartupLevels; ++level) {
            levelUsed[level] = this.serverLevel[level].size() != 0;
        }
        new ServerCmdThread(this, this.host, 0, levelUsed).start();
    }

    private void startNewBtnActionPerformed(ActionEvent evt) {
        block8: {
            try {
                DevWizard wdlg = new DevWizard((Frame)this.astor, (DeviceProxy)this.host);
                wdlg.showWizard(null);
                String servname = DevWizard.lastServStarted;
                if (servname == null) break block8;
                Point p = this.getLocationOnScreen();
                p.translate(50, 50);
                try {
                    if (new TangoServer(servname, false).startupLevel(this, this.host.getName(), p)) {
                        this.updateData();
                    }
                }
                catch (DevFailed e) {
                    PopupError.show((Component)this.astor, e);
                }
            }
            catch (NoSuchMethodError ex) {
                ListDialog jlist = new ListDialog(this.astor);
                Point p = this.getLocationOnScreen();
                p.translate(50, 50);
                jlist.setLocation(p);
                jlist.showDialog();
                servname = jlist.getSelectedItem();
                if (servname == null) break block8;
                try {
                    this.host.registerServer(servname);
                    this.host.startOneServer(servname);
                    if (new TangoServer(servname, false).startupLevel(this, this.host.getName(), p)) {
                        this.updateData();
                    }
                }
                catch (DevFailed e) {
                    PopupError.show((Component)this.astor, e);
                }
            }
        }
    }

    private void serverBtnActionPerformed(ActionEvent evt) {
        String message;
        if (this.host.state == 1 && JOptionPane.showConfirmDialog(this, message = new String("There is no Tango Administrator Server running on the Host '" + this.host.getName() + "'\n\n" + "Would you like a remote login to start it ?"), "Error Window", 0) == 0) {
            new RemoteLoginThread(this.host.getName(), this.astor).start();
        }
    }

    private void dismissBtnActionPerformed(ActionEvent evt) {
        this.doClose(-1);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(-1);
    }

    private synchronized Vector[] buildVectorOfStartupLevel() {
        int nb = this.nbStartupLevels;
        ++nb;
        ++nb;
        try {
            for (int i = 0; i < this.host.nbServers(); ++i) {
                TangoServer server = this.host.getServer(i);
                server.updateStartupInfo();
            }
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.astor, e);
        }
        Vector[] serverLevel = new Vector[nb];
        int idx = 0;
        int level = 1;
        while (level <= this.nbStartupLevels) {
            serverLevel[idx] = new Vector();
            for (int i = 0; i < this.host.nbServers(); ++i) {
                TangoServer server = this.host.getServer(i);
                if (server == null || server.info.startup_level != level) continue;
                serverLevel[idx].add(server);
            }
            ++level;
            ++idx;
        }
        serverLevel[nb - 2] = new Vector();
        serverLevel[nb - 1] = new Vector();
        for (int i = 0; i < this.host.nbServers(); ++i) {
            TangoServer server = this.host.getServer(i);
            if (server.info.controlled) {
                if (server.info.startup_level != 0) continue;
                serverLevel[nb - 2].add(server);
                continue;
            }
            serverLevel[nb - 1].add(server);
        }
        AstorUtil.getInstance().sort(serverLevel);
        return serverLevel;
    }

    private void addLevelPanelTitles() {
        int nb = this.nbStartupLevels + 2;
        GridBagConstraints gbc = new GridBagConstraints();
        int idx = 0;
        gbc.gridx = 1;
        gbc.anchor = 17;
        int level = 1;
        while (level <= this.nbStartupLevels) {
            gbc.gridy = 0;
            String text = new String("Level " + level + " : ");
            this.levelPanel[idx].add((Component)new JLabel(text), gbc);
            gbc.gridy = 500;
            this.levelPanel[idx].add((Component)new JLabel(" "), gbc);
            ++level;
            ++idx;
        }
        gbc.gridy = 0;
        this.levelPanel[idx].add((Component)new JLabel("Not Automaticly Started:"), gbc);
        gbc.gridy = 500;
        this.levelPanel[idx].add((Component)new JLabel(" "), gbc);
        gbc.gridy = 0;
        int n = ++idx;
        ++idx;
        this.levelPanel[n].add((Component)new JLabel("Not Controlled:"), gbc);
    }

    private void createStartupLevelPanels() {
        int nb = this.nbStartupLevels;
        ++nb;
        this.levelPanel = new JPanel[++nb];
        GridBagConstraints gbc = new GridBagConstraints();
        int idx = 0;
        int y = 0;
        gbc.gridx = 1;
        gbc.anchor = 17;
        gbc.gridy = y++;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        this.notifydBtn = new JButton("Events Notify Daemon");
        this.notifydBtn.setVisible(this.host.check_notifd);
        this.hostPanel.add((Component)this.notifydBtn, gbc);
        this.notifydBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HostInfoDialog.this.serverBtnMouseClicked(evt);
            }
        });
        gbc.gridy = y++;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.hostPanel.add((Component)new JLabel("   "), gbc);
        int level = 1;
        while (level <= this.nbStartupLevels) {
            gbc.gridy = y++;
            this.levelPanel[idx] = new JPanel(new GridBagLayout());
            this.hostPanel.add((Component)this.levelPanel[idx], gbc);
            this.levelPanel[idx].addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    HostInfoDialog.this.serverBtnMouseClicked(evt);
                }
            });
            ++level;
            ++idx;
        }
        gbc.gridy = y++;
        this.levelPanel[idx] = new JPanel(new GridBagLayout());
        this.hostPanel.add((Component)this.levelPanel[idx], gbc);
        gbc.gridy = y++;
        this.levelPanel[++idx] = new JPanel(new GridBagLayout());
        this.hostPanel.add((Component)this.levelPanel[idx], gbc);
    }

    public void buildPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        if (this.host.all_servers) {
            this.title.setText(" All Servers Registred on " + this.name + " ");
        } else {
            this.title.setText(" Servers Controlled on " + this.name + " ");
        }
        this.btn = new JButton[this.host.nbServers()];
        this.serverLevel = this.buildVectorOfStartupLevel();
        int nbmax = 0;
        for (int level = 0; level < this.nbStartupLevels + 2 && (level != this.nbStartupLevels + 1 || this.displayAllBtn.getSelectedObjects() != null); ++level) {
            if (this.serverLevel[level].size() <= nbmax) continue;
            nbmax = this.serverLevel[level].size();
        }
        int x_servers = (int)Math.sqrt(nbmax);
        if (x_servers > 2) {
            --x_servers;
        }
        int btnIdx = 0;
        for (int level = 0; level < this.nbStartupLevels + 2; ++level) {
            if (level == this.nbStartupLevels + 1 && this.displayAllBtn.getSelectedObjects() == null) {
                this.levelPanel[level].setVisible(false);
                break;
            }
            if (this.serverLevel[level].size() == 0) {
                this.levelPanel[level].setVisible(false);
                continue;
            }
            this.levelPanel[level].setVisible(true);
            int y = 1;
            int x = 1;
            for (int i = 0; i < this.serverLevel[level].size() && btnIdx < this.btn.length; ++btnIdx, ++i) {
                String classname;
                String[] prop;
                TangoServer server = (TangoServer)this.serverLevel[level].elementAt(i);
                gbc.gridx = x++;
                gbc.gridy = y;
                gbc.fill = 2;
                this.btn[btnIdx] = new JButton(server.toString());
                this.levelPanel[level].add((Component)this.btn[btnIdx], gbc);
                this.btn[btnIdx].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        HostInfoDialog.this.serverBtnActionPerformed(evt);
                    }
                });
                this.btn[btnIdx].addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent evt) {
                        HostInfoDialog.this.serverBtnMouseClicked(evt);
                    }
                });
                int pos = server.getName().indexOf("/");
                if (pos > 0 && (prop = AstorUtil.getServerClassProperties(classname = server.getName().substring(0, pos)))[0] != null) {
                    this.btn[btnIdx].setToolTipText(prop[0]);
                }
                if (x <= x_servers) continue;
                x = 1;
                ++y;
            }
        }
        this.addLevelPanelTitles();
        this.pack();
        if (this.btn.length > 0) {
            int i;
            int height = 10;
            int width = 0;
            for (i = 0; i < this.btn.length; ++i) {
                if (this.btn[i] == null || !this.btn[i].isVisible() || width >= this.btn[i].getWidth()) continue;
                width = this.btn[i].getWidth();
                height = this.btn[i].getHeight();
            }
            for (i = 0; i < this.btn.length; ++i) {
                if (this.btn[i] == null || !this.btn[i].isVisible()) continue;
                this.btn[i].setPreferredSize(new Dimension(width, height));
            }
        }
        this.pack();
    }

    private void serverBtnMouseClicked(MouseEvent evt) {
        this.pMenu.showMenu(evt);
    }

    public void updatePanel() {
        for (int level = 0; level < this.levelPanel.length; ++level) {
            this.levelPanel[level].removeAll();
        }
        this.buildPanel();
        this.thread.updateData(true);
    }

    private void checkUpdatePanel() {
        if (this.isVisible() && this.btn.length != this.host.nbServers()) {
            this.checkUpdatePanel(true);
        }
    }

    void checkUpdatePanel(boolean forced) {
        if (forced) {
            for (int level = 0; level < this.levelPanel.length; ++level) {
                this.levelPanel[level].removeAll();
            }
            this.buildPanel();
        }
    }

    public int getChoice() {
        return returnStatus;
    }

    public String getServerName() {
        return servname;
    }

    void doClose(int retStatus) {
        this.host.poll_serv_lists = false;
        returnStatus = retStatus;
        this.setVisible(false);
        this.thread.updateData(false);
        this.dispose();
    }

    void updateData() {
        this.thread.updateData(true);
    }

    static {
        returnStatus = 0;
    }

    class ServerThread
    extends Thread {
        private long period = AstorUtil.getStarterReadPeriod() / 2;
        private boolean update_data = true;

        public synchronized void wait_next_update() {
            try {
                this.wait(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void updateData(boolean b) {
            this.update_data = b;
            this.notify();
        }

        private synchronized void updateParent() {
            int state;
            HostInfoDialog.this.checkUpdatePanel(true);
            for (int i = 0; i < HostInfoDialog.this.btn.length; ++i) {
                if (HostInfoDialog.this.btn[i] == null) continue;
                TangoServer server = HostInfoDialog.this.host.getServer(HostInfoDialog.this.btn[i].getText());
                state = server == null ? 0 : (server.isRunning() ? 3 : 1);
                HostInfoDialog.this.btn[i].setForeground(AstorDefs.fg[state]);
                HostInfoDialog.this.btn[i].setBackground(AstorDefs.bg[state]);
            }
            state = ((HostInfoDialog)HostInfoDialog.this).host.notifyd_state;
            if (HostInfoDialog.this.notifydBtn.isVisible()) {
                HostInfoDialog.this.notifydBtn.setForeground(AstorDefs.fg[state]);
                HostInfoDialog.this.notifydBtn.setBackground(AstorDefs.bg[state]);
            }
        }

        public void run() {
            while (true) {
                if (this.update_data) {
                    this.updateParent();
                }
                this.wait_next_update();
            }
        }
    }
}

