/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.Monitor;
import app_util.PopupError;
import app_util.PopupMessage;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoDs.Except;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DeviceTree
extends JTree
implements AstorDefs {
    private CtrlSystem cs;
    private Astor appli;
    private JTextArea infoLabel;
    private DefaultTreeModel treeModel;
    private final String[] collections = new String[]{"Controlled Servers", "Not Controlled servers", "Devices"};
    private final int CTRL_SERVERS = 0;
    private final int N_CTRL_SERVERS = 1;
    private final int DEVICES = 2;
    private Monitor monitor;
    private DefaultMutableTreeNode[] collnodes;

    public DeviceTree(Astor appli, Monitor monitor, JTextArea lbl, String title) {
        this.appli = appli;
        this.monitor = monitor;
        this.infoLabel = lbl;
        this.cs = new CtrlSystem(appli.tree.hosts.length);
        this.initComponent(title);
    }

    private void initComponent(String title) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(title);
        this.createNodes(root);
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
                DeviceTree.this.collapsedPerfomed(e);
            }

            public void treeExpanded(TreeExpansionEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DeviceTree.this.treeMouseClicked(evt);
            }
        });
    }

    private void createNodes(DefaultMutableTreeNode root) {
        this.collnodes = new DefaultMutableTreeNode[this.collections.length];
        for (int i = 0; i < this.collections.length; ++i) {
            this.collnodes[i] = new DefaultMutableTreeNode(this.collections[i]);
            root.add(this.collnodes[i]);
        }
        try {
            DefaultMutableTreeNode[] s_node = new DefaultMutableTreeNode[2];
            double ratio = 0.0;
            String[] servers = ApiUtil.get_db_obj().get_server_name_list();
            for (int i = 0; i < servers.length; ++i) {
                ratio = (double)i / (double)servers.length / 2.0;
                s_node[0] = new DefaultMutableTreeNode(servers[i]);
                s_node[1] = new DefaultMutableTreeNode(servers[i]);
                String[] instances = ApiUtil.get_db_obj().get_instance_name_list(servers[i]);
                for (int j = 0; j < instances.length; ++j) {
                    String servname = servers[i] + "/" + instances[j];
                    this.monitor.setProgressValue(ratio, "Building for Server " + servname);
                    DbServInfo info = new DbServer(servname).get_info();
                    if (info.controlled) {
                        ++this.cs.nb_instances;
                        DbServer dbs = new DbServer(servname);
                        String[] classes = dbs.get_class_list();
                        this.cs.nb_classes += classes.length;
                        for (int c = 0; c < classes.length; ++c) {
                            String[] dn = dbs.get_device_name(classes[c]);
                            this.cs.nb_devices += dn.length;
                        }
                        s_node[0].add(new DefaultMutableTreeNode(instances[j]));
                        continue;
                    }
                    ++this.cs.not_c_instances;
                    s_node[1].add(new DefaultMutableTreeNode(instances[j]));
                }
                if (s_node[0].getChildCount() > 0) {
                    ++this.cs.nb_servers;
                    this.collnodes[0].add(s_node[0]);
                }
                if (s_node[1].getChildCount() > 0) {
                    this.collnodes[1].add(s_node[1]);
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Database dbase = ApiUtil.get_db_obj();
            String[] domain = dbase.get_device_domain("*");
            for (int i = 0; i < domain.length; ++i) {
                ratio = (double)i / (double)domain.length / 2.0 + 0.5;
                DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(domain[i]);
                this.collnodes[2].add(d_node);
                String wildcard = domain[i] + "/*";
                String[] family = dbase.get_device_family(wildcard);
                for (int f = 0; f < family.length; ++f) {
                    this.monitor.setProgressValue(ratio, "Building for Device family " + domain[i] + "/" + family[f]);
                    DefaultMutableTreeNode f_node = new DefaultMutableTreeNode(family[f]);
                    d_node.add(f_node);
                    wildcard = domain[i] + "/" + family[f] + "/*";
                    String[] member = dbase.get_device_member(wildcard);
                    for (int m = 0; m < member.length; ++m) {
                        DefaultMutableTreeNode m_node = new DefaultMutableTreeNode(member[m]);
                        f_node.add(m_node);
                    }
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.appli, e);
        }
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (this.getRowForLocation(evt.getX(), evt.getY()) < 1) {
            return;
        }
        TreePath path = this.getPathForLocation(evt.getX(), evt.getY());
        int mask = evt.getModifiers();
        if ((mask & 0x10) != 0) {
            String devname = null;
            switch (path.getPathCount()) {
                case 5: {
                    devname = this.getDeviceName(path);
                    if (devname != null) break;
                    return;
                }
                case 4: {
                    String servname = this.getServerName(path);
                    if (servname == null) {
                        return;
                    }
                    devname = "dserver/" + servname;
                    break;
                }
                default: {
                    return;
                }
            }
            try {
                DeviceInfo info = ApiUtil.get_db_obj().get_device_info(devname);
                this.infoLabel.setText(info.toString());
            }
            catch (DevFailed e) {
                this.infoLabel.setText(" ");
            }
            if (evt.getClickCount() == 2) {
                this.showHostInfoDialogForDevice(devname, evt);
            }
        }
    }

    public void collapsedPerfomed(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        if (path.getPathCount() > 2) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
        if (path.getPathCount() == 1) {
            this.setExpandedState(new TreePath(node.getPath()), true);
            PopupMessage.showImage((Component)this.appli, this.cs.toString(), "/admin/img/tango_icon.jpg");
        }
    }

    String[][] getNotCtrlServers() {
        DefaultMutableTreeNode node = this.collnodes[1];
        int nb_serv = node.getChildCount();
        Vector<String> v_serv = new Vector<String>();
        for (int i = 0; i < nb_serv; ++i) {
            node = node.getNextNode();
            String servname = node.toString();
            int nb_inst = node.getChildCount();
            try {
                for (int j = 0; j < nb_inst; ++j) {
                    node = node.getNextNode();
                    String server = servname + "/" + node;
                    DbServInfo info = new DbServer(server).get_info();
                    if (info.controlled || servname.equals("Starter")) continue;
                    v_serv.add(server);
                }
                continue;
            }
            catch (DevFailed e) {
                v_serv.add(e.errors[0].desc);
            }
        }
        String[][] result = new String[v_serv.size()][];
        for (int i = 0; i < v_serv.size(); ++i) {
            String server = (String)v_serv.elementAt(i);
            result[i] = new String[2];
            result[i][0] = server;
            try {
                String date;
                DeviceInfo info2 = new DbDevice("dserver/" + server).get_info();
                result[i][1] = date = info2.last_exported;
                continue;
            }
            catch (DevFailed e) {
                result[i][1] = e.errors[0].desc;
            }
        }
        return result;
    }

    private void showHostInfoDialogForDevice(String devname, MouseEvent evt) {
        try {
            String hostname = new IORdump(devname).get_host();
            if (hostname == null) {
                Except.throw_exception((String)"UNKNOWN_HOST", (String)"May be this device has never been exported !", (String)"");
            }
            StringTokenizer st = new StringTokenizer(hostname);
            hostname = st.nextToken();
            st = new StringTokenizer(hostname, ".");
            hostname = st.nextToken();
            this.appli.tree.setSelectionPath(hostname);
            this.appli.tree.displayHostInfo(this.getLocationOnScreen());
        }
        catch (DevFailed e) {
            PopupError.show((Component)this, e);
        }
    }

    private String getDeviceName(TreePath path) {
        String collec = path.getPathComponent(1).toString();
        if (!collec.equals(this.collections[2])) {
            return null;
        }
        String devname = path.getPathComponent(2).toString() + "/" + path.getPathComponent(3).toString() + "/" + path.getPathComponent(4).toString();
        return devname;
    }

    private String getServerName(TreePath path) {
        String collec = path.getPathComponent(1).toString();
        if (collec != this.collections[0] && collec != this.collections[1]) {
            return null;
        }
        String servname = path.getPathComponent(2).toString() + "/" + path.getPathComponent(3).toString();
        return servname;
    }

    String csInfo() {
        return this.cs.toString();
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon tangoIcon;
        private String tango_host = AstorUtil.getTangoHost();
        private ImageIcon serv_icon;
        private ImageIcon dev_icon;
        private Font[] fonts;
        private final int TITLE = 0;
        private final int LEAF = 1;

        public TangoRenderer() {
            this.tangoIcon = new ImageIcon(this.getClass().getResource("/admin/img/network5.gif"));
            this.serv_icon = new ImageIcon(this.getClass().getResource("/admin/img/server.gif"));
            this.dev_icon = new ImageIcon(this.getClass().getResource("/admin/img/device.gif"));
            this.fonts = new Font[2];
            this.fonts[0] = new Font("helvetica", 1, 18);
            this.fonts[1] = new Font("helvetica", 0, 12);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(Color.white);
            if (row == 0) {
                this.setBackgroundSelectionColor(Color.white);
                this.setIcon(this.tangoIcon);
                this.setFont(this.fonts[0]);
                this.setToolTipText("Double click to popup info");
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                Object user_obj = node.getUserObject();
                switch (node.getLevel()) {
                    case 1: {
                        this.setBackgroundSelectionColor(Color.white);
                        this.setToolTipText("Tango " + user_obj.toString());
                        this.setFont(this.fonts[0]);
                        break;
                    }
                    default: {
                        this.setBackgroundSelectionColor(Color.lightGray);
                        if (leaf) {
                            TreeNode[] path = node.getPath();
                            DefaultMutableTreeNode c_node = (DefaultMutableTreeNode)path[1];
                            String collec = c_node.getUserObject().toString();
                            if (collec.equals(DeviceTree.this.collections[2])) {
                                this.setIcon(this.dev_icon);
                            } else {
                                this.setIcon(this.serv_icon);
                            }
                            this.setToolTipText("Double click to popup host window.");
                        }
                        this.setFont(this.fonts[1]);
                    }
                }
            }
            return this;
        }
    }

    class CtrlSystem {
        int nb_hosts = 0;
        int nb_servers = 0;
        int nb_instances = 0;
        int nb_classes = 0;
        int nb_devices = 0;
        int not_c_instances = 0;

        public CtrlSystem(int nb_hosts) {
            this.nb_hosts = nb_hosts;
        }

        public String toString() {
            String str = "";
            str = str + this.nb_hosts + "  Hosts controlled.\n";
            str = str + this.nb_servers + "  Different controlled servers.\n";
            str = str + this.nb_instances + "  Controlled servers/instances.\n";
            str = str + this.nb_classes + "  Controlled classes.\n";
            str = str + this.nb_devices + "  Controlled devices.\n\n";
            str = str + this.not_c_instances + "  NOT controlled servers/instances.";
            return str;
        }
    }
}

