/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import java.io.IOException;

public class AstorCmdLine {
    private int action = -1;
    private TangoHost[] hosts = null;
    private AstorUtil util = AstorUtil.getInstance();
    private static final int NOT_INITIALIZED = -1;
    private static final int START_SERVERS = 0;
    private static final int STOP_SERVERS = 1;
    private static final String[] known_actions = new String[]{"start", "stop"};

    public AstorCmdLine(String[] args) throws DevFailed, Exception {
        this.manageArgs(args);
        this.doAction();
    }

    private void doAction() throws DevFailed, Exception {
        int nb_levels = AstorUtil.getStarterNbStartupLevels();
        switch (this.action) {
            case 0: {
                for (int level = 1; level <= nb_levels; ++level) {
                    this.doAction(level);
                }
                break;
            }
            case 1: {
                for (int level = nb_levels; level >= 1; --level) {
                    this.doAction(level);
                }
                break;
            }
        }
    }

    private void doAction(int level) {
        if (!this.getConfirm(level)) {
            System.out.println("Skip level " + level);
            return;
        }
        for (int h = 0; h < this.hosts.length; ++h) {
            try {
                switch (this.action) {
                    case 1: {
                        if (this.hosts[h].getName().startsWith("crate")) break;
                        this.hosts[h].stopServers(level);
                        break;
                    }
                    case 0: {
                        if (this.hosts[h].getName().startsWith("crate")) break;
                        this.hosts[h].startServers(level);
                    }
                }
                System.out.println("\tdone on " + this.hosts[h].getName());
                continue;
            }
            catch (DevFailed e) {
                System.out.println("\tfailed on " + this.hosts[h].getName());
                System.out.println(e.errors[0].desc);
            }
        }
    }

    private boolean getConfirm(int level) {
        String resp;
        System.out.println("\n");
        do {
            System.out.print(known_actions[this.action] + " all TANGO ds for level " + level + " ?  (y/n) ");
            byte[] b = new byte[80];
            try {
                System.in.read(b);
                resp = new String(b).toLowerCase().trim();
            }
            catch (IOException e) {
                resp = "no";
            }
        } while (!resp.startsWith("n") && !resp.startsWith("y"));
        return resp.startsWith("y");
    }

    private void manageArgs(String[] args) throws DevFailed, Exception {
        if (args.length < 3) {
            this.displaySyntax();
            throw new Exception("Astor Exception");
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h")) {
                String s;
                if ((s = args[++i]).toLowerCase().equals("all")) {
                    this.hosts = this.util.getTangoHostList();
                    continue;
                }
                this.hosts = new TangoHost[1];
                this.hosts[0] = new TangoHost(s);
                continue;
            }
            for (int j = 0; j < known_actions.length; ++j) {
                if (!args[i].equals(known_actions[j])) continue;
                this.action = j;
            }
        }
        if (this.action == -1 || this.hosts == null) {
            this.displaySyntax();
            throw new Exception("Astor Exception");
        }
    }

    private void displaySyntax() {
        System.out.println("Syntax:");
        System.out.println("astor <action> <-h hostname>");
        System.out.println();
        System.out.println("Actions:");
        System.out.println("\tstart: will start all servers");
        System.out.println("\tstop : will stop  all servers");
        System.out.println();
        System.out.println("hostname: host to do it (or -h all for all hosts)");
    }
}

