/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;
import pogo.gene.Property;

public class PropertyTable
extends Vector
implements PogoDefs {
    public PropertyTable() {
    }

    public PropertyTable(Vector v_in) {
        for (int i = 0; i < v_in.size(); ++i) {
            this.addElement(v_in.elementAt(i));
        }
    }

    public PropertyTable(String filename, int source, int lang) throws FileNotFoundException, SecurityException, IOException, PogoException {
        int end;
        String endstr;
        String[] srcStr = new String[]{"Class", "Device"};
        FileInputStream fidin = new FileInputStream(filename);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString code = new PogoString(inStr);
        fidin.close();
        String startstr = lang == 0 ? "//--------- Start of properties data members ----------" : "properties member data";
        int start = code.str.indexOf(startstr);
        if (start < 0) {
            System.out.println("No property found in " + filename);
            return;
        }
        if (source == 0) {
            endstr = lang == 0 ? "//--------- End of properties data members ----------" : "//\tMethod prototypes";
            start = code.nextCr(start) + 1;
            end = code.str.indexOf(endstr, start);
            end = code.previousCr(end) - 1;
        } else {
            String string = endstr = lang == 0 ? "//--------- End of properties data members ----------" : "//@}";
            if (lang == 0) {
                start = code.str.indexOf("/**", start);
                end = code.str.indexOf("//--------- End of properties data members ----------", start);
            } else {
                start = code.inMethod(start) + 2;
                end = code.str.indexOf("//@}", start);
            }
        }
        if (start > end || start < 0 || end < 0) {
            System.out.println("No property found in " + filename);
            return;
        }
        String core = new String(code.str.substring(start, end));
        end = 0;
        start = 0;
        while ((end = core.indexOf("*/", end)) > 0) {
            PogoString pgs = new PogoString(core.substring(start, end += 3));
            String desc = pgs.getDescription();
            start = end;
            end = core.indexOf(";", start);
            StringTokenizer st = new StringTokenizer(core.substring(start, end));
            String type = st.nextToken().toString();
            String name = st.nextToken().toString();
            if (name.charAt(0) >= 'a' || name.charAt(0) >= 'z') {
                char car = (char)(name.charAt(0) - 32);
                name = new String(car + name.substring(1));
            }
            this.addElement(new Property(name, type, desc));
        }
    }

    public Property propertyAt(int idx) {
        return (Property)this.elementAt(idx);
    }

    protected String updateJavaMethod(String readcode, String target, String classname) throws PogoException {
        Property property;
        int i;
        PogoString core = new PogoString(readcode);
        String cl_array = "cl_prop";
        String prop_array = target.equals("device") ? "dev_prop" : cl_array;
        int start = core.str.indexOf("Automatic code generation");
        if (start < 0) {
            throw new PogoException("Input File Syntax error 1!'Automatic code generation' Not found");
        }
        start = core.nextCr(start) + 1;
        start = core.nextCr(start) + 1;
        int end = core.str.indexOf("End of Automatic code generation", start);
        end = core.previousCr(end);
        StringBuffer sb = new StringBuffer(core.str.substring(0, start));
        sb.append("\t\tif (Util._UseDb==false)\n\t\t\treturn;\n");
        sb.append("\t\tString[]\tpropnames = {\n");
        for (i = 0; i < this.size(); ++i) {
            property = this.propertyAt(i);
            sb.append("\t\t\t\t\"" + property + "\"");
            if (i < this.size() - 1) {
                sb.append(",");
            }
            sb.append("\n");
        }
        sb.append("\t\t\t};\n");
        sb.append("\n");
        sb.append("\t\t//\tCall database and extract values\n");
        sb.append("\t\t//--------------------------------------------\n");
        if (target.equals("device")) {
            sb.append("\t\tDbDatum[]\t");
        } else {
            sb.append("\t\t");
        }
        sb.append(prop_array + " = get_db_" + target + "().get_property(propnames);\n");
        if (target.equals("device")) {
            sb.append("\t\t" + classname + "Class\tds_class = (" + classname + "Class)get_device_class();\n");
        }
        sb.append("\t\tint\ti = -1;\n");
        for (i = 0; i < this.size(); ++i) {
            property = this.propertyAt(i);
            sb.append("\t\t//\tExtract " + property.name + " value\n");
            sb.append("\t\tif (" + prop_array + "[++i].is_empty()==false)");
            sb.append("\t\t" + property.getVarName() + " = " + prop_array + "[i]." + property.type.extract_java_method() + ";\n");
            sb.append("\t\telse\n");
            if (target.equals("device")) {
                sb.append("\t\t{\n");
                sb.append("\t\t\t//\tTry to get value from class property\n");
                sb.append("\t\t\tDbDatum\tcl_prop = ds_class.get_class_property(dev_prop[i].name);\n");
                sb.append("\t\t\tif (cl_prop.is_empty()==false)\t" + property.getVarName() + " = cl_prop." + property.type.extract_java_method() + ";\n");
                sb.append("\t\t}\n");
            } else {
                sb.append("\t\t\t" + prop_array + "[i].insert(" + property.getVarName() + ");\n");
            }
            if (i >= this.size() - 1) continue;
            sb.append("\n");
        }
        sb.append("\n");
        sb.append(core.str.substring(end));
        return sb.toString();
    }

    protected String addJavaDataMembers(String readcode) throws PogoException {
        PogoString pg = new PogoString(readcode);
        int start = pg.str.indexOf("//--------- Start of properties data members ----------");
        if (start < 0) {
            throw new PogoException(new String("Input File Syntax error !\n//--------- Start of properties data members ----------\n Not found !"));
        }
        int end = pg.str.indexOf("//--------- End of properties data members ----------");
        if (end < 0) {
            throw new PogoException(new String("Input File Syntax error !\n//--------- End of properties data members ----------\n Not found !"));
        }
        String prev_declar = pg.str.substring(start, end);
        StringBuffer sb = new StringBuffer("//--------- Start of properties data members ----------");
        sb.append("\n\n");
        for (int i = 0; i < this.size(); ++i) {
            Property property = this.propertyAt(i);
            sb.append(property.buildDefinition(0));
        }
        sb.append("\n");
        pg.replace(prev_declar, sb.toString());
        return pg.str;
    }

    void readDefaultValues(String filename, int source, int lang) throws FileNotFoundException, SecurityException, IOException, PogoException {
        if (lang == 0) {
            return;
        }
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        int start = code.indexOf("::set_default_property()");
        if (start < 0) {
            return;
        }
        start = code.str.indexOf("{", start);
        int end = code.outMethod(start);
        PogoString method = new PogoString(code.str.substring(start, end));
        String tag = "//\tSet Default Device Properties";
        int idx = method.indexOf(tag);
        if (end < 0) {
            throw new PogoException("\"" + tag + "\" Not Found");
        }
        method = source == 0 ? new PogoString(method.str.substring(0, idx)) : new PogoString(method.str.substring(idx));
        for (int i = 0; i < this.size(); ++i) {
            Property prop = this.propertyAt(i);
            start = method.indexOf("\"" + prop.name + "\"");
            if (start <= 0) continue;
            start = method.indexOf("prop_def", start);
            start = method.indexOf("\"", start);
            end = method.nextCr(++start);
            end = method.lastIndexOf("\"", end);
            PogoString pgs = new PogoString(method.str.substring(start, end));
            while (pgs.str.indexOf("\\n") > 0) {
                pgs.replace("\\n", "\n");
            }
            prop.default_value = pgs.str;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < this.size(); ++i) {
            Property prop = (Property)this.elementAt(i);
            sb.append(prop.name + "\t");
            sb.append(prop.type.cpp_code_str + "\n");
        }
        return sb.toString();
    }
}

