/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import pogo.gene.PogoDefs;
import pogo.gene.PogoException;

public class ProjectFiles
implements PogoDefs {
    private static String orig_path = null;
    private static String orig_class_name = null;
    private static String path;
    private static String class_name;
    private static int language;
    private static String extention;
    private String doc_path = "";

    public ProjectFiles(String path, String class_name, int language) {
        ProjectFiles.path = path;
        ProjectFiles.class_name = class_name;
        ProjectFiles.language = language;
        extention = language == 0 ? ".java" : ".cpp";
    }

    public ProjectFiles(String filename) throws PogoException {
        int ext_idx;
        for (ext_idx = filename.length() - 1; ext_idx > 0 && filename.charAt(ext_idx) != '.'; --ext_idx) {
        }
        if (ext_idx == 0) {
            throw new PogoException(filename + ": Not Available File's Name !");
        }
        extention = filename.substring(ext_idx);
        if (extention.equals(".java")) {
            language = 0;
        } else if (extention.equals(".cpp") || extention.equals(".h")) {
            language = 1;
            extention = ".cpp";
        } else {
            throw new PogoException("File's extention unknown !");
        }
        int end_path = filename.lastIndexOf("/", ext_idx);
        if (end_path < 0 && (end_path = filename.lastIndexOf("\\", ext_idx)) < 0) {
            path = ".";
            class_name = filename.substring(0, ext_idx);
        }
        if (end_path > 0) {
            path = filename.substring(0, end_path);
            class_name = filename.substring(end_path + 1, ext_idx);
        }
        orig_path = new String(path);
        orig_class_name = new String(class_name);
    }

    public void updateOriginalFields() {
        orig_path = new String(path);
        orig_class_name = new String(class_name);
    }

    public int getLanguage() {
        return language;
    }

    public String getPath() {
        return path;
    }

    public String getOriginalPath() {
        return orig_path;
    }

    public void setPath(String path) {
        ProjectFiles.path = path;
    }

    public void setOriginalPath(String orig_path) {
        ProjectFiles.orig_path = orig_path;
    }

    public String getClassName() {
        return class_name;
    }

    public String getOriginalClassName() {
        return orig_class_name;
    }

    public void setClassName(String class_name) {
        ProjectFiles.class_name = class_name;
    }

    public void setOriginalClassName(String orig_class_name) {
        ProjectFiles.orig_class_name = orig_class_name;
    }

    public String getServer() {
        return path + "/" + class_name + extention;
    }

    public String getServer_h() {
        return path + "/" + class_name + ".h";
    }

    public String getServerClass() {
        return path + "/" + class_name + "Class" + extention;
    }

    public String getServerClass_h() {
        return path + "/" + class_name + "Class.h";
    }

    public String getAllowed() {
        if (language == 0) {
            return "";
        }
        return path + "/" + class_name + "StateMachine" + extention;
    }

    public String getDocHtml() {
        if (!this.doc_path.equals("")) {
            return this.doc_path;
        }
        this.doc_path = System.getProperty("HTML_DIR");
        this.doc_path = this.doc_path == null ? path + "/doc_html" : (this.doc_path.startsWith("/") ? this.doc_path : path + "/" + this.doc_path);
        return this.doc_path;
    }

    public String getHtmlServerslist() {
        return "ServersList";
    }

    public String toString() {
        return "ProjectFiles:\nPath:\t" + path + "\nClass: \t" + this.getClassName() + "\nServer:\t" + this.getServer() + "\nServer.h:\t" + this.getServer_h() + "\nServerC:\t" + this.getServerClass() + "\nServerC.h:\t" + this.getServerClass_h();
    }

    public static void main(String[] args) {
        String filename = "/segfs/tango/tools/pogo/test/cpp/PowerSupply/PowerSupply.h";
        try {
            ProjectFiles p = new ProjectFiles(filename);
            System.out.println(p);
            System.out.println();
            System.out.println();
            p = new ProjectFiles("../template", "Test", 1);
            System.out.println(p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

