/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import pogo.gene.DevState;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;

public class DevStateTable
extends Vector
implements PogoDefs {
    public DevStateTable() {
    }

    public DevStateTable(Vector v_in) {
        for (int i = 0; i < v_in.size(); ++i) {
            this.addElement(v_in.elementAt(i));
        }
    }

    public DevStateTable(String filename, int lang) throws FileNotFoundException, SecurityException, IOException, PogoException {
        String str = PogoUtil.readFile(filename);
        int start = str.indexOf("Device States Description:");
        if (start < 0) {
            System.out.println("WARNING: Device States Description:Not found !");
            return;
        }
        start = str.indexOf("\n", start) + 1;
        int end = str.indexOf("*/", start);
        PogoString pgs = new PogoString(str.substring(start, end));
        pgs.getDescription();
        String pattern = lang == 1 ? "Tango::" : "DevState.";
        end = 0;
        start = 0;
        while (end >= 0 && (start = pgs.str.indexOf(pattern, end)) >= 0) {
            end = pgs.str.indexOf(":", start + pattern.length() + 1);
            String name = pgs.str.substring(start, end).trim();
            start = end + 2;
            String desc = (end = pgs.str.indexOf(pattern, start)) > 0 ? pgs.str.substring(start, end).trim() : (start < pgs.str.length() ? pgs.str.substring(start) : "");
            this.addElement(new DevState(name, desc));
            start = end;
        }
    }

    public DevState stateAt(int idx) {
        return (DevState)this.elementAt(idx);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < this.size(); ++i) {
            DevState state = (DevState)this.elementAt(i);
            sb.append(state.name + ":\n");
            sb.append(state.description + "\n");
        }
        return sb.toString();
    }

    public String toStringComments(int lang) {
        StringBuffer sb = new StringBuffer(" *\tDevice States Description:\n");
        for (int i = 0; i < this.size(); ++i) {
            DevState state = (DevState)this.elementAt(i);
            String name = lang == 1 ? state.name : state.javaName();
            PogoString pgs = new PogoString(" *\t" + name + " :\t" + state.description);
            for (int idx = 0; idx < pgs.str.length(); ++idx) {
                if (pgs.str.charAt(idx) != '\n') continue;
                pgs.insert(idx + 1, " *\t\t\t");
            }
            sb.append(pgs + "\n");
        }
        return sb.toString();
    }

    String allowedCore() {
        if (this.size() == 0) {
            return null;
        }
        String s = "{\n\tif (";
        for (int i = 0; i < this.size(); ++i) {
            DevState state = this.stateAt(i);
            if (i > 0) {
                s = s + "\t||\n\t\t";
            }
            s = s + "get_state() == " + PogoDefs.TangoStatesArray[state.code];
        }
        s = s + ")\n\t{\n\t\t//\t";
        return s;
    }

    public DevStateTable(String method) {
        int start = method.indexOf("if (");
        if (start < 0) {
            return;
        }
        int end = method.indexOf(")\n", start += "if (".length());
        String code = method.substring(start, end);
        start = 0;
        String target = "get_state() == ";
        while ((start = code.indexOf(target, start)) >= 0) {
            StringTokenizer st = new StringTokenizer(code.substring(start += target.length()));
            String str_state = st.nextToken().toString();
            this.add(new DevState(str_state, str_state));
        }
    }

    public static void main(String[] args) {
        String code = "//=========================================================\n/**\n *\tRead/Write allowed for Voltage attribute.\n */\n//=========================================================\nbool PowerSupply::is_Voltage_allowed(Tango::AttReqType type)\n{\n\tif (get_state() == Tango::FAULT\t||\n\t\tget_state() == Tango::ALARM)\n\t{\n\t\t//\tEnd of Generated Code\n\t\t\n\t\t\tif(All_ok)\n\t\t\t\tdo_it();\n\n\t\t//\tRe-Start of Generated Code\n\t\treturn false;\n\t}\n\treturn true\n}\n";
        try {
            DevStateTable table = new DevStateTable(code);
            System.out.println(table);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

