/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.Tango.DispLevel;
import pogo.gene.DevStateTable;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.TangoTypes;

public class Attrib
implements PogoDefs {
    public String name;
    public int attrType;
    public TangoTypes dataType;
    public int rwType;
    public String assAttr;
    public int xSize;
    public int ySize;
    public DevStateTable notAllowedFor;
    public DispLevel disp_level = DispLevel.OPERATOR;
    public int polled_period = 0;
    public boolean memorized = false;
    public String[] properties;
    private String[] def_prop_method = new String[]{"set_label", "set_unit", "set_standard_unit", "set_display_unit", "set_format", "set_max_value", "set_min_value", "set_max_alarm", "set_min_alarm", "set_description"};
    private String set_def_prop_method = "set_default_properties";

    public Attrib(String name, String readcode) throws PogoException {
        this.name = name;
        PogoString code = new PogoString(readcode);
        int start = code.indexOf("class " + name + "Attr:");
        if (start < 0 && (start = code.indexOf("class " + name + "Attrib:")) < 0) {
            throw new PogoException("Attribute class not defined in header file !");
        }
        start = code.inMethod(start);
        int end = code.outMethod(start);
        PogoString class_def = new PogoString(code.substring(start, end));
        end = class_def.indexOf(") {}");
        start = class_def.lastIndexOf("(", end) + 1;
        PogoString constructor = new PogoString(class_def.substring(start, end));
        String[] params = constructor.getFields();
        end = start;
        String constr_signature = class_def.substring(start = class_def.lastIndexOf("public:", end) + "public:".length(), end).trim();
        this.attrType = constr_signature.indexOf(":ImageAttr") > 0 ? 2 : (constr_signature.indexOf(":SpectrumAttr") > 0 ? 1 : 0);
        int idx = 1;
        this.dataType = new TangoTypes(params[idx++]);
        this.rwType = 0;
        for (int i = 0; i < PogoDefs.AttrRWtypeArray.length; ++i) {
            String target = "Tango::" + PogoDefs.AttrRWtypeArray[i];
            if (!params[idx].equals(target)) continue;
            this.rwType = i;
        }
        ++idx;
        switch (this.attrType) {
            case 0: {
                if (this.rwType != 3) break;
                this.assAttr = params[idx++];
                break;
            }
            case 1: {
                this.xSize = new Integer(params[idx++]);
                break;
            }
            case 2: {
                this.xSize = new Integer(params[idx++]);
                this.ySize = new Integer(params[idx++]);
            }
        }
        this.properties = new String[10];
        this.notAllowedFor = new DevStateTable();
    }

    public Attrib(String name, int attrType, String dataType, int rwType, String assAttr) {
        this(name, attrType, dataType, 1, 1);
        this.rwType = rwType;
        this.assAttr = assAttr;
    }

    public Attrib(String name, int attrType, String dataType, int rwType, int xSize) {
        this(name, attrType, dataType, rwType, xSize, 1);
    }

    public Attrib(String name, int attrType, String dataType, int rwType, int xSize, int ySize) {
        this.name = name;
        this.attrType = attrType;
        this.dataType = new TangoTypes(dataType, "");
        this.rwType = rwType;
        this.xSize = xSize;
        this.ySize = ySize;
        this.assAttr = "";
        this.properties = new String[10];
        this.notAllowedFor = new DevStateTable();
    }

    public void setDataType(String dataType) {
        this.dataType = new TangoTypes(dataType, "");
    }

    public void setDataType(String dataType, int lang) {
        this.dataType = new TangoTypes(dataType);
    }

    public boolean getWritable() {
        return this.rwType != 0 && this.rwType != 3;
    }

    public String cppMemberData() {
        StringBuffer sb = new StringBuffer();
        if (this.rwType != 1) {
            sb.append("\t\t" + this.dataType.cpp + "\t*attr_" + this.name + "_read;\n");
        }
        if (this.getWritable()) {
            sb.append("\t\t" + this.dataType.cpp + "\tattr_" + this.name + "_write;\n");
        }
        return sb.toString();
    }

    public String javaMemberData() {
        StringBuffer sb = new StringBuffer();
        if (this.rwType != 1) {
            sb.append("\tprotected " + this.dataType.java + "[]\tattr_" + this.name + "_read " + "= new " + this.dataType.java);
            switch (this.attrType) {
                case 0: {
                    sb.append("[1];\n");
                    break;
                }
                case 1: {
                    sb.append("[" + this.xSize + "];\n");
                    break;
                }
                case 2: {
                    sb.append("[" + this.xSize * this.ySize + "];\n");
                }
            }
        }
        if (this.attrType == 0 && this.rwType != 0 && this.rwType != 3) {
            sb.append("\tprotected " + this.dataType.java + "\tattr_" + this.name + "_write;\n");
        }
        return sb.toString();
    }

    public String buildCodeForAttributeConstructor(int lang) {
        if (lang == 1) {
            return "\t" + this.name + "Attrib\t*" + this.getLowerName() + " = new " + this.name + "Attrib();\n";
        }
        String[] att_type = new String[]{"Attr", "SpectrumAttr", "ImageAttr"};
        String namespace = lang == 0 ? "" : "Tango::";
        String tab = lang == 0 ? "\t" : "";
        String pointer = lang == 0 ? "" : "*";
        String argtype = lang == 0 ? this.dataType.java_code_str : this.dataType.cpp_code_str;
        StringBuffer sb = new StringBuffer("\t" + tab + namespace);
        sb.append(att_type[this.attrType] + "\t" + pointer + this.getLowerName() + " = \n");
        sb.append(tab + "\t\t" + "new " + namespace + att_type[this.attrType] + "(");
        sb.append("\"" + this.name + "\", " + argtype + ", ");
        switch (this.attrType) {
            case 0: {
                if (lang == 0) {
                    namespace = "AttrWriteType.";
                }
                sb.append(namespace + PogoDefs.AttrRWtypeArray[this.rwType]);
                if (this.rwType != 3) break;
                sb.append(", \"" + this.assAttr + "\"");
                break;
            }
            case 1: {
                sb.append(this.xSize);
                break;
            }
            case 2: {
                sb.append(this.xSize + ", " + this.ySize);
            }
        }
        sb.append(");\n");
        return sb.toString();
    }

    public String buitCodeForDefaultProperties(int lang) {
        String namespace;
        String pointer;
        String tab = lang == 0 ? "\t" : "";
        boolean has_been_set = false;
        for (int i = 0; i < this.properties.length; ++i) {
            if (this.properties[i] == null || this.properties[i].length() <= 0) continue;
            has_been_set = true;
        }
        StringBuffer sb = new StringBuffer("");
        String string = pointer = lang == 0 ? "." : "->";
        if (has_been_set) {
            namespace = lang == 0 ? "" : "Tango::";
            sb.append(tab + "\t" + namespace + "UserDefaultAttrProp\t" + this.getLowerName() + "_prop");
            if (lang == 0) {
                sb.append(" = new UserDefaultAttrProp()");
            }
            sb.append(";\n");
            for (int i = 0; i < this.def_prop_method.length; ++i) {
                if (this.properties[i] == null || this.properties[i].length() <= 0) continue;
                sb.append(tab + "\t" + this.getLowerName() + "_prop." + this.def_prop_method[i] + "(\"" + this.properties[i] + "\");\n");
            }
            sb.append(tab + "\t" + this.getLowerName() + pointer + this.set_def_prop_method + "(" + this.getLowerName() + "_prop);\n");
        }
        if (this.polled_period > 0) {
            sb.append(tab + "\t" + this.getLowerName() + pointer + "set_polling_period(" + this.polled_period + ");\n");
        }
        if (this.disp_level == DispLevel.EXPERT) {
            namespace = lang == 0 ? "DispLevel." : "Tango::";
            sb.append(tab + "\t" + this.getLowerName() + pointer + "set_disp_level(" + namespace + "EXPERT);\n");
        }
        if (this.memorized) {
            sb.append(tab + "\t" + this.getLowerName() + pointer + "set_memorized();\n");
        }
        return sb.toString();
    }

    public void getDefaultProperties(PogoString pgs, int lang) {
        String method;
        String prop_def = new String(this.getLowerName() + "_prop.");
        int start = 0;
        int end = 0;
        String pattern = "//\tAttribute : ";
        start = pgs.str.indexOf(pattern + this.name);
        if (start < 0) {
            return;
        }
        end = pgs.str.indexOf(pattern, start + 1);
        PogoString block = end > 0 ? new PogoString(pgs.str.substring(start, end)) : new PogoString(pgs.str.substring(start));
        end = 0;
        while ((start = block.str.indexOf(prop_def, end)) > 0) {
            end = block.nextCr(start);
            int start1 = start + prop_def.length();
            int end1 = block.str.indexOf("(", start1);
            method = block.str.substring(start1, end1);
            start1 = block.str.indexOf("\"", end1) + 1;
            end1 = block.str.indexOf("\"", start1);
            String value = block.str.substring(start1, end1);
            for (int i = 0; i < this.def_prop_method.length; ++i) {
                if (!method.equals(this.def_prop_method[i])) continue;
                this.properties[i] = value;
            }
        }
        String code = block.str;
        String pointer = lang == 0 ? "." : "->";
        method = this.getLowerName() + pointer + "set_polling_period(";
        start = code.indexOf(method);
        if (start > 0) {
            this.polled_period = Integer.parseInt(code.substring(start += method.length(), code.indexOf(")", start)));
        }
        if ((start = code.indexOf(method = this.getLowerName() + pointer + "set_disp_level(")) > 0) {
            String strlevel;
            this.disp_level = (strlevel = code.substring(start += method.length(), code.indexOf(")", start))).indexOf("EXPERT") > 0 ? DispLevel.EXPERT : DispLevel.OPERATOR;
        }
        if ((start = code.indexOf(method = this.getLowerName() + pointer + "set_memorized();")) > 0) {
            this.memorized = true;
        }
    }

    String getDescription() {
        return this.properties[this.def_prop_method.length - 1];
    }

    String getDescriptionLine() {
        String desc = this.properties[this.def_prop_method.length - 1];
        if (desc == null) {
            return desc;
        }
        if (desc.length() == 0) {
            return desc;
        }
        PogoString line = new PogoString(desc);
        while (line.str.indexOf("\\n") >= 0) {
            line.replace("\\n", " ");
        }
        return line.str;
    }

    String buildCppClassesDefs(String template, String class_name) {
        String add_param;
        int start;
        String src;
        PogoString pgs = new PogoString(template);
        while (pgs.indexOf("ATTRIBUTE") > 0) {
            pgs.replace("ATTRIBUTE", this.name);
        }
        while (pgs.indexOf("CLASS") > 0) {
            pgs.replace("CLASS", class_name);
        }
        String inherite_class = src = ":Attr";
        if (this.attrType == 1) {
            inherite_class = ":SpectrumAttr";
        } else if (this.attrType == 2) {
            inherite_class = ":ImageAttr";
        }
        pgs.replace(src, inherite_class);
        pgs.replace(src, inherite_class);
        pgs.replace("DATA_TYPE", this.dataType.cpp_code_str);
        pgs.replace("RW_TYPE", "Tango::" + PogoDefs.AttrRWtypeArray[this.rwType]);
        if (this.attrType == 0 && this.rwType == 3) {
            start = pgs.indexOf(") {}");
            add_param = ", \"" + this.assAttr + "\"";
            pgs.insert(start, add_param);
        }
        if (this.attrType == 1 || this.attrType == 2) {
            start = pgs.indexOf(") {}");
            add_param = ", " + this.xSize;
            pgs.insert(start, add_param);
        }
        if (this.attrType == 2) {
            start = pgs.indexOf(") {}");
            add_param = ", " + this.ySize;
            pgs.insert(start, add_param);
        }
        if (!this.getWritable()) {
            start = pgs.indexOf("\tvirtual void write");
            int end = pgs.indexOf("\tvirtual bool is_allowed");
            pgs.remove(pgs.substring(start, end));
        }
        return pgs.str;
    }

    String readSignatureMethod(String class_name) {
        return this.signature("/**\n *\tExtract real attribute values for ATTRIBUTE acquisition result.\n */\n\tvirtual void CLASS::METHOD(Tango::Attribute &attr)", class_name, "read_" + this.name, false);
    }

    String writeSignatureMethod(String class_name) {
        return this.signature("/**\n *\tWrite ATTRIBUTE attribute values to hardware.\n */\n\tvirtual void CLASS::METHOD(Tango::WAttribute &attr)", class_name, "write_" + this.name, false);
    }

    String allowedSignatureMethod(String class_name) {
        return this.signature("/**\n *\tRead/Write allowed for ATTRIBUTE attribute.\n */\n\tvirtual bool CLASS::METHOD(Tango::AttReqType type)", class_name, "is_" + this.name + "_allowed", false);
    }

    String readFullSignatureMethod(String class_name) {
        return this.signature("/**\n *\tExtract real attribute values for ATTRIBUTE acquisition result.\n */\n\tvirtual void CLASS::METHOD(Tango::Attribute &attr)", class_name, "read_" + this.name, true);
    }

    String writeFullSignatureMethod(String class_name) {
        return this.signature("/**\n *\tWrite ATTRIBUTE attribute values to hardware.\n */\n\tvirtual void CLASS::METHOD(Tango::WAttribute &attr)", class_name, "write_" + this.name, true);
    }

    String allowedFullSignatureMethod(String class_name) {
        return this.signature("/**\n *\tRead/Write allowed for ATTRIBUTE attribute.\n */\n\tvirtual bool CLASS::METHOD(Tango::AttReqType type)", class_name, "is_" + this.name + "_allowed", true);
    }

    private String signature(String template, String cl_name, String method, boolean full) {
        int start;
        String target;
        PogoString pgs = new PogoString(template);
        pgs.replace("ATTRIBUTE", this.name);
        pgs.replace("METHOD", method);
        if (cl_name == null) {
            pgs.replace("CLASS::", "");
        } else {
            pgs.replace("CLASS", cl_name);
            if (full) {
                target = " *\t";
                start = pgs.indexOf(target, "/**".length());
                int end = pgs.nextCr(start += target.length());
                String desc = pgs.substring(start, end);
                PogoString separator = new PogoString("//+----------------------------------------------------------------------------\n//\n// method : \t\tCLASS::METHOD\n// \n// description : \tDESCRIPTION\n//\n//-----------------------------------------------------------------------------\n");
                separator.replace("CLASS", cl_name);
                separator.replace("METHOD", method);
                separator.replace("DESCRIPTION", desc);
                target = " */\n\tvirtual ";
                end = pgs.indexOf(target);
                String comments = pgs.substring(0, end + target.length());
                pgs.replace(comments, separator.str);
            }
        }
        if (!full) {
            target = " */\n\tvirtual ";
            start = pgs.indexOf(target);
            return pgs.substring(start += target.length());
        }
        return pgs.str;
    }

    String getDevImpl2ReadAttr(PogoString code, String classname) {
        String pattern = "void " + classname + "::read_attr(Tango::Attribute &attr)";
        int start = code.str.indexOf(pattern);
        if (start < 0) {
            return "";
        }
        start = code.inMethod(start);
        int end = code.outMethod(start);
        PogoString method = new PogoString(code.str.substring(start, end));
        pattern = "if (attr_name == \"" + this.name + "\")";
        start = method.str.indexOf(pattern);
        if (start < 0) {
            return "";
        }
        start = method.inMethod(start);
        end = method.outMethod(start);
        start = method.nextCr(start);
        end = method.previousCr(end - 2);
        PogoString block = new PogoString(method.str.substring(start, end));
        block.indent(-1);
        return block.str;
    }

    String getDevImpl2WriteAttr(PogoString code, String classname) {
        String pattern = "void " + classname + "::write_attr_hardware(vector<long> &attr_list)";
        int start = code.str.indexOf(pattern);
        if (start < 0) {
            System.out.println(pattern + " Not found !");
            return "";
        }
        start = code.inMethod(start);
        int end = code.outMethod(start);
        PogoString method = new PogoString(code.str.substring(start, end));
        pattern = "if (attr_name == \"" + this.name + "\")";
        start = method.str.indexOf(pattern);
        if (start < 0) {
            System.out.println(pattern + " Not found !");
            return "";
        }
        start = method.inMethod(start);
        end = method.outMethod(start);
        start = method.nextCr(start);
        end = method.previousCr(end - 2);
        PogoString block = new PogoString(method.str.substring(start, end));
        block.indent(-2);
        while (block.str.indexOf("att.") > 0) {
            block.replace("att.", "attr.");
        }
        return block.str;
    }

    String allowedCore() {
        return this.notAllowedFor.allowedCore();
    }

    public void setMemorized(boolean val) {
        System.out.println(this.name + " -> " + val);
        this.memorized = val;
    }

    public boolean getMemorized() {
        return this.memorized;
    }

    public String getLowerName() {
        PogoString pgs = new PogoString(this.name);
        return pgs.toLowerString();
    }

    public String toString() {
        return this.name;
    }
}

