/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import app_util.PopupError;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import pogo.appli.PogoAppli;
import pogo.appli.PogoAppliDefs;
import pogo.gene.DevState;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;

public class StateDialog
extends JDialog
implements PogoAppliDefs,
PogoDefs {
    private static int returnStatus = 0;
    private JFrame parent;
    private PogoClass server;
    private int state_idx = -1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton okBtn;
    private JButton cancelBtn;
    private JLabel nameLbl;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JTextArea descText;
    private JComboBox jComboBox1;
    private JScrollPane scrollPane;

    public StateDialog(JFrame parent, PogoClass server, DevState state, int action) {
        super((Frame)parent, true);
        int i;
        this.parent = parent;
        this.server = server;
        this.initComponents();
        for (i = 0; i < PogoDefs.TangoStatesArray.length; ++i) {
            this.jComboBox1.addItem(PogoDefs.TangoStatesArray[i]);
        }
        this.initializeWindow(state);
        if (action == 0) {
            this.state_idx = -1;
        } else {
            for (i = 0; i < server.states.size(); ++i) {
                if (server.states.stateAt(i) != state) continue;
                this.state_idx = i;
            }
        }
        this.pack();
    }

    private void initComponents() {
        this.setBackground(new Color(198, 178, 168));
        this.setTitle("Edit State Window");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                StateDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.jPanel1 = new JPanel();
        this.jPanel1.setLayout(new FlowLayout(2, 5, 5));
        this.okBtn = new JButton();
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StateDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn = new JButton();
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.setActionCommand("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StateDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2 = new JPanel();
        this.jPanel2.setLayout(new GridBagLayout());
        this.nameLbl = new JLabel();
        this.nameLbl.setText("State Name:    ");
        this.nameLbl.setForeground(Color.black);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.nameLbl, gridBagConstraints1);
        this.jLabel5 = new JLabel();
        this.jLabel5.setText(" ");
        this.jLabel5.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 6;
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints1);
        this.jLabel6 = new JLabel();
        this.jLabel6.setText("State Description:  ");
        this.jLabel6.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 8;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints1);
        this.descText = new JTextArea();
        this.descText.setColumns(80);
        this.descText.setPreferredSize(new Dimension(1000, 400));
        this.descText.setMinimumSize(new Dimension(0, 100));
        this.scrollPane = new JScrollPane();
        this.scrollPane.setPreferredSize(new Dimension(500, 150));
        this.scrollPane.setViewportView(this.descText);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 9;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.gridheight = 5;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.jPanel2.add((Component)this.scrollPane, gridBagConstraints1);
        this.jComboBox1 = new JComboBox();
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        this.jPanel2.add((Component)this.jComboBox1, gridBagConstraints1);
        this.getContentPane().add((Component)this.jPanel2, "Center");
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        String name = this.jComboBox1.getSelectedItem().toString();
        for (int i = 0; i < this.server.states.size(); ++i) {
            DevState state = this.server.states.stateAt(i);
            if (!state.name.equals(name) || i == this.state_idx) continue;
            PopupError.show((Component)this, "State " + name + " Already Exists !");
            return;
        }
        this.doClose(1);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    private void initializeWindow(DevState state) {
        if (state != null) {
            for (int i = 0; i < PogoDefs.TangoStatesArray.length; ++i) {
                if (!PogoDefs.TangoStatesArray[i].equals(state.name)) continue;
                this.jComboBox1.setSelectedIndex(i);
            }
            if (state.description != null) {
                this.descText.setText(state.description);
            }
        }
    }

    public int showDialog() {
        PogoAppli.centerDialog(this, this.parent);
        this.setVisible(true);
        return returnStatus;
    }

    public DevState getInput() {
        return new DevState(this.jComboBox1.getSelectedItem().toString(), this.descText.getText());
    }

    public String getInputName() {
        return this.jComboBox1.getSelectedItem().toString();
    }

    public String getInputDescription() {
        return this.descText.getText();
    }
}

