/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import app_util.PopupError;
import app_util.PopupMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import pogo.appli.ClassDialog;
import pogo.appli.GenerateThread;
import pogo.appli.PogoAppliDefs;
import pogo.appli.PogoCmdLine;
import pogo.appli.PogoFileFilter;
import pogo.appli.PogoTree;
import pogo.appli.PrefGeneDialog;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGeneCpp;
import pogo.gene.PogoUtil;
import pogo.gene.ServerDefinitions;
import pogo.gene.Taco2Tango;

public class PogoAppli
extends JFrame
implements PogoAppliDefs,
PogoDefs {
    private static String revNumber = "Revision 4.4.1a  -  Tue Sep 20 15:16:10 CEST 2005";
    static PogoTree tree;
    private static PogoClass pogo;
    private static String homeDir;
    private static JFileChooser chooser;
    private static String[] palette;
    JLabel versionLabel;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem newMenuItem;
    private JMenuItem openMenuItem;
    private JMenuItem importMenuItem;
    private JSeparator jSeparator1;
    private JMenuItem geneSrcBtn;
    private JMenuItem geneDocBtn;
    private JSeparator jSeparator2;
    private JMenuItem exitMenuItem;
    private JMenu editMenu;
    private JMenuItem deleteMenuItem;
    private JMenuItem moveUpItem;
    private JMenuItem moveDownItem;
    private JMenu helpMenu;
    private JMenuItem contentsMenuItem;
    private JMenuItem whatNewBtn;
    private JSeparator jSeparator4;
    private JMenuItem aboutMenuItem;
    private JScrollPane jScrollPane1;
    private JPanel southPanel;
    private JPanel mousePanel;
    private JLabel leftBtnLabel;
    private JLabel rightBtnLabel;
    private JPanel jPanel1;
    private JLabel jLabel1;
    private JRadioButton cppBtn;
    private JRadioButton javaBtn;

    public PogoAppli() {
        this.initComponents();
        tree = new PogoTree(this);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 450));
        this.jScrollPane1.setViewportView(tree);
        this.jScrollPane1.setBackground(tree.getBackground());
        this.customMenu();
        this.setPogoDefined(false);
        this.setTitle("POGO - " + revNumber);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/app_util/img/tango_icon.jpg"));
        this.setIconImage(icon.getImage());
        this.pack();
        this.centerWindow();
    }

    public void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrsize = toolkit.getScreenSize();
        Dimension appsize = this.getSize();
        Point p = new Point();
        p.x = (scrsize.width - appsize.width) / 2;
        p.y = (scrsize.height - appsize.height) / 2;
        this.setLocation(p);
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.importMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.geneSrcBtn = new JMenuItem();
        this.geneDocBtn = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.deleteMenuItem = new JMenuItem();
        this.moveUpItem = new JMenuItem();
        this.moveDownItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.whatNewBtn = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.aboutMenuItem = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.southPanel = new JPanel();
        this.mousePanel = new JPanel();
        this.leftBtnLabel = new JLabel();
        this.rightBtnLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.cppBtn = new JRadioButton();
        this.javaBtn = new JRadioButton();
        this.fileMenu.setText("File");
        this.fileMenu.setName("File");
        this.newMenuItem.setText("New Class");
        this.newMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.newMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newMenuItem);
        this.openMenuItem.setText("Open");
        this.openMenuItem.setToolTipText("Open Class File");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.importMenuItem.setText("Import");
        this.importMenuItem.setToolTipText("import TACO server");
        this.importMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.importMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.importMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.geneSrcBtn.setText("Generate Source");
        this.geneSrcBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.generateAP(evt);
            }
        });
        this.fileMenu.add(this.geneSrcBtn);
        this.geneDocBtn.setText("Generate Doc.");
        this.geneDocBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.generateAP(evt);
            }
        });
        this.fileMenu.add(this.geneDocBtn);
        this.fileMenu.add(this.jSeparator2);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent evt) {
                PogoAppli.this.editAP(evt);
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuCanceled(MenuEvent evt) {
            }
        });
        this.deleteMenuItem.setText("Delete");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.deleteMenuItem);
        this.moveUpItem.setText("Move Up");
        this.moveUpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.moveUpActionPerformed(evt);
            }
        });
        this.editMenu.add(this.moveUpItem);
        this.moveDownItem.setText("Move Down");
        this.moveDownItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.moveDownActionPerformed(evt);
            }
        });
        this.editMenu.add(this.moveDownItem);
        this.menuBar.add(this.editMenu);
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setText("Shortcuts");
        this.contentsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.helpAP(evt);
            }
        });
        this.helpMenu.add(this.contentsMenuItem);
        this.whatNewBtn.setText("What's New ?");
        this.whatNewBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.helpAP(evt);
            }
        });
        this.helpMenu.add(this.whatNewBtn);
        this.helpMenu.add(this.jSeparator4);
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.helpAP(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setTitle("Pogo Appli");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PogoAppli.this.exitForm(evt);
            }
        });
        this.jScrollPane1.setBackground(Color.white);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.southPanel.setLayout(new BorderLayout());
        this.mousePanel.setLayout(new BorderLayout());
        this.leftBtnLabel.setHorizontalTextPosition(2);
        this.mousePanel.add((Component)this.leftBtnLabel, "Center");
        this.mousePanel.add((Component)this.rightBtnLabel, "North");
        this.southPanel.add((Component)this.mousePanel, "Center");
        this.jLabel1.setBackground(Color.white);
        this.jLabel1.setText("Language Generated: ");
        this.jPanel1.add(this.jLabel1);
        this.cppBtn.setText("C++");
        this.cppBtn.setToolTipText("The device server will be generated in C++");
        this.cppBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.languageBtnAP(evt);
            }
        });
        this.jPanel1.add(this.cppBtn);
        this.javaBtn.setText("Java");
        this.javaBtn.setToolTipText("The device server will be generated in Java");
        this.javaBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.languageBtnAP(evt);
            }
        });
        this.jPanel1.add(this.javaBtn);
        this.southPanel.add((Component)this.jPanel1, "North");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.setJMenuBar(this.menuBar);
    }

    private void moveDownActionPerformed(ActionEvent evt) {
        tree.moveSelection("Down");
    }

    private void moveUpActionPerformed(ActionEvent evt) {
        tree.moveSelection("Up");
    }

    private void editAP(MenuEvent evt) {
        boolean state = tree.isLeafSelected();
        this.deleteMenuItem.setEnabled(state);
        this.moveUpItem.setEnabled(state);
        this.moveDownItem.setEnabled(state);
    }

    private void helpAP(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        String message = null;
        message = cmd.equals("About") ? "                     POGO \n\n(Program Obviously used to Generate tango Object)\n        TANGO device server code generator.\n\n" + revNumber + "\n\n" + "Pascal Verdier - Software Engineering Group - ESRF" : PogoUtil.getHelpMessage(cmd);
        if (message != null) {
            PopupMessage.showImage((Component)this, message, "/app_util/img/tango_icon.jpg");
        }
    }

    private void newMenuItemActionPerformed(ActionEvent evt) {
        ClassDialog classDialog;
        Object[] options;
        if (tree != null && tree.hasBeenModified() && JOptionPane.showOptionDialog(this, "This project has not been saved !\n\nDiscard modifications ?", "Warning", -1, 2, null, options = new Object[]{"OK", "CANCEL"}, options[0]) != 0) {
            return;
        }
        if (homeDir == null && (homeDir = System.getProperty("HOME_GENE")) == null) {
            homeDir = new File("").getAbsolutePath();
        }
        if ((classDialog = new ClassDialog(this, new ServerDefinitions())).showDialog() == 1) {
            if (tree != null) {
                this.setPogoDefined(false);
                this.versionLabel.setText("");
                pogo = null;
            }
            try {
                ServerDefinitions sd = classDialog.getInput();
                if (sd == null) {
                    return;
                }
                if (!sd.inherited_from.equals("Device_3Impl")) {
                    pogo = new PogoClass(sd.inherited_from);
                    PogoAppli.pogo.class_name = sd.name;
                    PogoAppli.pogo.is_abstractclass = false;
                    PogoAppli.pogo.inherited_from = sd.inherited_from;
                    PogoAppli.pogo.class_desc = sd.description;
                    PogoAppli.pogo.title = sd.project_title;
                } else {
                    pogo = new PogoClass(sd, this.getLanguage(), homeDir);
                }
                tree.setPogoTree(pogo);
                this.setPogoDefined(true);
                this.resetLanguage();
                tree.setHomeDir(homeDir);
            }
            catch (PogoException ex) {
                PopupError.show((Component)this, ex);
            }
            catch (Exception e) {
                PopupError.show((Component)this, e);
            }
        }
    }

    private void generateAP(ActionEvent evt) {
        String type = evt.getActionCommand();
        if (type.indexOf("Source") > 0) {
            this.generateSource(0);
        } else if (type.indexOf("Doc.") > 0 && tree != null) {
            if (tree.hasBeenModified()) {
                Object[] options = new Object[]{"Generate Source\n Before", "Generate Only\n Documentation", "CANCEL"};
                switch (JOptionPane.showOptionDialog(this, "The source files have not been generated !\nThe programmer's guide generation use source files.\n\n\n", "Warning", -1, 2, null, options, options[0])) {
                    case 0: {
                        this.generateSource(0);
                        this.generateSource(1);
                        break;
                    }
                    case 1: {
                        this.generateSource(1);
                    }
                }
            } else {
                this.generateSource(1);
            }
        }
    }

    private void languageBtnAP(ActionEvent evt) {
        String lang = evt.getActionCommand();
        if (lang.equals("Java")) {
            this.cppBtn.setSelected(false);
            this.javaBtn.setSelected(true);
            PogoClass server = tree.getPogoClass();
            if (PogoAppli.pogo.inherited_from != null && !PogoAppli.pogo.inherited_from.equals("Device_3Impl")) {
                PopupMessage.show((Component)this, "Java classes inheritance is not yet available");
                this.cppBtn.setSelected(true);
                this.javaBtn.setSelected(false);
                return;
            }
            String[] problems = server.attributes.isJavaCompatible();
            if (problems != null) {
                PopupMessage.show((Component)this, "WARNING: Java Servers API do not support:", problems);
            }
        } else {
            this.cppBtn.setSelected(true);
            this.javaBtn.setSelected(false);
        }
        tree.setLanguage(this.getLanguage());
    }

    private void generateSource(int item) {
        this.generateSource(item, 1);
    }

    private void generateSource(int item, int exiting) {
        if (homeDir == null && (homeDir = System.getProperty("HOME_GENE")) == null) {
            homeDir = new File("").getAbsolutePath();
        }
        int lang = 0;
        lang = this.getLanguage();
        tree.setLanguage(lang);
        PogoClass server = tree.getPogoClass();
        if (server == null) {
            return;
        }
        if (item == 0) {
            PrefGeneDialog dialog = new PrefGeneDialog(this, lang);
            if (dialog.showDialog(homeDir, server.is_abstractclass) != 1) {
                return;
            }
            homeDir = dialog.getOutputPath();
            server.is_abstractclass = dialog.getOutputModel();
            tree.setHomeDir(homeDir);
            tree.setOutputModel(server.is_abstractclass);
        }
        if (lang == 0) {
            Object[] options;
            StringTokenizer st = new StringTokenizer(homeDir, "/");
            String dir = null;
            while (st.countTokens() > 0) {
                dir = st.nextToken().toString();
            }
            if (!PogoAppli.pogo.class_name.equals(dir) && JOptionPane.showOptionDialog(this, new String("The Class name will be used as package name.\n\nBut the directory does not have the Class name !\n\nProblem will occur when you try to compile.\n"), "Warning", -1, 2, null, options = new String[]{"Generate Source", "CANCEL"}, options[1]) == 1) {
                return;
            }
            if (PogoAppli.pogo.inherited_from != null && !PogoAppli.pogo.inherited_from.equals("Device_3Impl")) {
                PopupMessage.show((Component)this, "Java classes inheritance is not yet available");
                return;
            }
            String[] problems = server.attributes.isJavaCompatible();
            if (problems != null) {
                PopupMessage.show((Component)this, "Java Servers API do not support:", problems);
                return;
            }
        }
        server.projectFiles.setPath(homeDir);
        server.author = PogoAppli.pogo.author;
        server.revision = PogoAppli.pogo.revision;
        if (lang == 1 && server.projectFiles.getOriginalClassName() != null && server.projectFiles.getOriginalPath() != null && !server.class_name.equals(server.projectFiles.getOriginalClassName()) && homeDir.equals(server.projectFiles.getOriginalPath())) {
            Object[] options = new Object[]{"Modify", "New Files", "CANCEL"};
            switch (JOptionPane.showOptionDialog(this, "The class name has been modified !\n\nWould you like to modify old files or create new ones ?", "Warning", -1, 2, null, options, options[0])) {
                case 0: {
                    System.out.println("Modify old files");
                    try {
                        new PogoGeneCpp(server).changeClassName();
                    }
                    catch (Exception e) {
                        PopupError.show((Component)this, e);
                    }
                    break;
                }
                case 1: {
                    System.out.println("Create new files");
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        server.language = this.getLanguage();
        GenerateThread gt = new GenerateThread(this, server, item, homeDir, exiting);
        gt.start();
        tree.setModified(false);
        tree.setLanguage(this.getLanguage());
        if (exiting == 0) {
            try {
                gt.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void customMenu() {
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/pogo/img/pogo.jpg")));
        this.jLabel1.setDisabledIcon(null);
        this.jLabel1.setBackground(Color.black);
        this.versionLabel = new JLabel();
        this.versionLabel.setText("");
        this.versionLabel.setBackground(Color.black);
        this.getContentPane().add((Component)this.versionLabel, "North");
        this.fileMenu.setMnemonic('F');
        this.editMenu.setMnemonic('E');
        this.helpMenu.setMnemonic('H');
        this.newMenuItem.setMnemonic('N');
        this.openMenuItem.setMnemonic('O');
        this.importMenuItem.setMnemonic('I');
        this.exitMenuItem.setMnemonic('E');
        this.deleteMenuItem.setMnemonic('D');
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.importMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.geneSrcBtn.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.geneDocBtn.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.moveUpItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.moveDownItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.resetLanguage();
    }

    private void setLanguage() {
        switch (PogoAppli.pogo.language) {
            case 0: {
                this.cppBtn.setSelected(false);
                this.javaBtn.setSelected(true);
                break;
            }
            case 1: {
                this.cppBtn.setSelected(true);
                this.javaBtn.setSelected(false);
                break;
            }
            default: {
                this.cppBtn.setSelected(false);
                this.javaBtn.setSelected(false);
            }
        }
    }

    private void resetLanguage() {
        boolean cpp = true;
        String inLang = System.getProperty("IN_LANG");
        if (inLang != null && inLang.indexOf("java") >= 0) {
            cpp = false;
        }
        this.cppBtn.setSelected(cpp);
        this.javaBtn.setSelected(!cpp);
    }

    int getLanguage() {
        if (this.javaBtn.getSelectedObjects() != null) {
            return 0;
        }
        return 1;
    }

    private void deleteMenuItemActionPerformed(ActionEvent evt) {
        tree.removeSelectedLeaf();
    }

    private void tracePogo(PogoClass server) {
        System.out.println("\n\n");
        System.out.println("-----------------------------------------------");
        System.out.println("Class Name:  " + server.class_name);
        System.out.println("States:");
        System.out.println(server.states);
        System.out.println("Commands:");
        System.out.println(server.commands);
        System.out.println("Output Files:  " + server.projectFiles.getPath());
        System.out.println("From templates:  " + server.templates_dir);
        System.out.println("-----------------------------------------------");
        for (int i = 0; i < server.commands.size(); ++i) {
            Cmd cmd = server.commands.cmdAt(i);
            System.out.println(cmd.name + " -> " + cmd.exec_method);
        }
    }

    void checkInheritance() throws PogoException, FileNotFoundException, SecurityException, IOException {
        int j;
        int i;
        if (System.getProperty("SUPER_HOME") == null) {
            PopupMessage.show((Component)this, "WARNING:\n" + PogoAppli.pogo.class_name + " inherit from " + pogo.inheritedClassName() + "\nBut SUPER_HOME is not defined !");
            return;
        }
        if (!new File(PogoAppli.pogo.inherited_from + ".h").exists()) {
            PopupMessage.show((Component)this, "WARNING:\n" + PogoAppli.pogo.class_name + " inherit from " + pogo.inheritedClassName() + "\n But " + PogoAppli.pogo.inherited_from + ".h not found !");
            return;
        }
        PogoClass sp = new PogoClass(PogoAppli.pogo.inherited_from + ".h");
        Vector<PogoDefs> v = new Vector<PogoDefs>();
        for (int i2 = 0; i2 < sp.commands.size(); ++i2) {
            boolean found = false;
            String name = sp.commands.cmdAt((int)i2).name;
            for (int j2 = 0; !found && j2 < PogoAppli.pogo.commands.size(); ++j2) {
                found = PogoAppli.pogo.commands.cmdAt((int)j2).name.equals(name);
            }
            if (found) continue;
            v.add(sp.commands.cmdAt(i2));
        }
        String message = "";
        if (v.size() > 0) {
            message = "Command" + (v.size() > 1 ? "s  " : "  ");
            for (i = 0; i < v.size(); ++i) {
                PogoAppli.pogo.commands.add(v.elementAt(i));
                message = message + v.elementAt(i).toString() + ", ";
            }
            message = message + " ha" + (v.size() > 1 ? "ve" : "s") + " been added in super class !";
        }
        if (message.length() > 0) {
            PopupMessage.show((Component)this, "WARNING:\n" + PogoAppli.pogo.class_name + " inherit from " + pogo.inheritedClassName() + "\n     But \n" + message);
        }
        v.clear();
        for (i = 0; i < sp.attributes.size(); ++i) {
            boolean found = false;
            String name = sp.attributes.attributeAt((int)i).name;
            for (j = 0; !found && j < PogoAppli.pogo.attributes.size(); ++j) {
                found = PogoAppli.pogo.attributes.attributeAt((int)j).name.equals(name);
            }
            if (found) continue;
            v.add(sp.attributes.attributeAt(i));
        }
        if (v.size() > 0) {
            message = "Attribute" + (v.size() > 1 ? "s  " : "  ");
            for (i = 0; i < v.size(); ++i) {
                PogoAppli.pogo.attributes.add(v.elementAt(i));
                message = message + v.elementAt(i).toString() + ", ";
            }
            message = message + " ha" + (v.size() > 1 ? "ve" : "s") + " been added in super class !";
        }
        v.clear();
        for (i = 0; i < sp.states.size(); ++i) {
            boolean found = false;
            String name = sp.states.stateAt((int)i).name;
            for (j = 0; !found && j < PogoAppli.pogo.states.size(); ++j) {
                found = PogoAppli.pogo.states.stateAt((int)j).name.equals(name);
            }
            if (found) continue;
            v.add(sp.states.stateAt(i));
        }
        if (v.size() > 0) {
            message = "State" + (v.size() > 1 ? "s  " : "  ");
            for (i = 0; i < v.size(); ++i) {
                PogoAppli.pogo.states.add(v.elementAt(i));
                message = message + v.elementAt(i).toString() + ", ";
            }
            message = message + " ha" + (v.size() > 1 ? "ve" : "s") + " been added in super class !";
        }
        if (message.length() > 0) {
            PopupMessage.show((Component)this, "WARNING:\n" + PogoAppli.pogo.class_name + " inherit from " + pogo.inheritedClassName() + "\n     But \n" + message);
        }
    }

    private void readSourceFile(String filename) {
        try {
            boolean action = false;
            String ext = PogoFileFilter.getExtension(filename);
            if (ext.equals("h")) {
                filename = filename.substring(0, filename.length() - 2) + ".cpp";
            }
            if (ext.equals("h") || ext.equals("cpp") || ext.equals("java")) {
                pogo = new PogoClass(filename);
                if (PogoAppli.pogo.inherited_from != null && !pogo.inheritedClassName().equals("Device_3Impl")) {
                    this.checkInheritance();
                }
            } else {
                Taco2Tango t2t = new Taco2Tango(filename);
                pogo = t2t.getPogoClass();
                action = true;
            }
            tree.setPogoTree(pogo);
            this.setPogoDefined(true);
            String message = PogoAppli.pogo.commands.checkArgsType();
            if (message != null) {
                PopupError.show((Component)this, message);
            }
            if (action && PogoAppli.pogo.states != null && PogoAppli.pogo.states.size() > 0) {
                PopupMessage.show((Component)this, "WARNING:\nDevice States have been created \n   BUT Not\nthe allowed state command !!!");
            }
        }
        catch (Exception ex) {
            PopupError.show((Component)this, ex);
            ex.printStackTrace();
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        this.buildPogoFromFile(0);
    }

    private void importMenuItemActionPerformed(ActionEvent evt) {
        this.buildPogoFromFile(1);
    }

    private void buildPogoFromFile(int action) {
        Object[] options;
        String defaultfile = System.getProperty("POGO_FILE");
        if (defaultfile != null && defaultfile.length() == 0) {
            defaultfile = null;
        }
        if (tree.hasBeenModified() && JOptionPane.showOptionDialog(this, "This project has not been saved !\n\nDiscard modifications ?", "Warning", -1, 2, null, options = new Object[]{"OK", "CANCEL"}, options[0]) != 0) {
            return;
        }
        String[] ext = new String[]{"h", "java"};
        PogoFileFilter tangoFF = new PogoFileFilter(ext, "TANGO Classes");
        tangoFF.setExtensionListInDescription(false);
        PogoFileFilter tacoFF = new PogoFileFilter("c", "TACO 'C' Classes");
        if (chooser == null) {
            homeDir = System.getProperty("HOME_GENE");
            if (homeDir == null) {
                homeDir = new File("").getAbsolutePath();
            }
            chooser = new JFileChooser(homeDir);
            chooser.addChoosableFileFilter(tacoFF);
            chooser.addChoosableFileFilter(tangoFF);
            if (action == 1) {
                chooser.setFileFilter(tacoFF);
            }
        } else if (action == 0) {
            PogoFileFilter ff = (PogoFileFilter)chooser.getFileFilter();
            if (ff.getDescription().indexOf("TACO") >= 0) {
                chooser.setFileFilter(tangoFF);
            }
        } else {
            chooser.setFileFilter(tacoFF);
        }
        chooser.setDialogTitle(action == 0 ? "Open" : "Import");
        chooser.setCurrentDirectory(new File(homeDir));
        int retval = defaultfile == null ? chooser.showOpenDialog(this) : 0;
        if (retval == 0) {
            File file;
            if (tree != null) {
                tree.clear();
                this.setPogoDefined(false);
                this.versionLabel.setText("");
                pogo = null;
            }
            if ((file = defaultfile == null ? chooser.getSelectedFile() : new File(defaultfile)) != null && !file.isDirectory()) {
                String filename = file.getAbsolutePath();
                this.readSourceFile(filename);
                homeDir = file.getParentFile().toString();
                if (pogo == null) {
                    return;
                }
                this.versionLabel.setText("  Author: " + PogoAppli.pogo.author + "  - Revision: " + PogoAppli.pogo.revision);
                if (file.getAbsolutePath().indexOf(".h") > 0) {
                    this.cppBtn.setSelected(true);
                    this.javaBtn.setSelected(false);
                } else if (file.getAbsolutePath().indexOf(".java") > 0) {
                    this.cppBtn.setSelected(false);
                    this.javaBtn.setSelected(true);
                }
                tree.setLanguage(this.getLanguage());
                tree.setHomeDir(homeDir);
                this.checkDevImplRev(filename);
            }
            PogoAppli.pogo.projectFiles.setOriginalClassName(PogoAppli.pogo.class_name);
            PogoAppli.pogo.projectFiles.setOriginalPath(homeDir);
        }
    }

    private void checkDevImplRev(String filename) {
        String message;
        int lang = 0;
        lang = this.getLanguage();
        if (lang == 0) {
            return;
        }
        String template_file = PogoAppli.pogo.templates_dir + "/cpp/DevServ.h";
        int template_rev = PogoUtil.deviceImplRevisionNumber(template_file);
        System.out.println("Template files are for Device_" + template_rev + "Impl");
        if (template_rev < 0) {
            message = "Cannot not found the C++ template files at\n" + PogoAppli.pogo.templates_dir + "/cpp\n";
            JOptionPane.showMessageDialog(this, message, "WARNING Window", 2);
            System.exit(0);
        } else if (template_rev < 3) {
            message = "The C++ template files situated in:\n" + PogoAppli.pogo.templates_dir + "/cpp\n" + "are not for this POGO version !\n\n" + "Please download and install the latest version.";
            JOptionPane.showMessageDialog(this, message, "WARNING Window", 2);
            System.exit(0);
        }
        int devimpl_rev = PogoUtil.deviceImplRevisionNumber(filename);
        if (devimpl_rev < 3) {
            System.out.println();
            System.out.println("**********************************************************************");
            System.out.println("This device server has been generated for an old TANGO release.\n\nBefore any modification of this project, Pogo needs to generate\ncode for new attribute model.\nYour code will be splited from :\n          read_attr(Tango::Attribute &attr)\n                       and\n          write_attr_hardware(vector<long> &attr_list)\nto the new methods generated for each attribute.\n\nThen you will be able to remove these two old methods.");
            System.out.println("**********************************************************************");
            System.out.println();
            Object[] options = new Object[]{"GENERATE", "CANCEL"};
            if (JOptionPane.showOptionDialog(this, "This device server has been generated for an old TANGO release.\n\nBefore any modification of this project, Pogo needs to generate\ncode for new attribute model.\nYour code will be splited from :\n          read_attr(Tango::Attribute &attr)\n                       and\n          write_attr_hardware(vector<long> &attr_list)\nto the new methods generated for each attribute.\n\nThen you will be able to remove these two old methods.", "Warning", -1, 2, null, options, options[0]) == 0) {
                System.out.println("Generate......");
                this.generateSource(0, 0);
                System.out.println();
                System.out.println("**********************************************************************");
                System.out.println("\tConversion to new TANGO model successfull");
                System.out.println("**********************************************************************");
                System.out.println();
                System.exit(0);
            }
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        if (tree != null && tree.hasBeenModified()) {
            Object[] options = new Object[]{"Yes", "No", "Cancel"};
            int choice = JOptionPane.showOptionDialog(this, "This project has not been saved !\n\nWould you like to generate modifications ?", "Warning", -1, 2, null, options, options[0]);
            switch (choice) {
                case 0: {
                    this.generateSource(0, 0);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        if (tree != null && tree.hasBeenModified() && JOptionPane.showConfirmDialog(this, "This project has not been saved !\n\nWould you like to generate modifications ?", "information", 0) == 0) {
            this.generateSource(0, 0);
        }
        System.exit(0);
    }

    private void setPogoDefined(boolean state) {
        tree.setVisible(state);
        this.geneSrcBtn.setEnabled(state);
        this.geneDocBtn.setEnabled(state);
        if (state) {
            this.setLanguage();
        }
    }

    public static void centerDialog(JDialog dialog, JFrame parent) {
        Point p = parent.getLocationOnScreen();
        p.x += (parent.getWidth() - dialog.getWidth()) / 2;
        p.y += (parent.getHeight() - dialog.getHeight()) / 2;
        dialog.setLocation(p);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                new PogoCmdLine(args);
            }
            catch (Exception e) {
                System.out.println(e);
            }
            System.exit(0);
        }
        try {
            PogoAppli pogoAppli = new PogoAppli();
            pogoAppli.setVisible(true);
            String[] list = PogoUtil.getTangoFilesList(".");
            if (System.getProperty("POGO_FILE") != null || list.length > 0) {
                pogoAppli.buildPogoFromFile(0);
            }
        }
        catch (Exception e) {
            System.out.println("POGO Startup Failed.");
            System.out.println(e);
            e.printStackTrace();
        }
    }

    static {
        palette = new String[]{"Edit Class", null, "Class  Property", "Device Property", "Command", "Attribute", "State"};
    }
}

