/*
 * Decompiled with CFR 0.152.
 */
package pogo.servers2www;

import java.io.File;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import pogo.gene.PogoClass;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;

public class CheckNews {
    private String old_list;
    private String new_list;
    private static final String title = "New Tango Device Server Classes";
    private String mail_tmp_file;

    public CheckNews(String[] filenames) throws Exception {
        this.old_list = PogoUtil.readFile(filenames[0]);
        this.new_list = PogoUtil.readFile(filenames[1]);
        this.mail_tmp_file = filenames[2];
    }

    public void checkData() throws Exception {
        Vector<String> v = new Vector<String>();
        StringTokenizer new_stk = new StringTokenizer(this.new_list, "\n");
        while (new_stk.hasMoreTokens()) {
            String classname = new_stk.nextToken();
            StringTokenizer old_stk = new StringTokenizer(this.old_list, "\n");
            boolean found = false;
            while (!found && old_stk.hasMoreTokens()) {
                found = classname.equals(old_stk.nextToken());
            }
            if (found) continue;
            int pos = classname.indexOf("/");
            if (pos > 0) {
                classname = classname.substring(0, pos);
            }
            v.add(classname);
        }
        System.out.println(v.size() + " new classes found !");
        if (v.size() == 0) {
            return;
        }
        Vector classes = this.getNewPogoClasses(v);
        if (classes.size() > 0) {
            this.buildMailFile(classes);
        }
    }

    private void buildMailFile(Vector classes) throws Exception {
        String templ_dir = System.getProperty("TEMPL_HOME");
        PogoString code = new PogoString(PogoUtil.readFile(templ_dir + "/html/header.html"));
        int position = code.indexOf("</Body>");
        String new_code = "";
        new_code = new_code + "New TANGO device servers list ";
        new_code = new_code + "has been automaticly generated at:\n";
        new_code = new_code + "http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc/";
        new_code = new_code + "\n\n" + classes.size();
        new_code = classes.size() > 1 ? new_code + " new classes have " : new_code + " new class has ";
        new_code = new_code + "been found during tango-cs, tango-ds and ESRF CVS repositories scan.\n";
        new_code = new_code + "\n\n\n";
        for (int i = 0; i < classes.size(); ++i) {
            PogoClass _class = (PogoClass)classes.elementAt(i);
            System.out.println(_class.class_name + " : " + _class.title + "\n" + _class.class_desc + "\n");
            new_code = new_code + _class.class_name + " : " + _class.title + "\n";
            new_code = new_code + "\t" + _class.class_desc + "\n\n\n";
        }
        new_code = new_code + "This is an automatic generated mail (" + new Date() + ").\n";
        new_code = new_code + "------------------------------------------------------------------------------------\n\n";
        PogoUtil.writeFile(this.mail_tmp_file, new_code);
    }

    private String getFileName(String classname) {
        String filename = classname + ".h";
        File file = new File(classname + "/" + classname + ".h");
        if (file.exists()) {
            return file.toString();
        }
        file = new File(classname + "/src/" + classname + ".h");
        if (file.exists()) {
            file.toString();
        } else {
            file = new File(classname + "/" + classname + ".java");
            if (file.exists()) {
                filename = file.toString();
            }
        }
        return filename;
    }

    private Vector getNewPogoClasses(Vector classnames) throws Exception {
        Vector<PogoClass> classes = new Vector<PogoClass>();
        for (int i = 0; i < classnames.size(); ++i) {
            String classname = (String)classnames.elementAt(i);
            String cmd = "tar -xzf " + classname + "/" + classname + ".tar.gz";
            System.out.println(cmd);
            PogoUtil.executeShellCmd(cmd);
            PogoUtil.executeShellCmd("ls -l");
            PogoClass _class = null;
            try {
                _class = new PogoClass(this.getFileName(classname));
            }
            catch (Exception e) {
                System.out.println(e);
            }
            if (_class != null) {
                classes.add(_class);
            }
            File f = new File(classname);
            String[] files = f.list();
            for (int j = 0; j < files.length; ++j) {
                File f1 = new File(classname + "/" + files[j]);
                if (!f1.isFile() || files[j].indexOf("tar.gz") >= 0) continue;
                f1.delete();
            }
        }
        return classes;
    }

    public static void main(String[] args) {
        CheckNews client = null;
        if (args.length < 3) {
            System.out.println("Old_file_names  new_file_names  mail_file_name ?");
            System.exit(0);
        }
        try {
            client = new CheckNews(args);
            client.checkData();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

