/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.Cmd;
import pogo.gene.DevState;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;
import pogo.gene.Property;

public class Taco2Tango
implements PogoDefs {
    private PogoClass server;
    private String filename;
    private String tacoCodeBeginning = new String(")/sizeof(db_resource)");
    private String tacoAddCommands = new String("DevCommandListEntry");
    private String tacoAddDevProps = new String("res_object[]");
    private String tacoAddClassProps = new String("res_class[]");
    private String tacoAddStates = new String("static long state_handler");
    private static String[] typeStr = new String[]{"D_VOID_TYPE", "Tango::DEV_VOID", "D_BOOLEAN_TYPE", "Tango::DEV_BOOLEAN", "D_USHORT_TYPE", "Tango::DEV_USHORT", "D_SHORT_TYPE", "Tango::DEV_SHORT", "D_ULONG_TYPE", "Tango::DEV_ULONG", "D_LONG_TYPE", "Tango::DEV_LONG", "D_FLOAT_TYPE", "Tango::DEV_FLOAT", "D_DOUBLE_TYPE", "Tango::DEV_DOUBLE", "D_STRING_TYPE", "Tango::DEV_STRING", "D_VAR_CHARARR", "Tango::DEVVAR_CHARARRAY", "D_VAR_STRINGARR", "Tango::DEVVAR_STRINGARRAY", "D_VAR_USHORTARR", "Tango::DEVVAR_USHORTARRAY", "D_VAR_SHORTARR", "Tango::DEVVAR_SHORTARRAY", "D_VAR_ULONGARR", "Tango::DEVVAR_ULONGARRAY", "D_VAR_LONGARR", "Tango::DEVVAR_LONGARRAY", "D_VAR_FLOATARR", "Tango::DEVVAR_FLOATARRAY", "D_VAR_DOUBLEARR", "Tango::DEVVAR_DOUBLEARRAY"};
    private static String[] typePropStr = new String[]{"D_VAR_STRINGARR", "vector<string>", "D_VAR_SHORTARR", "vector<short>", "D_VAR_LONGARR", "vector<long>", "D_VAR_FLOATARR", "vector<float>", "D_VAR_DOUBLEARR", "vector<double>"};
    private static String[] stateStr = new String[]{"DEVUNKNOWN", "DEVOFF", "DEVON", "DEVCLOSE", "DEVOPEN", "DEVLOW", "DEVHIGH", "DEVINSERTED", "DEVEXTRACTED", "DEVMOVING", "DEVWARMUP", "DEVINIT", "DEVSTANDBY", "DEVSERVICE", "DEVRUN", "DEVLOCAL", "DEVREMOTE", "DEVAUTOMATIC", "DEVRAMP", "DEVTRIPPED", "DEVHV_ENABLE", "DEVBEAM_ENABLE", "DEVBLOCKED", "DEVFAULT", "DEVSTARTING", "DEVSTOPPING", "DEVSTARTREQUESTED", "DEVSTOPREQUESTED", "DEVPOSITIVEENDSTOP", "DEVNEGATIVEENDSTOP", "DEVBAKEREQUESTED", "DEVBAKEING", "DEVSTOPBAKE", "DEVFORCEDOPEN", "DEVFORCEDCLOSE", "DEVOFFUNAUTHORISED", "DEVONNOTREGULAR", "DEVRESETTING", "DEVFORBIDDEN", "DEVOPENING", "DEVCLOSING", "DEVUNDEFINED", "DEVCOUNTING", "STOPPED", "RUNNING", "DEVALARM", "DEVDISABLED", "DEVSTANDBY_NOT_REACHED", "DEVON_NOT_REACHED"};

    private String extractClassFromPath(String str) {
        int start;
        int end;
        for (end = str.length() - 1; end > 0 && str.charAt(end) != '.'; --end) {
        }
        if (end == 0) {
            end = str.length() - 1;
        }
        for (start = end; start > 0 && str.charAt(start) != '/' && str.charAt(start) != '\\'; --start) {
        }
        if (str.charAt(start) == '/' || str.charAt(start) == '\\') {
            ++start;
        }
        return str.substring(start, end);
    }

    public Taco2Tango(String filename) throws PogoException {
        this.filename = filename;
        PogoString pgs = new PogoString(filename);
        this.server = new PogoClass(this.extractClassFromPath(filename), "From Taco Class", null, new Vector(), new Vector(), new Vector(), new Vector(), new Vector(), 1, pgs.extractPathFromFullPath());
        this.server.deviceImpl = 3;
        System.out.println("Taco2Tango created");
    }

    public PogoClass getPogoClass() throws FileNotFoundException, SecurityException, IOException, PogoException {
        PogoString pgs = new PogoString(PogoUtil.readFile(this.filename));
        this.extractCommands(pgs);
        this.extractStates(pgs);
        this.extractProperties(pgs, this.tacoAddDevProps);
        this.extractProperties(pgs, this.tacoAddClassProps);
        this.server.title = this.server.class_name;
        this.server.language = 1;
        this.server.deviceImpl = 3;
        return this.server;
    }

    private void extractStates(PogoString pgs) throws PogoException {
        block0: for (int i = 0; i < stateStr.length; ++i) {
            if (pgs.str.indexOf(stateStr[i]) <= 0) continue;
            String s1 = stateStr[i].substring(new String("DEV").length());
            for (int j = 0; j < PogoDefs.TangoStatesArray.length; ++j) {
                String s2 = PogoDefs.TangoStatesArray[j].substring(new String("Tango::").length());
                if (!s1.equals(s2)) continue;
                this.server.states.addElement(new DevState(PogoDefs.TangoStatesArray[j], ""));
                continue block0;
            }
        }
    }

    private void extractCommands(PogoString pgs) throws PogoException {
        int start = pgs.str.indexOf(this.tacoAddCommands);
        if (start < 0) {
            throw new PogoException(this.tacoAddCommands + " not found in " + this.filename);
        }
        start = pgs.inMethod(start);
        PogoString cmdStruct = new PogoString(pgs.extractMethodCore(start));
        start = 0;
        int end = 0;
        while ((start = cmdStruct.inMethod(end)) >= 0) {
            end = cmdStruct.outMethod(start);
            PogoString line = new PogoString(cmdStruct.str.substring(start, end).trim());
            String[] fields = line.getFields();
            String tacoCmd = fields[0];
            String tacoArgin = this.getTangoType(fields[2]);
            String tacoArgout = this.getTangoType(fields[3]);
            if (tacoCmd.equals("DevState") || tacoCmd.equals("DevStatus")) continue;
            this.server.commands.addElement(new Cmd(tacoCmd, new String(tacoCmd + "Cmd"), tacoArgin, tacoArgout, "", "", ""));
        }
    }

    private void extractProperties(PogoString pgs, String propertyType) throws PogoException {
        int start = pgs.str.indexOf(propertyType);
        if (start < 0) {
            System.out.println(propertyType + " not found in " + this.filename);
            return;
        }
        start = pgs.inMethod(start);
        PogoString propStruct = new PogoString(pgs.extractMethodCore(start));
        start = 0;
        int end = 0;
        while ((start = propStruct.inMethod(end)) >= 0) {
            end = propStruct.outMethod(start);
            PogoString line = new PogoString(propStruct.str.substring(start, end));
            String[] fields = line.getFields();
            String propname = fields[0];
            String proptype = this.getPropTangoType(fields[1]);
            System.out.println(propname + ": " + proptype);
            if (propertyType == this.tacoAddDevProps) {
                this.server.dev_properties.addElement(new Property(propname, proptype, ""));
                continue;
            }
            if (propertyType != this.tacoAddClassProps) continue;
            this.server.class_properties.addElement(new Property(propname, proptype, ""));
        }
    }

    private String getPropTangoType(String tacoType) {
        if (!tacoType.startsWith("D_VAR_")) {
            return this.getTangoType(tacoType);
        }
        for (int i = 0; i < typePropStr.length; i += 2) {
            if (!typePropStr[i].equals(tacoType)) continue;
            return typePropStr[i + 1];
        }
        return tacoType;
    }

    private String getTangoType(String tacoType) {
        for (int i = 0; i < typeStr.length; i += 2) {
            if (!typeStr[i].equals(tacoType)) continue;
            return typeStr[i + 1];
        }
        return tacoType;
    }

    public static void main(String[] args) {
        try {
            Taco2Tango t2t = new Taco2Tango("/segfs/tango/tools/pogo/generated/taco/ipc.c");
            PogoClass pogoClass = t2t.getPogoClass();
        }
        catch (Exception e) {
            System.out.println("POGO Startup Failed.");
            System.out.println(e);
        }
    }
}

