/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.util.StringTokenizer;
import java.util.Vector;

public class PogoString {
    public String str;
    private static final String DUMMY_CHAR = "`";

    public PogoString(String str) {
        this.str = this.takeOffWindowsChar(str);
    }

    public PogoString(byte[] b) {
        this.str = this.takeOffWindowsChar(b);
    }

    String takeOffWindowsChar(String s) {
        return this.takeOffWindowsChar(s.getBytes());
    }

    String takeOffWindowsChar(byte[] b_in) {
        int nb = 0;
        for (int i = 0; i < b_in.length; ++i) {
            if (b_in[i] == 13) continue;
            ++nb;
        }
        byte[] b_out = new byte[nb];
        int j = 0;
        for (int i = 0; i < b_in.length; ++i) {
            if (b_in[i] == 13) continue;
            b_out[j++] = b_in[i];
        }
        return new String(b_out);
    }

    public int previousCr(int start) {
        while (start >= 0 && this.str.charAt(start) != '\n') {
            --start;
        }
        return ++start;
    }

    public int nextCr(int start) {
        while (start < this.str.length() && this.str.charAt(start) != '\n') {
            ++start;
        }
        return start;
    }

    public int inTest(int start) {
        if ((start = this.str.indexOf("if", start)) < 0) {
            return start;
        }
        start = this.str.indexOf("(", start);
        return start;
    }

    public int outTest(int start) {
        ++start;
        int cnt = 1;
        while (cnt != 0) {
            switch (this.str.charAt(start)) {
                case '(': {
                    ++cnt;
                    break;
                }
                case ')': {
                    --cnt;
                }
            }
            ++start;
        }
        return start;
    }

    public int inMethod(int start) {
        while (start < this.str.length() && this.str.charAt(start) != '{') {
            ++start;
        }
        if (start < this.str.length()) {
            return start;
        }
        return -1;
    }

    public int outMethod(int start) {
        int end;
        int cnt = 1;
        block4: for (end = start + 1; cnt != 0 && end < this.str.length(); ++end) {
            switch (this.str.charAt(end)) {
                case '{': {
                    ++cnt;
                    continue block4;
                }
                case '}': {
                    --cnt;
                }
            }
        }
        if ((end = this.nextCr(end)) < this.str.length() - 1) {
            ++end;
        }
        return end;
    }

    public String extractMethodCore() {
        return this.extractMethodCore(0);
    }

    public String extractMethodCore(int start) {
        int end;
        start = this.inMethod(start) + 1;
        for (end = this.outMethod(start); end > start && this.str.charAt(end) != '}'; --end) {
        }
        return this.str.substring(start, end);
    }

    public String[] getParams() {
        String[] params = this.getFields();
        return params;
    }

    public String setComments() {
        StringBuffer sb = new StringBuffer("");
        int start = 0;
        int end = 0;
        int n = 0;
        while ((end = this.nextCr(start)) < this.str.length()) {
            ++end;
            if (n++ > 0) {
                sb.append(" *\t");
            }
            sb.append(this.str.substring(start, end));
            start = end;
        }
        if (n++ > 0) {
            sb.append(" *\t");
        }
        sb.append(this.str.substring(start, end));
        return sb.toString();
    }

    public void manageDoubleCotes() {
        int idx = 0;
        while ((idx = this.str.indexOf(34, idx)) > 0) {
            this.insert(idx, "\\");
            idx += 2;
        }
    }

    public void insert(int idx, String s) {
        StringBuffer sb = new StringBuffer(this.str);
        sb.insert(idx, s);
        this.str = new String(sb.toString());
    }

    public void remove(String pattern) {
        this.remove(0, pattern);
    }

    public void remove(int start, String pattern) {
        this.replace(start, pattern, "");
    }

    public void replace(String pattern, String newOne) {
        this.replace(0, pattern, newOne);
    }

    public void replace(int start, String pattern, String newOne) {
        StringBuffer sb = new StringBuffer(this.str);
        int start1 = this.str.indexOf(pattern, start);
        if (start1 < 0) {
            return;
        }
        int end = start1 + pattern.length();
        if (newOne == null) {
            sb.replace(start1, end, "");
        } else {
            sb.replace(start1, end, newOne);
        }
        this.str = new String(sb.toString());
    }

    public void append(String newStr) {
        StringBuffer sb = new StringBuffer(this.str);
        sb.append(newStr);
        this.str = new String(sb.toString());
    }

    public String noEdges() {
        return this.noEdges(0);
    }

    public String noEdges(int start) {
        int end = this.str.length() - 1;
        while (start < end && (this.str.charAt(start) < '.' || this.str.charAt(start) == '/')) {
            ++start;
        }
        while (start <= end && (this.str.charAt(end) < '.' || this.str.charAt(end) == '/')) {
            --end;
        }
        return this.str.substring(start, ++end);
    }

    public String getDescription() {
        String tmp;
        StringBuffer sb = new StringBuffer("");
        int start = this.str.indexOf("/**");
        if (start < 0) {
            start = 0;
        }
        String s = this.noEdges(start);
        StringTokenizer st = new StringTokenizer(s);
        boolean newLine = false;
        int i = 0;
        while (st.hasMoreTokens() && (tmp = st.nextToken()).indexOf("@") < 0) {
            if (tmp.indexOf("*") >= 0) {
                newLine = true;
                sb.append("\n");
            } else {
                if (!newLine) {
                    sb.append(" ");
                }
                sb.append(tmp);
                newLine = false;
            }
            ++i;
        }
        this.str = sb.toString();
        this.str = this.noEdges();
        return this.str;
    }

    public String extractPathFromFullPath() {
        int end;
        for (end = this.str.length() - 1; end > 0 && this.str.charAt(end) != '/'; --end) {
        }
        if (end == 0) {
            for (end = this.str.length() - 1; end > 0 && this.str.charAt(end) != '\\'; --end) {
            }
        }
        return this.str.substring(0, end);
    }

    public String toLowerString() {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < this.str.length(); ++i) {
            if (this.str.charAt(i) >= 'A' && this.str.charAt(i) <= 'Z') {
                if (i > 0 && (this.str.charAt(i - 1) < 'A' || this.str.charAt(i - 1) > 'Z')) {
                    sb.append('_');
                }
                sb.append((char)(this.str.charAt(i) + 32));
                continue;
            }
            sb.append(this.str.charAt(i));
        }
        return sb.toString();
    }

    public int indexOf(String s) {
        return this.str.indexOf(s);
    }

    public int indexOf(String s, int i) {
        return this.str.indexOf(s, i);
    }

    public int lastIndexOf(String s) {
        return this.str.lastIndexOf(s);
    }

    public int lastIndexOf(String s, int i) {
        return this.str.lastIndexOf(s, i);
    }

    public String substring(int start, int end) {
        return this.str.substring(start, end);
    }

    public String substring(int start) {
        return this.str.substring(start);
    }

    public String toString() {
        return this.str;
    }

    public String[] getFields() {
        this.str = this.trim('\n');
        this.str = this.trim(';');
        this.str = this.trim(',');
        this.str = this.str.trim();
        this.str = this.trim('{');
        this.str = this.trim('}');
        boolean in_quotes = false;
        for (int i = 0; i < this.str.length(); ++i) {
            if (this.str.charAt(i) == '\"') {
                in_quotes = !in_quotes;
                continue;
            }
            if (this.str.charAt(i) != '(' || in_quotes) continue;
            this.str = this.str.substring(0, i) + ',' + this.str.substring(i + 1);
        }
        this.str = this.trim(')');
        this.replaceCommaByDummyChar();
        StringTokenizer st = new StringTokenizer(this.str, ",");
        Vector<String> v = new Vector<String>();
        while (st.countTokens() > 0) {
            v.add(st.nextToken().toString().trim());
        }
        String[] fields = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            PogoString p = new PogoString((String)v.elementAt(i));
            while (p.str.indexOf(DUMMY_CHAR) >= 0) {
                p.replace(DUMMY_CHAR, ",");
            }
            fields[i] = p.trim('\"');
        }
        return fields;
    }

    public String[] string2array(String delim) {
        StringTokenizer st = new StringTokenizer(this.str, delim);
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        String[] list = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            list[i] = (String)v.elementAt(i);
        }
        return list;
    }

    public String[] string2array() {
        StringTokenizer st = new StringTokenizer(this.str);
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        String[] list = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            list[i] = (String)v.elementAt(i);
        }
        return list;
    }

    private void replaceCommaByDummyChar() {
        int start = 0;
        while ((start = this.str.indexOf("\"", start)) > 0) {
            int end;
            if ((end = this.str.indexOf("\"", ++start)) > 0) {
                PogoString pgs = new PogoString(this.str.substring(start, end));
                while (pgs.str.indexOf(",") >= 0) {
                    pgs.replace(",", DUMMY_CHAR);
                }
                this.str = this.str.substring(0, start) + pgs.str + this.str.substring(end);
            }
            start = end + 2;
        }
    }

    public String trim(char c) {
        int start;
        if (this.str.length() == 0) {
            return "";
        }
        if (this.str.length() == 1) {
            return this.str;
        }
        int end = this.str.length() - 1;
        for (start = 0; this.str.charAt(start) == c && start < end; ++start) {
        }
        while (this.str.charAt(end) == c && end > start) {
            --end;
        }
        if (start > end) {
            return "";
        }
        String s = this.str.substring(start, end + 1);
        if (s.equals("\"")) {
            return "";
        }
        return s;
    }

    void indent(int val) {
        int start = 0;
        while (this.str.charAt(start) == '\n') {
            ++start;
        }
        String result = "";
        int end = this.nextCr(start + 1);
        while (end < this.str.length()) {
            ++end;
            if (val < 0) {
                if (start - val < end) {
                    char c = this.str.charAt(start);
                    result = c == ' ' || c == '\t' ? result + this.str.substring(start - val, end) : result + this.str.substring(start, end);
                }
            } else {
                result = result + "\t" + this.str.substring(start, end);
            }
            start = end;
            end = this.nextCr(start + 1);
        }
        this.str = result;
    }

    boolean isCommentLine(int position) {
        String line;
        int idx;
        int start = this.str.lastIndexOf("\n", position);
        int end = this.str.indexOf("\n", position);
        if (start < 0) {
            start = 0;
        }
        if ((idx = (line = end < 0 ? this.str.substring(start) : this.str.substring(start, end)).indexOf("//")) < 0) {
            return false;
        }
        return idx < position - start;
    }

    byte[] getBytes() {
        return this.str.getBytes();
    }

    public static void main(String[] args) {
        String test = "command_list.push_back(new DevSetCurrentCmd(\"DevSetCurrent\",\nTango::DEV_DOUBLE, Tango::DEV_VOID,\n\"The output current, value to set.\",\n\"\",\nTango::EXPERT));";
        System.out.println("input: \n" + test);
        System.out.println();
        PogoString pgs = new PogoString(test);
        String[] result = pgs.getFields();
        for (int i = 0; i < result.length; ++i) {
            System.out.println(i + " - " + result[i]);
        }
    }
}

