/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.Tango.DispLevel;
import fr.esrf.TangoDs.TangoConst;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.DevState;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;
import pogo.gene.Property;
import pogo.gene.TangoTypes;

public class PogoGeneDoc
extends PogoGene
implements PogoDefs,
TangoConst {
    private PogoClass pogo;
    private String outDoc;
    private String header;
    private String footer = null;
    private Cmd init_cmd;
    private final String end_html = "\n\n</BODY>\n</HTML>\n";

    public PogoGeneDoc(PogoClass pogo) {
        super(pogo);
        this.pogo = pogo;
        this.outDoc = new String(pogo.projectFiles.getDocHtml());
        this.header = new String("\"" + pogo.class_name + " Device Server generated by POGO\"");
        this.init_cmd = new Cmd("Init", "", "Tango::DEV_VOID", "Tango::DEV_VOID", "none.", "none.", "This commands re-initialise a device keeping the same network connection.<Br>\nAfter an Init command executed on a device, it is not necessary for client to re-connect to the device.<Br>\nThis command first calls the device <i> delete_device() </i>method and then execute its <i> init_device()</i> method.<Br>\nFor C++ device server, all the memory allocated in the <i> nit_device() </i> method must be freed in the <i> delete_device() </i> method.<Br>\nThe language device desctructor automatically calls the <i> delete_device() </i> method.");
    }

    private static String buildTableHeader(String title, int nb_col) {
        StringBuffer sb = new StringBuffer("<Table Border=2 Cellpadding=3 CELLSPACING=0 WIDTH=\"100%\">\n");
        sb.append("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n");
        sb.append("<Td COLSPAN=" + nb_col + "> <Font Size=+2>");
        sb.append("<Center>");
        sb.append("<b>" + title + "</b></td></Font></Center>\n");
        return sb.toString();
    }

    public static String buildTableHeader(String title, String[] col_titles) {
        StringBuffer sb = new StringBuffer(PogoGeneDoc.buildTableHeader(title, col_titles.length));
        sb.append("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n");
        for (int i = 0; i < col_titles.length; ++i) {
            sb.append("<Td>");
            sb.append("<Center>");
            sb.append("<b>" + col_titles[i] + "</b></td></Center>\n");
        }
        return sb.toString();
    }

    private void makeDocDir() throws SecurityException {
        int end = 1;
        while ((end = this.outDoc.indexOf("/", end)) > 0) {
            String path = this.outDoc.substring(0, end);
            File f = new File(path);
            if (!f.exists()) {
                f.mkdir();
                System.out.println(path + "  created");
            }
            ++end;
        }
        File f = new File(this.outDoc);
        if (!f.exists()) {
            f.mkdir();
            System.out.println(this.outDoc + "  created");
        }
    }

    /*
     * WARNING - void declaration
     */
    private String generateProgrammersGuide() throws FileNotFoundException, SecurityException, IOException, InterruptedException, PogoException {
        String str;
        void var2_2;
        boolean isUnix = PogoUtil.osIsUnix();
        this.makeDocDir();
        switch (this.pogo.language) {
            case 0: {
                String[] cmd = this.buildCmdDocFromJava();
                break;
            }
            case 1: {
                String[] cmd = this.buildCmdDocFromCpp();
                if (cmd != null) break;
                this.removePgGuideLink();
                return "Doxygen NOT installed !";
            }
            default: {
                return "Languange not supported !";
            }
        }
        Process proc = Runtime.getRuntime().exec((String[])var2_2);
        if (!isUnix) {
            return "";
        }
        InputStream istr = proc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(istr));
        StringBuffer sb = new StringBuffer("Generating Doc:\n\n");
        while ((str = br.readLine()) != null) {
            System.out.println(str);
            sb.append(str + "\n");
        }
        proc.waitFor();
        int retVal = proc.exitValue();
        if (retVal != 0) {
            InputStream errstr = proc.getErrorStream();
            br = new BufferedReader(new InputStreamReader(errstr));
            while ((str = br.readLine()) != null) {
                System.out.println(str);
                sb.append(str + "\n");
            }
            throw new PogoException("Programmer's guide generation returns : " + retVal + " !\n\n" + sb.toString());
        }
        System.out.println(sb);
        return sb.toString();
    }

    private String[] buildCmdDocFromCpp() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String template = new String(this.pogo.templates_dir + "/html/Doxyfile");
        String doxyfile = new String(this.pogo.projectFiles.getPath() + "/Doxyfile");
        String[] cmd = new String[2];
        String docPath = System.getProperty("CPP_DOC_PATH");
        int n = 0;
        if (docPath == null) {
            cmd[n++] = new String("doxygen");
        } else {
            if (docPath.equals("NOT_INSTALLED")) {
                return null;
            }
            cmd[n++] = new String(docPath + "/doxygen");
        }
        cmd[n++] = doxyfile;
        FileInputStream fidin = new FileInputStream(template);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        fidin.close();
        PogoString code = new PogoString(inStr);
        code.replace("POGO_TITLE", "\"" + this.pogo.title + "\"");
        code.replace("POGO_SRC_FILES", this.pogo.projectFiles.getPath());
        code.replace("POGO_OUT_DOC", this.outDoc);
        FileOutputStream fidout = new FileOutputStream(doxyfile);
        fidout.write(code.str.getBytes());
        fidout.close();
        return cmd;
    }

    private String[] buildCmdDocFromJava() {
        String[] cmd = new String[this.pogo.commands.size() + 9];
        int n = 0;
        cmd[n++] = "javadoc";
        cmd[n++] = "-private";
        cmd[n++] = "-author";
        cmd[n++] = "-windowtitle";
        cmd[n++] = this.header;
        cmd[n++] = "-header";
        cmd[n++] = this.header;
        cmd[n++] = "-d";
        cmd[n++] = this.outDoc + "/html";
        cmd[n++] = new String(this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + ".java");
        cmd[n++] = new String(this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + "Class" + ".java");
        for (int i = 2; i < this.pogo.commands.size(); ++i) {
            Cmd c = this.pogo.commands.cmdAt(i);
            cmd[n++] = new String(this.pogo.projectFiles.getPath() + "/" + c.cmd_class + ".java");
        }
        return cmd;
    }

    protected void generateIndexFile() throws IOException, PogoException {
        PogoString pgs = this.readTemplate("index.html", "");
        String f_out = new String(this.outDoc + "/index.html");
        this.writeDocFile(f_out, pgs.str, true);
        if (this.pogo.inherited_from != null && !this.pogo.inheritedClassName().equals("Device_3Impl")) {
            PogoString code = new PogoString(PogoUtil.readFile(this.outDoc + "/index.html"));
            String inheritance_message = "<b>This class inherits from " + this.pogo.inheritedClassName() + " class.</b><Br>\n";
            String intro = "<h2>Introduction:</h2>\n";
            int pos = code.str.indexOf(intro);
            code.insert(pos += intro.length(), inheritance_message);
            PogoUtil.writeFile(this.outDoc + "/index.html", code.str);
        }
    }

    protected void generateDescriptionFile() throws IOException, PogoException {
        String f_out = new String(this.outDoc + "/Description.html");
        if (new File(f_out).exists()) {
            String old_mess;
            int start;
            boolean modified = false;
            PogoString code = new PogoString(PogoUtil.readFile(f_out));
            int end = code.str.indexOf("<HR WIDTH=\"100%\"></H5>");
            if (end > 0) {
                String templname = this.pogo.templates_dir + "/html/header.html";
                String old_header = code.str.substring(0, end);
                String new_header = PogoUtil.readFile(templname);
                int p = new_header.indexOf("</Body>");
                if (p > 0) {
                    new_header = new_header.substring(0, p);
                }
                code.replace(old_header, new_header);
                modified = true;
            }
            if ((start = code.str.indexOf(old_mess = "This Page Must Be Filled by <Br>\nThe Programmer")) > 0) {
                code.replace(old_mess, this.pogo.class_desc);
                modified = true;
            }
            if (modified) {
                PogoUtil.writeFile(f_out, code.str);
            }
        } else {
            PogoString pgs = this.readTemplate("page.html", "Device Description");
            pgs.append("<Center>\n");
            pgs.append(this.pogo.class_desc);
            pgs.append("\n<Br>\n<Br>\n");
            pgs.append("</Center>\n");
            this.writeDocFile(f_out, pgs.str, true);
        }
        PogoGeneDoc.checkDocFile(this.outDoc);
    }

    protected void generateStateDescriptionFile() throws IOException, PogoException {
        PogoString pgs = this.readTemplate("page.html", "Device States Description");
        pgs.append("<Center>\n");
        pgs.append("<Br> <Br> <Br> \n");
        String[] titles = new String[]{"Names", "Descriptions"};
        pgs.append(PogoGeneDoc.buildTableHeader("States", titles));
        for (int i = 0; i < this.pogo.states.size(); ++i) {
            DevState state = (DevState)this.pogo.states.elementAt(i);
            pgs.append("<Tr><Td>" + this.removeTangoNamespace(state.name) + "</Td>\n");
            pgs.append("<Td>" + state.description + "</Td></Tr>\n\n");
        }
        pgs.append("\n");
        pgs.append("\n");
        pgs.append("\n");
        pgs.append("</Table>\n");
        pgs.append("</Center>\n");
        String f_out = new String(this.outDoc + "/TangoDevStates.html");
        this.writeDocFile(f_out, pgs.str, true);
    }

    protected void generatePropertyDescriptionFile() throws IOException, PogoException {
        Property property;
        int i;
        boolean class_prop = false;
        boolean device_prop = false;
        PogoString pgs = this.readTemplate("page.html", "Properties Description");
        pgs.append("<Br> <Br> <Br> \n");
        pgs.append("<Center>\n");
        String[] titles = new String[]{"Property name", "Property type", "Description"};
        if (this.pogo.class_properties.size() > 0) {
            class_prop = true;
            pgs.append(PogoGeneDoc.buildTableHeader("Class Properties", titles));
            pgs.append("\n");
            for (i = 0; i < this.pogo.class_properties.size(); ++i) {
                property = this.pogo.class_properties.propertyAt(i);
                pgs.append("<Tr><Td>" + property.name + "</Td>\n");
                pgs.append("<Td>" + property.type.cpp_code_str + "</Td>\n");
                pgs.append("<Td>" + property.description + "</Td></Tr>\n\n");
            }
            pgs.append("</Table>\n");
            pgs.append("\n");
        }
        if (this.pogo.dev_properties.size() > 0) {
            device_prop = true;
            pgs.append("<Br> <Br> <Br> \n");
            pgs.append(PogoGeneDoc.buildTableHeader("Device Properties", titles));
            for (i = 0; i < this.pogo.dev_properties.size(); ++i) {
                property = this.pogo.dev_properties.propertyAt(i);
                pgs.append("<Tr><Td>" + property.name + "</Td>\n");
                pgs.append("<Td>" + property.type.cpp_code_str + "</Td>\n");
                pgs.append("<Td>" + property.description + "</Td></Tr>\n\n");
            }
            pgs.append("</Table>\n");
            pgs.append("\n");
        }
        if (!device_prop || !class_prop) {
            pgs.append("<Br><Br><Br>\n");
            pgs.append("<Center><b>\n");
            if (!class_prop) {
                pgs.append("There is no Class properties.<Br><Br>\n");
            }
            if (!device_prop) {
                pgs.append("There is no Device Properties.<Br><Br>\n");
            }
            pgs.append("</Center></b>\n");
        }
        String f_out = new String(this.outDoc + "/Properties.html");
        this.writeDocFile(f_out, pgs.str, true);
    }

    protected void generateAttributesFile() throws IOException, PogoException {
        String level;
        String str_type;
        String desc;
        PogoString pgs = this.readTemplate("page.html", "Device Attributes Description");
        pgs.append("<Br>\n");
        boolean assAttr = false;
        boolean scalar = false;
        boolean spectrum = false;
        boolean image = false;
        for (int i = 0; i < this.pogo.attributes.size(); ++i) {
            Attrib attr = this.pogo.attributes.attributeAt(i);
            if (attr.attrType == 0) {
                scalar = true;
                if (attr.rwType != 3) continue;
                assAttr = true;
                continue;
            }
            if (attr.attrType == 1) {
                spectrum = true;
                continue;
            }
            if (attr.attrType != 2) continue;
            image = true;
        }
        if (scalar) {
            String[] titles = new String[4 + (assAttr ? 1 : 0)];
            int n = 0;
            titles[n++] = "Attribute name";
            titles[n++] = "Data Type";
            titles[n++] = "R/W Type";
            if (assAttr) {
                titles[n++] = "Ass. Attr.";
            }
            titles[n++] = "Expert";
            pgs.append(PogoGeneDoc.buildTableHeader("Scalar Attributes", titles));
            for (int i = 0; i < this.pogo.attributes.size(); ++i) {
                Attrib attr = this.pogo.attributes.attributeAt(i);
                if (attr.attrType != 0) continue;
                pgs.append("<Tr><Td><b><Center>" + attr.name + "</b>");
                String desc2 = attr.getDescriptionLine();
                if (desc2 != null && desc2.length() > 0) {
                    pgs.append("<Br>( " + desc2 + " )");
                }
                pgs.append("</Center></Td>\n");
                String str_type2 = this.simpleType(attr.dataType);
                String str_rw = PogoDefs.AttrRWtypeArray[attr.rwType];
                String level2 = attr.disp_level == DispLevel.OPERATOR ? "No" : "Yes";
                pgs.append("<Td><Center>" + str_type2 + "</Center></Td>");
                pgs.append("<Td><Center>" + str_rw + "</Center></Td>");
                if (attr.rwType == 3) {
                    pgs.append("<Td><Center>" + attr.assAttr + "</Center></Td>");
                } else if (assAttr) {
                    pgs.append("<Td><Center> - </Center></Td>");
                }
                pgs.append("<Td><Center>" + level2 + "</Center></Td>");
                pgs.append("</Tr>\n\n");
            }
            pgs.append("</Table>\n");
            pgs.append("</Center>\n");
            pgs.append("<Br><Br><Br><Br><Br>\n");
        }
        if (spectrum) {
            String[] titles = new String[]{"Attribute name", "Data Type", "X Data Length", "Expert"};
            pgs.append(PogoGeneDoc.buildTableHeader("Spectrum Attributes", titles));
            for (int i = 0; i < this.pogo.attributes.size(); ++i) {
                Attrib attr = this.pogo.attributes.attributeAt(i);
                if (attr.attrType != 1) continue;
                pgs.append("<Tr><Td><b><Center>" + attr.name + "</b>");
                desc = attr.getDescriptionLine();
                if (desc != null && desc.length() > 0) {
                    pgs.append("<Br>( " + desc + " )");
                }
                pgs.append("</Center></Td>\n");
                str_type = this.simpleType(attr.dataType);
                level = attr.disp_level == DispLevel.OPERATOR ? "No" : "Yes";
                pgs.append("<Td><Center>" + str_type + "</Center></Td>");
                pgs.append("<Td><Center>" + attr.xSize + "</Center></Td>");
                pgs.append("<Td><Center>" + level + "</Center></Td>");
                pgs.append("</Tr>\n\n");
            }
            pgs.append("</Table>\n");
            pgs.append("</Center>\n");
            pgs.append("<Br><Br><Br><Br><Br>\n");
        }
        if (image) {
            String[] titles = new String[]{"Attribute name", "Data Type", "X Data Length", "Y Data Length", "Expert"};
            pgs.append(PogoGeneDoc.buildTableHeader("Image Attributes", titles));
            for (int i = 0; i < this.pogo.attributes.size(); ++i) {
                Attrib attr = this.pogo.attributes.attributeAt(i);
                if (attr.attrType != 2) continue;
                pgs.append("<Tr><Td><b><Center>" + attr.name + "</b>");
                desc = attr.getDescriptionLine();
                if (desc != null && desc.length() > 0) {
                    pgs.append("<Br>( " + desc + " )");
                }
                pgs.append("</Center></Td>\n");
                str_type = this.simpleType(attr.dataType);
                level = attr.disp_level == DispLevel.OPERATOR ? "No" : "Yes";
                pgs.append("<Td><Center>" + str_type + "</Center></Td>");
                pgs.append("<Td><Center>" + attr.xSize + "</Center></Td>");
                pgs.append("<Td><Center>" + attr.ySize + "</Center></Td>");
                pgs.append("<Td><Center>" + level + "</Center></Td>");
                pgs.append("</Tr>\n\n");
            }
            pgs.append("</Table>\n");
            pgs.append("</Center>\n");
        }
        String f_out = new String(this.outDoc + "/Attributes.html");
        this.writeDocFile(f_out, pgs.str, true);
    }

    protected void generateCmdListFile() throws IOException, PogoException {
        String str = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">\n";
        str = str + "<HTML><HEAD>\n";
        str = str + "<TITLE>Commands\n</TITLE></HEAD>\n";
        str = str + "<BODY BGCOLOR=\"white\">\n";
        str = str + "<FONT size=\"+1\" ID=\"FrameHeadingFont\">\n";
        str = str + "<B>Commands:</B></FONT>\n";
        str = str + "<Br>\n<Br>\n<Br>\n";
        str = str + "<A Href=\"DevCommands.html#Init";
        str = str + "\" TARGET=\"DevCommands\"> ";
        str = str + "Init</a><Br>\n";
        for (int i = 0; i < this.pogo.commands.size(); ++i) {
            Cmd cmd = this.pogo.commands.cmdAt(i);
            str = str + "<A Href=\"DevCommands.html#" + cmd.name;
            str = str + "\" TARGET=\"DevCommands\"> ";
            str = str + cmd.name + "</a><Br>\n";
        }
        str = str + "\n\n</BODY>\n</HTML>\n";
        String f_out = new String(this.outDoc + "/DevCommandsList.html");
        this.writeDocFile(f_out, str, false);
        PogoGeneDoc.copyFile(this.pogo.templates_dir + "/html/frame.html", this.outDoc + "/DevCommandsFrame.html");
    }

    private String buildCmdDesc(Cmd cmd, int cmd_idx) {
        PogoString desc;
        PogoString pgs = new PogoString("<A NAME=\"" + cmd.name + "\"><!-- --></A>\n");
        pgs.append("<A NAME=\"" + cmd.name + "\"><!-- --></A>\n");
        pgs.append("<h2>" + cmd_idx + " - " + cmd.name);
        if (cmd.level == DispLevel.EXPERT) {
            pgs.append(" (for expert only)");
        }
        pgs.append("</h2>\n<ul>\n");
        pgs.append("<Li><Strong>Description: </Strong> ");
        if (cmd.description != null) {
            pgs.append(cmd.description);
        }
        pgs.append("<Br>&nbsp\n");
        pgs.append("<Li><Strong>Argin:<Br>" + this.simpleType(cmd.argin) + "</Strong>\n");
        if (cmd.argin.description != null) {
            desc = new PogoString(cmd.argin.description);
            while (desc.indexOf("\\n") >= 0) {
                desc.replace("\\n", "<Br>\n");
            }
            pgs.append(" : " + desc);
        }
        pgs.append("<Br>&nbsp\n");
        pgs.append("<Li><Strong>Argout:<Br>" + this.simpleType(cmd.argout) + "</Strong>\n");
        if (cmd.argout.description != null) {
            desc = new PogoString(cmd.argout.description);
            while (desc.indexOf("\\n") >= 0) {
                desc.replace("\\n", "<Br>\n");
            }
            pgs.append(" : " + desc);
        }
        if (cmd.notAllowedFor != null) {
            pgs.append("<Br>&nbsp\n");
            pgs.append("<Li><Strong>Command allowed for: </Strong><Ul>\n");
            for (int idx = 0; idx < this.pogo.states.size(); ++idx) {
                DevState st = this.pogo.states.stateAt(idx);
                boolean found = false;
                for (int alIdx = 0; alIdx < cmd.notAllowedFor.size(); ++alIdx) {
                    DevState st1 = cmd.notAllowedFor.stateAt(alIdx);
                    if (!st1.name.equals(st.name)) continue;
                    found = true;
                }
                if (found) continue;
                pgs.append("<Li>" + st.name);
            }
            pgs.append("</Ul>\n");
        } else {
            pgs.append("<Li><Strong>Command allowed for all device states.</Strong><Br>\n");
        }
        pgs.append("<Br>&nbsp\n");
        if (cmd.polled_period > 0) {
            pgs.append("<Li><Strong>Polled every " + cmd.polled_period + " ms</Strong><Br>\n");
        }
        pgs.append("</ul><Br>\n<Br>\n");
        return pgs.str;
    }

    protected void generateCmdListDescriptionFile() throws IOException, PogoException {
        PogoString pgs = this.readTemplate("page.html", "Device Commands Description");
        pgs.append("<Br>\n<Br>\n<Br>\n");
        int cmd_idx = 1;
        pgs.append(this.buildCmdDesc(this.init_cmd, cmd_idx++));
        for (int i = 0; i < this.pogo.commands.size(); ++i) {
            Cmd cmd = this.pogo.commands.cmdAt(i);
            pgs.append(this.buildCmdDesc(cmd, cmd_idx++));
        }
        String f_out = new String(this.outDoc + "/DevCommands.html");
        this.writeDocFile(f_out, pgs.str, true);
    }

    protected void generateCmdTableFile() throws IOException, PogoException {
        Cmd cmd;
        int i;
        PogoString pgs = this.readTemplate("page.html", "Device Commands Description");
        String[] titles = new String[]{"Command name", "Argument In", "Argument Out"};
        pgs.append("<Center>\n");
        pgs.append("<Br><Br>\n<A Href=\"DevCommandsFrame.html\"> More Details on commands.... </a><Br>\n");
        pgs.append("<Br> <Br>\n");
        pgs.append(PogoGeneDoc.buildTableHeader("Device Commands for Operator Level", titles));
        pgs.append(new String("<Tr><Td>" + this.init_cmd.name + "</Td>\n"));
        pgs.append(new String("<Td>" + this.simpleType(this.init_cmd.argin) + "</Td>\n"));
        pgs.append(new String("<Td>" + this.simpleType(this.init_cmd.argout) + "</Td>\n"));
        int nb_expert = 0;
        for (i = 0; i < this.pogo.commands.size(); ++i) {
            cmd = this.pogo.commands.cmdAt(i);
            if (cmd.level == DispLevel.OPERATOR) {
                pgs.append(new String("<Tr><Td>" + cmd.name + "</Td>\n"));
                pgs.append(new String("<Td>" + this.simpleType(cmd.argin) + "</Td>\n"));
                pgs.append(new String("<Td>" + this.simpleType(cmd.argout) + "</Td>\n"));
                continue;
            }
            ++nb_expert;
        }
        pgs.append("\n\n\n</Table></Center>\n");
        if (nb_expert > 0) {
            pgs.append("<Br> <Br> <Br> \n");
            pgs.append("<Center>\n");
            pgs.append(PogoGeneDoc.buildTableHeader("Device Commands for Expert Level Only", titles));
            for (i = 0; i < this.pogo.commands.size(); ++i) {
                cmd = this.pogo.commands.cmdAt(i);
                if (cmd.level != DispLevel.EXPERT) continue;
                pgs.append("<Tr><Td>" + cmd.name + "</Td>\n");
                pgs.append("<Td>" + this.simpleType(cmd.argin) + "</Td>\n");
                pgs.append("<Td>" + this.simpleType(cmd.argout) + "</Td>\n");
            }
            pgs.append("\n\n\n</Table></Center>\n");
        }
        String f_out = new String(this.outDoc + "/DevCommandsTable.html");
        this.writeDocFile(f_out, pgs.str, true);
    }

    private void writeDocFile(String filename, String str, boolean write_footer) throws IOException, PogoException {
        if (write_footer) {
            if (this.footer == null) {
                String footname = this.pogo.templates_dir + "/html/footer.html";
                FileInputStream fidin = new FileInputStream(footname);
                int nb = fidin.available();
                byte[] inStr = new byte[nb];
                fidin.read(inStr);
                this.footer = new String(inStr);
                fidin.close();
            }
            str = str + this.footer;
        }
        FileOutputStream fidout = new FileOutputStream(filename);
        fidout.write(str.getBytes());
        fidout.close();
    }

    protected void removePgGuideLink() throws FileNotFoundException, IOException {
        String[] pgGuideLink = new String[]{"<h2>Programmer's guide:</h2>", "<ul>", "<li> <a href=\"html/index.html\">\t\tSoftware description.</a>", "</ul>"};
        String filename = this.pogo.projectFiles.getDocHtml() + "/index.html";
        PogoString pgs = new PogoString(PogoUtil.readFile(filename));
        for (int i = 0; i < pgGuideLink.length; ++i) {
            pgs.replace(pgGuideLink[i], "");
        }
        FileOutputStream fidout = new FileOutputStream(filename);
        fidout.write(pgs.str.getBytes());
        fidout.close();
    }

    private PogoString readTemplate(String filename, String page_title) throws IOException, PogoException {
        FileInputStream fidin = new FileInputStream(this.pogo.templates_dir + "/html/" + filename);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace("project :", this.pogo.title);
        pgs.replace("Page Title", page_title);
        pgs.replace("ClassName", this.pogo.class_name);
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        pgs.replace("Class Description:", this.pogo.class_desc);
        return pgs;
    }

    private String simpleType(TangoTypes type) {
        return this.removeTangoNamespace(type.cpp_code_str);
    }

    private String removeTangoNamespace(String s) {
        if (s.indexOf("Tango::") != 0) {
            return s;
        }
        return s.substring("Tango::".length());
    }

    public static void checkDocFile(String targetdir) {
        File f = new File(targetdir);
        if (!f.exists()) {
            return;
        }
        String[] src_files = f.list();
        for (int i = 0; i < src_files.length; ++i) {
            String src_file = targetdir + "/" + src_files[i];
            if (new File(src_file).isDirectory()) continue;
            int idx = src_file.lastIndexOf(".");
            if (idx < 0) break;
            if (!src_file.substring(idx).equals(".doc") && !src_file.substring(idx).equals(".pdf")) continue;
            idx = src_file.lastIndexOf("/");
            idx = idx < 0 ? 0 : ++idx;
            String filename = src_file.substring(idx);
            System.out.println(filename);
            PogoGeneDoc.addLinkOnDoc(targetdir, filename);
        }
    }

    public static void addLinkOnDoc(String targetdir, String filename) {
        try {
            PogoString code = new PogoString(PogoUtil.readFile(targetdir + "/Description.html"));
            if (code.str.indexOf(filename) > 0) {
                return;
            }
            int idx = code.str.indexOf("Revision");
            if (idx < 0) {
                return;
            }
            idx = code.str.toLowerCase().indexOf("</center>", idx);
            if (idx < 0) {
                return;
            }
            String link = "<Br><Br><Br>\nDownload <A href=" + filename + "> " + filename + " </a>\n";
            code.insert(idx, link);
            PogoUtil.writeFile(targetdir + "/Description.html", code.str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String generate() throws FileNotFoundException, SecurityException, IOException, InterruptedException, PogoException {
        System.out.println("Generating HTML Doc files...");
        this.makeDocDir();
        this.generateIndexFile();
        this.generateDescriptionFile();
        this.generateStateDescriptionFile();
        this.generatePropertyDescriptionFile();
        this.generateCmdListDescriptionFile();
        this.generateCmdListFile();
        this.generateCmdTableFile();
        this.generateAttributesFile();
        return "";
    }
}

