/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import pogo.gene.CppServer;
import pogo.gene.CppServerClass;
import pogo.gene.CppStateMachine;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;

public class PogoGeneCpp
extends PogoGene
implements PogoDefs,
TangoConst {
    public PogoGeneCpp(PogoClass pogo) {
        super(pogo);
    }

    private void insertAbstractClassPath(String filename) throws FileNotFoundException, SecurityException, IOException, PogoException {
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        if (code.str.indexOf("SUPER_HOME") < 0) {
            int pos = code.str.indexOf("INCLUDE_DIRS");
            if (pos < 0) {
                throw new PogoException("Makefile Syntax error");
            }
            code.insert(pos, "SUPER_HOME   =  " + this.pogo.inheritedClassPath() + "\n");
            pos = code.str.indexOf("\\", pos);
            code.insert(pos, " -I$(SUPER_HOME) ");
            PogoUtil.writeFile(filename, code.str);
        }
    }

    private void buildAbstractClassMakefile(String filename) throws FileNotFoundException, SecurityException, IOException {
        int start;
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        code.remove("main.o\t\\\n\t\tClassFactory.o\t\\\n\t\t");
        code.remove("\t\\\n\t\t$(CLASS)StateMachine.o\t\\\n\t\t$(CLASS).o");
        while ((start = code.str.indexOf("LFLAGS =")) > 0) {
            code.remove(code.str.substring(start, code.str.indexOf("endif", start)));
        }
        code.remove("\tar ruv $(TARGET_LIB) $(CLASS).o\n");
        code.remove("\tar ruv $(TARGET_LIB) $(CLASS)StateMachine.o\n");
        start = code.str.indexOf("all:") + "all:".length();
        int end = code.str.indexOf("\n", start);
        code.replace(code.str.substring(start, end), "\t$(SVC_OBJS)");
        code.remove("$(CLASS):\t$(SVC_OBJS)\n\t$(CC) $(SVC_OBJS) -o $(CLASS) $(LFLAGS)\n");
        code.remove("#-----------------------------------------\n#\t Install binary file\n#-----------------------------------------\ninstall:\n\tcp $(CLASS) $(TANGO_HOME)/bin/$(BIN_DIR)\n");
        PogoUtil.writeFile(filename, code.str);
    }

    private void addObjectToMakefile(String filename) throws FileNotFoundException, SecurityException, IOException {
        if (this.pogo.is_abstractclass) {
            return;
        }
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        String new_obj = "$(CLASS)StateMachine.o";
        if (code.str.indexOf(new_obj) > 0) {
            return;
        }
        int position = code.str.indexOf("$(CLASS).o");
        int start = code.str.lastIndexOf("\n", position);
        new_obj = new_obj + " \\" + code.str.substring(start, position);
        code.insert(position, new_obj);
        PogoUtil.writeFile(filename, code.str);
    }

    private void updateNamespaceInClFac(String filename) throws FileNotFoundException, SecurityException, IOException {
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        String old_ns = this.pogo.class_name + "::" + this.pogo.class_name + "Class::init";
        String new_ns = this.pogo.namespace() + "::" + this.pogo.class_name + "Class::init";
        if (code.str.indexOf(old_ns) > 0) {
            code.replace(old_ns, new_ns);
            PogoUtil.writeFile(filename, code.str);
        }
    }

    private void updateNamespace(String filename) throws FileNotFoundException, SecurityException, IOException {
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        String old_ns = "namespace " + this.pogo.class_name + "\n{\n";
        String new_ns = "namespace " + this.pogo.namespace() + "\n{\n";
        boolean modified = false;
        if (code.str.indexOf(old_ns) > 0) {
            code.replace(old_ns, new_ns);
            modified = true;
        }
        old_ns = "namespace " + this.pogo.class_name + " {\n";
        new_ns = "namespace " + this.pogo.namespace() + " {\n";
        if (code.str.indexOf(old_ns) > 0) {
            code.replace(old_ns, new_ns);
            modified = true;
        }
        if (modified) {
            PogoUtil.writeFile(filename, code.str);
        }
    }

    private void checkCleanup(String filename) throws FileNotFoundException, SecurityException, IOException, PogoException {
        String clp_method = "tg->server_cleanup();";
        PogoString pgs = new PogoString(PogoUtil.readFile(filename));
        if (pgs.str.indexOf(clp_method) < 0) {
            int idx = pgs.str.indexOf("return");
            idx = pgs.previousCr(idx);
            pgs.insert(idx, "\t" + clp_method + "\n");
            PogoUtil.writeFile(filename, pgs.str);
        }
    }

    public void generate() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String makefile = new String(this.pogo.projectFiles.getPath() + "/Makefile");
        String main = new String(this.pogo.projectFiles.getPath() + "/main.cpp");
        String cfactory = new String(this.pogo.projectFiles.getPath() + "/ClassFactory.cpp");
        String server = new String(this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + ".cpp");
        String server_h = new String(this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + ".h");
        String serverclass = new String(this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + "Class.cpp");
        String serverclass_h = new String(this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + "Class.h");
        String allowedfile = this.pogo.projectFiles.getAllowed();
        this.sbTrace = new StringBuffer("C++ source code generation:\n\n");
        if (this.mustGenerate(makefile)) {
            System.out.println("Generating " + makefile + " for C++....");
            this.replacePatternFile(new String(this.pogo.templates_dir + "/cpp/Makefile"), makefile, "TemplateDevServ", this.pogo.class_name);
            this.sbTrace.append(makefile + " for C++     Created\n");
            if (this.pogo.is_abstractclass) {
                this.buildAbstractClassMakefile(makefile);
            }
        } else {
            this.addObjectToMakefile(makefile);
        }
        if (this.pogo.inherited_from != null && !this.pogo.inherited_from.equals("Device_3Impl")) {
            this.insertAbstractClassPath(makefile);
        }
        if (!this.pogo.is_abstractclass && this.mustGenerate(main)) {
            System.out.println("Generating " + main + "....");
            PogoGeneCpp.copyFile(new String(this.pogo.templates_dir + "/cpp/main.cpp"), main);
            this.sbTrace.append(main + "     Created\n");
        }
        if (!this.pogo.is_abstractclass && this.mustGenerate(cfactory)) {
            System.out.println("Generating " + cfactory + "....");
            this.replacePatternFile(new String(this.pogo.templates_dir + "/cpp/ClassFactory.cpp"), cfactory, "TemplateDevServ", this.pogo.class_name);
            this.sbTrace.append(cfactory + "      Created\n");
        }
        CppServerClass sc = new CppServerClass(this.pogo);
        sc.generateHeader(serverclass_h);
        this.sbTrace.append(serverclass_h + "      written\n");
        sc.generateSource(serverclass);
        this.sbTrace.append(serverclass + "      Written\n");
        CppServer serv = new CppServer(this.pogo);
        serv.generateHeader(server_h);
        this.sbTrace.append(server_h + "      written\n");
        if (!this.pogo.is_abstractclass) {
            serv.generateSource(server);
            this.sbTrace.append(server + "       written\n");
        }
        CppStateMachine allowed = new CppStateMachine(this.pogo);
        allowed.generateSource(this.pogo.templates_dir + "/cpp/MachineState.cpp", allowedfile);
        this.sbTrace.append(allowedfile + "       written\n");
        this.updateNamespace(serverclass_h);
        this.updateNamespace(serverclass);
        this.updateNamespace(server_h);
        if (!this.pogo.is_abstractclass) {
            this.updateNamespace(server);
            this.updateNamespace(allowedfile);
            this.updateNamespaceInClFac(cfactory);
        }
    }

    private void changeClassName(String old_file, String new_file, String old_name, String new_name) throws FileNotFoundException, SecurityException, IOException, PogoException {
        this.replacePatternFile(old_file, new_file, old_name, new_name);
        if (!new_file.equals(old_file)) {
            new File(old_file).delete();
        }
    }

    public void changeClassName() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String old_classname = this.pogo.projectFiles.getOriginalClassName();
        String makefile = new String(this.pogo.projectFiles.getPath() + "/Makefile");
        String main = new String(this.pogo.projectFiles.getPath() + "/main.cpp");
        String cfactory = new String(this.pogo.projectFiles.getPath() + "/ClassFactory.cpp");
        String server = new String(this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + ".cpp");
        String server_h = new String(this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + ".h");
        String serverclass = new String(this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + "Class.cpp");
        String serverclass_h = new String(this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + "Class.h");
        String state_machine = new String(this.pogo.projectFiles.getPath() + "/" + this.pogo.class_name + "StateMachine.cpp");
        String old_server = new String(this.pogo.projectFiles.getPath() + "/" + old_classname + ".cpp");
        String old_server_h = new String(this.pogo.projectFiles.getPath() + "/" + old_classname + ".h");
        String old_serverclass = new String(this.pogo.projectFiles.getPath() + "/" + old_classname + "Class.cpp");
        String old_serverclass_h = new String(this.pogo.projectFiles.getPath() + "/" + old_classname + "Class.h");
        String old_state_machine = new String(this.pogo.projectFiles.getPath() + "/" + old_classname + "StateMachine.cpp");
        if (this.already_exists(makefile)) {
            this.replacePatternFile(makefile, makefile, old_classname, this.pogo.class_name);
        }
        if (this.already_exists(main)) {
            this.replacePatternFile(main, main, old_classname, this.pogo.class_name);
        }
        if (this.already_exists(cfactory)) {
            this.replacePatternFile(cfactory, cfactory, old_classname, this.pogo.class_name);
        }
        if (this.already_exists(old_server)) {
            this.changeClassName(old_server, server, old_classname, this.pogo.class_name);
        }
        if (this.already_exists(old_server_h)) {
            this.changeClassName(old_server_h, server_h, old_classname, this.pogo.class_name);
            this.changeClassName(server_h, server_h, old_classname.toUpperCase(), this.pogo.class_name.toUpperCase());
        }
        if (this.already_exists(old_serverclass)) {
            this.changeClassName(old_serverclass, serverclass, old_classname, this.pogo.class_name);
        }
        if (this.already_exists(old_serverclass_h)) {
            this.changeClassName(old_serverclass_h, serverclass_h, old_classname, this.pogo.class_name);
            this.changeClassName(serverclass_h, serverclass_h, old_classname.toUpperCase(), this.pogo.class_name.toUpperCase());
        }
        if (this.already_exists(old_state_machine)) {
            this.changeClassName(old_state_machine, state_machine, old_classname, this.pogo.class_name);
        }
        this.pogo.projectFiles.updateOriginalFields();
    }
}

