/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pogo.appli.PogoAppli;
import pogo.appli.PogoAppliDefs;
import pogo.gene.PogoUtil;
import pogo.gene.ServerDefinitions;

public class ClassDialog
extends JDialog
implements PogoAppliDefs {
    private static int returnStatus = 0;
    private static final String impl_txt = "Tango Device";
    private String[] class_list = null;
    private JPanel jPanel1;
    private JButton okBtn;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel jLabel8;
    private JTextField nameText;
    private JLabel jLabel4;
    private JTextField projectText;
    private JLabel inheritedLabel;
    private JComboBox abstractClassComboBox;
    private JLabel jLabel6;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private JTextArea descText;

    public ClassDialog(JFrame parent, ServerDefinitions defs) {
        super((Frame)parent, true);
        int i;
        this.initComponents();
        this.nameText.setText(defs.name);
        this.descText.setText(defs.description);
        this.descText.setToolTipText("Description for device server documentation.");
        this.projectText.setText(defs.project_title);
        this.projectText.setToolTipText("Short description for documentation header");
        String impl_txt = impl_txt;
        if (defs.inherited_from == null) {
            String[] tmp = PogoUtil.abstractClassList();
            this.class_list = new String[tmp.length + 1];
            this.class_list[0] = impl_txt;
            for (i = 0; i < tmp.length; ++i) {
                this.class_list[i + 1] = tmp[i];
            }
        } else {
            this.class_list = new String[1];
            this.class_list[0] = defs.inherited_from == null || defs.inherited_from.equals("Device_3Impl") ? impl_txt : defs.inherited_from;
        }
        for (i = 0; i < this.class_list.length; ++i) {
            int start = this.class_list[i].lastIndexOf("/");
            int end = this.class_list[i].lastIndexOf(".");
            String classname = end > ++start ? this.class_list[i].substring(start, end) : this.class_list[i].substring(start);
            this.abstractClassComboBox.addItem(classname);
        }
        this.pack();
        PogoAppli.centerDialog(this, parent);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel8 = new JLabel();
        this.nameText = new JTextField();
        this.jLabel4 = new JLabel();
        this.projectText = new JTextField();
        this.inheritedLabel = new JLabel();
        this.abstractClassComboBox = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.descText = new JTextArea();
        this.setTitle("Command Window");
        this.setBackground(new Color(198, 178, 168));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ClassDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2));
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel8.setFont(new Font("Dialog", 1, 18));
        this.jLabel8.setText("Class Name :");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel8, gridBagConstraints1);
        this.nameText.setFont(new Font("Dialog", 1, 18));
        this.nameText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassDialog.this.nameTextActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 3);
        this.jPanel2.add((Component)this.nameText, gridBagConstraints1);
        this.jLabel4.setText("Project Title :");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 3);
        this.jPanel2.add((Component)this.projectText, gridBagConstraints1);
        this.inheritedLabel.setText(" Inherited from class:");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new Insets(0, 3, 0, 0);
        this.jPanel2.add((Component)this.inheritedLabel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        this.jPanel2.add((Component)this.abstractClassComboBox, gridBagConstraints1);
        this.jLabel6.setText("Class Description:  ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints1);
        this.jLabel1.setText(" ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints1);
        this.jLabel7.setText(" ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints1);
        this.jScrollPane1.setForeground(Color.lightGray);
        this.jScrollPane1.setPreferredSize(new Dimension(500, 150));
        this.descText.setColumns(80);
        this.descText.setMinimumSize(new Dimension(0, 100));
        this.descText.setPreferredSize(new Dimension(880, 400));
        this.jScrollPane1.setViewportView(this.descText);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 7;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 3, 0, 3);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints1);
        this.getContentPane().add((Component)this.jPanel2, "Center");
    }

    public int showDialog() {
        this.setVisible(true);
        return returnStatus;
    }

    private void nameTextActionPerformed(ActionEvent evt) {
        String classname = this.checkClassName();
        if (classname == null) {
            return;
        }
        this.doClose(1);
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        String classname = this.checkClassName();
        if (classname == null) {
            return;
        }
        this.doClose(1);
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    ServerDefinitions getInput() {
        String classname = this.checkClassName();
        if (classname == null) {
            return null;
        }
        String inherited_from = null;
        if (this.class_list != null) {
            String str = this.class_list[this.abstractClassComboBox.getSelectedIndex()];
            inherited_from = str.equals(impl_txt) ? "Device_3Impl" : str;
        }
        return new ServerDefinitions(classname, inherited_from, this.descText.getText(), this.projectText.getText());
    }

    private String checkClassName() {
        if (this.nameText.getText().length() == 0) {
            return null;
        }
        StringTokenizer stk = new StringTokenizer(this.nameText.getText());
        String name = "";
        int i = 0;
        while (stk.hasMoreTokens()) {
            String tmp = stk.nextToken();
            if (tmp.charAt(0) >= 'a' || tmp.charAt(0) >= 'z') {
                char car = (char)(tmp.charAt(0) - 32);
                tmp = new String(car + tmp.substring(1));
                name = name + tmp;
            } else {
                name = name + tmp;
            }
            ++i;
        }
        if (name.length() == 0) {
            return null;
        }
        return name;
    }
}

