/*
 * Decompiled with CFR 0.152.
 */
package app_util;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.CommunicationFailed;
import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.EventSystemFailed;
import fr.esrf.TangoApi.NonDbDevice;
import fr.esrf.TangoApi.NonSupportedFeature;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoApi.WrongNameSyntax;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JOptionPane;

public class PopupError {
    public static void show(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, "Error Window", 0);
    }

    public static void show(Component parent, Exception e) {
        PopupError.show(parent, e.toString());
    }

    public static void show(Component parent, DevFailed e) {
        PopupError.show(parent, null, e);
    }

    public static void show(Component parent, String message, DevFailed e) {
        StringBuffer sb = new StringBuffer();
        if (message != null) {
            sb.append(message + ":\n");
        }
        if (e instanceof ConnectionFailed) {
            sb.append(((ConnectionFailed)e).getStack());
        } else if (e instanceof CommunicationFailed) {
            sb.append(((CommunicationFailed)e).getStack());
        } else if (e instanceof WrongNameSyntax) {
            sb.append(((WrongNameSyntax)e).getStack());
        } else if (e instanceof WrongData) {
            sb.append(((WrongData)e).getStack());
        } else if (e instanceof NonDbDevice) {
            sb.append(((NonDbDevice)e).getStack());
        } else if (e instanceof NonSupportedFeature) {
            sb.append(((NonSupportedFeature)e).getStack());
        } else if (e instanceof EventSystemFailed) {
            sb.append(((EventSystemFailed)e).getStack());
        } else if (e instanceof AsynReplyNotArrived) {
            sb.append(((AsynReplyNotArrived)e).getStack());
        } else {
            for (int i = 0; i < e.errors.length; ++i) {
                if (message == null) {
                    sb.append(e.toString() + ":\n");
                }
                sb.append("Tango exception\n");
                sb.append("Severity -> ");
                switch (e.errors[i].severity.value()) {
                    case 0: {
                        sb.append("WARNING \n");
                        break;
                    }
                    case 1: {
                        sb.append("ERROR \n");
                        break;
                    }
                    case 2: {
                        sb.append("PANIC \n");
                        break;
                    }
                    default: {
                        sb.append("Unknown severity code");
                    }
                }
                sb.append("Desc -> " + e.errors[i].desc + "\n");
                sb.append("Reason -> " + e.errors[i].reason + "\n");
                sb.append("Origin -> " + e.errors[i].origin + "\n");
                if (i >= e.errors.length - 1) continue;
                sb.append("-------------------------------------------------------------\n");
            }
        }
        PopupError.show(parent, sb.toString());
    }

    public static String getStackTrace(Exception e) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(stream);
        e.printStackTrace(ps);
        return stream.toString();
    }

    public static void showStackTrace(Component parent, Exception e) {
        PopupError.show(parent, PopupError.getStackTrace(e));
    }
}

