/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.soleil.TangoHdb.HdbTools.Mode.ModeAbsolu;
import fr.soleil.TangoHdb.HdbTools.Mode.ModePeriode;
import fr.soleil.TangoHdb.HdbTools.Mode.ModeRelatif;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import jive.AbsoluteMode;
import jive.Mode;
import jive.PeriodicMode;
import jive.RelativeMode;

public class HdbModeDlg
extends JDialog
implements ActionListener {
    private static int dlgWidth = 400;
    private static int dlgHeight = 265;
    private static int nbMode = 3;
    private static int hdbMode = 0;
    private static Mode[] panelsMode = new Mode[]{new PeriodicMode(dlgWidth - 20), new AbsoluteMode(dlgWidth - 20), new RelativeMode(dlgWidth - 20)};
    private JComboBox comboMode;
    private JLabel lbMode;
    private JButton okBtn;
    private JButton okAllBtn;
    private JButton cancelBtn;
    private JPanel descPanel;
    private JTextArea descText;
    private int ret_value;
    private boolean multipleSelection;

    public HdbModeDlg(String string, Frame frame) {
        super(frame, string, true);
        this.multipleSelection = false;
        this.initComponents();
    }

    public HdbModeDlg(String string, Dialog dialog) {
        super(dialog, string, true);
        this.multipleSelection = true;
        this.initComponents();
    }

    public void initComponents() {
        this.getContentPane().setLayout(null);
        this.lbMode = new JLabel("Mode");
        this.getContentPane().add(this.lbMode);
        this.lbMode.setBounds(5, 5, 100, 25);
        this.comboMode = new JComboBox();
        this.getContentPane().add(this.comboMode);
        this.comboMode.setBounds(105, 5, 280, 25);
        this.comboMode.setEditable(false);
        this.comboMode.removeAllItems();
        for (int i = 0; i < nbMode; ++i) {
            this.comboMode.addItem(panelsMode[i].getName());
            this.getContentPane().add(panelsMode[i]);
            panelsMode[i].setBounds(5, 30, 380, 100);
            panelsMode[i].setVisible(false);
        }
        this.comboMode.setSelectedIndex(hdbMode);
        panelsMode[hdbMode].setVisible(true);
        this.comboMode.addActionListener(this);
        this.descPanel = new JPanel();
        this.descPanel.setLayout(new GridLayout(1, 0));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Mode descripton");
        titledBorder.setTitleFont(new Font("Dialog", 0, 11));
        this.descPanel.setBorder(titledBorder);
        this.getContentPane().add(this.descPanel);
        this.descPanel.setBounds(5, 132, 380, 70);
        this.descText = new JTextArea("");
        this.descText.setEditable(false);
        this.descText.setBackground(this.getBackground());
        this.descText.setText(panelsMode[hdbMode].getModeDescription());
        this.descPanel.add(this.descText);
        this.okBtn = new JButton("Apply");
        this.okBtn.setToolTipText("Apply this mode configuration for the selected attribute only");
        this.getContentPane().add(this.okBtn);
        this.okBtn.setBounds(5, 205, 120, 25);
        this.okBtn.addActionListener(this);
        if (this.multipleSelection) {
            this.okAllBtn = new JButton("Apply to all");
            this.okAllBtn.setToolTipText("Apply this mode configuration to all \"is_archivied\" HDB items selected.");
            this.getContentPane().add(this.okAllBtn);
            this.okAllBtn.setBounds(130, 205, 125, 25);
            this.okAllBtn.addActionListener(this);
        }
        this.cancelBtn = new JButton("Cancel");
        this.getContentPane().add(this.cancelBtn);
        this.cancelBtn.setBounds(260, 205, 120, 25);
        this.cancelBtn.addActionListener(this);
        this.ret_value = 0;
        this.centerWindow();
    }

    public void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = new Dimension(dlgWidth, dlgHeight);
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setBounds(n, n2, dimension2.width, dimension2.height);
    }

    public fr.soleil.TangoHdb.HdbTools.Mode.Mode getMode() {
        this.setVisible(true);
        if (this.ret_value > 0) {
            try {
                switch (hdbMode) {
                    case 0: {
                        PeriodicMode periodicMode = (PeriodicMode)panelsMode[hdbMode];
                        ModePeriode modePeriode = new ModePeriode();
                        modePeriode.setFrequency(periodicMode.getPeriod());
                        fr.soleil.TangoHdb.HdbTools.Mode.Mode mode = new fr.soleil.TangoHdb.HdbTools.Mode.Mode();
                        mode.setModeP(modePeriode);
                        return mode;
                    }
                    case 1: {
                        AbsoluteMode absoluteMode = (AbsoluteMode)panelsMode[hdbMode];
                        ModeAbsolu modeAbsolu = new ModeAbsolu();
                        modeAbsolu.setFrequency(absoluteMode.getPeriod());
                        modeAbsolu.setValInf(absoluteMode.getMinimum());
                        modeAbsolu.setValSup(absoluteMode.getMaximum());
                        fr.soleil.TangoHdb.HdbTools.Mode.Mode mode = new fr.soleil.TangoHdb.HdbTools.Mode.Mode();
                        mode.setModeA(modeAbsolu);
                        return mode;
                    }
                    case 2: {
                        RelativeMode relativeMode = (RelativeMode)panelsMode[hdbMode];
                        ModeRelatif modeRelatif = new ModeRelatif();
                        modeRelatif.setFrequency(relativeMode.getPeriod());
                        modeRelatif.setPercentInf(relativeMode.getMinimum());
                        modeRelatif.setPercentSup(relativeMode.getMaximum());
                        fr.soleil.TangoHdb.HdbTools.Mode.Mode mode = new fr.soleil.TangoHdb.HdbTools.Mode.Mode();
                        mode.setModeR(modeRelatif);
                        return mode;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean getContinueState() {
        return this.ret_value == 2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.comboMode) {
            int n = this.comboMode.getSelectedIndex();
            for (int i = 0; i < nbMode; ++i) {
                panelsMode[i].setVisible(i == n);
            }
            this.descText.setText(panelsMode[n].getModeDescription());
        }
        if (actionEvent.getSource() == this.okBtn) {
            this.ret_value = 1;
            this.setVisible(false);
        }
        if (actionEvent.getSource() == this.okAllBtn) {
            this.ret_value = 2;
            this.setVisible(false);
        }
        if (actionEvent.getSource() == this.cancelBtn) {
            this.ret_value = 0;
            this.setVisible(false);
        }
    }
}

