/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.TangoConst;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import jive.ArgParser;
import jive.AttrInfo;
import jive.DevHelperDevFailed;
import jive.ExecDev;

public final class ExtractHelper
implements TangoConst {
    public static void string_to_devicedata(String string, DeviceData deviceData, int n) throws NumberFormatException {
        if (n == 0) {
            return;
        }
        ArgParser argParser = new ArgParser(string);
        switch (n) {
            case 1: {
                deviceData.insert(argParser.parse_boolean());
                break;
            }
            case 6: {
                deviceData.insert_us(argParser.parse_ushort());
                break;
            }
            case 2: {
                deviceData.insert(argParser.parse_short());
                break;
            }
            case 7: {
                deviceData.insert_ul(argParser.parse_ulong());
                break;
            }
            case 3: {
                deviceData.insert(argParser.parse_long());
                break;
            }
            case 4: {
                deviceData.insert(argParser.parse_float());
                break;
            }
            case 5: {
                deviceData.insert(argParser.parse_double());
                break;
            }
            case 8: {
                deviceData.insert(argParser.parse_string());
                break;
            }
            case 9: {
                deviceData.insert(argParser.parse_char_array());
                break;
            }
            case 14: {
                deviceData.insert_us(argParser.parse_ushort_array());
                break;
            }
            case 10: {
                deviceData.insert(argParser.parse_short_array());
                break;
            }
            case 15: {
                deviceData.insert_ul(argParser.parse_ulong_array());
                break;
            }
            case 11: {
                deviceData.insert(argParser.parse_long_array());
                break;
            }
            case 12: {
                deviceData.insert(argParser.parse_float_array());
                break;
            }
            case 13: {
                deviceData.insert(argParser.parse_double_array());
                break;
            }
            case 16: {
                deviceData.insert(argParser.parse_string_array());
                break;
            }
            case 17: {
                deviceData.insert(new DevVarLongStringArray(argParser.parse_long_array(), argParser.parse_string_array()));
                break;
            }
            case 18: {
                deviceData.insert(new DevVarDoubleStringArray(argParser.parse_double_array(), argParser.parse_string_array()));
                break;
            }
            case 19: {
                deviceData.insert(DevState.from_int((int)argParser.parse_ushort()));
                break;
            }
            default: {
                throw new NumberFormatException("Command type not supported code=" + n);
            }
        }
    }

    public static void string_to_deviceattribute(String string, DeviceAttribute deviceAttribute, AttrDataFormat attrDataFormat, int n) throws NumberFormatException {
        ArgParser argParser = new ArgParser(string);
        switch (n) {
            case 20: {
                switch (attrDataFormat.value()) {
                    case 0: {
                        deviceAttribute.insert(argParser.parse_uchar());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert(argParser.parse_uchar_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert(argParser.parse_uchar_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            case 1: {
                switch (attrDataFormat.value()) {
                    case 0: {
                        deviceAttribute.insert(argParser.parse_boolean());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert(argParser.parse_boolean_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert(argParser.parse_boolean_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            case 2: {
                switch (attrDataFormat.value()) {
                    case 0: {
                        deviceAttribute.insert(argParser.parse_short());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert(argParser.parse_short_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert(argParser.parse_short_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            case 6: {
                switch (attrDataFormat.value()) {
                    case 0: {
                        deviceAttribute.insert_us(argParser.parse_ushort());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert_us(argParser.parse_ushort_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert_us(argParser.parse_ushort_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            case 3: {
                switch (attrDataFormat.value()) {
                    case 0: {
                        deviceAttribute.insert(argParser.parse_long());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert(argParser.parse_long_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert(argParser.parse_long_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            case 4: {
                switch (attrDataFormat.value()) {
                    case 0: {
                        deviceAttribute.insert(argParser.parse_float());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert(argParser.parse_float_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert(argParser.parse_float_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            case 5: {
                switch (attrDataFormat.value()) {
                    case 0: {
                        deviceAttribute.insert(argParser.parse_double());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert(argParser.parse_double_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert(argParser.parse_double_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            case 8: {
                switch (attrDataFormat.value()) {
                    case 0: {
                        deviceAttribute.insert(argParser.parse_string());
                        break;
                    }
                    case 1: {
                        deviceAttribute.insert(argParser.parse_string_array());
                        break;
                    }
                    case 2: {
                        deviceAttribute.insert(argParser.parse_string_image(), argParser.get_image_width(), argParser.get_image_height());
                    }
                }
                break;
            }
            default: {
                throw new NumberFormatException("Attribute type not supported code=" + n);
            }
        }
    }

    public static String devicedata_to_string(DeviceData deviceData, int n) {
        String string = new String("");
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                Boolean bl = new Boolean(deviceData.extractBoolean());
                string = bl.toString();
                break;
            }
            case 6: {
                string = Integer.toString(deviceData.extractUShort());
                break;
            }
            case 2: {
                string = Short.toString(deviceData.extractShort());
                break;
            }
            case 7: {
                string = Long.toString(deviceData.extractULong());
                break;
            }
            case 3: {
                string = Integer.toString(deviceData.extractLong());
                break;
            }
            case 4: {
                string = Float.toString(deviceData.extractFloat());
                break;
            }
            case 5: {
                string = Double.toString(deviceData.extractDouble());
                break;
            }
            case 8: {
                string = deviceData.extractString();
                break;
            }
            case 9: {
                byte[] byArray = deviceData.extractByteArray();
                string = string + "array length: " + byArray.length + "\n";
                if (byArray.length > ExecDev.answerLimit) {
                    string = string + "Array too long to be displayed. (You may change the AnswerLimit)\n";
                    break;
                }
                for (int i = 0; i < byArray.length; ++i) {
                    string = string + "[" + i + "]\t " + Integer.toString(byArray[i]);
                    string = byArray[i] >= 32 ? string + " '" + new Character((char)byArray[i]).toString() + "'" : string + " '.'";
                    string = string + "\n";
                }
                break;
            }
            case 14: {
                int[] nArray = deviceData.extractUShortArray();
                string = string + "array length: " + nArray.length + "\n";
                if (nArray.length > ExecDev.answerLimit) {
                    string = string + "Array too long to be displayed. (You may change the AnswerLimit)\n";
                    break;
                }
                for (int i = 0; i < nArray.length; ++i) {
                    string = string + "[" + i + "]\t " + Integer.toString(nArray[i]) + "\n";
                }
                break;
            }
            case 10: {
                short[] sArray = deviceData.extractShortArray();
                string = string + "array length: " + sArray.length + "\n";
                if (sArray.length > ExecDev.answerLimit) {
                    string = string + "Array too long to be displayed. (You may change the AnswerLimit)\n";
                    break;
                }
                for (int i = 0; i < sArray.length; ++i) {
                    string = string + "[" + i + "]\t " + Short.toString(sArray[i]) + "\n";
                }
                break;
            }
            case 15: {
                long[] lArray = deviceData.extractULongArray();
                string = string + "array length: " + lArray.length + "\n";
                if (lArray.length > ExecDev.answerLimit) {
                    string = string + "Array too long to be displayed. (You may change the AnswerLimit)\n";
                    break;
                }
                for (int i = 0; i < lArray.length; ++i) {
                    string = string + "[" + i + "]\t " + Long.toString(lArray[i]) + "\n";
                }
                break;
            }
            case 11: {
                int[] nArray = deviceData.extractLongArray();
                string = string + "array length: " + nArray.length + "\n";
                if (nArray.length > ExecDev.answerLimit) {
                    string = string + "Array too long to be displayed. (You may change the AnswerLimit)\n";
                    break;
                }
                for (int i = 0; i < nArray.length; ++i) {
                    string = string + "[" + i + "]\t " + Integer.toString(nArray[i]) + "\n";
                }
                break;
            }
            case 12: {
                float[] fArray = deviceData.extractFloatArray();
                string = string + "array length: " + fArray.length + "\n";
                if (fArray.length > ExecDev.answerLimit) {
                    string = string + "Array too long to be displayed. (You may change the AnswerLimit)\n";
                    break;
                }
                for (int i = 0; i < fArray.length; ++i) {
                    string = string + "[" + i + "]\t " + Float.toString(fArray[i]) + "\n";
                }
                break;
            }
            case 13: {
                double[] dArray = deviceData.extractDoubleArray();
                string = string + "array length: " + dArray.length + "\n";
                if (dArray.length > ExecDev.answerLimit) {
                    string = string + "Array too long to be displayed. (You may change the AnswerLimit)\n";
                    break;
                }
                for (int i = 0; i < dArray.length; ++i) {
                    string = string + "[" + i + "]\t" + Double.toString(dArray[i]) + "\n";
                }
                break;
            }
            case 16: {
                String[] stringArray = deviceData.extractStringArray();
                string = string + "array length: " + stringArray.length + "\n";
                if (stringArray.length > ExecDev.answerLimit) {
                    string = string + "Array too long to be displayed. (You may change the AnswerLimit)\n";
                    break;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + "[" + i + "]\t " + stringArray[i] + "\n";
                }
                break;
            }
            case 17: {
                int n2;
                DevVarLongStringArray devVarLongStringArray = deviceData.extractLongStringArray();
                string = string + "long array length: " + devVarLongStringArray.lvalue.length + "\n";
                string = string + "lvalue:\n";
                if (devVarLongStringArray.lvalue.length > ExecDev.answerLimit) {
                    string = string + "Array too long to be displayed. (You may change the AnswerLimit)\n";
                } else {
                    for (n2 = 0; n2 < devVarLongStringArray.lvalue.length; ++n2) {
                        string = string + "[" + n2 + "]\t " + Integer.toString(devVarLongStringArray.lvalue[n2]) + "\n";
                    }
                }
                string = string + "string array length: " + devVarLongStringArray.svalue.length + "\n";
                string = string + "svalue:\n";
                if (devVarLongStringArray.svalue.length > ExecDev.answerLimit) {
                    string = string + "Array too long to be displayed. (You may change the AnswerLimit)\n";
                    break;
                }
                for (n2 = 0; n2 < devVarLongStringArray.svalue.length; ++n2) {
                    string = string + "[" + n2 + "]\t " + devVarLongStringArray.svalue[n2] + "\n";
                }
                break;
            }
            case 18: {
                int n3;
                DevVarDoubleStringArray devVarDoubleStringArray = deviceData.extractDoubleStringArray();
                string = string + "double array length: " + devVarDoubleStringArray.dvalue.length + "\n";
                string = string + "lvalue:\n";
                if (devVarDoubleStringArray.dvalue.length > ExecDev.answerLimit) {
                    string = string + "Array too long to be displayed. (You may change the AnswerLimit)\n";
                } else {
                    for (n3 = 0; n3 < devVarDoubleStringArray.dvalue.length; ++n3) {
                        string = string + "[" + n3 + "]\t " + Double.toString(devVarDoubleStringArray.dvalue[n3]) + "\n";
                    }
                }
                string = string + "string array length: " + devVarDoubleStringArray.svalue.length + "\n";
                string = string + "svalue:\n";
                if (devVarDoubleStringArray.svalue.length > ExecDev.answerLimit) {
                    string = string + "Array too long to be displayed. (You may change the AnswerLimit)\n";
                    break;
                }
                for (n3 = 0; n3 < devVarDoubleStringArray.svalue.length; ++n3) {
                    string = string + "[" + n3 + "]\t " + devVarDoubleStringArray.svalue[n3] + "\n";
                }
                break;
            }
            case 19: {
                string = TangoConst.Tango_DevStateName[deviceData.extractDevState().value()];
                break;
            }
        }
        return string;
    }

    private static void appendAttributeValue(Object[] objectArray, AttrWriteType attrWriteType, AttrDataFormat attrDataFormat, int n, StringBuffer stringBuffer) {
        if (attrDataFormat.value() == 0) {
            if (objectArray.length > 0) {
                if (attrWriteType == AttrWriteType.WRITE) {
                    stringBuffer.append("last written value: " + objectArray[0].toString() + "\n");
                } else {
                    stringBuffer.append("read point: " + objectArray[0].toString() + "\n");
                }
            }
            if (objectArray.length > 1) {
                stringBuffer.append("set  point: " + objectArray[1].toString() + "\n");
            }
        } else {
            stringBuffer.append("array length: " + n + "\n");
            if (objectArray.length > ExecDev.answerLimit) {
                stringBuffer.append("Array too long to be displayed. (You may change the AnswerLimit)\n");
            } else {
                int n2;
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("[" + n2 + "]\t" + objectArray[n2].toString() + "\n");
                }
                if (objectArray.length > n) {
                    stringBuffer.append("\n");
                    int n3 = 0;
                    while (n2 < objectArray.length) {
                        stringBuffer.append("Set [" + n3 + "]\t" + objectArray[n2].toString() + "\n");
                        ++n3;
                        ++n2;
                    }
                }
            }
        }
    }

    public static String deviceattribute_to_string(DeviceAttribute deviceAttribute, AttrWriteType attrWriteType, AttrDataFormat attrDataFormat, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            TimeVal timeVal = deviceAttribute.getTimeVal();
            stringBuffer.append("measure date: " + timeVal.tv_sec + "sec   " + timeVal.tv_usec + "usec\n");
            Date date = new Date((long)((double)timeVal.tv_sec * 1000.0 + (double)timeVal.tv_usec / 1000.0));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            simpleDateFormat.setTimeZone(TimeZone.getDefault());
            stringBuffer.append("measure date: " + simpleDateFormat.format(date) + "\n");
            AttrQuality attrQuality = deviceAttribute.getQuality();
            stringBuffer.append("quality: ");
            switch (attrQuality.value()) {
                case 0: {
                    stringBuffer.append("VALID\n");
                    break;
                }
                case 1: {
                    stringBuffer.append("INVALID\n");
                    return stringBuffer.toString();
                }
                case 2: {
                    stringBuffer.append("ALARM\n");
                    break;
                }
                default: {
                    stringBuffer.append("UNKNOWN\n");
                }
            }
            switch (attrDataFormat.value()) {
                case 0: {
                    break;
                }
                case 1: {
                    stringBuffer.append("dim x: " + deviceAttribute.getDimX() + "\n");
                    break;
                }
                case 2: {
                    stringBuffer.append("dim x: " + deviceAttribute.getDimX() + "\n");
                    stringBuffer.append("dim y: " + deviceAttribute.getDimY() + "\n");
                    break;
                }
            }
            switch (n) {
                case 19: {
                    stringBuffer.append(TangoConst.Tango_DevStateName[deviceAttribute.extractState().value()] + "\n");
                    break;
                }
                case 20: {
                    short[] sArray = deviceAttribute.extractUCharArray();
                    Object[] objectArray = new Short[sArray.length];
                    for (int i = 0; i < sArray.length; ++i) {
                        objectArray[i] = new Short(sArray[i]);
                    }
                    ExtractHelper.appendAttributeValue(objectArray, attrWriteType, attrDataFormat, deviceAttribute.getNbRead(), stringBuffer);
                    break;
                }
                case 2: {
                    short[] sArray = deviceAttribute.extractShortArray();
                    Object[] objectArray = new Short[sArray.length];
                    for (int i = 0; i < sArray.length; ++i) {
                        objectArray[i] = new Short(sArray[i]);
                    }
                    ExtractHelper.appendAttributeValue(objectArray, attrWriteType, attrDataFormat, deviceAttribute.getNbRead(), stringBuffer);
                    break;
                }
                case 1: {
                    boolean[] blArray = deviceAttribute.extractBooleanArray();
                    Object[] objectArray = new Boolean[blArray.length];
                    for (int i = 0; i < blArray.length; ++i) {
                        objectArray[i] = new Boolean(blArray[i]);
                    }
                    ExtractHelper.appendAttributeValue(objectArray, attrWriteType, attrDataFormat, deviceAttribute.getNbRead(), stringBuffer);
                    break;
                }
                case 6: {
                    int[] nArray = deviceAttribute.extractUShortArray();
                    Object[] objectArray = new Integer[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        objectArray[i] = new Integer(nArray[i]);
                    }
                    ExtractHelper.appendAttributeValue(objectArray, attrWriteType, attrDataFormat, deviceAttribute.getNbRead(), stringBuffer);
                    break;
                }
                case 3: {
                    int[] nArray = deviceAttribute.extractLongArray();
                    Object[] objectArray = new Integer[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        objectArray[i] = new Integer(nArray[i]);
                    }
                    ExtractHelper.appendAttributeValue(objectArray, attrWriteType, attrDataFormat, deviceAttribute.getNbRead(), stringBuffer);
                    break;
                }
                case 5: {
                    double[] dArray = deviceAttribute.extractDoubleArray();
                    Object[] objectArray = new Double[dArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        objectArray[i] = new Double(dArray[i]);
                    }
                    ExtractHelper.appendAttributeValue(objectArray, attrWriteType, attrDataFormat, deviceAttribute.getNbRead(), stringBuffer);
                    break;
                }
                case 4: {
                    float[] fArray = deviceAttribute.extractFloatArray();
                    Object[] objectArray = new Float[fArray.length];
                    for (int i = 0; i < fArray.length; ++i) {
                        objectArray[i] = new Float(fArray[i]);
                    }
                    ExtractHelper.appendAttributeValue(objectArray, attrWriteType, attrDataFormat, deviceAttribute.getNbRead(), stringBuffer);
                    break;
                }
                case 8: {
                    Object[] objectArray = deviceAttribute.extractStringArray();
                    ExtractHelper.appendAttributeValue(objectArray, attrWriteType, attrDataFormat, deviceAttribute.getNbRead(), stringBuffer);
                    break;
                }
                default: {
                    stringBuffer.append("Unsupported attribute type code=" + n + "\n");
                    break;
                }
            }
        }
        catch (DevFailed devFailed) {
            return new DevHelperDevFailed(devFailed).toString();
        }
        return stringBuffer.toString();
    }

    public static String cmd_argin_example(int n) {
        String string = new String("Ex: ");
        switch (n) {
            case 0: {
                string = new String("");
                break;
            }
            case 19: {
                string = string + "0 (16bits value)";
                break;
            }
            case 1: {
                string = string + "true,false or 0,1";
                break;
            }
            case 20: {
                string = string + "10 or 0xa (unsigned 8bits)";
                break;
            }
            case 6: {
                string = string + "10 or 0xa (unsigned 16bits)";
                break;
            }
            case 2: {
                string = string + "10 or 0xa (signed 16bits)";
                break;
            }
            case 7: {
                string = string + "10 or 0xa (unsigned 32bits)";
                break;
            }
            case 3: {
                string = string + "10 or 0xa (signed 32bits)";
                break;
            }
            case 4: {
                string = string + "2.3 (32bits float)";
                break;
            }
            case 5: {
                string = string + "2.3 (64bits float)";
                break;
            }
            case 8: {
                string = "quotes needed for string with space or special char";
                break;
            }
            case 9: {
                string = string + "2,0xa,4 (signed 8bits)";
                break;
            }
            case 14: {
                string = string + "2,0xa,4 (unsigned 16bits)";
                break;
            }
            case 10: {
                string = string + "2,0xa,4 (signed 16bits)";
                break;
            }
            case 15: {
                string = string + "2,0xa,4 (unsigned 32bits)";
                break;
            }
            case 11: {
                string = string + "2,0xa,4 (signed 32bits)";
                break;
            }
            case 12: {
                string = string + "2.3,4 (32bits floats)";
                break;
            }
            case 13: {
                string = string + "2.3,4 (64bits floats)";
                break;
            }
            case 16: {
                string = string + "Dance,\"the TANGO\" (quotes needed for string with space or special char)";
                break;
            }
            case 17: {
                string = string + "[1,2][A,\"B C\",D] (quotes needed for string with space or special char)";
                break;
            }
            case 18: {
                string = "[1.0,2.0][A,\"B C\",D] (quotes needed for string with space or special char)";
                break;
            }
            default: {
                string = new String("");
            }
        }
        return string;
    }

    public static String att_argin_example(AttrInfo attrInfo) {
        String string = "";
        switch (attrInfo.data_type_num) {
            case 19: {
                string = string + "0 (16bits value)";
                break;
            }
            case 20: {
                string = string + "10 or 0xa (unsigned 8bits)";
                break;
            }
            case 1: {
                string = string + "true,false or 0,1";
                break;
            }
            case 6: {
                string = string + "10 or 0xa (unsigned 16bits)";
                break;
            }
            case 2: {
                string = string + "10 or 0xa (signed 16bits)";
                break;
            }
            case 3: {
                string = string + "10 or 0xa (signed 32bits)";
                break;
            }
            case 4: {
                string = string + "2.3 (32bits float)";
                break;
            }
            case 5: {
                string = string + "2.3 (64bits float)";
                break;
            }
            case 8: {
                string = "quotes needed for string with space or special char";
                break;
            }
            default: {
                string = new String("");
            }
        }
        if (attrInfo.data_format.equals("SPECTRUM")) {
            return "Array of " + string + " Ex: a,b,c";
        }
        if (attrInfo.data_format.equals("IMAGE")) {
            return "Image of " + string + " Ex: [a,b,c][d,e,f][g,h,i]";
        }
        return "Ex: " + string;
    }
}

