/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DispLevel;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoDs.TangoConst;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jive.AttrInfo;
import jive.CmdInfo;
import jive.DevHelper;
import jive.DevHelperDevFailed;
import jive.ExtractHelper;

public class ExecDev
extends JPanel
implements ActionListener,
MouseListener,
TangoConst {
    String client_host = null;
    DevHelper device;
    String device_name = null;
    String session_id = null;
    int nb_commands;
    CmdInfo[] commands;
    String[] attrs;
    AttrInfo[] attr_configs;
    final String SEP_COMMAND_NAME = "_____________";
    int getto_index;
    int setto_index;
    int setlim_index;
    public static int answerLimit = 2048;
    JList list_commands;
    JList list_attrs;
    JList list_attr_props;
    JScrollPane list_commands_view;
    JScrollPane list_attrs_view;
    JScrollPane list_attr_props_view;
    JTextField in_type_field;
    JTextField out_type_field;
    JTextArea in_type_desc;
    JTextArea out_type_desc;
    JScrollPane in_type_desc_view;
    JScrollPane out_type_desc_view;
    JTextField in_value;
    JTextArea history;
    JScrollPane history_view;
    JButton exec_button;
    JButton clear_button;
    JButton rdattr_button;
    JButton wrattr_button;
    JButton close_button;
    JComboBox cmd_source_cb;
    JLabel title_label;
    JLabel in_example;
    JLabel in_value_lb;
    JLabel command_list_lb;
    JLabel argin_type_lb;
    JLabel argout_type_lb;
    JLabel argin_desc_lb;
    JLabel argout_desc_lb;
    JLabel att_list_lb;
    JLabel att_prop_lb;
    JLabel cmd_source_lb;
    boolean isAnApplet = false;
    static final int DBG_NONE = 0;
    static final int DBG_ERRORS = 1;
    static final int DBG_TRACE = 2;
    static final int DBG_INFOS = 3;
    static final int DBG_MAX = 4;

    public ExecDev() {
        this.setLayout(null);
        this.title_label = new JLabel();
        this.title_label.setHorizontalAlignment(0);
        this.title_label.setFont(new Font("Lucida Bright", 1, 16));
        this.add(this.title_label);
        this.in_value_lb = new JLabel("Argin Value");
        this.add(this.in_value_lb);
        this.in_example = new JLabel("", 4);
        this.add(this.in_example);
        this.in_value = new JTextField();
        this.in_value.setBackground(Color.white);
        this.in_value.setEditable(true);
        this.add(this.in_value);
        this.command_list_lb = new JLabel("");
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Command");
        this.command_list_lb.setBorder(titledBorder);
        this.add(this.command_list_lb);
        this.argin_type_lb = new JLabel("Argin Type");
        this.add(this.argin_type_lb);
        this.argout_type_lb = new JLabel("Argout Type");
        this.add(this.argout_type_lb);
        this.list_commands = new JList();
        this.list_commands.addMouseListener(this);
        this.list_commands_view = new JScrollPane(this.list_commands);
        this.add(this.list_commands_view);
        this.in_type_field = new JTextField();
        this.in_type_field.setEditable(false);
        this.add(this.in_type_field);
        this.out_type_field = new JTextField(10);
        this.out_type_field.setEditable(false);
        this.add(this.out_type_field);
        this.argin_desc_lb = new JLabel("Argin Description");
        this.add(this.argin_desc_lb);
        this.argout_desc_lb = new JLabel("Argout Description");
        this.add(this.argout_desc_lb);
        this.in_type_desc = new JTextArea();
        this.in_type_desc.setEditable(false);
        this.in_type_desc.setBackground(this.in_type_field.getBackground());
        this.in_type_desc_view = new JScrollPane(this.in_type_desc);
        this.in_type_desc_view.setHorizontalScrollBarPolicy(32);
        this.add(this.in_type_desc_view);
        this.out_type_desc = new JTextArea();
        this.out_type_desc.setEditable(false);
        this.out_type_desc.setBackground(this.out_type_field.getBackground());
        this.out_type_desc_view = new JScrollPane(this.out_type_desc);
        this.out_type_desc_view.setHorizontalScrollBarPolicy(32);
        this.add(this.out_type_desc_view);
        this.exec_button = new JButton("Execute");
        this.exec_button.addActionListener(this);
        this.add(this.exec_button);
        this.clear_button = new JButton("Clear History");
        this.clear_button.addActionListener(this);
        this.add(this.clear_button);
        this.cmd_source_cb = new JComboBox();
        this.cmd_source_cb.addItem("CACHE");
        this.cmd_source_cb.addItem("CACHE_DEVICE");
        this.cmd_source_cb.addItem("DEVICE");
        this.add(this.cmd_source_cb);
        this.cmd_source_lb = new JLabel("Source");
        this.add(this.cmd_source_lb);
        this.att_list_lb = new JLabel("");
        titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Attribute");
        this.att_list_lb.setBorder(titledBorder);
        this.add(this.att_list_lb);
        this.list_attrs = new JList();
        this.list_attrs.addMouseListener(this);
        this.list_attrs_view = new JScrollPane(this.list_attrs);
        this.add(this.list_attrs_view);
        this.list_attr_props = new JList();
        this.list_attr_props.addMouseListener(this);
        this.list_attr_props_view = new JScrollPane(this.list_attr_props);
        this.add(this.list_attr_props_view);
        this.rdattr_button = new JButton("Read Attribute");
        this.rdattr_button.addActionListener(this);
        this.add(this.rdattr_button);
        this.wrattr_button = new JButton("Write Attribute");
        this.wrattr_button.addActionListener(this);
        this.add(this.wrattr_button);
        this.close_button = new JButton("Dismiss");
        this.close_button.addActionListener(this);
        this.add(this.close_button);
        this.history = new JTextArea("");
        this.history.setEditable(false);
        this.history_view = new JScrollPane(this.history);
        this.add(this.history_view);
    }

    public Rectangle getPRect(double d, double d2, double d3, double d4) {
        Dimension dimension = this.getSize();
        double d5 = (double)dimension.width / 100.0;
        double d6 = (double)dimension.height / 100.0;
        Rectangle rectangle = new Rectangle((int)(d * d5), (int)(d2 * d6), (int)((d3 - d) * d5), (int)((d4 - d2) * d6));
        return rectangle;
    }

    public void placeComponents(Dimension dimension) {
        this.setSize(dimension);
        this.title_label.setBounds(this.getPRect(2.0, 1.0, 98.0, 4.0));
        this.in_value_lb.setBounds(this.getPRect(2.0, 4.0, 30.0, 6.4));
        this.in_example.setBounds(this.getPRect(36.4, 4.0, 98.0, 6.4));
        this.in_value.setBounds(this.getPRect(2.0, 6.8, 98.0, 10.2));
        this.cmd_source_lb.setBounds(this.getPRect(2.0, 10.5, 19.0, 14.0));
        this.cmd_source_cb.setBounds(this.getPRect(20.0, 10.5, 60.0, 14.0));
        this.command_list_lb.setBounds(this.getPRect(0.8, 14.0, 99.5, 39.0));
        this.list_commands_view.setBounds(this.getPRect(2.0, 16.5, 31.6, 38.0));
        this.argin_type_lb.setBounds(this.getPRect(33.4, 15.4, 62.2, 18.2));
        this.in_type_field.setBounds(this.getPRect(33.4, 18.6, 62.6, 22.8));
        this.argout_type_lb.setBounds(this.getPRect(66.4, 15.4, 98.0, 18.2));
        this.out_type_field.setBounds(this.getPRect(66.4, 18.6, 98.0, 22.8));
        this.argin_desc_lb.setBounds(this.getPRect(33.4, 23.6, 62.2, 26.2));
        this.in_type_desc_view.setBounds(this.getPRect(33.4, 26.6, 63.0, 32.5));
        this.argout_desc_lb.setBounds(this.getPRect(66.4, 23.6, 98.0, 26.2));
        this.out_type_desc_view.setBounds(this.getPRect(66.4, 26.6, 98.0, 32.5));
        this.exec_button.setBounds(this.getPRect(51.0, 34.0, 80.0, 38.0));
        this.att_list_lb.setBounds(this.getPRect(0.8, 39.0, 99.5, 61.5));
        this.list_attrs_view.setBounds(this.getPRect(2.0, 42.0, 40.5, 55.4));
        this.list_attr_props_view.setBounds(this.getPRect(41.4, 42.0, 98.0, 55.4));
        this.rdattr_button.setBounds(this.getPRect(15.0, 56.4, 50.0, 60.4));
        this.wrattr_button.setBounds(this.getPRect(50.5, 56.4, 85.0, 60.4));
        this.history_view.setBounds(this.getPRect(1.0, 61.6, 99.0, 94.5));
        this.close_button.setBounds(this.getPRect(15.0, 95.2, 50.0, 99.5));
        this.clear_button.setBounds(this.getPRect(50.5, 95.2, 85.0, 99.5));
        this.list_commands_view.revalidate();
        this.history_view.revalidate();
        this.list_attrs_view.revalidate();
        this.list_attr_props_view.revalidate();
        this.out_type_desc_view.revalidate();
        this.in_type_desc_view.revalidate();
        this.cmd_source_cb.revalidate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.clear_button) {
            this.history.replaceRange("", 0, this.history.getText().length());
        }
        if (object == this.exec_button) {
            this.execCurCommand();
        }
        if (object == this.rdattr_button) {
            this.readCurAttr();
        }
        if (object == this.wrattr_button) {
            this.writeCurAttr();
        }
        if (object == this.close_button) {
            this.getParent().getParent().getParent().getParent().setVisible(false);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.list_commands) {
            if (mouseEvent.getClickCount() >= 2) {
                this.execCurCommand();
            } else {
                this.update_command_infos();
            }
        } else if (object == this.list_attrs) {
            if (mouseEvent.getClickCount() >= 2) {
                this.readCurAttr();
            } else {
                this.update_attr_infos();
            }
        }
    }

    public void display_error(String string) {
        JOptionPane.showMessageDialog(null, string, "Device Panel Error", 0);
    }

    public boolean set_device_name(String string) {
        this.device_name = string;
        this.debug(2, "Entering set_device_name()");
        this.title_label.setText(this.device_name);
        if (!this.isAnApplet) {
            try {
                this.device = new DevHelper(this.device_name);
            }
            catch (DevHelperDevFailed devHelperDevFailed) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("failed to import device: " + this.device_name + "\n");
                stringBuffer.append(devHelperDevFailed);
                this.debug(1, stringBuffer.toString());
                this.display_error(stringBuffer.toString());
                return true;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("ORB failed connecting to database");
                this.debug(1, stringBuffer.toString());
                this.display_error(stringBuffer.toString());
                return true;
            }
        }
        this.cmd_source_cb.setSelectedIndex(this.device.get_source());
        this.get_commands();
        this.get_attrs();
        this.update_ui_list();
        this.history.replaceRange("", 0, this.history.getText().length());
        return false;
    }

    void update_ui_list() {
        int n;
        this.list_commands.removeAll();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (n = 0; n < this.nb_commands; ++n) {
            defaultListModel.add(n, this.commands[n].cmd_name);
        }
        this.list_commands.setModel(defaultListModel);
        this.list_commands.setSelectedIndex(0);
        this.update_command_infos();
        this.list_attrs.removeAll();
        this.list_attr_props.removeAll();
        if (this.attrs.length > 0) {
            defaultListModel = new DefaultListModel();
            for (n = 0; n < this.attrs.length; ++n) {
                defaultListModel.add(n, this.attrs[n]);
            }
            this.list_attrs.setModel(defaultListModel);
            this.list_attrs.setSelectedIndex(0);
            this.update_attr_infos();
            this.rdattr_button.setEnabled(true);
            this.wrattr_button.setEnabled(true);
        } else {
            this.rdattr_button.setEnabled(false);
            this.wrattr_button.setEnabled(false);
        }
    }

    void get_commands() {
        int n;
        this.debug(2, "Entering get_commands()");
        CmdInfo[] cmdInfoArray = null;
        int n2 = 0;
        if (!this.isAnApplet) {
            CommandInfo[] commandInfoArray = this.device.command_list_query();
            n2 = commandInfoArray.length;
            cmdInfoArray = new CmdInfo[n2];
            for (n = 0; n < n2; ++n) {
                cmdInfoArray[n] = new CmdInfo();
                cmdInfoArray[n].cmd_name = commandInfoArray[n].cmd_name;
                cmdInfoArray[n].in_type = commandInfoArray[n].in_type;
                cmdInfoArray[n].in_type_desc = commandInfoArray[n].in_type_desc;
                cmdInfoArray[n].out_type = commandInfoArray[n].out_type;
                cmdInfoArray[n].out_type_desc = commandInfoArray[n].out_type_desc;
            }
        }
        int n3 = 4;
        this.nb_commands = n2 + n3;
        this.commands = new CmdInfo[this.nb_commands];
        n = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (n4 == 3) {
                n += n3;
            }
            this.commands[n] = new CmdInfo();
            this.commands[n].cmd_name = cmdInfoArray[n4].cmd_name;
            this.commands[n].in_type = cmdInfoArray[n4].in_type;
            this.commands[n].in_type_desc = cmdInfoArray[n4].in_type_desc;
            this.commands[n].out_type = cmdInfoArray[n4].out_type;
            this.commands[n].out_type_desc = cmdInfoArray[n4].out_type_desc;
            ++n4;
            ++n;
        }
        n = 3;
        this.commands[n] = new CmdInfo();
        this.commands[n].cmd_name = "SetTimeout";
        this.commands[n].in_type = 2;
        this.commands[n].in_type_desc = "Timeout in mS";
        this.commands[n].out_type = 0;
        this.commands[n].out_type_desc = "";
        this.setto_index = n++;
        this.commands[n] = new CmdInfo();
        this.commands[n].cmd_name = "GetTimeout";
        this.commands[n].in_type = 0;
        this.commands[n].in_type_desc = "";
        this.commands[n].out_type = 2;
        this.commands[n].out_type_desc = "Timeout in mS";
        this.getto_index = n++;
        this.commands[n] = new CmdInfo();
        this.commands[n].cmd_name = "SetAnswerLimit";
        this.commands[n].in_type = 2;
        this.commands[n].in_type_desc = "Argout print limit (-1 for no limit)";
        this.commands[n].out_type = 0;
        this.commands[n].out_type_desc = "";
        this.setlim_index = n++;
        this.commands[n] = new CmdInfo();
        this.commands[n].cmd_name = "_____________";
        this.commands[n].in_type = 0;
        this.commands[n].in_type_desc = "";
        this.commands[n].out_type = 0;
        this.commands[n].out_type_desc = "";
        ++n;
        this.debug(2, "Leaving get_commands()");
    }

    void get_attrs() {
        this.debug(2, "Entering get_attrs()");
        if (!this.isAnApplet) {
            this.attrs = this.device.get_attribute_list();
            AttributeInfo[] attributeInfoArray = this.device.get_attribute_config();
            int n = attributeInfoArray.length;
            this.attr_configs = new AttrInfo[n];
            for (int i = 0; i < n; ++i) {
                this.attr_configs[i] = new AttrInfo(attributeInfoArray[i].name, ExecDev.AttrWriteType_to_string(attributeInfoArray[i].writable), ExecDev.AttrDataFormat_to_string(attributeInfoArray[i].data_format), TangoConst.Tango_CmdArgTypeName[attributeInfoArray[i].data_type], attributeInfoArray[i].data_type, Integer.toString(attributeInfoArray[i].max_dim_x), Integer.toString(attributeInfoArray[i].max_dim_y), attributeInfoArray[i].description, attributeInfoArray[i].label, attributeInfoArray[i].unit, attributeInfoArray[i].standard_unit, attributeInfoArray[i].display_unit, attributeInfoArray[i].format, attributeInfoArray[i].min_value, attributeInfoArray[i].max_value, attributeInfoArray[i].min_alarm, attributeInfoArray[i].max_alarm);
            }
        }
        this.debug(2, "Leaving get_attrs()");
    }

    public static String AttrWriteType_to_string(AttrWriteType attrWriteType) {
        String string = attrWriteType == AttrWriteType.READ ? "READ" : (attrWriteType == AttrWriteType.READ_WITH_WRITE ? "READ_WITH_WRITE" : (attrWriteType == AttrWriteType.WRITE ? "WRITE" : (attrWriteType == AttrWriteType.READ_WRITE ? "READ_WRITE" : "UNKNOWN")));
        return string;
    }

    public static String DispLevel_to_string(DispLevel dispLevel) {
        String string = dispLevel == DispLevel.OPERATOR ? "OPERATOR" : (dispLevel == DispLevel.EXPERT ? "EXPERT" : "UNKNOWN");
        return string;
    }

    public static String AttrDataFormat_to_string(AttrDataFormat attrDataFormat) {
        String string = attrDataFormat == AttrDataFormat.SCALAR ? "SCALAR" : (attrDataFormat == AttrDataFormat.SPECTRUM ? "SPECTRUM" : (attrDataFormat == AttrDataFormat.IMAGE ? "IMAGE" : "UNKNOWN"));
        return string;
    }

    String get_timeout() {
        int n = -1;
        this.debug(2, "Entering get_timeout()");
        if (!this.isAnApplet) {
            try {
                n = this.device.get_timeout();
            }
            catch (DevHelperDevFailed devHelperDevFailed) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("failed getting timeout\n");
                stringBuffer.append(devHelperDevFailed);
                this.debug(1, stringBuffer.toString());
                this.display_error(stringBuffer.toString());
                return null;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Exception: " + exception.getClass().getName() + "\n");
                stringBuffer.append("message:\t" + exception.getMessage() + "\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return null;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n###################################\n");
        stringBuffer.append("Current timeout to communicate with device\n");
        stringBuffer.append(Integer.toString(n) + " mS\n");
        this.debug(2, "Leaving get_timeout()");
        return stringBuffer.toString();
    }

    String set_timeout(String string) {
        this.debug(2, "Entering set_timeout()");
        String string2 = null;
        try {
            int n = Integer.valueOf(string);
            if (n < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.append_error("New timeout value not a positive integer value");
            return null;
        }
        if (!this.isAnApplet) {
            try {
                string2 = this.device.set_timeout(string);
            }
            catch (DevHelperDevFailed devHelperDevFailed) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("failed setting timeout to: " + string + "\n");
                stringBuffer.append(devHelperDevFailed);
                this.debug(1, stringBuffer.toString());
                this.display_error(stringBuffer.toString());
                return null;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Exception: " + exception.getClass().getName() + "\n");
                stringBuffer.append("message:\t" + exception.getMessage() + "\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return null;
            }
        }
        this.debug(2, "Leaving set_timeout()");
        return string2;
    }

    void execCurCommand() {
        this.debug(2, "Entering execCurCommand()");
        int n = this.list_commands.getSelectedIndex();
        if (n < 0) {
            return;
        }
        String string = this.commands[n].cmd_name;
        String string2 = this.in_value.getText();
        int n2 = this.commands[n].in_type;
        int n3 = this.commands[n].out_type;
        String string3 = null;
        if (string.equals("_____________")) {
            return;
        }
        if (n == this.getto_index) {
            string3 = this.get_timeout();
        } else if (n == this.setto_index) {
            string3 = this.set_timeout(string2);
        } else if (n == this.setlim_index) {
            try {
                answerLimit = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("wrong argin\n");
                stringBuffer.append("expecting an integer value\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n###################################\n");
            string3 = stringBuffer.toString();
        } else if (!this.isAnApplet) {
            try {
                this.device.set_source(this.cmd_source_cb.getSelectedIndex());
                string3 = this.device.exec_command(string, string2);
            }
            catch (DevHelperDevFailed devHelperDevFailed) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("failed execution command: " + string + "\n");
                stringBuffer.append(devHelperDevFailed);
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(numberFormatException.getMessage() + "\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Exception: " + exception.getClass().getName() + "\n");
                stringBuffer.append("message:\t" + exception.getMessage() + "\n");
                exception.printStackTrace();
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
        }
        if (string3 != null) {
            this.append_history(string3);
            if (string3.indexOf("WARNING: device re-imported") != -1) {
                this.get_commands();
                this.get_attrs();
                this.update_ui_list();
            }
        }
        this.debug(2, "Leaving execCurCommand()");
    }

    void readCurAttr() {
        this.debug(2, "Entering readCurAttr()");
        int n = this.list_attrs.getSelectedIndex();
        String string = this.attrs[n];
        this.debug(3, "Attribute to be read: " + string);
        String string2 = null;
        if (!this.isAnApplet) {
            try {
                this.device.set_source(this.cmd_source_cb.getSelectedIndex());
                string2 = this.device.read_attr(string);
            }
            catch (DevHelperDevFailed devHelperDevFailed) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("failed reading attribute: " + string + "\n");
                stringBuffer.append(devHelperDevFailed);
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Exception: " + exception.getClass().getName() + "\n");
                stringBuffer.append("message:\t" + exception.getMessage() + "\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
        }
        if (string2 != null) {
            this.append_history(string2);
            if (string2.indexOf("WARNING: device re-imported") != -1) {
                this.get_commands();
                this.get_attrs();
                this.update_ui_list();
            }
        }
        this.debug(2, "Leaving readCurAttr()");
    }

    void writeCurAttr() {
        this.debug(2, "Entering writeCurAttr()");
        int n = this.list_attrs.getSelectedIndex();
        String string = this.attrs[n];
        this.debug(3, "Attribute to write: " + string);
        String string2 = this.in_value.getText();
        String string3 = null;
        if (!this.isAnApplet) {
            try {
                string3 = this.device.write_attr(string, string2);
            }
            catch (DevHelperDevFailed devHelperDevFailed) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("failed writting attribute: " + string + "\n");
                stringBuffer.append(devHelperDevFailed);
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(numberFormatException.getMessage() + "\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Exception: " + exception.getClass().getName() + "\n");
                stringBuffer.append("message:\t" + exception.getMessage() + "\n");
                this.debug(1, stringBuffer.toString());
                this.append_error(stringBuffer.toString());
                return;
            }
        }
        if (string3 != null) {
            this.append_history(string3);
            if (string3.indexOf("WARNING: device re-imported") != -1) {
                this.get_commands();
                this.get_attrs();
                this.update_ui_list();
            }
        }
        this.debug(2, "Leaving writeCurAttr()");
    }

    private void update_command_infos() {
        int n = this.list_commands.getSelectedIndex();
        this.in_type_field.setText(TangoConst.Tango_CmdArgTypeName[this.commands[n].in_type]);
        if (this.commands[n].in_type != 0) {
            this.in_type_desc.setText(this.commands[n].in_type_desc);
            this.in_value.setEditable(true);
            this.in_example.setText(ExtractHelper.cmd_argin_example(this.commands[n].in_type));
        } else {
            this.in_type_desc.setText("");
            this.in_value.setText("");
            this.in_value.setEditable(false);
            this.in_example.setText("");
        }
        this.in_type_desc.setCaretPosition(0);
        this.out_type_field.setText(TangoConst.Tango_CmdArgTypeName[this.commands[n].out_type]);
        if (this.commands[n].out_type != 0) {
            this.out_type_desc.setText(this.commands[n].out_type_desc);
        } else {
            this.out_type_desc.setText("");
        }
        this.out_type_desc.setCaretPosition(0);
    }

    private void update_attr_infos() {
        int n = this.list_attrs.getSelectedIndex();
        this.list_attr_props.removeAll();
        if (this.attr_configs.length == 0) {
            return;
        }
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.add(0, "Name:          " + this.attr_configs[n].name);
        defaultListModel.add(1, "Writable:      " + this.attr_configs[n].writable);
        defaultListModel.add(2, "Data Format:   " + this.attr_configs[n].data_format);
        defaultListModel.add(3, "Data Type:     " + this.attr_configs[n].data_type);
        defaultListModel.add(4, "Max Dim X:     " + this.attr_configs[n].max_dim_x);
        defaultListModel.add(5, "Max Dim Y:     " + this.attr_configs[n].max_dim_y);
        defaultListModel.add(6, "Description:   " + this.attr_configs[n].description);
        defaultListModel.add(7, "Label:         " + this.attr_configs[n].label);
        defaultListModel.add(8, "Unit:          " + this.attr_configs[n].unit);
        defaultListModel.add(9, "Standard Unit: " + this.attr_configs[n].standard_unit);
        defaultListModel.add(10, "Display Unit:  " + this.attr_configs[n].display_unit);
        defaultListModel.add(11, "Format:        " + this.attr_configs[n].format);
        defaultListModel.add(12, "Min Value:     " + this.attr_configs[n].min_value);
        defaultListModel.add(13, "Max Value:     " + this.attr_configs[n].max_value);
        defaultListModel.add(14, "Min Alarm:     " + this.attr_configs[n].min_alarm);
        defaultListModel.add(15, "Max Alarm:     " + this.attr_configs[n].max_alarm);
        this.list_attr_props.setModel(defaultListModel);
        this.list_attr_props.setSelectedIndex(0);
        if (this.attr_configs[n].writable.indexOf("WRITE") != -1) {
            this.in_value.setEditable(true);
            this.in_example.setText(ExtractHelper.att_argin_example(this.attr_configs[n]));
        } else {
            this.in_value.setEditable(false);
            this.in_example.setText("");
        }
    }

    private void append_error(String string) {
        this.debug(1, string);
        this.append_history("\n###################################\nERROR !!\n" + string);
    }

    private void append_history(String string) {
        this.history.append(string);
        int n = this.history.getText().length();
        this.history.select(n, n);
    }

    private void debug(int n, String string) {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: ExecDev devicename");
        } else {
            final ExecDev execDev = new ExecDev();
            if (!execDev.set_device_name(stringArray[0])) {
                final JFrame jFrame = new JFrame();
                jFrame.setTitle("Device Panel");
                jFrame.getContentPane().setLayout(null);
                jFrame.getContentPane().add(execDev);
                jFrame.addComponentListener(new ComponentListener(){

                    public void componentHidden(ComponentEvent componentEvent) {
                        System.exit(0);
                    }

                    public void componentMoved(ComponentEvent componentEvent) {
                    }

                    public void componentResized(ComponentEvent componentEvent) {
                        execDev.placeComponents(jFrame.getContentPane().getSize());
                    }

                    public void componentShown(ComponentEvent componentEvent) {
                        execDev.placeComponents(jFrame.getContentPane().getSize());
                    }
                });
                jFrame.setBounds(50, 50, 450, 650);
                jFrame.setVisible(true);
            } else {
                System.exit(0);
            }
        }
    }
}

