/*
 * Decompiled with CFR 0.152.
 */
package explorer.ui;

import explorer.ui.DTMenuBar;
import explorer.ui.DTPrinter;
import explorer.ui.FileHandler;
import explorer.ui.UIBit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;

public class FileUI {
    UIBit saveBit;
    File file;
    JFileChooser fc;
    FileHandler main;
    JToolBar toolbar;

    public FileUI(FileHandler main, JToolBar toolbar, DTMenuBar menubar, boolean isAdmin, final JFrame mainFrame) {
        this.main = main;
        this.toolbar = toolbar;
        ImageIcon saveIcon = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/Save16.gif"));
        ImageIcon saveAsIcon = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/SaveAs16.gif"));
        ImageIcon newIcon = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/New16.gif"));
        ImageIcon openIcon = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/Open16.gif"));
        ImageIcon printIcon = new ImageIcon(this.getClass().getResource("/explorer/ui/printer.gif"));
        this.saveBit = new UIBit("Save", new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileUI.this.save();
            }
        }, saveIcon);
        this.saveBit.setEnabled(false);
        this.saveBit.setAccelerator('S');
        UIBit saveAsBit = new UIBit("Save as..", "Save as", new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileUI.this.saveAs();
            }
        }, saveAsIcon);
        saveAsBit.setAccelerator('A');
        saveAsBit.setEnabled(isAdmin);
        UIBit newBit = new UIBit("New", new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileUI.this.newFile();
            }
        }, newIcon);
        newBit.setAccelerator('N');
        newBit.setEnabled(isAdmin);
        UIBit openBit = new UIBit("Open...", "Open file", new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileUI.this.open();
            }
        }, openIcon);
        openBit.setAccelerator('O');
        openBit.setEnabled(isAdmin);
        UIBit printBit = new UIBit("Print..", "Print...", new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DTPrinter.printFrame(mainFrame, "DeviceTree", true, 0);
            }
        }, printIcon);
        menubar.add2FileMenu(openBit.getItem(), 0);
        menubar.add2FileMenu(newBit.getItem(), 1);
        menubar.add2FileMenu(new JSeparator(), 2);
        menubar.add2FileMenu(this.saveBit.getItem(), 3);
        menubar.add2FileMenu(saveAsBit.getItem(), 4);
        menubar.add2FileMenu(new JSeparator(), 5);
        menubar.add2FileMenu(printBit.getItem(), 6);
        toolbar.add(openBit.getButton());
        toolbar.add(newBit.getButton());
        toolbar.add(this.saveBit.getButton());
        toolbar.add(saveAsBit.getButton());
        toolbar.add(printBit.getButton());
        menubar.setQuitHandler(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileUI.this.quit();
            }
        });
        this.fc = new JFileChooser(new File("."));
        this.fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = FileUI.this.getExtension(f);
                return extension != null && extension.equals("xml");
            }

            public String getDescription() {
                return "xml files ";
            }
        });
    }

    public String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public void quit() {
        this.main.quit();
    }

    public void open() {
        int returnVal = this.fc.showOpenDialog(this.toolbar.getRootPane().getParent());
        if (returnVal == 0) {
            this.file = this.fc.getSelectedFile();
            this.saveBit.setEnabled(true);
            this.main.open(this.file);
        }
    }

    public void newFile() {
        this.main.newFile();
    }

    public void save() {
        this.main.save(this.file);
    }

    protected boolean confirm() {
        return JOptionPane.showConfirmDialog(null, "The file " + this.file.toString() + " exists, " + "do you want to overwrite it?", "Alert", 0) == 0;
    }

    public void saveAs() {
        int returnVal = this.fc.showSaveDialog(this.toolbar.getRootPane().getParent());
        if (returnVal == 0) {
            this.file = this.fc.getSelectedFile();
            if (!this.file.exists() || this.confirm()) {
                if (this.getExtension(this.file) == null) {
                    this.file = new File(this.file.getAbsolutePath() + ".xml");
                }
                this.main.save(this.file);
                this.saveBit.setEnabled(true);
            }
        }
    }
}

