/*
 * Decompiled with CFR 0.152.
 */
package explorer.ui;

import explorer.ui.Clearable;
import explorer.ui.DTMenuBar;
import explorer.ui.PreferencesDialog;
import explorer.ui.UIDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class EditUI {
    Clearable attributeTable;
    Clearable commandTable;

    public EditUI(Clearable attributeTable, Clearable commandTable, JToolBar toolbar, DTMenuBar menubar, boolean isAdmin) {
        JMenuItem properties = new JMenuItem("Preferences...");
        JMenuItem clearAttributes = new JMenuItem("Clear attributes...");
        JMenuItem clearCommands = new JMenuItem("Clear commands...");
        this.attributeTable = attributeTable;
        this.commandTable = commandTable;
        properties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditUI.this.properties();
            }
        });
        clearAttributes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditUI.this.clearAttributes();
            }
        });
        clearCommands.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditUI.this.clearCommands();
            }
        });
        properties.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/Preferences16.gif")));
        properties.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        menubar.add2EditMenu(clearAttributes, 0);
        menubar.add2EditMenu(clearCommands, 1);
        clearAttributes.setEnabled(isAdmin);
        clearCommands.setEnabled(isAdmin);
        menubar.add2EditMenu(properties, 2);
        PreferencesDialog.getInstance().addTop("Look and feel", UIDialog.getInstance());
    }

    public void properties() {
        PreferencesDialog.getInstance().show();
    }

    public void clearAttributes() {
        if (JOptionPane.showConfirmDialog(null, "Do you really want to clear the attribute table?", "Alert", 0) == 0) {
            this.attributeTable.clear();
        }
    }

    public void clearCommands() {
        if (JOptionPane.showConfirmDialog(null, "Do you really want to clear the command table?", "Alert", 0) == 0) {
            this.commandTable.clear();
        }
    }
}

