/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.About;
import explorer.AdminMain;
import explorer.AttributePanel;
import explorer.AttributeTable;
import explorer.AttributeTableModel;
import explorer.CommandTable;
import explorer.CommandTableModel;
import explorer.EntityTableModel;
import explorer.FileManager;
import explorer.Preferences;
import explorer.Status;
import explorer.ViewerMain;
import explorer.ui.DTMenuBar;
import explorer.ui.Dialog;
import explorer.ui.EditUI;
import explorer.ui.FileHandler;
import explorer.ui.FileUI;
import explorer.ui.RefreshUI;
import explorer.ui.RunUI;
import explorer.ui.UIDialog;
import fr.esrf.tangoatk.core.AEntityList;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IStatusListener;
import fr.esrf.tangoatk.core.StatusEvent;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import fr.esrf.tangoatk.widget.util.HelpWindow;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class Main
implements Status,
FileHandler,
IStatusListener {
    String done = "done";
    static String VERSION = "Device Tree : V1.3";
    public static boolean FULL = false;
    AttributePanel attributePanel;
    AttributeTable attributeTable;
    AttributeTableModel attributeTableModel;
    CommandTable commandTable;
    CommandTableModel commandTableModel;
    DTMenuBar menuBar;
    ErrorHistory errorHistory;
    ErrorPopup errorPopup;
    JFrame mainFrame;
    JToolBar refreshBar;
    JToolBar fileBar;
    File file;
    Preferences preferences;
    Dialog trendFrame;
    JPopupMenu entityPopup;
    JPopupMenu treePopup;
    JProgressBar progress;
    JLabel status;
    JCheckBoxMenuItem trendVisible;
    JSplitPane tableSplit;
    JSplitPane viewSplit;
    FileManager fileManager;
    static Trend globalTrend;
    boolean isAdmin;
    Splash splash;
    boolean runningFromShell = true;
    int windowX;
    int windowY;
    int windowWidth;
    int windowHeight;
    int tableSplitWidth;
    int tableSplitHeight;
    int viewSplitDividerLocation;
    int tableSplitDividerLocation;
    int mainSplitDividerLocation;
    boolean globalTrendVisible;
    boolean fileRecordable = true;
    public static final int DEFAULT_WINDOW_X = 50;
    public static final int DEFAULT_WINDOW_Y = 50;
    public static final int DEFAULT_WINDOW_WIDTH = 800;
    public static final int DEFAULT_WINDOW_HEIGHT = 600;
    public static final int DEFAULT_TABLE_SPLIT_DIVIDER_LOCATION = 200;
    public static final int DEFAULT_TABLE_SPLIT_WIDTH = 800;
    public static final int DEFAULT_TABLE_SPLIT_HEIGHT = 400;
    public static final int DEFAULT_VIEW_SPLIT_DIVIDER_LOCATION = 400;
    public static final boolean DEFAULT_GLOBAL_TREND_VISIBLE = true;
    public static final int DEFAULT_MAIN_SPLIT_DIVIDER_LOCATION = 300;
    public static final String MAIN_SPLIT_DIVIDER_LOCATION_KEY = "MAIN_SPLIT_DIVIDER_LOCATION";
    public static final String WINDOW_X_KEY = "MAIN_WINDOW_X";
    public static final String WINDOW_Y_KEY = "MAIN_WINDOW_Y";
    public static final String WINDOW_WIDTH_KEY = "MAIN_WINDOW_WIDTH";
    public static final String WINDOW_HEIGHT_KEY = "MAIN_WINDOW_HEIGHT";
    public static final String TABLE_SPLIT_DIVIDER_LOCATION_KEY = "TABLE_SPLIT_DIVIDER_LOCATION";
    public static final String VIEW_SPLIT_DIVIDER_LOCATION_KEY = "VIEW_SPLIT_DIVIDER_LOCATION";
    public static final String TABLE_SPLIT_WIDTH_KEY = "TABLE_SPLIT_WIDTH";
    public static final String TABLE_SPLIT_HEIGHT_KEY = "TABLE_SPLIT_HEIGHT";
    public static final String GLOBAL_TREND_VISIBLE_KEY = "GLOBAL_TREND_VISIBLE";

    protected void initHelp() {
        if (this.runningFromShell) {
            this.splash.setMessage("Setting up help...");
        }
        HelpWindow.getInstance().setTop("Explorer", this.getClass().getResource("/explorer/html/MainHelp.html"));
        HelpWindow.getInstance().addCategory("Main", "Device tree", this.getClass().getResource("/explorer/html/DeviceTreeHelp.html"));
        HelpWindow.getInstance().addCategory("Main", "Tool bar", this.getClass().getResource("/explorer/html/ToolBarHelp.html"));
        HelpWindow.getInstance().addCategory("Main", "Menu bar", this.getClass().getResource("/explorer/html/MenuBarHelp.html"));
        if (this.runningFromShell) {
            this.splash.setMessage("Setting up help..." + this.done);
        }
    }

    protected void initTrend() {
        if (this.runningFromShell) {
            this.splash.setMessage("Setting up trend...");
        }
        this.trendVisible = new JCheckBoxMenuItem("Global trend...");
        globalTrend = new Trend();
        this.trendFrame = new Dialog((JComponent)globalTrend);
        this.trendVisible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int loc = Main.this.tableSplit.getDividerLocation();
                if (Main.this.trendVisible.isSelected()) {
                    Main.this.viewSplit.setDividerLocation(0.5);
                } else {
                    Main.this.viewSplit.setDividerLocation(1.0);
                }
                Main.this.tableSplit.setDividerLocation(loc);
            }
        });
        globalTrend.setButtonBarVisible(false);
        this.attributeTable.setGlobalTrend(globalTrend);
        this.menuBar.add2ViewMenu(this.trendVisible, 1);
        if (this.runningFromShell) {
            this.splash.setMessage("Setting up trend..." + this.done);
        }
    }

    protected void initFileManager() {
        this.fileManager = FileManager.getInstance();
        this.fileManager.addErrorListener((IErrorListener)this.errorHistory);
    }

    protected void initTables() {
        if (this.runningFromShell) {
            this.splash.setMessage("Initializing components...");
        }
        this.attributeTableModel.addErrorListener((IErrorListener)this.errorHistory);
        this.attributeTableModel.addErrorListener((IErrorListener)this.errorPopup);
        this.commandTableModel.addErrorListener((IErrorListener)this.errorHistory);
        this.commandTableModel.addErrorListener((IErrorListener)this.errorPopup);
        if (this.runningFromShell) {
            this.splash.setMessage("Initializing collections..." + this.done);
        }
    }

    protected void resetPreferences() {
        this.windowX = this.preferences.getInt(WINDOW_X_KEY, 50);
        this.windowY = this.preferences.getInt(WINDOW_Y_KEY, 50);
        this.windowWidth = this.preferences.getInt(WINDOW_WIDTH_KEY, 800);
        this.windowHeight = this.preferences.getInt(WINDOW_HEIGHT_KEY, 600);
        this.tableSplitHeight = this.preferences.getInt(TABLE_SPLIT_HEIGHT_KEY, 400);
        this.tableSplitWidth = this.preferences.getInt(TABLE_SPLIT_WIDTH_KEY, 800);
        this.tableSplitDividerLocation = this.preferences.getInt(TABLE_SPLIT_DIVIDER_LOCATION_KEY, 200);
        this.viewSplitDividerLocation = this.preferences.getInt(VIEW_SPLIT_DIVIDER_LOCATION_KEY, 400);
        this.mainSplitDividerLocation = this.preferences.getInt(MAIN_SPLIT_DIVIDER_LOCATION_KEY, 300);
    }

    protected void initPreferences() {
        if (this.runningFromShell) {
            this.splash.setMessage("Getting preferences...");
        }
        this.preferences = FileManager.getInstance().getPreferences();
        this.resetPreferences();
        if (this.runningFromShell) {
            this.splash.setMessage("Getting preferences..." + this.done);
        }
    }

    protected void initUI(boolean isAdmin) {
        if (this.runningFromShell) {
            this.splash.setMessage("Initializing ui...");
        }
        Font font = new Font("Dialog", 0, 12);
        UIManager.put("Label.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("Menu.font", font);
        UIManager.put("Button.font", font);
        UIManager.put("TabbedPane.font", font);
        UIManager.put("CheckBox.font", font);
        UIManager.put("ProgressBar.font", font);
        this.errorPopup = new ErrorPopup();
        this.menuBar = new DTMenuBar(this.errorHistory);
        this.refreshBar = new JToolBar();
        this.fileBar = new JToolBar();
        this.mainFrame = new JFrame(VERSION);
        this.status = new JLabel();
        this.status.setBorder(BorderFactory.createLoweredBevelBorder());
        this.status.setText("Ready...");
        this.progress = new JProgressBar();
        this.progress.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mainFrame.setJMenuBar(this.menuBar);
        this.mainFrame.setBounds(this.windowX, this.windowY, this.windowWidth, this.windowHeight);
        this.attributeTableModel = new AttributeTableModel(this, this.preferences);
        this.attributeTable = new AttributeTable(this.attributeTableModel, this.preferences, isAdmin);
        this.commandTableModel = new CommandTableModel(this, this.preferences);
        this.commandTable = new CommandTable(this.commandTableModel, this.preferences, isAdmin);
        new RefreshUI(this.attributeTableModel, this.refreshBar, this.menuBar);
        new FileUI(this, this.fileBar, this.menuBar, isAdmin, this.mainFrame);
        new EditUI(this.attributeTableModel, this.commandTableModel, this.fileBar, this.menuBar, isAdmin);
        new RunUI(this.fileBar, this.menuBar);
        UIDialog.getInstance().addComponent(this.mainFrame);
        this.attributePanel = new AttributePanel();
        this.attributePanel.setTable(this.attributeTable);
        if (this.runningFromShell) {
            this.splash.setMessage("Initializing ui..." + this.done);
        }
    }

    protected void initComponents() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Main.this.exit();
            }
        });
        if (this.runningFromShell) {
            this.splash = new Splash();
            this.splash.setTitle(VERSION);
            this.splash.setMaxProgress(10);
            this.splash.progress(1);
        }
        DeviceFactory.setAutoStart((boolean)false);
        this.errorHistory = new ErrorHistory();
        this.initFileManager();
        this.initPreferences();
        if (this.runningFromShell) {
            this.splash.progress(2);
        }
        this.initUI(this.isAdmin);
        if (this.runningFromShell) {
            this.splash.progress(3);
        }
        this.initTables();
        if (this.runningFromShell) {
            this.splash.progress(4);
        }
        if (this.runningFromShell) {
            this.splash.progress(6);
        }
        this.initHelp();
        if (this.runningFromShell) {
            this.splash.progress(7);
        }
        this.initTrend();
        if (this.runningFromShell) {
            this.splash.progress(8);
        }
        if (this.runningFromShell) {
            this.splash.setMessage("Setting up frame...");
        }
        this.tableSplit = new JSplitPane(0);
        this.tableSplit.setPreferredSize(new Dimension(this.tableSplitWidth, this.tableSplitHeight));
        this.tableSplit.setDividerSize(9);
        this.tableSplit.setTopComponent(this.attributePanel);
        this.tableSplit.setBottomComponent(this.commandTable);
        this.tableSplit.setOneTouchExpandable(true);
        this.tableSplit.setDividerLocation(200);
        this.tableSplit.setResizeWeight(0.5);
        this.viewSplit = new JSplitPane(0);
        this.viewSplit.setPreferredSize(new Dimension(800, 200));
        this.viewSplit.setDividerSize(9);
        this.viewSplit.setTopComponent(this.tableSplit);
        this.viewSplit.setBottomComponent(new JScrollPane((Component)globalTrend));
        this.viewSplit.setOneTouchExpandable(true);
        this.viewSplit.setDividerLocation(400);
        this.viewSplit.setResizeWeight(0.6666666666666666);
        this.mainFrame.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.gridy = 0;
        constraints.gridx = 0;
        this.mainFrame.getContentPane().add((Component)this.refreshBar, constraints);
        constraints.gridx = 1;
        this.mainFrame.getContentPane().add((Component)this.fileBar, constraints);
        constraints.fill = 1;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        this.mainFrame.getContentPane().add((Component)new JLabel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weighty = 0.5;
        constraints.fill = 1;
        constraints.gridwidth = 0;
        constraints.gridx = 0;
        if (this.runningFromShell) {
            this.splash.setMessage("Setting up frame..." + this.done);
        }
        if (this.runningFromShell) {
            this.splash.progress(9);
        }
        this.specificSetup(constraints);
        if (this.runningFromShell) {
            this.splash.progress(10);
        }
        this.initStatus(constraints);
        this.menuBar.setAboutHandler(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new About().show();
            }
        });
        this.mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                Main.this.quit();
            }
        });
        if (this.runningFromShell) {
            this.splash.setVisible(false);
        }
        if (this.runningFromShell) {
            this.splash.dispose();
        }
    }

    protected void initStatus(GridBagConstraints constraints) {
        JPanel p = new JPanel();
        ++constraints.gridy;
        constraints.weightx = 0.1;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        constraints.gridx = 0;
        constraints.weightx = 0.9;
        this.mainFrame.getContentPane().add((Component)p, constraints);
        p.setLayout(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        p.add((Component)this.progress, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        p.add((Component)this.status, constraints);
    }

    public void open(File file) {
        this.file = file;
        this.fileRecordable = this.open(file.getAbsolutePath());
    }

    protected boolean open(String source) {
        this.mainFrame.setTitle(source);
        String src = source;
        this.attributePanel.clear();
        this.progress.setIndeterminate(true);
        this.progress.setStringPainted(true);
        boolean success = false;
        try {
            success = this.fileManager.open(source);
            this.resetPreferences();
            this.tableSplit.setDividerLocation(this.tableSplitDividerLocation);
            this.tableSplit.setPreferredSize(new Dimension(this.tableSplitWidth, this.tableSplitHeight));
            this.mainFrame.setBounds(this.windowX, this.windowY, this.windowWidth, this.windowHeight);
            SwingUtilities.updateComponentTreeUI(this.mainFrame);
            this.viewSplit.setDividerLocation(this.viewSplitDividerLocation);
            AttributeList attributes = this.fileManager.getAttributeList();
            CommandList commands = this.fileManager.getCommandList();
            this.attributeTable.setPreferences(this.preferences);
            this.commandTable.setPreferences(this.preferences);
            this.attributeTableModel.setPreferences(this.preferences);
            this.commandTableModel.setPreferences(this.preferences);
            this.attributeTableModel.addEntities((AEntityList)attributes);
            this.commandTableModel.addEntities((AEntityList)commands);
            EntityTableModel model = (EntityTableModel)this.attributeTable.getModel();
            int i = 0;
            while (i < model.getRowCount()) {
                String keyname;
                String st;
                String err;
                IEntity att = model.getEntityAt(i);
                if (att instanceof INumberSpectrum && (err = this.attributePanel.setSpectrumGraphSettings(att, st = this.preferences.getString(keyname = att.getName() + ".GraphSettings", ""))).length() > 0) {
                    JOptionPane.showMessageDialog(null, "Failed apply trend configuration: " + err, "Error", 0);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.status("Could not open " + this.file, e);
            e.printStackTrace();
            return false;
        }
        this.progress.setIndeterminate(false);
        return success;
    }

    public void status(String msg, Exception e) {
        Main.status(this.mainFrame, msg, e);
    }

    public static void status(Component comp, String msg, Exception e) {
        JOptionPane.showMessageDialog(comp, msg + " " + e.toString(), "Error", 0);
    }

    public void statusChange(StatusEvent evt) {
        this.status.setText(evt.getStatus());
    }

    public void quit() {
        if (this.runningFromShell) {
            System.exit(0);
        } else {
            this.mainFrame.hide();
            this.mainFrame.dispose();
        }
    }

    public void exit() {
    }

    protected abstract void specificSetup(GridBagConstraints var1);

    public static void main(String[] args) {
        FULL = true;
        if (args.length == 0) {
            new AdminMain(args);
        } else {
            new ViewerMain(args);
        }
    }

    static {
        DEFAULT_WINDOW_X = 50;
        DEFAULT_WINDOW_Y = 50;
        DEFAULT_WINDOW_WIDTH = 800;
        DEFAULT_WINDOW_HEIGHT = 600;
        DEFAULT_TABLE_SPLIT_DIVIDER_LOCATION = 200;
        DEFAULT_TABLE_SPLIT_WIDTH = 800;
        DEFAULT_TABLE_SPLIT_HEIGHT = 400;
        DEFAULT_VIEW_SPLIT_DIVIDER_LOCATION = 400;
        DEFAULT_GLOBAL_TREND_VISIBLE = true;
        DEFAULT_MAIN_SPLIT_DIVIDER_LOCATION = 300;
        MAIN_SPLIT_DIVIDER_LOCATION_KEY = MAIN_SPLIT_DIVIDER_LOCATION_KEY;
        WINDOW_X_KEY = WINDOW_X_KEY;
        WINDOW_Y_KEY = WINDOW_Y_KEY;
        WINDOW_WIDTH_KEY = WINDOW_WIDTH_KEY;
        WINDOW_HEIGHT_KEY = WINDOW_HEIGHT_KEY;
        TABLE_SPLIT_DIVIDER_LOCATION_KEY = TABLE_SPLIT_DIVIDER_LOCATION_KEY;
        VIEW_SPLIT_DIVIDER_LOCATION_KEY = VIEW_SPLIT_DIVIDER_LOCATION_KEY;
        TABLE_SPLIT_WIDTH_KEY = TABLE_SPLIT_WIDTH_KEY;
        TABLE_SPLIT_HEIGHT_KEY = TABLE_SPLIT_HEIGHT_KEY;
        GLOBAL_TREND_VISIBLE_KEY = GLOBAL_TREND_VISIBLE_KEY;
    }
}

