/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import com.braju.format.Format;
import explorer.EntityAdapter;
import explorer.EntityTableModel;
import explorer.Preferences;
import explorer.Status;
import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.NumberImageEvent;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.core.StatusEvent;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class AttributeTableModel
extends EntityTableModel {
    static String LABEL = "Label";
    static String VALUE = "Value";
    static String DISP_UNIT = "Disp. Unit";
    static String MIN_VAL = "Min value";
    static String MAX_VAL = "Max value";
    static String MIN_ALARM = "Min alarm";
    static String MAX_ALARM = "Max alarm";
    static String UNIT = "Unit";
    static String DATA_FORMAT = "Data format";
    static String DATA_TYPE = "Data type";
    static String DESCRIPTION = "Description";
    static String WRITABLE = "Writable";
    static String WRITABLE_NAME = "Writable name";
    static String MAX_Y = "Max dim y";
    static String MAX_X = "Max dim x";
    static String STD_UNIT = "Standar unit";
    static String SET = "Set";

    public AttributeTableModel(Status status, Preferences preferences) {
        this.status = status;
        this.entities = new AttributeList();
        this.adapters = new ArrayList();
        this.columnIdentifiers = new ArrayList();
        this.preferences = preferences;
        this.setRefreshInterval(preferences.getInt("refreshInterval", 1000));
    }

    void initColumns() {
        this.columnIdentifiers.add(EntityTableModel.DEVICE);
        this.columnIdentifiers.add(EntityTableModel.NAME);
        this.columnIdentifiers.add(LABEL);
        this.columnIdentifiers.add(VALUE);
        this.columnIdentifiers.add(DISP_UNIT);
        this.columnIdentifiers.add(DESCRIPTION);
        this.columnIdentifiers.add(UNIT);
        this.columnIdentifiers.add(WRITABLE);
        this.columnIdentifiers.add(SET);
        this.columnNames = new ArrayList(this.columnIdentifiers);
        this.columnNames.add(MIN_ALARM);
        this.columnNames.add(MAX_ALARM);
        this.columnNames.add(DATA_FORMAT);
        this.columnNames.add(DATA_TYPE);
        this.columnNames.add(MIN_VAL);
        this.columnNames.add(MAX_VAL);
        this.columnNames.add(WRITABLE_NAME);
        this.columnNames.add(MAX_X);
        this.columnNames.add(MAX_Y);
        this.columnNames.add(EntityTableModel.LEVEL);
        this.columnNames.add(STD_UNIT);
        this.fireTableStructureChanged();
    }

    StringBuffer getPreferencePrefix() {
        return new StringBuffer("AttributeTable.");
    }

    public Object getValueAt(int row, int column) {
        Object o = this.adapters.get(row);
        AttributeAdapter adapter = (AttributeAdapter)o;
        IAttribute attribute = adapter.getAttribute();
        String header = this.getColumnName(column);
        if (EntityTableModel.DEVICE == header) {
            return this.getDeviceAlias((IDevice)attribute.getDevice());
        }
        if (EntityTableModel.NAME == header) {
            return this.getEntityAlias((IEntity)attribute);
        }
        if (LABEL == header) {
            return attribute.getLabel();
        }
        if (VALUE == header) {
            return adapter;
        }
        if (DISP_UNIT == header) {
            return attribute.getDisplayUnit();
        }
        if (MIN_VAL == header) {
            if (attribute instanceof INumberScalar) {
                return new Double(((INumberScalar)attribute).getMinValue());
            }
            return new Double(Double.NaN);
        }
        if (MAX_VAL == header) {
            if (attribute instanceof INumberScalar) {
                return new Double(((INumberScalar)attribute).getMaxValue());
            }
            return new Double(Double.NaN);
        }
        if (MIN_ALARM == header) {
            if (attribute instanceof INumberScalar) {
                return new Double(((INumberScalar)attribute).getMinAlarm());
            }
            return new Double(Double.NaN);
        }
        if (MAX_ALARM == header) {
            if (attribute instanceof INumberScalar) {
                return new Double(((INumberScalar)attribute).getMinAlarm());
            }
            return new Double(Double.NaN);
        }
        if (UNIT == header) {
            return attribute.getUnit();
        }
        if (DATA_FORMAT == header) {
            return adapter.getDataFormat();
        }
        if (DATA_TYPE == header) {
            return adapter.getDataType();
        }
        if (DESCRIPTION == header) {
            return attribute.getDescription();
        }
        if (WRITABLE == header) {
            return adapter.getWritable();
        }
        if (WRITABLE_NAME == header) {
            return adapter.getWritableName();
        }
        if (MAX_X == header) {
            return new Integer(attribute.getMaxXDimension());
        }
        if (MAX_Y == header) {
            return new Integer(attribute.getMaxYDimension());
        }
        if (EntityTableModel.LEVEL == header) {
            return adapter.getLevel();
        }
        if (SET == header) {
            return attribute.isWritable() ? SET : "";
        }
        return null;
    }

    public void load(String name, String alias, String deviceAlias) throws ConnectionException {
        IAttribute attribute = (IAttribute)this.entities.add(name);
        this.addAttribute(attribute);
    }

    public void addEntity(IEntity attribute) {
        this.entities.add(attribute);
        this.addAttribute((IAttribute)attribute);
    }

    public void addAttribute(IAttribute attribute) {
        if (this.exists((IEntity)attribute)) {
            return;
        }
        this.adapters.add(new AttributeAdapter(attribute, this.adapters.size()));
        this.fireTableRowsInserted(this.adapters.size() - 1, this.adapters.size() - 1);
    }

    protected void addNumberScalar(String name) {
        try {
            INumberScalar scalar = (INumberScalar)this.entities.add(name);
            this.addAttribute((IAttribute)scalar);
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    protected void addStringScalar(String name) {
        try {
            IStringScalar scalar = (IStringScalar)this.entities.add(name);
            this.addAttribute((IAttribute)scalar);
        }
        catch (ConnectionException e) {
            this.status.status("Cannot load attribute " + name, (Exception)((Object)e));
        }
    }

    protected void addNumberSpectrum(String name) {
        try {
            INumberSpectrum spectrum = (INumberSpectrum)this.entities.add(name);
            this.addAttribute((IAttribute)spectrum);
        }
        catch (ConnectionException e) {
            this.status.status("Cannot load attribute " + name, (Exception)((Object)e));
        }
    }

    protected void addNumberImage(String name) {
        try {
            INumberImage image = (INumberImage)this.entities.add(name);
            this.addAttribute((IAttribute)image);
        }
        catch (ConnectionException e) {
            this.status.status("Cannot load attribute " + name, (Exception)((Object)e));
        }
    }

    boolean isExecuteColumn(int i) {
        return this.columnModel.getColumn(i).getHeaderValue() == SET;
    }

    class AttributeAdapter
    implements IStringScalarListener,
    INumberScalarListener,
    ISpectrumListener,
    IImageListener,
    IStateListener,
    EntityAdapter {
        int row;
        IAttribute attribute;
        String last = "See tab";
        String format = "";
        double doubleVal;

        public IEntity getEntity() {
            return this.attribute;
        }

        public void reloadProperties() {
            AttributeTableModel.this.fireTableRowsUpdated(this.row, this.row);
        }

        public AttributeAdapter(IAttribute attribute, int row) {
            this.row = row;
            this.attribute = attribute;
            attribute.getDevice().addStateListener((IStateListener)this);
            if (attribute instanceof INumberScalar) {
                this.last = "----";
                ((INumberScalar)attribute).addNumberScalarListener((INumberScalarListener)this);
                this.format = attribute.getFormat();
            }
            if (attribute instanceof IStringScalar) {
                this.last = "----";
                ((IStringScalar)attribute).addStringScalarListener((IStringScalarListener)this);
            }
            if (attribute instanceof INumberSpectrum) {
                ((INumberSpectrum)attribute).addSpectrumListener((ISpectrumListener)this);
            }
            if (attribute instanceof INumberImage) {
                ((INumberImage)attribute).addImageListener((IImageListener)this);
            }
        }

        public void remove() {
            this.attribute.getDevice().removeStateListener((IStateListener)this);
            if (this.attribute instanceof INumberScalar) {
                ((INumberScalar)this.attribute).removeNumberScalarListener((INumberScalarListener)this);
            } else if (this.attribute instanceof IStringScalar) {
                ((IStringScalar)this.attribute).removeStringScalarListener((IStringScalarListener)this);
            } else if (this.attribute instanceof INumberSpectrum) {
                ((INumberSpectrum)this.attribute).removeSpectrumListener((ISpectrumListener)this);
            } else if (this.attribute instanceof INumberImage) {
                ((INumberImage)this.attribute).removeImageListener((IImageListener)this);
            }
        }

        public void statusChange(StatusEvent evt) {
        }

        public void stateChange(StateEvent evt) {
            JComponent r = AttributeTableModel.this.getDeviceRenderer(AttributeTableModel.this.getDeviceAlias((IDevice)this.attribute.getDevice()));
            if (r == null) {
                return;
            }
            r.setBackground(ATKConstant.getColor4State((String)evt.getState()));
            r.setToolTipText(evt.getState());
            AttributeTableModel.this.fireTableRowsUpdated(this.row, this.row);
        }

        JComponent getValueRenderer() {
            return AttributeTableModel.this.getRenderer(this, VALUE);
        }

        public void errorChange(ErrorEvent evt) {
        }

        public void stateChange(AttributeStateEvent evt) {
            JComponent r = this.getValueRenderer();
            if (r == null) {
                return;
            }
            r.setToolTipText(evt.getState());
            r.setBackground(ATKConstant.getColor4Quality((String)evt.getState()));
            AttributeTableModel.this.fireTableRowsUpdated(this.row, this.row);
        }

        public void stringScalarChange(StringScalarEvent evt) {
            this.last = evt.getValue();
            this.updateRenderer();
        }

        public void numberScalarChange(NumberScalarEvent evt) {
            this.doubleVal = evt.getValue();
            this.last = Double.toString(this.doubleVal);
            this.updateRenderer();
        }

        void updateRenderer() {
            JComponent r = this.getValueRenderer();
            if (r == null) {
                return;
            }
            ((JLabel)r).setText(this.getLastValue());
            AttributeTableModel.this.fireTableRowsUpdated(this.row, this.row);
        }

        public void spectrumChange(NumberSpectrumEvent evt) {
        }

        public void imageChange(NumberImageEvent evt) {
        }

        public IAttribute getAttribute() {
            return this.attribute;
        }

        public String getLastValue() {
            if (this.format.equals("No format") || this.format == "") {
                return this.last;
            }
            if (this.format.indexOf(37) == -1) {
                return AttrManip.format((String)this.format, (double)this.doubleVal);
            }
            Object[] o = new Object[]{new Double(this.doubleVal)};
            return Format.sprintf((String)this.format, (Object[])o);
        }

        public String toString() {
            return this.getLastValue();
        }

        public String getLevel() {
            return ((Property)this.attribute.getPropertyMap().get("level")).getPresentation();
        }

        public String getDataFormat() {
            return ((Property)this.attribute.getPropertyMap().get("data_format")).getPresentation();
        }

        public String getDataType() {
            return ((Property)this.attribute.getPropertyMap().get("data_type")).getPresentation();
        }

        public String getWritable() {
            return ((Property)this.attribute.getPropertyMap().get("writable")).getPresentation();
        }

        public String getWritableName() {
            return ((Property)this.attribute.getPropertyMap().get("writable_attr_name")).getPresentation();
        }
    }
}

