/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.AstorUtil;
import admin.astor.DbaseObject;
import admin.astor.RemoteLoginThread;
import admin.astor.ServerCmdThread;
import admin.astor.TangoHost;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreePopupMenu
extends JPopupMenu
implements AstorDefs {
    private DefaultMutableTreeNode node_cut = null;
    private Astor astor;
    private AstorTree parent;
    private TangoHost host;
    private Point evt_position;
    private String collec_name;
    private TangoHost[] collec_hosts;
    private static String[] pMenuLabels = new String[]{"Open control Panel", "Disable control", "Enable  control", "Remote Login", "Starter info", "Starter test", "Starter Logging", "Unexport Starter device", "Start all Servers", "Stop  all Servers", "Clone", "Cut", "Paste", "Edit Properties", "Remove", "Change Name"};
    private static final int OFFSET = 2;
    private static final int OPEN_PANEL = 0;
    private static final int DISABLE = 1;
    private static final int ENABLE = 2;
    private static final int REM_LOGIN = 3;
    private static final int STARTER_INFO = 4;
    private static final int STARTER_TEST = 5;
    private static final int STARTER_LOGG = 6;
    private static final int UNEXPORT_STARTER = 7;
    private static final int START_SERVERS = 8;
    private static final int STOP_SERVERS = 9;
    private static final int CLONE_HOST = 10;
    private static final int CUT_HOST = 11;
    private static final int PASTE_HOST = 12;
    private static final int EDIT_PROP = 13;
    private static final int REMOVE_HOST = 14;
    private static final int CHANGE_NAME = 15;

    public TreePopupMenu(Astor astor, AstorTree parent) {
        this.astor = astor;
        this.parent = parent;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        JLabel title = new JLabel("Host Control :");
        title.setFont(new Font("Dialog", 1, 16));
        this.add(title);
        this.add(new JPopupMenu.Separator());
        for (int i = 0; i < pMenuLabels.length; ++i) {
            JMenuItem btn = new JMenuItem(pMenuLabels[i]);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TreePopupMenu.this.hostActionPerformed(evt);
                }
            });
            this.add(btn);
        }
    }

    private boolean getSelectedObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.parent.getLastSelectedPathComponent();
        if (node == null) {
            return false;
        }
        Object obj = node.getUserObject();
        if (obj instanceof DbaseObject) {
            return false;
        }
        if (obj instanceof TangoHost) {
            this.host = (TangoHost)((Object)obj);
            this.collec_name = null;
        } else {
            this.host = null;
            int nb = node.getChildCount();
            this.collec_hosts = new TangoHost[nb];
            for (int i = 0; i < nb; ++i) {
                Object o = (node = node.getNextNode()).getUserObject();
                if (!(o instanceof TangoHost)) {
                    return false;
                }
                this.collec_hosts[i] = (TangoHost)((Object)o);
            }
            this.collec_name = (String)obj;
        }
        return true;
    }

    public void showMenu(MouseEvent evt) {
        TreePath selectedPath = this.parent.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        Object[] path = selectedPath.getPath();
        this.parent.setSelectionPath(selectedPath);
        if (!this.getSelectedObject()) {
            return;
        }
        for (int i = 3; i < this.getComponentCount(); ++i) {
            ((JMenuItem)this.getComponent(i)).setVisible(true);
        }
        if (this.host != null) {
            JLabel lbl = (JLabel)this.getComponent(0);
            lbl.setText("  " + this.host.getName() + "  :");
            boolean do_open = this.host.do_polling && this.host.state != 1;
            ((JMenuItem)this.getComponent(2)).setEnabled(do_open);
            if (this.host.use_events || !AstorUtil.getCtrlBtn()) {
                ((JMenuItem)this.getComponent(3)).setVisible(false);
                ((JMenuItem)this.getComponent(4)).setVisible(false);
            } else {
                ((JMenuItem)this.getComponent(3)).setEnabled(this.host.do_polling);
                ((JMenuItem)this.getComponent(4)).setEnabled(!this.host.do_polling);
            }
            ((JMenuItem)this.getComponent(10)).setVisible(false);
            ((JMenuItem)this.getComponent(11)).setVisible(false);
            ((JMenuItem)this.getComponent(13)).setEnabled(true);
            ((JMenuItem)this.getComponent(14)).setEnabled(false);
            ((JMenuItem)this.getComponent(15)).setEnabled(true);
            ((JMenuItem)this.getComponent(17)).setVisible(false);
            ((JMenuItem)this.getComponent(12)).setEnabled(true);
            boolean can_test = this.host.state == 3 || this.host.state == 2;
            ((JMenuItem)this.getComponent(7)).setEnabled(can_test);
            ((JMenuItem)this.getComponent(8)).setEnabled(can_test);
            ((JMenuItem)this.getComponent(16)).setEnabled(!can_test);
            boolean can_unexport = this.host.state == 0;
            ((JMenuItem)this.getComponent(9)).setVisible(can_unexport);
        } else if (this.collec_name != null) {
            JLabel lbl = (JLabel)this.getComponent(0);
            lbl.setText("  " + this.collec_name + "  :");
            ((JMenuItem)this.getComponent(2)).setEnabled(false);
            ((JMenuItem)this.getComponent(3)).setVisible(AstorUtil.getCtrlBtn());
            ((JMenuItem)this.getComponent(4)).setVisible(AstorUtil.getCtrlBtn());
            ((JMenuItem)this.getComponent(3)).setEnabled(true);
            ((JMenuItem)this.getComponent(4)).setEnabled(true);
            ((JMenuItem)this.getComponent(5)).setVisible(false);
            ((JMenuItem)this.getComponent(6)).setVisible(false);
            ((JMenuItem)this.getComponent(7)).setVisible(false);
            ((JMenuItem)this.getComponent(8)).setVisible(false);
            ((JMenuItem)this.getComponent(12)).setEnabled(false);
            ((JMenuItem)this.getComponent(13)).setEnabled(false);
            ((JMenuItem)this.getComponent(15)).setEnabled(false);
            ((JMenuItem)this.getComponent(14)).setEnabled(this.node_cut != null);
            ((JMenuItem)this.getComponent(16)).setEnabled(false);
            ((JMenuItem)this.getComponent(9)).setVisible(false);
        }
        if (!AstorUtil.osIsUnix()) {
            ((JMenuItem)this.getComponent(5)).setVisible(false);
        }
        this.evt_position = new Point(evt.getX(), evt.getY());
        this.show(this.parent, evt.getX(), evt.getY());
    }

    private void hostActionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals(pMenuLabels[0])) {
            this.parent.displayHostInfo(this.evt_position);
        } else if (cmd.equals(pMenuLabels[7])) {
            this.host.unexportStarter(this.astor);
        } else if (cmd.equals(pMenuLabels[5])) {
            this.host.testStarter(this.astor);
        } else if (cmd.equals(pMenuLabels[6])) {
            this.host.displayLogging(this.astor);
        } else if (cmd.equals(pMenuLabels[4])) {
            this.host.displayInfo(this.parent);
        } else if (cmd.equals(pMenuLabels[3])) {
            new RemoteLoginThread(this.host.getName(), this.parent).start();
        } else if (cmd.equals(pMenuLabels[2])) {
            this.enablePolling(true);
        } else if (cmd.equals(pMenuLabels[1])) {
            this.enablePolling(false);
        } else if (cmd.equals(pMenuLabels[10])) {
            this.astor.addNewHost(this.host);
        } else if (cmd.equals(pMenuLabels[13])) {
            this.astor.editHostProperties(this.host);
        } else if (cmd.equals(pMenuLabels[11])) {
            this.node_cut = (DefaultMutableTreeNode)this.parent.getLastSelectedPathComponent();
        } else if (cmd.equals(pMenuLabels[12])) {
            this.parent.moveNode(this.node_cut);
            this.node_cut = null;
        } else if (cmd.equals(pMenuLabels[14])) {
            this.astor.removeHost(this.host.getName());
        } else if (cmd.equals(pMenuLabels[15])) {
            this.parent.changeNodeName();
        } else if (cmd.equals(pMenuLabels[8])) {
            new ServerCmdThread(this.astor, this.collec_hosts, 0).start();
        } else if (cmd.equals(pMenuLabels[9])) {
            new ServerCmdThread(this.astor, this.collec_hosts, 1).start();
        }
    }

    private void enablePolling(boolean enable) {
        if (this.host != null) {
            this.host.do_polling = enable;
            if (!enable) {
                this.parent.hostDialogs.close(this.host);
            }
        } else {
            for (int i = 0; i < this.collec_hosts.length; ++i) {
                this.collec_hosts[i].do_polling = enable;
                if (enable) continue;
                this.parent.hostDialogs.close(this.collec_hosts[i]);
            }
        }
    }
}

