/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.PutServerInfoDialog;
import admin.astor.ServArchitectureDialog;
import admin.astor.TangoHost;
import app_util.PopupError;
import app_util.PopupHtml;
import app_util.PopupMessage;
import app_util.PopupText;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Random;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jive.DevWizard;
import jive.ExecDev;

public class TangoServer
extends DeviceProxy
implements AstorDefs,
TangoConst {
    private String name;
    private DbServer server = null;
    private String devname;
    private boolean running;
    public DbServInfo info;

    public TangoServer(String name, boolean running) throws DevFailed {
        super("dserver/" + name);
        this.set_transparency_reconnection(true);
        this.name = name;
        this.devname = this.name();
        this.running = running;
    }

    public TangoServer(String name) throws DevFailed {
        super(name);
        this.set_transparency_reconnection(true);
        this.name = name;
        this.devname = this.name();
        this.running = true;
    }

    public int getStartupLevel() throws DevFailed {
        this.updateStartupInfo();
        return this.info.startup_level;
    }

    public DbServInfo getStartupInfo() throws DevFailed {
        this.updateStartupInfo();
        return this.info;
    }

    public void putStartupInfo(DbServInfo si) throws DevFailed {
        if (this.server == null) {
            this.server = new DbServer(this.name);
        }
        this.info = si;
        this.server.put_info(this.info);
    }

    public void updateStartupInfo() throws DevFailed {
        if (this.server == null) {
            this.server = new DbServer(this.name);
        }
        this.info = this.server.get_info();
    }

    public void setRunning(boolean b) {
        this.running = b;
    }

    public boolean isRunning() {
        return this.running;
    }

    public String getName() {
        return this.name;
    }

    public String[] queryClass() throws DevFailed {
        DeviceData argout = this.command_inout("QueryClass");
        return argout.extractStringArray();
    }

    public DbDevImportInfo getImportInfo() throws DevFailed {
        return this.import_device();
    }

    public String[] queryDevice() throws DevFailed {
        DeviceData argout;
        try {
            argout = this.command_inout("QueryDevice");
        }
        catch (DevFailed e) {
            if (!e.errors[0].reason.equals("API_CommandNotFound")) {
                throw e;
            }
            argout = this.command_inout("DevQueryDevice");
        }
        String separator = "::";
        String[] devices = argout.extractStringArray();
        int start = 0;
        for (int i = 0; i < devices.length; ++i) {
            start = devices[i].indexOf(separator);
            if (start <= 0) continue;
            devices[i] = devices[i].substring(start + separator.length());
        }
        return devices;
    }

    public String toString() {
        return this.name;
    }

    public boolean startupLevel(JDialog parent, String hostname, Point p) {
        boolean modif = false;
        try {
            PutServerInfoDialog dialog = new PutServerInfoDialog(parent, true);
            dialog.setLocation(p);
            this.updateStartupInfo();
            if (dialog.showDialog(this.info) == 0) {
                this.info = dialog.getSelection();
                if (this.info != null) {
                    this.info.host = hostname;
                    this.putStartupInfo(this.info);
                } else {
                    if (this.running) {
                        PopupMessage.show((Component)parent, "Stop " + this.name + "  server before !");
                        return modif;
                    }
                    this.putStartupInfo(new DbServInfo(this.name, "", false, 0));
                    if (this.server == null) {
                        this.server = new DbServer(this.name);
                    }
                    String[] devname = this.server.get_device_class_list();
                    for (int i = 0; i < devname.length; i += 2) {
                        ApiUtil.get_db_obj().export_device(new DbDevExportInfo(devname[i], "", "", ""));
                        ApiUtil.get_db_obj().unexport_device(devname[i]);
                    }
                }
                modif = true;
            }
        }
        catch (DevFailed e) {
            e.printStackTrace();
            PopupError.show((Component)parent, e);
        }
        return modif;
    }

    public String chooseDevice(Component parent) throws DevFailed {
        Object[] devices = this.queryDevice();
        String choice = null;
        switch (devices.length) {
            case 0: {
                Except.throw_exception((String)"NO_DEVICE_REGISTRED", (String)"No device registred for this derver", (String)"TangoServer.chooseDevice()");
                break;
            }
            case 1: {
                choice = devices[0];
                break;
            }
            default: {
                choice = (String)JOptionPane.showInputDialog(parent, "Device selection :", "", 1, null, devices, devices[0]);
                if (choice != null) break;
                choice = null;
            }
        }
        return choice;
    }

    public void testDevice(Component parent, Point point) {
        try {
            String choice = this.chooseDevice(parent);
            if (choice == null) {
                return;
            }
            final ExecDev p = new ExecDev();
            if (!p.set_device_name(choice)) {
                JDialog d1 = null;
                if (parent instanceof JFrame) {
                    d1 = new JDialog((Frame)((JFrame)parent), false);
                } else if (parent instanceof JDialog) {
                    d1 = new JDialog((Dialog)((JDialog)parent), false);
                } else {
                    Except.throw_exception((String)"ParentTypeError", (String)"Parent is not a good instance", (String)"TangoServer.testDevice()");
                }
                final JDialog d = d1;
                d.setTitle(choice + " Device Panel");
                d.getContentPane().setLayout(null);
                d.getContentPane().add((Component)p);
                d.addComponentListener(new ComponentListener(){

                    public void componentHidden(ComponentEvent e) {
                    }

                    public void componentMoved(ComponentEvent e) {
                    }

                    public void componentResized(ComponentEvent e) {
                        p.placeComponents(d.getContentPane().getSize());
                    }

                    public void componentShown(ComponentEvent e) {
                        p.placeComponents(d.getContentPane().getSize());
                    }
                });
                Rectangle r = parent.getBounds();
                d.setBounds(r.x + 50, r.y + 50, 500, 650);
                d.setVisible(true);
            }
        }
        catch (DevFailed e) {
            PopupError.show(parent, e);
        }
    }

    public String getServerInfo(Component parent, boolean ds_present) {
        String servinfo = "------------ Server Info ------------\n\n";
        try {
            servinfo = servinfo + this.get_info().toString();
        }
        catch (DevFailed e) {
            PopupError.show(parent, e);
            return "";
        }
        if (ds_present) {
            try {
                String[] devices = this.queryDevice();
                servinfo = servinfo + "\n\n----------- Device(s) Served -----------\n\n";
                for (int i = 0; i < devices.length; ++i) {
                    servinfo = servinfo + devices[i] + "\n";
                }
            }
            catch (DevFailed e) {
                // empty catch block
            }
        }
        return servinfo;
    }

    public void configureWithWizard(JDialog parent) {
        try {
            DevWizard wdlg = new DevWizard((Dialog)parent);
            wdlg.showClassesWizard(this.name);
        }
        catch (NoSuchMethodError e) {
            PopupError.show((Component)parent, "Not supported by Jive before 2.6 revision.");
        }
    }

    public void displatArchitecture(JDialog parent) {
        try {
            ServArchitectureDialog dialog = new ServArchitectureDialog(parent, this);
            AstorUtil.centerDialog((JDialog)dialog, parent);
            dialog.setVisible(true);
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("API_CommandNotFound")) {
                PopupError.show((Component)parent, "Available only for TANGO 5 servers  (Device_3Impl)");
            }
            PopupError.show((Component)parent, e);
        }
    }

    public void displayServerInfo(Component parent) {
        String servinfo = this.getServerInfo(parent, this.running);
        if (servinfo.length() > 0) {
            PopupMessage.show(parent, servinfo);
        }
    }

    public void displayClassInfo(JFrame parent) {
        try {
            FileOutputStream fidout;
            String[] classes = this.server.get_class_list();
            StringBuffer sb = new StringBuffer("<FONT SIZE=+2>Tango Device Server " + this.name + " : </font>\n\n");
            sb.append("<ul>\n");
            for (int i = 0; i < classes.length; ++i) {
                sb.append("<li> <b> Class " + classes[i] + ":</b>\n");
                sb.append("<ul>\n");
                String[] prop = AstorUtil.getServerClassProperties(classes[i]);
                if (prop[2].equals("Doc location unknown....")) {
                    sb.append("Doc location unknown....<Br><Br>\n");
                } else {
                    sb.append("<a href=\"" + prop[2] + "\">\n\t");
                    sb.append(prop[2] + "</a>\n<Br><Br>\n");
                }
                if (prop[0] != null) {
                    sb.append(prop[0] + "<Br>\n");
                }
                if (prop[1] != null) {
                    sb.append(prop[1] + "<Br>\n");
                }
                sb.append("</ul>\n<Br><Br>");
            }
            sb.append("</ul>\n");
            int random_value = new Random().nextInt(30000);
            String filename = new String("/tmp/astor." + random_value);
            try {
                fidout = new FileOutputStream(filename);
            }
            catch (FileNotFoundException e) {
                filename = new String("c:/temp/astor." + random_value);
                fidout = new FileOutputStream(filename);
            }
            fidout.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#FF0000\" ALINK=\"#FF0000\">\n\n<table width=\"100%\" height=\"20%\"><tr>\n<td align=CENTER>\n<FONT COLOR=\"#0000FF\"><FONT SIZE=+4>E</FONT></FONT><FONT SIZE=+1>UROPEAN</FONT>\n<FONT COLOR=\"#0000FF\"><FONT SIZE=+4>S</FONT></FONT><FONT SIZE=+1>YNCHROTRON</FONT>\n<FONT COLOR=\"#0000FF\"><FONT SIZE=+4>R</FONT></FONT><FONT SIZE=+1>ADIATION</FONT>\n<FONT COLOR=\"#0000FF\"><FONT SIZE=+4>F</FONT></FONT><FONT SIZE=+1>ACILITY</FONT>\n</td><td>\n<IMG SRC=\"http://www.esrf.fr/gifs/logo/80.gif\">\n</td></tr></table>\n<P><Br>\n".getBytes());
            fidout.write(sb.toString().getBytes());
            fidout.write("\n</Body>\n</Html>\n".getBytes());
            fidout.close();
            String urlstr = new String("file:" + filename);
            new PopupHtml(parent, true).show(urlstr);
            new File(filename).delete();
        }
        catch (Exception e) {
            PopupError.show((Component)parent, e);
            e.printStackTrace();
        }
    }

    private String indent(String s) {
        String ret = "";
        String tab = "        ";
        int start = 0;
        int end = 0;
        while ((end = s.indexOf("\n", start)) >= 0) {
            if (start > 0) {
                ret = ret + "\n";
            }
            ret = ret + tab + s.substring(start, end);
            start = end + 1;
        }
        if (start > 0) {
            ret = ret + "\n";
        }
        if ((ret = ret + tab + s.substring(start)).endsWith("\n")) {
            ret = ret.substring(0, ret.length() - 2);
        }
        return ret;
    }

    public void checkStates(JDialog parent, Point point) {
        try {
            String servinfo = "";
            String[] _devices = this.queryDevice();
            String[] devices = new String[_devices.length + 1];
            devices[0] = this.devname;
            for (int i = 0; i < _devices.length; ++i) {
                devices[i + 1] = _devices[i];
            }
            DevState[] states = new DevState[devices.length];
            for (int i = 0; i < devices.length; ++i) {
                DeviceProxy d = new DeviceProxy(devices[i]);
                states[i] = d.state();
                servinfo = servinfo + devices[i] + ":    ";
                servinfo = servinfo + ApiUtil.stateName((DevState)states[i]) + "\n";
                if (states[i] != DevState.FAULT && states[i] != DevState.ALARM && states[i] != DevState.UNKNOWN) continue;
                servinfo = servinfo + this.indent(d.status()) + "\n\n";
            }
            int nb_lines = 0;
            for (int i = 0; i < servinfo.length(); ++i) {
                if (servinfo.charAt(i) != '\n') continue;
                ++nb_lines;
            }
            if (nb_lines <= 40) {
                PopupMessage.show((Component)parent, servinfo);
            } else {
                new PopupText(parent, true).show(servinfo);
            }
        }
        catch (DevFailed e) {
            PopupError.show((Component)parent, e);
        }
    }

    void restart(Component parent, TangoHost host) {
        if (JOptionPane.showConfirmDialog(parent, "Are you sure to want to restart " + this.getName(), "Confirm Dialog", 0) == 0) {
            new restartThread(parent, host).start();
        }
    }

    private class restartThread
    extends Thread {
        private TangoHost host;
        private Component parent;

        restartThread(Component parent, TangoHost host) {
            this.host = host;
            this.parent = parent;
        }

        public void run() {
            try {
                long t0;
                this.host.stopServer(TangoServer.this.name);
                long t1 = t0 = System.currentTimeMillis();
                while (TangoServer.this.running && t1 - t0 < 5000L) {
                    this.host.updateData();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    t1 = System.currentTimeMillis();
                }
                if (TangoServer.this.running) {
                    Except.throw_exception((String)"STOP_TIMOUT", (String)("Stopping server " + TangoServer.this.name + " timeout\n" + "may be, it cannot be stopped."), (String)"TangoServer.restartThread.run()");
                }
                this.host.startServer(this.parent, TangoServer.this.name);
            }
            catch (DevFailed e) {
                PopupError.show(this.parent, e);
            }
        }
    }
}

