/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.Monitor;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ServerCmdThread
extends Thread
implements AstorDefs {
    private Component parent;
    private TangoHost[] hosts;
    private int cmd;
    private Monitor monitor;
    private boolean[] levelUsed;
    private short nbStartupLevels;
    private String monitor_title;

    public ServerCmdThread(Component parent, TangoHost[] hosts, int cmd) {
        this.parent = parent;
        this.hosts = hosts;
        this.cmd = cmd;
        this.monitor_title = " on all controlled hosts   ";
        this.nbStartupLevels = AstorUtil.getStarterNbStartupLevels();
        this.levelUsed = new boolean[this.nbStartupLevels];
        for (int i = 0; i < this.nbStartupLevels; ++i) {
            this.levelUsed[i] = true;
        }
    }

    public ServerCmdThread(Component parent, TangoHost host, int cmd, boolean[] levelUsed) {
        this.parent = parent;
        this.hosts = new TangoHost[1];
        this.hosts[0] = host;
        this.cmd = cmd;
        this.levelUsed = levelUsed;
        this.monitor_title = " on " + (Object)((Object)host) + "   ";
        this.nbStartupLevels = AstorUtil.getStarterNbStartupLevels();
    }

    private void updateProgressMonitor(int level, int hostnum, double ratio) {
        String message;
        if (this.monitor == null) {
            message = new String(AstorDefs.cmdStr[this.cmd] + this.monitor_title);
            if (this.parent instanceof JDialog) {
                this.monitor = new Monitor((JDialog)this.parent, message, AstorDefs.cmdStr[this.cmd]);
            } else if (this.parent instanceof JFrame) {
                this.monitor = new Monitor((JFrame)this.parent, message, AstorDefs.cmdStr[this.cmd]);
            }
        }
        message = AstorDefs.cmdStr[this.cmd] + "Servers on " + this.hosts[hostnum].getName() + " for level " + level;
        this.monitor.setProgressValue(ratio, message);
    }

    public void run() {
        AstorUtil.getStarterNbStartupLevels();
        this.updateProgressMonitor(0, 0, 0.05);
        switch (this.cmd) {
            case 0: {
                for (int level = 1; !this.monitor.isCanceled() && level <= this.nbStartupLevels; ++level) {
                    if (!this.levelUsed[level - 1]) continue;
                    int option = JOptionPane.showConfirmDialog(this.parent, new String(AstorDefs.cmdStr[this.cmd] + " for level " + level), "", 1);
                    if (option == 2) {
                        level = this.nbStartupLevels;
                        continue;
                    }
                    boolean do_it = option == 0;
                    this.executeCommand(this.hosts, level, do_it);
                }
                break;
            }
            case 1: {
                for (int level = this.nbStartupLevels; !this.monitor.isCanceled() && level > 0; --level) {
                    if (!this.levelUsed[level - 1]) continue;
                    int option = JOptionPane.showConfirmDialog(this.parent, new String(AstorDefs.cmdStr[this.cmd] + " for level " + level), "", 1);
                    if (option == 2) {
                        level = 0;
                        continue;
                    }
                    boolean do_it = option == 0;
                    this.executeCommand(this.hosts, level, do_it);
                }
                break;
            }
        }
        this.monitor.setProgressValue(100.0);
    }

    private void executeCommand(TangoHost[] hosts, int level, boolean doThisLevel) {
        for (int i = 0; doThisLevel && !this.monitor.isCanceled() && i < hosts.length; ++i) {
            TangoHost host = hosts[i];
            try {
                switch (this.cmd) {
                    case 0: {
                        double ratio = ((double)(level + 1) * (double)hosts.length + (double)i) / (double)(hosts.length * (this.nbStartupLevels + 2));
                        this.updateProgressMonitor(level, i, ratio);
                        host.startServers(level);
                        break;
                    }
                    case 1: {
                        double ratio = ((double)(this.nbStartupLevels - level + 1) * (double)hosts.length + (double)i) / (double)(hosts.length * (this.nbStartupLevels + 2));
                        this.updateProgressMonitor(level, i, ratio);
                        host.stopServers(level);
                        try {
                            ServerCmdThread.sleep(50L);
                            break;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (DevFailed e) {
                // empty catch block
            }
            host.updateData();
        }
    }
}

