/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.MultiLineToolTipUI;

public class ServArchitectureDialog
extends JDialog {
    private JDialog parent;
    private int retVal = 0;
    private String servname;
    private boolean from_appli = true;
    private ServInfoTree tree;
    public static final boolean EXPAND_NOT_FULL = false;
    public static final boolean EXPAND_FULL = true;
    private JLabel titleLabel;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JRadioButton expandBtn;
    private JButton cancelBtn;

    public ServArchitectureDialog(JDialog parent, String servname) throws DevFailed {
        super((Dialog)parent, false);
        this.parent = parent;
        this.servname = servname;
        this.initComponents();
        this.titleLabel.setText(servname + "  Architecture");
        this.tree = new ServInfoTree();
        this.jScrollPane1.setViewportView(this.tree);
        if (parent.getWidth() == 0) {
            this.from_appli = false;
        }
        MultiLineToolTipUI.initialize();
        this.pack();
        this.tree.expandTree(false);
    }

    public ServArchitectureDialog(JDialog parent, DeviceProxy dev) throws DevFailed {
        this(parent, dev.name().substring("dserver/".length()));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.expandBtn = new JRadioButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ServArchitectureDialog.this.closeDialog(evt);
            }
        });
        this.expandBtn.setText("Expand all properties");
        this.expandBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServArchitectureDialog.this.expandBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.expandBtn);
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServArchitectureDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void expandBtnActionPerformed(ActionEvent evt) {
        if (this.expandBtn.getSelectedObjects() != null) {
            this.tree.expandTree(true);
        } else {
            this.tree.expandTree(false);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (!this.from_appli) {
            System.exit(0);
        }
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public static void main(String[] args) {
        String servname = "PowerSupply/pv";
        if (args.length > 0) {
            servname = args[0];
        }
        try {
            new ServArchitectureDialog(new JDialog(), new DeviceProxy("dserver/" + servname)).setVisible(true);
        }
        catch (DevFailed e) {
            PopupError.show((Component)new JDialog(), e);
            System.exit(0);
        }
    }

    class TgClass {
        String name;
        String desc;

        public TgClass(String name) {
            this.name = name;
            this.desc = "No Description Found in Database";
            try {
                DbDatum data = new DbClass(name).get_property("Description");
                if (!data.is_empty()) {
                    String[] array = data.extractStringArray();
                    this.desc = "";
                    for (int i = 0; i < array.length; ++i) {
                        this.desc = this.desc + array[i] + "\n";
                    }
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }

        public String toString() {
            return "Class: " + this.name;
        }
    }

    class TgProperty {
        String objname;
        String src;
        String name;
        String desc;
        String value;

        public TgProperty(String objname, String src, String name, String desc, String value) {
            int idx;
            this.objname = objname;
            this.src = src;
            this.name = name;
            this.desc = desc;
            this.value = "";
            while ((idx = value.indexOf(10)) >= 0) {
                value = value.substring(0, idx) + ", " + value.substring(idx + 1);
            }
            this.value = value;
        }

        public String toString() {
            return this.name;
        }
    }

    class TgServer {
        String name;
        String desc;

        public TgServer(String name) {
            this.name = name;
            this.desc = "";
            try {
                String admin = "dserver/" + name;
                IORdump id = new IORdump(admin);
                DeviceInfo info = new DbDevice(admin).get_info();
                this.desc = id.toString() + "\nsince " + info.last_exported;
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }

        public String toString() {
            return this.name;
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon root_icon = new ImageIcon(this.getClass().getResource("/admin/img/network5.gif"));
        private ImageIcon class_icon = new ImageIcon(this.getClass().getResource("/admin/img/class.gif"));
        private ImageIcon dev_icon = new ImageIcon(this.getClass().getResource("/admin/img/device.gif"));
        private ImageIcon prop_icon = new ImageIcon(this.getClass().getResource("/admin/img/attleaf.gif"));
        private ImageIcon leaf_icon = new ImageIcon(this.getClass().getResource("/admin/img/uleaf.gif"));
        private Font[] fonts = new Font[4];
        private final int TITLE = 0;
        private final int CLASS_DEV = 1;
        private final int PROP_NAME = 2;
        private final int PROP_DESC = 3;
        public final String img_path = "/admin/img/";

        public TangoRenderer() {
            this.fonts[0] = new Font("helvetica", 1, 18);
            this.fonts[1] = new Font("helvetica", 1, 16);
            this.fonts[2] = new Font("helvetica", 1, 14);
            this.fonts[3] = new Font("helvetica", 0, 12);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            String tip = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            Object user_obj = node.getUserObject();
            if (row == 0) {
                this.setIcon(this.root_icon);
                this.setFont(this.fonts[0]);
                tip = ((TgServer)user_obj).desc;
            } else if (user_obj instanceof TgClass) {
                this.setIcon(this.class_icon);
                this.setFont(this.fonts[1]);
                tip = ((TgClass)user_obj).desc;
            } else if (user_obj instanceof TgProperty) {
                this.setIcon(this.prop_icon);
                this.setFont(this.fonts[2]);
                tip = ((TgProperty)user_obj).desc;
            } else if (user_obj instanceof String) {
                String str = user_obj.toString();
                if (str.startsWith("Device:")) {
                    this.setIcon(this.dev_icon);
                    this.setFont(this.fonts[1]);
                } else {
                    this.setIcon(this.leaf_icon);
                    this.setFont(this.fonts[3]);
                }
            }
            this.setToolTipText(tip);
            return this;
        }
    }

    class ServInfoTree
    extends JTree {
        private DeviceProxy dev = null;
        private String[] devlist = null;
        private DefaultTreeModel treeModel;
        private DefaultMutableTreeNode root;

        public ServInfoTree() throws DevFailed {
            this.initComponent();
        }

        public ServInfoTree(DeviceProxy dev) throws DevFailed {
            this.dev = dev;
            this.initComponent();
        }

        void expandTree(boolean expand) {
            this.expandTree(this.root, expand);
        }

        private void expandTree(DefaultMutableTreeNode node, boolean expand) {
            int nb = node.getChildCount();
            for (int i = 0; i < nb; ++i) {
                TreePath path;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                Object obj = child.getUserObject();
                if (expand || !(obj instanceof TgProperty)) {
                    path = new TreePath(child.getPath());
                    this.expandPath(path);
                    this.expandTree(child, expand);
                }
                if (expand || !(obj instanceof TgProperty)) continue;
                path = new TreePath(child.getPath());
                this.collapsePath(path);
            }
        }

        private void initComponent() throws DevFailed {
            this.root = new DefaultMutableTreeNode(new TgServer(ServArchitectureDialog.this.servname));
            this.createNodes(this.root);
            this.getSelectionModel().setSelectionMode(1);
            this.treeModel = new DefaultTreeModel(this.root);
            this.setModel(this.treeModel);
            ToolTipManager.sharedInstance().registerComponent(this);
            this.setCellRenderer(new TangoRenderer());
        }

        private void createNodes(DefaultMutableTreeNode root) throws DevFailed {
            if (this.dev == null) {
                this.dev = new DeviceProxy("dserver/" + ServArchitectureDialog.this.servname);
            }
            String[] classnames = this.getClasses();
            DefaultMutableTreeNode[] classnodes = new DefaultMutableTreeNode[classnames.length];
            for (int c = 0; c < classnames.length; ++c) {
                TgClass _class = new TgClass(classnames[c]);
                classnodes[c] = new DefaultMutableTreeNode(_class);
                root.add(classnodes[c]);
                TgProperty[] cl_prop = this.getProperties(classnames[c], "Class");
                for (int p = 0; p < cl_prop.length; ++p) {
                    cl_prop[p] = this.checkDbProperty(cl_prop[p]);
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(cl_prop[p]);
                    classnodes[c].add(node);
                    node.add(new DefaultMutableTreeNode(cl_prop[p].value));
                }
                String[] devnames = this.getDevices(classnames[c]);
                DefaultMutableTreeNode[] devnodes = new DefaultMutableTreeNode[devnames.length];
                TgProperty[] dev_prop = this.getProperties(classnames[c], "Dev");
                for (int d = 0; d < devnames.length; ++d) {
                    devnodes[d] = new DefaultMutableTreeNode("Device: " + devnames[d]);
                    classnodes[c].add(devnodes[d]);
                    for (int p = 0; p < dev_prop.length; ++p) {
                        dev_prop[p] = this.checkDbProperty(dev_prop[p]);
                        DefaultMutableTreeNode node = new DefaultMutableTreeNode(dev_prop[p]);
                        devnodes[d].add(node);
                        node.add(new DefaultMutableTreeNode(dev_prop[p].value));
                    }
                }
            }
        }

        private TgProperty checkDbProperty(TgProperty prop) {
            try {
                DbDatum data = prop.src.equals("Dev") ? new DeviceProxy(prop.objname).get_property(prop.name) : new DbClass(prop.objname).get_property(prop.name);
                if (!data.is_empty()) {
                    String[] tmp = data.extractStringArray();
                    prop.value = "";
                    for (int i = 0; i < tmp.length; ++i) {
                        prop.value = prop.value + tmp[i];
                        if (i >= tmp.length - 1) continue;
                        prop.value = prop.value + ", ";
                    }
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            return prop;
        }

        private String[] getDevices(String classname) throws DevFailed {
            if (this.devlist == null) {
                DeviceData argout = this.dev.command_inout("QueryDevice");
                this.devlist = argout.extractStringArray();
            }
            Vector<String> v = new Vector<String>();
            String str = classname + "::";
            for (int i = 0; i < this.devlist.length; ++i) {
                if (!this.devlist[i].startsWith(str)) continue;
                v.add(this.devlist[i].substring(str.length()));
            }
            String[] devnames = new String[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                devnames[i] = (String)v.elementAt(i);
            }
            return devnames;
        }

        private String[] getClasses() throws DevFailed {
            DeviceData argout = this.dev.command_inout("QueryClass");
            return argout.extractStringArray();
        }

        private TgProperty[] getProperties(String classname, String source) throws DevFailed {
            DeviceData argin = new DeviceData();
            argin.insert(classname);
            String cmd = "QueryWizard" + source + "Property";
            DeviceData argout = this.dev.command_inout(cmd, argin);
            String[] str = argout.extractStringArray();
            TgProperty[] prop = new TgProperty[str.length / 3];
            int n = 0;
            for (int i = 0; i < str.length; i += 3) {
                prop[n] = new TgProperty(classname, source, str[i], str[i + 1], str[i + 2]);
                ++n;
            }
            return prop;
        }
    }
}

