/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.PropListDialog;
import admin.astor.TangoHost;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class NewStarterDialog
extends JDialog
implements AstorDefs {
    private JFrame parent;
    private TangoHost[] hosts;
    private TangoHost h;
    private String[] collec;
    private int retVal = 2;
    private boolean creating;
    private JPanel jPanel1;
    private JButton createBtn;
    private JLabel jLabel1;
    private JButton cancelBtn;
    private JPanel jPanel3;
    private JLabel jLabel3;
    private JPanel jPanel4;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTextField hostText;
    private JLabel jLabel2;
    private JTextField familyText;
    private JButton pathBtn;
    private JButton familyBtn;
    private JScrollPane jScrollPane1;
    private JTextArea pathText;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JTextField usageText;
    private JRadioButton useEventsBtn;

    private boolean getUseEvents() {
        boolean ue = false;
        try {
            DbDatum data = this.h.get_property("UseEvents");
            if (!data.is_empty()) {
                ue = data.extractBoolean();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ue;
    }

    public NewStarterDialog(JFrame parent, TangoHost h, String[] collec, TangoHost[] hosts, boolean creating) {
        super((Frame)parent, true);
        this.parent = parent;
        this.hosts = hosts;
        this.creating = creating;
        this.collec = new String[collec.length - 1];
        for (int i = 1; i < collec.length; ++i) {
            this.collec[i - 1] = collec[i];
        }
        this.initComponents();
        this.h = h;
        if (h != null) {
            String hostname = h.getName();
            String[] ds_path = h.getPath();
            for (int i = 0; i < ds_path.length; ++i) {
                this.pathText.append(ds_path[i] + "\n");
            }
            this.usageText.setText(h.usage);
            this.familyText.setText(h.getFamily());
            this.hostText.setText(hostname);
            this.useEventsBtn.setSelected(this.getUseEvents());
            if (creating) {
                this.familyText.setText(h.getFamily());
                this.hostText.setText(hostname);
                this.hostText.select(0, hostname.length());
            } else {
                this.jLabel3.setText("Change property for " + hostname + " starter in database");
                this.jLabel2.setText("  ");
                this.hostText.setVisible(false);
                this.jLabel4.setVisible(false);
                this.familyText.setVisible(false);
                this.familyBtn.setVisible(false);
                this.createBtn.setText("Apply");
            }
        }
        this.pack();
        AstorUtil.centerDialog((JDialog)this, parent);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.createBtn = new JButton();
        this.jLabel1 = new JLabel();
        this.cancelBtn = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.hostText = new JTextField();
        this.jLabel2 = new JLabel();
        this.familyText = new JTextField();
        this.pathBtn = new JButton();
        this.familyBtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.pathText = new JTextArea();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.usageText = new JTextField();
        this.useEventsBtn = new JRadioButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NewStarterDialog.this.closeDialog(evt);
            }
        });
        this.createBtn.setText("Create");
        this.createBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewStarterDialog.this.createBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.createBtn);
        this.jLabel1.setText("          ");
        this.jPanel1.add(this.jLabel1);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewStarterDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jLabel3.setFont(new Font("Dialog", 1, 14));
        this.jLabel3.setText("Create a Starter in Database For a New Host");
        this.jPanel3.add(this.jLabel3);
        this.getContentPane().add((Component)this.jPanel3, "North");
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel4.setText("Host name :");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 17;
        this.jPanel4.add((Component)this.jLabel4, gridBagConstraints1);
        this.jLabel5.setText("Device Servers PATH :");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.anchor = 17;
        this.jPanel4.add((Component)this.jLabel5, gridBagConstraints1);
        this.hostText.setColumns(20);
        this.hostText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewStarterDialog.this.hostTextActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        this.jPanel4.add((Component)this.hostText, gridBagConstraints1);
        this.jLabel2.setText("Host Family:");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.anchor = 17;
        this.jPanel4.add((Component)this.jLabel2, gridBagConstraints1);
        this.familyText.setColumns(20);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = 2;
        this.jPanel4.add((Component)this.familyText, gridBagConstraints1);
        this.pathBtn.setText("...");
        this.pathBtn.setMargin(new Insets(2, 5, 2, 5));
        this.pathBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewStarterDialog.this.pathBtnActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 6;
        this.jPanel4.add((Component)this.pathBtn, gridBagConstraints1);
        this.familyBtn.setText("...");
        this.familyBtn.setMargin(new Insets(2, 5, 2, 5));
        this.familyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewStarterDialog.this.familyBtnActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 3;
        this.jPanel4.add((Component)this.familyBtn, gridBagConstraints1);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 180));
        this.jScrollPane1.setViewportView(this.pathText);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 7;
        gridBagConstraints1.gridwidth = 4;
        gridBagConstraints1.fill = 2;
        this.jPanel4.add((Component)this.jScrollPane1, gridBagConstraints1);
        this.jLabel6.setText("   ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 5;
        this.jPanel4.add((Component)this.jLabel6, gridBagConstraints1);
        this.jLabel7.setText("   ");
        this.jLabel7.setPreferredSize(new Dimension(220, 15));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 6;
        this.jPanel4.add((Component)this.jLabel7, gridBagConstraints1);
        this.jLabel8.setText("Host Usage:");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.anchor = 17;
        this.jPanel4.add((Component)this.jLabel8, gridBagConstraints1);
        this.usageText.setColumns(20);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 2;
        this.jPanel4.add((Component)this.usageText, gridBagConstraints1);
        this.useEventsBtn.setText("Use Events");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 17;
        this.jPanel4.add((Component)this.useEventsBtn, gridBagConstraints1);
        this.getContentPane().add((Component)this.jPanel4, "Center");
        this.pack();
    }

    private void hostTextActionPerformed(ActionEvent evt) {
    }

    private void familyBtnActionPerformed(ActionEvent evt) {
        PropListDialog list = new PropListDialog(this.parent, this.collec);
        list.showDialog();
        String family = list.getSelectedItem();
        if (family != null) {
            this.familyText.setText(family);
        }
    }

    private void pathBtnActionPerformed(ActionEvent evt) {
        new PropListDialog(this.parent, this.pathText, this.hosts).showDialog();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void createBtnActionPerformed(ActionEvent evt) {
        String hostname = this.hostText.getText();
        String usage = this.usageText.getText();
        String family = this.familyText.getText();
        String str_ds_path = this.pathText.getText().trim();
        if (hostname.length() == 0 || str_ds_path.length() == 0) {
            JOptionPane.showMessageDialog(this.parent, "Fill the fields before creation !", "Warning", 2);
            return;
        }
        try {
            String message;
            String classname = "Starter";
            String servname = classname + "/" + hostname;
            String devname = "tango/admin/" + hostname;
            String admindev = "dserver/" + classname + "/" + hostname;
            if (this.creating) {
                System.out.println("Create server");
                DbDevInfo[] devinfo = new DbDevInfo[]{new DbDevInfo(admindev, classname, servname), new DbDevInfo(devname, classname, servname)};
                Database db = ApiUtil.get_db_obj((String)AstorUtil.getTangoHost());
                db.add_device(devname, classname, servname);
            } else {
                System.out.println("Update properties");
            }
            str_ds_path = NewStarterDialog.manageBackSlash(str_ds_path);
            String[] ds_path = AstorUtil.string2StringArray(str_ds_path);
            DeviceProxy dev = new DeviceProxy(devname);
            dev.put_property(new DbDatum("StartDsPath", ds_path));
            if (usage.length() > 0) {
                dev.put_property(new DbDatum("HostUsage", usage));
            }
            if (this.h != null && !this.creating && !usage.equals(this.h.usage)) {
                this.h.usage = usage;
                Astor astor = (Astor)this.parent;
                astor.tree.changeHostNode(this.h);
            }
            if (family.length() > 0 && this.creating) {
                dev.put_property(new DbDatum("HostCollection", family));
            }
            String[] valStr = new String[]{"WARNING", "file::/tmp/ds.log/starter_" + hostname + ".log", new Integer(500).toString()};
            DbDatum[] datum = new DbDatum[AstorDefs.logging_properties.length];
            for (int i = 0; i < AstorDefs.logging_properties.length; ++i) {
                datum[i] = new DbDatum(AstorDefs.logging_properties[i], valStr[i]);
            }
            dev.put_property(datum);
            this.manageUseEvents(dev);
            if (this.creating) {
                message = "A Starter server has been created in TANGO database.\n\nYou can now start it on " + hostname + " machine.";
            } else {
                message = "The property has been modified in database";
                try {
                    dev.command_inout("Init");
                    message = message + "\nand the device has been re-initialized.";
                }
                catch (DevFailed e) {
                    // empty catch block
                }
            }
            JOptionPane.showMessageDialog(this.parent, message, "Command Done", 1);
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.parent, e);
            return;
        }
        this.retVal = 0;
        this.doClose();
    }

    private void manageUseEvents(DeviceProxy dev) throws DevFailed {
        if (this.useEventsBtn.getSelectedObjects() != null) {
            DbDatum data = new DbDatum("UseEvents", 1);
            dev.put_property(data);
            DbAttribute att = new DbAttribute("HostState");
            att.add("abs_change", 1);
            dev.put_attribute_property(att);
        } else {
            DbDatum data = new DbDatum("UseEvents", 0);
            dev.put_property(data);
        }
    }

    static String manageBackSlash(String str) {
        String ret = "";
        int idx = 0;
        while ((idx = str.indexOf("\\", idx)) >= 0) {
            ret = ret + str.substring(0, ++idx);
            ret = ret + "\\";
            str = str.substring(idx);
            idx = 0;
        }
        ret = ret + str;
        return ret;
    }

    int getValue() {
        return this.retVal;
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

