/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoDs.Except;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class AstorUtil
implements AstorDefs {
    private static DbClass _class = null;
    private static AstorUtil instance = null;
    private static short readInfoPeriod = (short)5;
    private static short nbStartupLevels = (short)5;
    private static String rloginCmd = null;
    private static String rloginUser = null;
    private static String[] tools = null;
    private static String serverHelpURL = "http://www.esrf.fr/computing/cs/tango/";
    private static String appliHelpURL = "http://www.esrf.fr/computing/cs/tango/";
    private static boolean res_read = false;
    private static boolean debug = false;
    private static boolean no_ctrl_btn = false;
    MyCompare compare = new MyCompare();
    private static boolean _osIsUnix = true;
    private static boolean _osIsUnixTested = false;

    private AstorUtil() {
    }

    public static AstorUtil getInstance() {
        if (instance == null) {
            instance = new AstorUtil();
        }
        return instance;
    }

    static boolean getCtrlBtn() {
        if (!no_ctrl_btn) {
            AstorUtil.readAstorRes();
        }
        return !no_ctrl_btn;
    }

    static boolean getDebug() {
        if (!res_read) {
            AstorUtil.readAstorRes();
        }
        return debug;
    }

    public static String getRloginCmd() {
        AstorUtil.readAstorRes();
        return rloginCmd;
    }

    public static String getRloginUser() {
        AstorUtil.readAstorRes();
        return rloginUser;
    }

    public static String[] getTools() {
        if (!res_read) {
            AstorUtil.readAstorRes();
        }
        return tools;
    }

    static void readAstorRes() {
        Object argout = null;
        try {
            Database dbase = ApiUtil.get_db_obj();
            String[] propnames = new String[]{"Debug", "RloginCmd", "RloginUser", "Tools", "NoCtrlButton"};
            DbDatum[] datum = dbase.get_property("Astor", propnames);
            int i = -1;
            if (!datum[++i].is_empty()) {
                debug = datum[i].extractBoolean();
            }
            if (!datum[++i].is_empty()) {
                rloginCmd = datum[i].extractString();
            }
            if (!datum[++i].is_empty()) {
                rloginUser = datum[i].extractString();
            }
            if (!datum[++i].is_empty()) {
                tools = datum[i].extractStringArray();
            }
            if (!datum[++i].is_empty()) {
                no_ctrl_btn = datum[i].extractBoolean();
            }
            res_read = true;
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    String[] getCollectionList(TangoHost[] hosts) {
        boolean null_exists = false;
        Vector<String> vect = new Vector<String>();
        for (int i = 0; i < hosts.length; ++i) {
            boolean found = false;
            for (int j = 0; j < vect.size() && !found; ++j) {
                if (hosts[i].collection == null) {
                    null_exists = true;
                    continue;
                }
                found = hosts[i].collection.equals((String)vect.elementAt(j));
            }
            if (found || hosts[i].collection == null) continue;
            vect.add(hosts[i].collection);
        }
        if (null_exists) {
            vect.add("Miscellaneous");
        }
        Collections.sort(vect, this.compare);
        vect.add(0, "Tango Database");
        String[] list = new String[vect.size()];
        for (int i = 0; i < vect.size(); ++i) {
            list[i] = (String)vect.elementAt(i);
        }
        return list;
    }

    public TangoHost[] getTangoHostList() throws DevFailed {
        String[] hostnames = this.getHostControlledList();
        TangoHost[] hosts = new TangoHost[hostnames.length];
        int i = 0;
        int j = 0;
        while (i < hostnames.length) {
            hosts[j] = new TangoHost(hostnames[i]);
            ++i;
            ++j;
        }
        return hosts;
    }

    private String[] getHostControlledList() throws DevFailed {
        Database dbase = ApiUtil.get_db_obj();
        String[] devices = dbase.get_device_member("tango/admin/*");
        return devices;
    }

    public static String getTangoHost() {
        return System.getProperty("TANGO_HOST");
    }

    public static void setTangoHost(String tango_host) {
        Properties props = System.getProperties();
        props.put("TANGO_HOST", tango_host);
        System.setProperties(props);
        _class = null;
    }

    public static String getTangoPort() throws DevFailed {
        int i;
        String strport = System.getProperty("TANGO_HOST");
        if (strport == null) {
            Except.throw_exception((String)"TANGO_HOST_NOT_DEFINED", (String)"TANGO_HOST Not Defined !", (String)"AstorUtil.getTangoPort()");
        }
        if ((i = strport.indexOf(":")) < 0) {
            Except.throw_exception((String)"TANGO_HOST_NOT_DEFINED", (String)"TANGO_HOST Incorect Definition !", (String)"AstorUtil.getTangoPort()");
        }
        return strport.substring(i + 1);
    }

    public static short getStarterReadPeriod() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return readInfoPeriod;
    }

    public static short getStarterNbStartupLevels() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return nbStartupLevels;
    }

    public static String getStarterHelpURL() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return serverHelpURL;
    }

    public static String getAppliHelpURL() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return appliHelpURL;
    }

    private static void getStarterClassProperties() {
        try {
            _class = new DbClass("Starter");
            String[] propnames = new String[]{"NbStartupLevels", "ReadInfoDbPeriod", "doc_url", "appli_doc_url"};
            DbDatum[] properties = _class.get_property(propnames);
            if (!properties[0].is_empty()) {
                nbStartupLevels = properties[0].extractShort();
            }
            if (!properties[1].is_empty()) {
                readInfoPeriod = properties[1].extractShort();
            }
            readInfoPeriod = (short)(readInfoPeriod * 1000);
            if (!properties[2].is_empty()) {
                serverHelpURL = properties[2].extractString();
            }
            if (!properties[3].is_empty()) {
                appliHelpURL = properties[3].extractString();
            }
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
        if (AstorUtil.getDebug()) {
            System.out.println("NbStartupLevels:  " + nbStartupLevels);
            System.out.println("ReadInfoDbPeriod: " + readInfoPeriod);
            System.out.println("server doc_url:   " + serverHelpURL);
            System.out.println("appli_doc_url:    " + appliHelpURL);
        }
    }

    static String[] getServerClassProperties(String classname) {
        String[] result = new String[3];
        try {
            DbClass dbclass = new DbClass(classname);
            String[] propnames = new String[]{"ProjectTitle", "Description", "doc_url"};
            DbDatum[] prop = dbclass.get_property(propnames);
            if (!prop[0].is_empty()) {
                result[0] = prop[0].extractString();
            }
            if (!prop[1].is_empty()) {
                String[] desc = prop[1].extractStringArray();
                result[1] = "";
                for (int i = 0; i < desc.length; ++i) {
                    result[1] = result[1] + desc[i];
                    if (i >= desc.length - 1) continue;
                    result[1] = result[1] + "\n";
                }
            }
            result[2] = prop[2].is_empty() ? "Doc location unknown...." : prop[2].extractString();
        }
        catch (DevFailed e) {
            result[2] = null;
            result[1] = null;
            result[0] = null;
        }
        return result;
    }

    public static void centerDialog(JDialog dialog, JFrame parent) {
        Point p = parent.getLocationOnScreen();
        p.x += (parent.getWidth() - dialog.getWidth()) / 2;
        p.y += (parent.getHeight() - dialog.getHeight()) / 2;
        dialog.setLocation(p);
    }

    public static void centerDialog(JDialog dialog, JDialog parent) {
        Point p = parent.getLocationOnScreen();
        p.x += (parent.getWidth() - dialog.getWidth()) / 2;
        p.y += (parent.getHeight() - dialog.getHeight()) / 2;
        dialog.setLocation(p);
    }

    public static void rightShiftDialog(JDialog dialog, JFrame parent) {
        Point p = parent.getLocationOnScreen();
        p.x += parent.getWidth();
        p.y += (parent.getHeight() - dialog.getHeight()) / 2;
        dialog.setLocation(p);
    }

    static String[] string2StringArray(String str) {
        int idx = 0;
        Vector<String> v = new Vector<String>();
        while ((idx = str.indexOf("\n")) > 0) {
            v.add(str.substring(0, idx));
            str = str.substring(idx + 1);
            idx = 0;
        }
        v.add(str);
        String[] result = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            result[i] = (String)v.elementAt(i);
        }
        return result;
    }

    public static String executeShellCmd(String cmd) throws Exception {
        String str;
        Process proc = Runtime.getRuntime().exec(cmd);
        InputStream istr = proc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(istr));
        StringBuffer sb = new StringBuffer("");
        while ((str = br.readLine()) != null) {
            sb.append(str + "\n");
        }
        proc.waitFor();
        int retVal = proc.exitValue();
        if (retVal != 0) {
            InputStream errstr = proc.getErrorStream();
            br = new BufferedReader(new InputStreamReader(errstr));
            while ((str = br.readLine()) != null) {
                System.out.println(str);
                sb.append(str + "\n");
            }
            Except.throw_exception((String)"SHELL_CMD_FAILED", (String)("the shell command\n" + cmd + "\nreturns : " + retVal + " !\n\n" + sb.toString()), (String)"AstorUtil.executeShellCmd()");
        }
        return sb.toString();
    }

    public static boolean osIsUnix() {
        if (!_osIsUnixTested) {
            try {
                String os = System.getProperty("os.name");
                _osIsUnix = !os.toLowerCase().startsWith("windows");
            }
            catch (Exception e) {
                _osIsUnix = false;
            }
        }
        return _osIsUnix;
    }

    public void sort(Vector[] array) {
        for (int i = 0; i < array.length; ++i) {
            Collections.sort(array[i], this.compare);
        }
    }

    public void sort(Vector v) {
        Collections.sort(v, this.compare);
    }

    class MyCompare
    implements Comparator {
        MyCompare() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1.toString().toLowerCase();
            String s2 = o2.toString().toLowerCase();
            return s1.compareTo(s2);
        }
    }
}

