/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorCmdLine;
import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.AstorUtil;
import admin.astor.CtrlServersDialog;
import admin.astor.DeviceTreeDialog;
import admin.astor.NewStarterDialog;
import admin.astor.OneTool;
import admin.astor.ServerCmdThread;
import admin.astor.TangoHost;
import app_util.PopupError;
import app_util.PopupHtml;
import app_util.PopupMessage;
import app_util.PopupText;
import app_util.TangoWindow;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.TangORBversion;
import fr.esrf.TangoDs.Except;
import fr.esrf.logviewer.Main;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;

public class Astor
extends JFrame
implements AstorDefs {
    private static String revNumber = "Revision 4.0.3  -  Mon Oct 03 12:28:22 CEST 2005";
    public AstorTree tree = null;
    private boolean expanded = false;
    private JScrollPane scrowllPane;
    static CtrlServersDialog ctrl_serv_d = null;
    static boolean displayed = false;
    private Vector app_tools;
    private Main logviewer = null;
    private JMenuBar jMenuBar1;
    private JMenu fileMenu;
    private JMenuItem exitBtn;
    private JMenu viewMenu;
    private JMenuItem refreshBtn;
    private JMenuItem changeTgHostBtn;
    private JMenuItem expandBtn;
    private JMenu cmdMenu;
    private JMenuItem startServersBtn;
    private JMenuItem stopServersBtn;
    private JMenuItem newHostBtn;
    private JMenuItem newBranchBtn;
    private JMenu toolsMenu;
    private JMenuItem serversItem;
    private JMenuItem findByDeviceBtn;
    private JMenuItem jiveMenuItem;
    private JMenuItem logviewerMenuItem;
    private JMenu helpMenu;
    private JMenuItem principleBtn;
    private JMenuItem helpAppliBtn;
    private JMenuItem helpStarterBtn;
    private JMenuItem stateIconsBtn;
    private JMenuItem tangorbBtn;
    private JMenuItem starterEventsItem;
    private JMenuItem aboutBtn;
    private JPanel jPanel1;
    private JLabel jLabel1;
    private JToggleButton allHostsControledBtn;
    private JToggleButton stopHostsControledBtn;

    public Astor() {
        this.initComponents();
        this.customizeMenu();
        this.setTitle("TANGO Manager - " + revNumber);
        this.buildTree();
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/app_util/img/tango_icon.jpg"));
        this.setIconImage(icon.getImage());
        this.changeTgHostBtn.setVisible(false);
        this.jPanel1.setVisible(AstorUtil.getCtrlBtn());
        this.centerWindow();
    }

    public void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrsize = toolkit.getScreenSize();
        Dimension appsize = this.getSize();
        Point p = new Point();
        p.x = (scrsize.width - appsize.width) / 2;
        p.y = (scrsize.height - appsize.height) / 2;
        this.setLocation(p);
    }

    private void buildTree() {
        try {
            if (this.tree != null) {
                this.tree.stopThreads();
                this.scrowllPane.remove(this.tree);
                this.remove(this.scrowllPane);
            }
            this.tree = new AstorTree(this, true);
            this.scrowllPane = new JScrollPane();
            this.scrowllPane.setPreferredSize(new Dimension(340, 600));
            this.scrowllPane.setViewportView(this.tree);
            this.getContentPane().add((Component)this.scrowllPane, "Center");
        }
        catch (DevFailed e) {
            PopupError.show((Component)this, e);
        }
        this.expanded = false;
        this.pack();
    }

    private void customizeMenu() {
        this.fileMenu.setMnemonic('F');
        this.exitBtn.setMnemonic('E');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.viewMenu.setMnemonic('V');
        this.newBranchBtn.setMnemonic('N');
        this.newBranchBtn.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.refreshBtn.setMnemonic('U');
        this.refreshBtn.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.changeTgHostBtn.setMnemonic('T');
        this.changeTgHostBtn.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.expandBtn.setMnemonic('E');
        this.expandBtn.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.toolsMenu.setMnemonic('T');
        this.findByDeviceBtn.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.jiveMenuItem.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.logviewerMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.cmdMenu.setMnemonic('C');
        this.newHostBtn.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.serversItem.setVisible(false);
        this.serversItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.app_tools = new Vector();
        String[] str_tools = AstorUtil.getTools();
        if (str_tools != null) {
            for (int i = 0; i < str_tools.length; i += 2) {
                OneTool t = new OneTool(str_tools[i], str_tools[i + 1]);
                this.app_tools.add(t);
                JMenuItem mi = new JMenuItem();
                mi.setText(t.name);
                mi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        Astor.this.toolsItemActionPerformed(evt);
                    }
                });
                this.toolsMenu.add(mi);
            }
        }
    }

    private void initComponents() {
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitBtn = new JMenuItem();
        this.viewMenu = new JMenu();
        this.refreshBtn = new JMenuItem();
        this.changeTgHostBtn = new JMenuItem();
        this.expandBtn = new JMenuItem();
        this.cmdMenu = new JMenu();
        this.startServersBtn = new JMenuItem();
        this.stopServersBtn = new JMenuItem();
        this.newHostBtn = new JMenuItem();
        this.newBranchBtn = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.serversItem = new JMenuItem();
        this.findByDeviceBtn = new JMenuItem();
        this.jiveMenuItem = new JMenuItem();
        this.logviewerMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.principleBtn = new JMenuItem();
        this.helpAppliBtn = new JMenuItem();
        this.helpStarterBtn = new JMenuItem();
        this.stateIconsBtn = new JMenuItem();
        this.tangorbBtn = new JMenuItem();
        this.starterEventsItem = new JMenuItem();
        this.aboutBtn = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.allHostsControledBtn = new JToggleButton();
        this.stopHostsControledBtn = new JToggleButton();
        this.fileMenu.setText("File");
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.exitBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitBtn);
        this.jMenuBar1.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.refreshBtn.setText("Update Tree from database");
        this.refreshBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.refreshBtnActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.refreshBtn);
        this.changeTgHostBtn.setText("Change Tango Host");
        this.changeTgHostBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.changeTgHostBtnActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.changeTgHostBtn);
        this.expandBtn.setText("Expand Tree");
        this.expandBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.expandBtnActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.expandBtn);
        this.jMenuBar1.add(this.viewMenu);
        this.cmdMenu.setText("Command");
        this.startServersBtn.setText("Start All Controlled Servers");
        this.startServersBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.startServersBtnActionPerformed(evt);
            }
        });
        this.cmdMenu.add(this.startServersBtn);
        this.stopServersBtn.setText("Stop All Controlled Servers");
        this.stopServersBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.stopServersBtnActionPerformed(evt);
            }
        });
        this.cmdMenu.add(this.stopServersBtn);
        this.newHostBtn.setText("Add a New Host");
        this.newHostBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.newHostBtnActionPerformed(evt);
            }
        });
        this.cmdMenu.add(this.newHostBtn);
        this.newBranchBtn.setText("Add a New Branch");
        this.newBranchBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.newBranchBtnActionPerformed(evt);
            }
        });
        this.cmdMenu.add(this.newBranchBtn);
        this.jMenuBar1.add(this.cmdMenu);
        this.toolsMenu.setText("Tools");
        this.serversItem.setText("Controlled Servers");
        this.serversItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.serversItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.serversItem);
        this.findByDeviceBtn.setText("Find by Device");
        this.findByDeviceBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.findByDeviceBtnActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.findByDeviceBtn);
        this.jiveMenuItem.setText("Jive");
        this.jiveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.jiveMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.jiveMenuItem);
        this.logviewerMenuItem.setText("LogViewer");
        this.logviewerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.logviewerMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.logviewerMenuItem);
        this.jMenuBar1.add(this.toolsMenu);
        this.helpMenu.setText("Help");
        this.principleBtn.setText("Principle");
        this.principleBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.principleBtn);
        this.helpAppliBtn.setText("Application");
        this.helpAppliBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpAppliBtn);
        this.helpStarterBtn.setText("Starter Server");
        this.helpStarterBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpStarterBtn);
        this.stateIconsBtn.setText("State Icons");
        this.stateIconsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.stateIconsBtn);
        this.tangorbBtn.setText("TangORB revision");
        this.tangorbBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.tangorbBtn);
        this.starterEventsItem.setText("Hosts Controlled on Events");
        this.starterEventsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.starterEventsItem);
        this.aboutBtn.setText("About");
        this.aboutBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutBtn);
        this.jMenuBar1.add(this.helpMenu);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Astor.this.exitForm(evt);
            }
        });
        this.jLabel1.setText("Control  :   ");
        this.jPanel1.add(this.jLabel1);
        this.allHostsControledBtn.setFont(new Font("Dialog", 1, 10));
        this.allHostsControledBtn.setText("  All  hosts  ");
        this.allHostsControledBtn.setToolTipText("Start Control on All Hosts");
        this.allHostsControledBtn.setBorder(new BevelBorder(0));
        this.allHostsControledBtn.setMargin(new Insets(2, 2, 2, 2));
        this.allHostsControledBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.allHostsControledBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.allHostsControledBtn);
        this.stopHostsControledBtn.setFont(new Font("Dialog", 1, 10));
        this.stopHostsControledBtn.setText("    None   ");
        this.stopHostsControledBtn.setToolTipText("Stop Control on All Hosts");
        this.stopHostsControledBtn.setBorder(new BevelBorder(0));
        this.stopHostsControledBtn.setMargin(new Insets(2, 2, 2, 2));
        this.stopHostsControledBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Astor.this.stopHostsControledBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.stopHostsControledBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void logviewerMenuItemActionPerformed(ActionEvent evt) {
        if (this.logviewer == null) {
            this.logviewer = new Main((JFrame)this);
        }
        this.logviewer.setVisible(true);
        this.logviewer.toFront();
    }

    private void jiveMenuItemActionPerformed(ActionEvent evt) {
        this.tree.displayDbaseInfo();
    }

    private void findByDeviceBtnActionPerformed(ActionEvent evt) {
        new DeviceTreeDialog(this, this.tree.hosts);
    }

    private void serversItemActionPerformed(ActionEvent evt) {
        if (ctrl_serv_d != null) {
            ctrl_serv_d.doClose();
        }
        ctrl_serv_d = new CtrlServersDialog(this, this.tree.hosts);
    }

    private void toolsItemActionPerformed(ActionEvent evt) {
        String name = evt.getActionCommand();
        for (int i = 0; i < this.app_tools.size(); ++i) {
            OneTool t = (OneTool)this.app_tools.elementAt(i);
            if (!t.name.equals(name)) continue;
            try {
                System.out.println("Starting " + t.classname);
                if (t.jframe == null) {
                    Class<?> cl = Class.forName(t.classname);
                    Class[] param = new Class[]{new JFrame().getClass()};
                    Constructor<?> contructor = cl.getConstructor(param);
                    JFrame[] argin = new JFrame[]{this};
                    Object obj = contructor.newInstance(argin);
                    JFrame jframe = (JFrame)obj;
                    t.setJFrame(jframe);
                    jframe.setVisible(true);
                    continue;
                }
                t.jframe.setVisible(true);
                continue;
            }
            catch (Exception e) {
                PopupError.show((Component)this, e);
            }
        }
    }

    void removeHost(String hostname) {
        if (JOptionPane.showConfirmDialog(this, "Are you sure to want to remove " + hostname, "Confirm Dialog", 0) != 0) {
            return;
        }
        String servname = "Starter/" + hostname;
        String devadmin = "dserver/" + servname;
        String devname = "tango/admin/" + hostname;
        try {
            DeviceProxy dev = new DeviceProxy(devname);
            dev.delete_property("StarteDsPath");
            dev.delete_property("HostCollection");
            Database db = ApiUtil.get_db_obj((String)AstorUtil.getTangoHost());
            db.delete_device(devname);
            db.delete_device(devadmin);
            db.delete_server(servname);
            JOptionPane.showMessageDialog(this, hostname + " has been removed !", "Command Done", 1);
            this.buildTree();
        }
        catch (DevFailed e) {
            PopupError.show((Component)this, e);
        }
    }

    private void newHostBtnActionPerformed(ActionEvent evt) {
        this.addNewHost(null);
    }

    void addNewHost(TangoHost h) {
        NewStarterDialog dialog = new NewStarterDialog(this, h, AstorTree.collec_names, this.tree.hosts, true);
        dialog.setVisible(true);
        if (dialog.getValue() == 0) {
            this.buildTree();
        }
    }

    void editHostProperties(TangoHost h) {
        NewStarterDialog dialog = new NewStarterDialog(this, h, AstorTree.collec_names, this.tree.hosts, false);
        dialog.setVisible(true);
    }

    private void stopServersBtnActionPerformed(ActionEvent evt) {
        new ServerCmdThread(this, this.tree.hosts, 1).start();
    }

    private void startServersBtnActionPerformed(ActionEvent evt) {
        new ServerCmdThread(this, this.tree.hosts, 0).start();
    }

    private void newBranchBtnActionPerformed(ActionEvent evt) {
        String branch_name = (String)JOptionPane.showInputDialog(this, "New Branch Name", "Input Dialog", 1, null, null, "");
        if (branch_name != null) {
            this.tree.addBranch(branch_name);
        }
    }

    private void helpActionPerformed(ActionEvent evt) {
        String item = evt.getActionCommand();
        if (item.equals(this.principleBtn.getText())) {
            PopupMessage.showImage((Component)this, (String)null, "/admin/img/principle.gif");
        } else if (item.equals(this.helpAppliBtn.getText())) {
            new PopupHtml(this).show(AstorUtil.getAppliHelpURL());
        } else if (item.equals(this.helpStarterBtn.getText())) {
            new PopupHtml(this).show(AstorUtil.getStarterHelpURL());
        } else if (item.equals(this.stateIconsBtn.getText())) {
            PopupMessage.showImage((Component)this, (String)null, "/admin/img/astor_state_icons.jpg");
        } else if (item.equals(this.tangorbBtn.getText())) {
            TangORBversion tangorb = null;
            try {
                tangorb = new TangORBversion();
            }
            catch (Exception e) {
                // empty catch block
            }
            String message = tangorb.jarfile + ":\n\n" + tangorb;
            PopupText txt = new PopupText((Frame)this, true);
            txt.setFont(new Font("Courier", 1, 14));
            AstorUtil.centerDialog((JDialog)txt, this);
            txt.show(message);
        } else if (item.equals(this.aboutBtn.getText())) {
            String message = "           Astor  (Tango Manager) \n\nThis programme is used to control, start and stop\n           the TANGO device servers. \n\n" + revNumber + "\n\n" + "Pascal Verdier - Software Engineering Group - ESRF";
            PopupMessage.showImage((Component)this, message, "/admin/img/tango_icon.jpg");
        } else if (item.equals(this.starterEventsItem.getText())) {
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < this.tree.hosts.length; ++i) {
                if (!this.tree.hosts[i].use_events) continue;
                v.add(this.tree.hosts[i].getName());
            }
            String title = null;
            String[] hostnames = null;
            if (v.size() == 0) {
                title = "There is no host controlled on events !";
            } else if (v.size() == this.tree.hosts.length) {
                title = "All hosts are controlled on events !";
            } else {
                title = "On " + this.tree.hosts.length + " hosts,\n" + v.size() + "  are controlled on events :";
                hostnames = new String[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    hostnames[i] = (String)v.elementAt(i);
                }
            }
            if (hostnames == null) {
                PopupMessage.show((Component)this, title);
            } else {
                new PopupText((Frame)this, true).show(title, hostnames, 300, 400);
            }
        } else {
            PopupMessage.show((Component)this, "Not implemented yet !");
        }
    }

    private void stopHostsControledBtnActionPerformed(ActionEvent evt) {
        if (this.tree != null) {
            for (int i = 0; i < this.tree.hosts.length; ++i) {
                this.tree.hosts[i].do_polling = false;
                this.tree.hostDialogs.close(this.tree.hosts[i]);
            }
            this.stopHostsControledBtn.setSelected(false);
        }
    }

    private void allHostsControledBtnActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.tree.hosts.length; ++i) {
            this.tree.hosts[i].do_polling = true;
        }
        this.allHostsControledBtn.setSelected(false);
    }

    private void expandBtnActionPerformed(ActionEvent evt) {
        this.expanded = !this.expanded;
        this.tree.expand(this.expanded);
        if (this.expanded) {
            this.expandBtn.setText("Collapse Tree");
        } else {
            this.expandBtn.setText("Expand Tree");
        }
    }

    private void changeTgHostBtnActionPerformed(ActionEvent evt) {
        String tango_host = AstorUtil.getTangoHost();
        if ((tango_host = (String)JOptionPane.showInputDialog(this, "New Tango Host (e.g.  hal:2001)", "Input Dialog", 1, null, null, tango_host)) != null) {
            AstorUtil.setTangoHost(tango_host);
            this.buildTree();
            StringBuffer stringBuffer = new StringBuffer().append("TANGO_HOST= ");
            AstorUtil.getInstance();
            System.out.println(stringBuffer.append(AstorUtil.getTangoHost()).toString());
        }
    }

    private void refreshBtnActionPerformed(ActionEvent evt) {
        this.buildTree();
    }

    private void exitBtnActionPerformed(ActionEvent evt) {
        this.doExit();
    }

    private void exitForm(WindowEvent evt) {
        this.doExit();
    }

    private void doExit() {
        this.setVisible(false);
        System.out.println("Astor exiting....");
        if (this.tree != null && this.tree.hosts != null) {
            for (int i = 0; i < this.tree.hosts.length; ++i) {
                if (i % 2 == 0) {
                    System.out.print("\\\r");
                } else {
                    System.out.print("/\r");
                }
                this.tree.hosts[i].stopThread();
                if (!this.tree.hosts[i].use_events) continue;
                try {
                    Thread.sleep(20L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        System.out.println(" ");
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                new AstorCmdLine(args);
            }
            catch (DevFailed e) {
                Except.print_exception((Exception)((Object)e));
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
            System.exit(0);
        }
        long t0 = System.currentTimeMillis();
        try {
            TangoWindow tw = new TangoWindow("ASTOR  Tango Manager");
            tw.setVisible(true);
            Astor astor = new Astor();
            astor.setVisible(true);
            displayed = true;
            tw.setVisible(false);
        }
        catch (InternalError e) {
            System.out.println(e);
        }
        long t1 = System.currentTimeMillis();
        System.out.println("Build  GUI :" + (t1 - t0) + " ms");
    }
}

