/*
 * Decompiled with CFR 0.152.
 */
package atkpanel;

import atkpanel.ImagePanel;
import atkpanel.SpectrumPanel;
import atkpanel.StringSpectrumPanel;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IScalarAttribute;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringSpectrum;
import fr.esrf.tangoatk.widget.attribute.ScalarListViewer;
import fr.esrf.tangoatk.widget.attribute.StateViewer;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.command.CommandComboViewer;
import fr.esrf.tangoatk.widget.device.StatusViewer;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;

public class MainPanel
extends JFrame {
    private final Splash splash = new Splash();
    private final int MIN_WIDTH = 220;
    private final int MAX_WIDTH = 570;
    private final int MIN_HEIGHT = 220;
    private final int MAX_HEIGHT = 570;
    private boolean standAlone = false;
    private boolean keepStateRefresher = true;
    private boolean operatorView = true;
    private boolean modifPropButton = true;
    private boolean roMode = false;
    private AttributeList all_scalar_atts;
    private AttributeList op_scalar_atts;
    private AttributeList exp_scalar_atts;
    private AttributeList state_status_atts;
    private AttributePolledList number_scalar_atts;
    private AttributeList all_spectrum_atts;
    private AttributeList op_spectrum_atts;
    private List all_spectrum_panels = null;
    private AttributeList all_number_image_atts;
    private AttributeList op_number_image_atts;
    private List all_image_panels = null;
    private CommandList all_cmdl;
    private CommandList op_cmdl;
    private Device panelDev;
    private ErrorHistory errorHistory;
    private ErrorPopup errorPopup;
    private JFrame trendFrame;
    private ScalarListViewer allScalarListViewer;
    private ScalarListViewer operatorScalarListViewer;
    private IDevStateScalar stateAtt = null;
    private IStringScalar statusAtt = null;
    private JMenuBar jMenuBar1;
    private JMenu jMenu1;
    private JMenuItem jMenuItem1;
    private JMenu jMenu3;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem3;
    private JMenuItem diagJMenuItem;
    private JMenu jMenu2;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem2;
    private JCheckBoxMenuItem expertCheckBoxMenuItem;
    private JCheckBoxMenuItem operatorCheckBoxMenuItem;
    private JMenu jMenu4;
    private JMenuItem jMenuItem4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private CommandComboViewer commandComboViewer1;
    private fr.esrf.tangoatk.widget.device.StateViewer devStateViewer;
    private StatusViewer devStatusViewer;
    private StateViewer attStateViewer;
    private fr.esrf.tangoatk.widget.attribute.StatusViewer attStatusViewer;
    private JTabbedPane jTabbedPane1;
    private JScrollPane jScrollPane1;
    private JPanel jPanel3;

    public MainPanel(String devName) {
        if (!this.connectDevice(devName)) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    public MainPanel(String[] args) {
        this(args[0]);
    }

    public MainPanel(String dev, boolean stda) {
        this.standAlone = stda;
        if (!this.connectDevice(dev)) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    public MainPanel(String[] args, boolean stda) {
        this.standAlone = stda;
        if (!this.connectDevice(args[0])) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    public MainPanel(String dev, boolean stda, boolean keepStateRef) {
        this.standAlone = stda;
        this.keepStateRefresher = keepStateRef;
        if (!this.connectDevice(dev)) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    public MainPanel(String dev, boolean stda, boolean keepStateRef, boolean modifProp) {
        this.standAlone = stda;
        this.keepStateRefresher = keepStateRef;
        this.modifPropButton = modifProp;
        if (!this.connectDevice(dev)) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    public MainPanel(String dev, boolean stda, boolean keepStateRef, boolean modifProp, boolean ro) {
        this.standAlone = stda;
        this.keepStateRefresher = keepStateRef;
        this.modifPropButton = modifProp;
        this.roMode = ro;
        if (ro) {
            this.modifPropButton = false;
        }
        if (!this.connectDevice(dev)) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    public MainPanel(String dev, Boolean stda, Boolean keepStateRef, Boolean modifProp, Boolean ro) {
        this.standAlone = stda;
        this.keepStateRefresher = keepStateRef;
        this.modifPropButton = modifProp;
        this.roMode = ro;
        if (ro.booleanValue()) {
            this.modifPropButton = false;
        }
        if (!this.connectDevice(dev)) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    private boolean connectDevice(String devName) {
        String message;
        this.splash.setTitle("AtkPanel  1.16");
        this.splash.setMessage("Waiting for device-name...");
        this.splash.initProgress();
        this.splash.setMaxProgress(12);
        if (devName == null) {
            devName = JOptionPane.showInputDialog(null, (Object)"Please type device name");
        }
        this.all_scalar_atts = new AttributeList();
        this.all_scalar_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                return entity instanceof IScalarAttribute || entity instanceof IBooleanScalar;
            }
        });
        this.op_scalar_atts = new AttributeList();
        this.op_scalar_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if ((entity instanceof IScalarAttribute || entity instanceof IBooleanScalar) && entity.isOperator()) {
                    String message = "Adding Operator scalar attributes(";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                    return true;
                }
                return false;
            }
        });
        this.exp_scalar_atts = new AttributeList();
        this.exp_scalar_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if ((entity instanceof IScalarAttribute || entity instanceof IBooleanScalar) && !entity.isOperator()) {
                    String message = "Adding Expert scalar attributes(";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                    return true;
                }
                return false;
            }
        });
        this.state_status_atts = new AttributeList();
        this.number_scalar_atts = new AttributePolledList();
        this.number_scalar_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof INumberScalar) {
                    String message = "Adding scalar attributes(";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                    return true;
                }
                return false;
            }
        });
        this.all_spectrum_atts = new AttributeList();
        this.all_spectrum_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof INumberSpectrum) {
                    if (entity instanceof INumberScalar) {
                        return false;
                    }
                    String message = "Adding to all_spectrum_atts : ";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice());
                    return true;
                }
                if (entity instanceof IStringSpectrum) {
                    String message = "Adding to all_spectrum_atts : ";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice());
                    return true;
                }
                return false;
            }
        });
        this.op_spectrum_atts = new AttributeList();
        this.op_spectrum_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof INumberSpectrum) {
                    if (entity instanceof INumberScalar) {
                        return false;
                    }
                    if (entity.isOperator()) {
                        String message = "Adding to op_spectrum_atts : ";
                        MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                        return true;
                    }
                } else if (entity instanceof IStringSpectrum && entity.isOperator()) {
                    String message = "Adding to op_spectrum_atts : ";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice());
                    return true;
                }
                return false;
            }
        });
        this.all_number_image_atts = new AttributeList();
        this.all_number_image_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof INumberImage) {
                    if (entity instanceof INumberSpectrum) {
                        return false;
                    }
                    String message = "Adding image attributes(";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                    return true;
                }
                return false;
            }
        });
        this.op_number_image_atts = new AttributeList();
        this.op_number_image_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof INumberImage) {
                    if (entity instanceof INumberSpectrum) {
                        return false;
                    }
                    if (entity.isOperator()) {
                        String message = "Adding image attributes(";
                        MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                        return true;
                    }
                }
                return false;
            }
        });
        this.all_cmdl = new CommandList();
        this.op_cmdl = new CommandList();
        this.op_cmdl.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof ICommand && entity.isOperator()) {
                    String message = "Adding Operator command (";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                    return true;
                }
                return false;
            }
        });
        this.panelDev = null;
        this.errorHistory = new ErrorHistory();
        this.errorPopup = new ErrorPopup();
        this.all_scalar_atts.addErrorListener((IErrorListener)this.errorHistory);
        this.all_scalar_atts.addSetErrorListener((ISetErrorListener)this.errorPopup);
        this.all_scalar_atts.addSetErrorListener((ISetErrorListener)this.errorHistory);
        this.state_status_atts.addErrorListener((IErrorListener)this.errorHistory);
        this.all_cmdl.addErrorListener((IErrorListener)this.errorHistory);
        this.all_cmdl.addErrorListener((IErrorListener)this.errorPopup);
        try {
            message = "Getting device " + devName + "...";
            this.splash.setMessage(message);
            this.panelDev = DeviceFactory.getInstance().getDevice(devName);
            this.splash.progress(1);
            this.splash.setMessage(message + "done");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Cannot connect to the device.\nCheck the device name you entered; Application will abort ...\nConnection Exception : " + e, "Connection to device failed", 0);
            System.out.println("AtkPanel: Cannot connect to the device.");
            System.out.println("AtkPanel: Check the device name you entered;");
            System.out.println("AtkPanel: Application aborted....");
            System.out.println("AtkPanel: Connection Exception : " + e);
            this.abortAppli();
            return false;
        }
        if (this.panelDev == null) {
            JOptionPane.showMessageDialog(null, "Cannot initialize the device object.\nCheck the device name you entered; Application will abort ...\n", "Device init failed", 0);
            System.out.println("AtkPanel: cannot initialize the device object.");
            System.out.println("AtkPanel: Check the device name you entered;");
            System.out.println("AtkPanel: Application aborted....");
            this.abortAppli();
            return false;
        }
        try {
            message = "Importing attributes from " + devName + "...";
            try {
                this.splash.setMessage(message);
                this.op_scalar_atts.add(devName + "/*");
                this.exp_scalar_atts.add(devName + "/*");
                this.number_scalar_atts.add(devName + "/*");
                this.splash.progress(4);
                this.all_spectrum_atts.add(devName + "/*");
                this.op_spectrum_atts.add(devName + "/*");
                this.splash.progress(5);
                this.all_number_image_atts.add(devName + "/*");
                this.op_number_image_atts.add(devName + "/*");
                this.splash.progress(6);
                this.splash.setMessage(message + "done");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Cannot build the attribute list.\nApplication will abort ...\nException received : " + e, "No Attribute Exception", 0);
                System.out.println("AtkPanel: Cannot build attribute list.");
                System.out.println("AtkPanel: Application aborted....");
                System.out.println("AtkPanel: Connection Exception : " + e);
                this.abortAppli();
                return false;
            }
            message = "Importing commands from " + devName + "...";
            this.all_cmdl.add(devName + "/*");
            this.op_cmdl.add(devName + "/*");
            this.splash.progress(7);
            this.splash.setMessage(message + "done");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Cannot build the command list.\nApplication will abort ...\nException received : " + e, "No Command Exception", 0);
            System.out.println("AtkPanel: Cannot build the command list.");
            System.out.println("AtkPanel: Application aborted....");
            System.out.println("AtkPanel: Connection Exception : " + e);
            this.abortAppli();
            return false;
        }
        this.setTitle("AtkPanel : " + devName);
        return true;
    }

    private void startUp() {
        String message = "Initializing commands...";
        this.splash.setMessage(message);
        this.createAllCmdList();
        if (this.all_cmdl.getSize() > 0) {
            if (this.operatorView) {
                this.show_operator_commands();
            } else {
                this.show_all_commands();
            }
        }
        if (this.roMode) {
            this.commandComboViewer1.setVisible(false);
        }
        this.splash.progress(8);
        this.splash.setMessage(message + "done");
        message = "Initializing scalar attributes...";
        this.splash.setMessage(message);
        this.allScalarListViewer = null;
        this.operatorScalarListViewer = null;
        this.createAllScalarListViewers();
        if (this.all_scalar_atts.getSize() > 0 && this.allScalarListViewer != null && this.operatorScalarListViewer != null) {
            if (this.operatorView) {
                this.show_operator_scalars();
                this.expertCheckBoxMenuItem.setState(false);
                this.operatorCheckBoxMenuItem.setState(true);
            } else {
                this.show_all_scalars();
                this.expertCheckBoxMenuItem.setState(true);
                this.operatorCheckBoxMenuItem.setState(false);
            }
        }
        try {
            this.stateAtt = (IDevStateScalar)this.state_status_atts.add(this.panelDev.getName() + "/State");
            this.statusAtt = (IStringScalar)this.state_status_atts.add(this.panelDev.getName() + "/Status");
        }
        catch (Exception e) {
            this.stateAtt = null;
            this.statusAtt = null;
        }
        if (this.stateAtt == null || this.statusAtt == null) {
            System.out.println("AtkPanel: Cannot get the State and / or Status attributes for the device.");
            System.out.println("AtkPanel: May be an old IDL 2 device server....");
            this.devStateViewer.setVisible(true);
            this.devStatusViewer.setVisible(true);
            this.attStateViewer.setVisible(false);
            this.attStatusViewer.setVisible(false);
        } else {
            this.devStateViewer.setVisible(false);
            this.devStatusViewer.setVisible(false);
            this.attStateViewer.setModel(this.stateAtt);
            this.attStatusViewer.setModel(this.statusAtt);
            this.attStateViewer.setVisible(true);
            this.attStatusViewer.setVisible(true);
            if (!this.stateAtt.hasEvents()) {
                this.state_status_atts.startRefresher();
            }
        }
        this.splash.progress(10);
        this.splash.setMessage(message + "done");
        message = "Initializing number spectrum attributes...";
        this.splash.setMessage(message);
        this.createAllSpectrumTabs();
        if (this.all_spectrum_atts.getSize() > 0) {
            if (this.operatorView) {
                this.show_operator_spectrums();
            } else {
                this.show_all_spectrums();
            }
        }
        this.splash.progress(11);
        this.splash.setMessage(message + "done");
        message = "Initializing number image attributes...";
        this.splash.setMessage(message);
        this.createAllNumberImageTabs();
        if (this.all_number_image_atts.getSize() > 0) {
            if (this.operatorView) {
                this.show_operator_images();
            } else {
                this.show_all_images();
            }
        }
        if (this.all_scalar_atts.getSize() <= 0 && this.all_spectrum_atts.getSize() <= 0 && this.all_number_image_atts.getSize() <= 0) {
            this.jTabbedPane1.setVisible(false);
        }
        this.splash.progress(12);
        this.splash.setMessage(message + "done");
        this.splash.setMessage(message);
        this.splash.setVisible(false);
        this.pack();
        this.setVisible(true);
        this.all_scalar_atts.startRefresher();
        this.all_spectrum_atts.startRefresher();
        this.all_number_image_atts.startRefresher();
        Trend globalTrend = new Trend(this.trendFrame);
        globalTrend.setModel(this.number_scalar_atts);
        this.trendFrame = null;
        this.trendFrame = new JFrame();
        JPanel jp = new JPanel();
        this.trendFrame.getContentPane().add((Component)jp, "Center");
        jp.setPreferredSize(new Dimension(600, 300));
        jp.setLayout(new GridBagLayout());
        GridBagConstraints trendGbc = new GridBagConstraints();
        trendGbc.gridx = 0;
        trendGbc.gridy = 0;
        trendGbc.fill = 1;
        trendGbc.weightx = 1.0;
        trendGbc.weighty = 1.0;
        jp.add((Component)globalTrend, trendGbc);
        this.trendFrame.pack();
    }

    private void initComponents() {
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.diagJMenuItem = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.expertCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.operatorCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jMenu4 = new JMenu();
        this.jMenuItem4 = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.commandComboViewer1 = new CommandComboViewer();
        this.devStateViewer = new fr.esrf.tangoatk.widget.device.StateViewer();
        this.devStatusViewer = new StatusViewer();
        this.attStateViewer = new StateViewer();
        this.attStatusViewer = new fr.esrf.tangoatk.widget.attribute.StatusViewer();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.devStateViewer.setStateClickable(false);
        this.devStatusViewer.setPreferredSize(new Dimension(50, 100));
        this.attStatusViewer.setPreferredSize(new Dimension(50, 100));
        this.jMenu1.setText("File");
        this.jMenuItem1.setText("Quit");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu3.setText("View");
        this.jMenuItem5.setText("Trends ");
        this.jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.viewTrendActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem5);
        this.jMenuItem3.setText("Error History");
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.viewErrHistoryActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem3);
        this.diagJMenuItem.setText("Diagnostic ...");
        this.diagJMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ATKDiagnostic.showDiagnostic();
            }
        });
        this.jMenu3.add(this.diagJMenuItem);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu2.setText("Preferences");
        this.jMenuItem6.setText("Stop   Refreshing");
        this.jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.stopStartRefreshActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem6);
        this.jMenuItem7.setText("Refresh  once");
        this.jMenuItem7.setEnabled(false);
        this.jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.refreshOnceActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem7);
        this.jMenuItem2.setText("Set refreshing period ...");
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.refPeriodActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem2);
        JSeparator jsep = new JSeparator();
        this.jMenu2.add(jsep);
        this.operatorCheckBoxMenuItem.setSelected(true);
        this.operatorCheckBoxMenuItem.setText("Operator  View");
        this.operatorCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.operatorCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.operatorCheckBoxMenuItem);
        this.expertCheckBoxMenuItem.setSelected(false);
        this.expertCheckBoxMenuItem.setText("Expert  View");
        this.expertCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.expertCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.expertCheckBoxMenuItem);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu4.setText("Help");
        this.jMenuItem4.setText("On Version ...");
        this.jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.helpVersionActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jMenuItem4);
        this.jMenuBar1.add(this.jMenu4);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MainPanel.this.exitForm(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(22, 22));
        this.jPanel2.setLayout(new GridBagLayout());
        JPanel dummyPanel1 = new JPanel();
        JPanel dummyPanel2 = new JPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.attStateViewer, gridBagConstraints2);
        this.devStateViewer.setModel(this.panelDev);
        this.jPanel2.add((Component)this.devStateViewer, gridBagConstraints2);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.commandComboViewer1, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.5;
        gridBagConstraints2.weighty = 0.0;
        this.jPanel2.add((Component)dummyPanel1, gridBagConstraints2);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.5;
        gridBagConstraints2.weighty = 0.0;
        this.jPanel2.add((Component)dummyPanel2, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridwidth = 4;
        this.jPanel2.add((Component)this.attStatusViewer, gridBagConstraints2);
        this.devStatusViewer.setModel(this.panelDev);
        this.jPanel2.add((Component)this.devStatusViewer, gridBagConstraints2);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 0.01;
        gridBagConstraints1.weighty = 0.01;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints1);
        this.jTabbedPane1.setTabPlacement(3);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jPanel3);
        this.jTabbedPane1.addTab("Scalar", this.jScrollPane1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.jPanel1.add((Component)this.jTabbedPane1, gridBagConstraints1);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void refreshOnceActionPerformed(ActionEvent evt) {
        this.all_scalar_atts.refresh();
        this.all_spectrum_atts.refresh();
        this.all_number_image_atts.refresh();
        if (this.devStateViewer.isVisible() || this.devStatusViewer.isVisible()) {
            DeviceFactory.getInstance().refresh();
        } else if (this.stateAtt != null && this.statusAtt != null && !this.stateAtt.hasEvents()) {
            this.state_status_atts.refresh();
        }
    }

    private void stopStartRefreshActionPerformed(ActionEvent evt) {
        JMenuItem menuButton = (JMenuItem)evt.getSource();
        if (menuButton.getText().equalsIgnoreCase("Stop   Refreshing")) {
            menuButton.setText("Start   Refreshing");
            this.jMenuItem7.setEnabled(true);
            this.all_scalar_atts.stopRefresher();
            this.all_spectrum_atts.stopRefresher();
            this.all_number_image_atts.stopRefresher();
            if (this.devStateViewer.isVisible() || this.devStatusViewer.isVisible()) {
                if (!this.keepStateRefresher) {
                    DeviceFactory.getInstance().stopRefresher();
                }
            } else if (this.stateAtt != null && this.statusAtt != null && !this.stateAtt.hasEvents()) {
                this.state_status_atts.stopRefresher();
            }
        } else {
            menuButton.setText("Stop   Refreshing");
            this.jMenuItem7.setEnabled(false);
            this.all_scalar_atts.startRefresher();
            this.all_spectrum_atts.startRefresher();
            this.all_number_image_atts.startRefresher();
            if (this.devStateViewer.isVisible() || this.devStatusViewer.isVisible()) {
                DeviceFactory.getInstance().startRefresher();
            } else if (this.stateAtt != null && this.statusAtt != null && !this.stateAtt.hasEvents()) {
                this.state_status_atts.startRefresher();
            }
        }
    }

    private void helpVersionActionPerformed(ActionEvent evt) {
        String versionText = new String("$Revision: 1.16 $");
        int colon_idx = versionText.lastIndexOf(":");
        int dollar_idx = versionText.lastIndexOf("$");
        String versNumber = versionText.substring(colon_idx + 1, dollar_idx);
        try {
            JOptionPane.showMessageDialog(this, "\n\n   atkpanel   : " + versNumber + "\n\n   ESRF  :   Computing  Services \n\n", "atkpanel   Version", -1);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void viewTrendActionPerformed(ActionEvent evt) {
        this.trendFrame.setVisible(true);
    }

    private void refPeriodActionPerformed(ActionEvent evt) {
        String refp_str;
        int ref_period = -1;
        ref_period = this.all_scalar_atts.getRefreshInterval();
        if (ref_period == -1) {
            ref_period = this.all_spectrum_atts.getRefreshInterval();
        }
        if (ref_period == -1) {
            ref_period = this.all_number_image_atts.getRefreshInterval();
        }
        if ((refp_str = JOptionPane.showInputDialog(this, "Enter refresh interval (ms)", new Integer(ref_period))) != null) {
            try {
                int it = Integer.parseInt(refp_str);
                this.all_scalar_atts.setRefreshInterval(it);
                this.all_spectrum_atts.setRefreshInterval(it);
                this.all_number_image_atts.setRefreshInterval(it);
                if (!(this.devStateViewer.isVisible() || this.devStatusViewer.isVisible() || this.stateAtt == null || this.statusAtt == null || this.stateAtt.hasEvents())) {
                    this.state_status_atts.setRefreshInterval(it);
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Invalid number !", "Error", 0);
                return;
            }
        }
    }

    private void viewErrHistoryActionPerformed(ActionEvent evt) {
        this.errorHistory.setVisible(true);
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        if (this.standAlone) {
            System.exit(0);
        } else {
            this.all_scalar_atts.stopRefresher();
            this.all_spectrum_atts.stopRefresher();
            this.all_number_image_atts.stopRefresher();
            if (this.devStateViewer.isVisible() || this.devStatusViewer.isVisible()) {
                if (!this.keepStateRefresher) {
                    DeviceFactory.getInstance().stopRefresher();
                }
            } else if (this.stateAtt != null && this.statusAtt != null && !this.stateAtt.hasEvents()) {
                this.state_status_atts.stopRefresher();
            }
            this.dispose();
        }
    }

    private void expertCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        if (this.all_cmdl.getSize() > 0) {
            this.show_all_commands();
        }
        if (this.all_number_image_atts.getSize() > 0) {
            this.show_all_images();
        }
        if (this.all_spectrum_atts.getSize() > 0) {
            this.show_all_spectrums();
        }
        if (this.all_scalar_atts.getSize() > 0) {
            this.show_all_scalars();
        }
        this.expertCheckBoxMenuItem.setState(true);
        this.operatorCheckBoxMenuItem.setState(false);
    }

    private void operatorCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        if (this.all_cmdl.getSize() > 0) {
            this.show_operator_commands();
        }
        if (this.all_number_image_atts.getSize() > 0) {
            this.show_operator_images();
        }
        if (this.all_spectrum_atts.getSize() > 0) {
            this.show_operator_spectrums();
        }
        if (this.all_scalar_atts.getSize() > 0) {
            this.show_operator_scalars();
        }
        this.expertCheckBoxMenuItem.setState(false);
        this.operatorCheckBoxMenuItem.setState(true);
    }

    private void exitForm(WindowEvent evt) {
        if (this.standAlone) {
            System.exit(0);
        } else {
            this.all_scalar_atts.stopRefresher();
            this.all_spectrum_atts.stopRefresher();
            this.all_number_image_atts.stopRefresher();
            if (this.devStateViewer.isVisible() || this.devStatusViewer.isVisible()) {
                if (!this.keepStateRefresher) {
                    DeviceFactory.getInstance().stopRefresher();
                }
            } else if (this.stateAtt != null && this.statusAtt != null && !this.stateAtt.hasEvents()) {
                this.state_status_atts.stopRefresher();
            }
            this.dispose();
        }
    }

    private void abortAppli() {
        if (this.standAlone) {
            System.exit(-1);
        } else {
            this.all_scalar_atts.stopRefresher();
            this.all_spectrum_atts.stopRefresher();
            this.all_number_image_atts.stopRefresher();
            if (this.devStateViewer.isVisible() || this.devStatusViewer.isVisible()) {
                if (!this.keepStateRefresher) {
                    DeviceFactory.getInstance().stopRefresher();
                }
            } else if (this.stateAtt != null && this.statusAtt != null && !this.stateAtt.hasEvents()) {
                this.state_status_atts.stopRefresher();
            }
            this.dispose();
        }
    }

    private void createAllScalarListViewers() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.allScalarListViewer = null;
        this.operatorScalarListViewer = null;
        if (this.op_scalar_atts.getSize() <= 0 && this.exp_scalar_atts.getSize() <= 0) {
            JLabel noatt = new JLabel();
            noatt.setText("No   attribute ");
            noatt.setFont(new Font("Helvetica", 0, 18));
            noatt.setForeground(Color.black);
            this.jPanel3.add((Component)noatt, gbc);
        } else {
            int ind = 0;
            while (ind < this.op_scalar_atts.getSize()) {
                IEntity ie = (IEntity)this.op_scalar_atts.get(ind);
                this.all_scalar_atts.add(ie);
                ++ind;
            }
            int ind2 = 0;
            while (ind2 < this.exp_scalar_atts.getSize()) {
                IEntity ie = (IEntity)this.exp_scalar_atts.get(ind2);
                this.all_scalar_atts.add(ie);
                ++ind2;
            }
            this.allScalarListViewer = new ScalarListViewer();
            this.operatorScalarListViewer = new ScalarListViewer();
            if (!this.modifPropButton) {
                this.allScalarListViewer.setPropertyButtonVisible(false);
                this.operatorScalarListViewer.setPropertyButtonVisible(false);
            }
            if (this.roMode) {
                this.allScalarListViewer.setSetterVisible(false);
                this.operatorScalarListViewer.setSetterVisible(false);
            }
            this.allScalarListViewer.setTheFont(new Font("Dialog", 0, 14));
            this.allScalarListViewer.setModel(this.all_scalar_atts);
            this.operatorScalarListViewer.setTheFont(new Font("Dialog", 0, 14));
            this.operatorScalarListViewer.setModel(this.op_scalar_atts);
        }
    }

    private void show_all_scalars() {
        int neededWidth = this.allScalarListViewer.getPreferredSize().width;
        int neededHeight = this.allScalarListViewer.getPreferredSize().height;
        if (neededWidth < 220) {
            neededWidth = 220;
        }
        if (neededWidth > 570) {
            neededWidth = 570;
        }
        if (neededHeight < 220) {
            neededHeight = 220;
        }
        if (neededHeight > 570) {
            neededHeight = 570;
        }
        this.jScrollPane1.setViewportView((Component)this.allScalarListViewer);
        this.jTabbedPane1.setPreferredSize(new Dimension(neededWidth + 30, neededHeight + 30));
        this.pack();
    }

    private void show_operator_scalars() {
        int neededWidth = this.operatorScalarListViewer.getPreferredSize().width;
        int neededHeight = this.operatorScalarListViewer.getPreferredSize().height;
        if (neededWidth < 220) {
            neededWidth = 220;
        }
        if (neededWidth > 570) {
            neededWidth = 570;
        }
        if (neededHeight < 220) {
            neededHeight = 220;
        }
        if (neededHeight > 570) {
            neededHeight = 570;
        }
        this.jScrollPane1.setViewportView((Component)this.operatorScalarListViewer);
        this.jTabbedPane1.setPreferredSize(new Dimension(neededWidth + 30, neededHeight + 30));
        this.pack();
    }

    private void createAllSpectrumTabs() {
        IEntity spectrum_att = null;
        INumberSpectrum nb_spectrum_att = null;
        IStringSpectrum str_spectrum_att = null;
        this.all_spectrum_panels = new Vector();
        int nb_atts = this.all_spectrum_atts.getSize();
        if (nb_atts > 0) {
            AttributeList all_sorted_spectrum_atts = new AttributeList();
            int ind = 0;
            while (ind < this.op_spectrum_atts.getSize()) {
                IEntity ie = (IEntity)this.op_spectrum_atts.get(ind);
                all_sorted_spectrum_atts.add(ie);
                ++ind;
            }
            int ind2 = 0;
            while (ind2 < this.all_spectrum_atts.getSize()) {
                IEntity ie = (IEntity)this.all_spectrum_atts.get(ind2);
                if (ie.isExpert()) {
                    all_sorted_spectrum_atts.add(ie);
                }
                ++ind2;
            }
            this.all_spectrum_atts = all_sorted_spectrum_atts;
        }
        nb_atts = this.all_spectrum_atts.getSize();
        int idx = 0;
        while (idx < nb_atts) {
            spectrum_att = (IEntity)this.all_spectrum_atts.getElementAt(idx);
            if (spectrum_att instanceof INumberSpectrum) {
                nb_spectrum_att = (INumberSpectrum)spectrum_att;
                SpectrumPanel sp_panel = new SpectrumPanel(nb_spectrum_att);
                this.jTabbedPane1.addTab(nb_spectrum_att.getNameSansDevice(), sp_panel);
                this.all_spectrum_panels.add(idx, sp_panel);
            } else if (spectrum_att instanceof IStringSpectrum) {
                str_spectrum_att = (IStringSpectrum)spectrum_att;
                StringSpectrumPanel str_sp_panel = new StringSpectrumPanel(str_spectrum_att);
                this.jTabbedPane1.addTab(str_spectrum_att.getNameSansDevice(), str_sp_panel);
                this.all_spectrum_panels.add(idx, str_sp_panel);
            }
            ++idx;
        }
    }

    private void show_operator_spectrums() {
        int nb_tabs = 0;
        Component specPanel = null;
        INumberSpectrum nSpecAtt = null;
        IStringSpectrum strSpecAtt = null;
        nb_tabs = this.jTabbedPane1.getTabCount();
        int ind = 1;
        while (ind < nb_tabs) {
            StringSpectrumPanel strsp;
            int specInd;
            specPanel = this.jTabbedPane1.getComponentAt(ind);
            if (specPanel instanceof SpectrumPanel) {
                SpectrumPanel sp = (SpectrumPanel)specPanel;
                nSpecAtt = sp.getModel();
                specInd = this.op_spectrum_atts.indexOf((Object)nSpecAtt);
                if (specInd < 0) {
                    this.jTabbedPane1.removeTabAt(ind);
                }
            } else if (specPanel instanceof StringSpectrumPanel && (specInd = this.op_spectrum_atts.indexOf((Object)(strSpecAtt = (strsp = (StringSpectrumPanel)specPanel).getModel()))) < 0) {
                this.jTabbedPane1.removeTabAt(ind);
            }
            ++ind;
        }
    }

    private void show_all_spectrums() {
        int nb_spectrums = 0;
        Object obj = null;
        Object spObj = null;
        SpectrumPanel specPanel = null;
        StringSpectrumPanel strspecPanel = null;
        INumberSpectrum nSpecAtt = null;
        IStringSpectrum strSpecAtt = null;
        nb_spectrums = this.all_spectrum_atts.getSize();
        int ind = 0;
        while (ind < nb_spectrums) {
            int specInd;
            obj = this.all_spectrum_atts.get(ind);
            if (obj instanceof INumberSpectrum) {
                nSpecAtt = (INumberSpectrum)obj;
                specInd = this.jTabbedPane1.indexOfTab(nSpecAtt.getNameSansDevice());
                if (specInd < 0 && (spObj = this.all_spectrum_panels.get(ind)) instanceof SpectrumPanel) {
                    specPanel = spObj;
                    this.jTabbedPane1.addTab(nSpecAtt.getNameSansDevice(), specPanel);
                }
            } else if (obj instanceof IStringSpectrum && (specInd = this.jTabbedPane1.indexOfTab((strSpecAtt = (IStringSpectrum)obj).getNameSansDevice())) < 0 && (spObj = this.all_spectrum_panels.get(ind)) instanceof StringSpectrumPanel) {
                strspecPanel = spObj;
                this.jTabbedPane1.addTab(strSpecAtt.getNameSansDevice(), strspecPanel);
            }
            ++ind;
        }
    }

    private void createAllNumberImageTabs() {
        INumberImage image_att = null;
        this.all_image_panels = new Vector();
        int nb_atts = this.all_number_image_atts.getSize();
        if (nb_atts > 0) {
            AttributeList all_sorted_image_atts = new AttributeList();
            int ind = 0;
            while (ind < this.op_number_image_atts.getSize()) {
                IEntity ie = (IEntity)this.op_number_image_atts.get(ind);
                all_sorted_image_atts.add(ie);
                ++ind;
            }
            int ind2 = 0;
            while (ind2 < this.all_number_image_atts.getSize()) {
                IEntity ie = (IEntity)this.all_number_image_atts.get(ind2);
                if (ie.isExpert()) {
                    all_sorted_image_atts.add(ie);
                }
                ++ind2;
            }
            this.all_number_image_atts = all_sorted_image_atts;
        }
        nb_atts = this.all_number_image_atts.getSize();
        int idx = 0;
        while (idx < nb_atts) {
            image_att = (INumberImage)this.all_number_image_atts.getElementAt(idx);
            ImagePanel att_tab = new ImagePanel(image_att);
            this.jTabbedPane1.addTab(image_att.getNameSansDevice(), att_tab);
            this.all_image_panels.add(idx, att_tab);
            ++idx;
        }
    }

    private void show_operator_images() {
        int nb_tabs = 0;
        Component imagePanel = null;
        INumberImage nImageAtt = null;
        nb_tabs = this.jTabbedPane1.getTabCount();
        int ind = 1;
        while (ind < nb_tabs) {
            ImagePanel ip;
            int imageInd;
            imagePanel = this.jTabbedPane1.getComponentAt(ind);
            if (imagePanel instanceof ImagePanel && (imageInd = this.op_number_image_atts.indexOf((Object)(nImageAtt = (ip = (ImagePanel)imagePanel).getModel()))) < 0) {
                this.jTabbedPane1.removeTabAt(ind);
            }
            ++ind;
        }
    }

    private void show_all_images() {
        int nb_images = 0;
        Object obj = null;
        Object imageObj = null;
        ImagePanel imagePanel = null;
        INumberImage nImageAtt = null;
        nb_images = this.all_number_image_atts.getSize();
        int ind = 0;
        while (ind < nb_images) {
            int imageInd;
            obj = this.all_number_image_atts.get(ind);
            if (obj instanceof INumberImage && (imageInd = this.jTabbedPane1.indexOfTab((nImageAtt = (INumberImage)obj).getNameSansDevice())) < 0 && (imageObj = this.all_image_panels.get(ind)) instanceof ImagePanel) {
                imagePanel = imageObj;
                this.jTabbedPane1.addTab(nImageAtt.getNameSansDevice(), imagePanel);
            }
            ++ind;
        }
    }

    private void createAllCmdList() {
        int nb_cmds = this.all_cmdl.getSize();
        if (nb_cmds > 0) {
            CommandList all_sorted_cmds = new CommandList();
            int ind = 0;
            while (ind < this.op_cmdl.getSize()) {
                IEntity ie = (IEntity)this.op_cmdl.get(ind);
                all_sorted_cmds.add(ie);
                ++ind;
            }
            int ind2 = 0;
            while (ind2 < this.all_cmdl.getSize()) {
                IEntity ie = (IEntity)this.all_cmdl.get(ind2);
                if (ie.isExpert()) {
                    all_sorted_cmds.add(ie);
                }
                ++ind2;
            }
            this.all_cmdl = all_sorted_cmds;
            this.commandComboViewer1.setModel(this.all_cmdl);
        } else {
            this.commandComboViewer1.setModel(null);
        }
    }

    private void show_operator_commands() {
        if (this.all_cmdl.getSize() > 0) {
            this.commandComboViewer1.setModel(this.op_cmdl);
        }
    }

    private void show_all_commands() {
        if (this.all_cmdl.getSize() > 0) {
            this.commandComboViewer1.setModel(this.all_cmdl);
        }
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            new MainPanel(null, true, false);
        } else if (args.length == 1) {
            new MainPanel(args[0], true, false);
        } else if (args[0].equalsIgnoreCase("-ro")) {
            new MainPanel(args[1], true, false, false, true);
        } else if (args[1].equalsIgnoreCase("-ro")) {
            new MainPanel(args[0], true, false, false, true);
        } else {
            new MainPanel(args[0], true, false);
        }
    }
}

