/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jive.DevWizard;
import jive.JiveUtils;
import jive.WizardPanel;

class PropertyPanel
extends WizardPanel
implements ActionListener {
    static final int CLASS_PROPERTY = 0;
    static final int DEVICE_PROPERTY = 1;
    JTextArea propValue;
    JScrollPane valueView;
    JButton setDefaultButton;
    JButton viewDefaultButton;
    int type;
    String entity;
    String description;
    String name;
    String defValue;
    String dbValue;
    String srvName;
    String devClass;

    public PropertyPanel(DevWizard devWizard, int n, String string, String string2, String string3, String string4, String string5, String string6) {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(350, 95));
        this.parent = devWizard;
        this.entity = string2;
        this.type = n;
        this.description = string4;
        this.name = string3;
        this.defValue = string5;
        this.dbValue = string5;
        this.srvName = string;
        this.devClass = string6;
        this.propValue = new JTextArea();
        this.propValue.setEditable(true);
        this.propValue.setBorder(BorderFactory.createLoweredBevelBorder());
        this.valueView = new JScrollPane(this.propValue);
        this.valueView.setBounds(0, 0, 230, 95);
        this.add(this.valueView);
        this.refreshValue();
        this.setDefaultButton = new JButton("Set Default");
        this.setDefaultButton.setMargin(new Insets(2, 1, 2, 1));
        this.setDefaultButton.setFont(DevWizard.wizFont);
        this.setDefaultButton.addActionListener(this);
        this.setDefaultButton.setBounds(235, 0, 115, 25);
        this.add(this.setDefaultButton);
        this.viewDefaultButton = new JButton("View Default");
        this.viewDefaultButton.setMargin(new Insets(2, 1, 2, 1));
        this.viewDefaultButton.setFont(DevWizard.wizFont);
        this.viewDefaultButton.addActionListener(this);
        this.viewDefaultButton.setBounds(235, 30, 115, 25);
        this.add(this.viewDefaultButton);
        this.panelIcon = n == 0 ? new ImageIcon(this.getClass().getResource("/jive/class_wz.gif")) : new ImageIcon(this.getClass().getResource("/jive/device_wz.gif"));
    }

    private void refreshValue() {
        DbDatum dbDatum = null;
        try {
            Database database = ApiUtil.get_db_obj();
            switch (this.type) {
                case 0: {
                    dbDatum = database.get_class_property(this.entity, this.name);
                    break;
                }
                case 1: {
                    dbDatum = database.get_device_property(this.entity, this.name);
                }
            }
            if (!dbDatum.is_empty()) {
                this.dbValue = dbDatum.extractString();
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
        this.propValue.setText(this.dbValue);
    }

    public void setEntityName(String string) {
        this.entity = string;
        this.refreshValue();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.setDefaultButton) {
            this.propValue.setText(this.defValue);
        } else if (object == this.viewDefaultButton) {
            JOptionPane.showMessageDialog(this, this.defValue, "Default value for " + this.name, 1);
        }
    }

    public String getTitle() {
        return "Property: " + this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getNextState() {
        return true;
    }

    public boolean next() {
        String string = this.propValue.getText();
        if (!string.equals(this.dbValue)) {
            DbDatum dbDatum = new DbDatum(this.name, string);
            DbDatum[] dbDatumArray = new DbDatum[]{dbDatum};
            try {
                Database database = ApiUtil.get_db_obj();
                switch (this.type) {
                    case 0: {
                        database.put_class_property(this.entity, dbDatumArray);
                        break;
                    }
                    case 1: {
                        database.put_device_property(this.entity, dbDatumArray);
                    }
                }
                System.out.println("Writting " + this.entity + "/" + this.name + " to database");
                this.dbValue = string;
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
                return false;
            }
        }
        return true;
    }

    public boolean back() {
        return true;
    }

    public String getSubTitle() {
        String string = "Server:\n " + this.srvName + "\n";
        switch (this.type) {
            case 0: {
                string = string + "Class:\n " + this.entity;
                break;
            }
            case 1: {
                string = string + "Class:\n " + this.devClass + "\n";
                string = string + "Device:\n " + this.entity;
            }
        }
        return string;
    }
}

