/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.Tango.DevSource;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import jive.DevHelperDevFailed;
import jive.ExtractHelper;

public class DevHelper
implements TangoConst {
    String id = "$Id: DevHelper.java,v 1.9 2005/09/08 06:23:50 pascal_verdier Exp $";
    DeviceProxy device;
    String device_name;
    CommandInfo[] commands;
    String[] attrs;
    AttributeInfo[] attr_configs = new AttributeInfo[0];
    String client_host;
    public static final String CMD_RESULT_FINISHED = "finished";
    public static final String CMD_INTERNAL = "MP_Jive_Internal";
    public static final String GET_TIMEOUT_CMD = "MP_Jive_Internal_Get_Timeout";
    public static final String SET_TIMEOUT_CMD = "MP_Jive_Internal_Set_Timeout";

    public DevHelper(String string) throws DevHelperDevFailed {
        this.device_name = string;
        try {
            this.client_host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.import_device();
    }

    private void import_device() throws DevHelperDevFailed {
        try {
            this.device = new DeviceProxy(this.device_name);
            this.device.set_transparency_reconnection(true);
        }
        catch (DevFailed devFailed) {
            throw new DevHelperDevFailed(devFailed);
        }
        CommandInfo[] commandInfoArray = null;
        try {
            commandInfoArray = this.device.command_list_query();
        }
        catch (DevFailed devFailed) {
            throw new DevHelperDevFailed(devFailed);
        }
        int n = commandInfoArray.length;
        this.commands = new CommandInfo[n + 3];
        DevCmdInfo devCmdInfo = new DevCmdInfo();
        int n2 = 0;
        devCmdInfo.cmd_name = "BlackBox";
        devCmdInfo.in_type = 3;
        devCmdInfo.in_type_desc = "Nb commands";
        devCmdInfo.out_type = 16;
        devCmdInfo.out_type_desc = "Last commands";
        this.commands[n2++] = new CommandInfo(devCmdInfo);
        devCmdInfo.cmd_name = "Info";
        devCmdInfo.in_type = 0;
        devCmdInfo.in_type_desc = "";
        devCmdInfo.out_type = 8;
        devCmdInfo.out_type_desc = "Device infos";
        this.commands[n2++] = new CommandInfo(devCmdInfo);
        devCmdInfo.cmd_name = "Ping";
        devCmdInfo.in_type = 0;
        devCmdInfo.in_type_desc = "";
        devCmdInfo.out_type = 8;
        devCmdInfo.out_type_desc = "Device alive";
        this.commands[n2++] = new CommandInfo(devCmdInfo);
        for (int i = 0; i < n; ++i) {
            this.commands[i + n2] = commandInfoArray[i];
        }
        try {
            this.attrs = this.device.get_attribute_list();
            this.attr_configs = this.device.get_attribute_info();
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("API_AttrNotFound")) {
                this.attrs = new String[0];
            }
            throw new DevHelperDevFailed(devFailed);
        }
    }

    public CommandInfo[] command_list_query() {
        return this.commands;
    }

    public String[] get_attribute_list() {
        return this.attrs;
    }

    public AttributeInfo[] get_attribute_config() {
        return this.attr_configs;
    }

    public String get_device_name() {
        return this.device_name;
    }

    public String exec_command(String string, String string2) throws DevHelperDevFailed, NumberFormatException {
        boolean bl;
        DeviceData deviceData;
        int n;
        long l = 0L;
        long l2 = 0L;
        String string3 = new String("");
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n = 0; n < this.commands.length && !string.equals(this.commands[n].cmd_name); ++n) {
        }
        if (n >= this.commands.length) {
            this.import_device();
            bl2 = true;
            for (n = 0; n < this.commands.length && !string.equals(this.commands[n].cmd_name); ++n) {
            }
            if (n >= this.commands.length) {
                throw new DevHelperDevFailed(new String("unknown command for that device"), new String("DevHelper"), new String("unknown command even after a re-import of the device"));
            }
        }
        try {
            deviceData = new DeviceData();
        }
        catch (DevFailed devFailed) {
            throw new DevHelperDevFailed(devFailed);
        }
        ExtractHelper.string_to_devicedata(string2, deviceData, this.commands[n].in_type);
        n2 = 0;
        do {
            block30: {
                bl = false;
                if (string.equals("BlackBox")) {
                    try {
                        String[] stringArray = null;
                        l = System.currentTimeMillis();
                        stringArray = this.device.black_box(Integer.parseInt(string2));
                        l2 = System.currentTimeMillis();
                        for (int i = 0; i < stringArray.length; ++i) {
                            string3 = string3 + stringArray[i] + "\n";
                        }
                    }
                    catch (DevFailed devFailed) {
                        if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl3)) {
                            bl = true;
                        }
                        throw new DevHelperDevFailed(devFailed);
                    }
                } else if (string.equals("Info")) {
                    try {
                        DevInfo devInfo = null;
                        l = System.currentTimeMillis();
                        devInfo = this.device.info();
                        l2 = System.currentTimeMillis();
                        string3 = string3 + "device class:   " + devInfo.dev_class + "\n";
                        string3 = string3 + "server id:      " + devInfo.server_id + "\n";
                        string3 = string3 + "server host:    " + devInfo.server_host + "\n";
                        string3 = string3 + "server version: " + devInfo.server_version + "\n";
                        string3 = string3 + "doc URL:        " + devInfo.doc_url + "\n";
                    }
                    catch (DevFailed devFailed) {
                        if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl3)) {
                            bl = true;
                        }
                        throw new DevHelperDevFailed(devFailed);
                    }
                } else if (string.equals("Ping")) {
                    try {
                        l = System.currentTimeMillis();
                        this.device.ping();
                        l2 = System.currentTimeMillis();
                        string3 = "Device ALIVE";
                    }
                    catch (DevFailed devFailed) {
                        if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl3)) {
                            bl = true;
                            break block30;
                        }
                        string3 = "Device NOT ALIVE";
                        l = 0L;
                        l2 = 0L;
                    }
                } else {
                    try {
                        int n3;
                        l = System.currentTimeMillis();
                        DeviceData deviceData2 = this.device.command_inout(string, deviceData);
                        l2 = System.currentTimeMillis();
                        try {
                            n3 = deviceData2.getType();
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            n3 = this.commands[n].out_type;
                        }
                        string3 = ExtractHelper.devicedata_to_string(deviceData2, n3);
                    }
                    catch (DevFailed devFailed) {
                        if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl3)) {
                            bl = true;
                        }
                        throw new DevHelperDevFailed(devFailed);
                    }
                }
            }
            if (n2 != 0 || !bl) continue;
            this.import_device();
            bl3 = true;
        } while (++n2 < 2 && bl);
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        String string4 = "";
        if (bl2 || bl3) {
            string4 = "   WARNING: device re-imported";
        }
        String string5 = "\n###################################\n" + simpleDateFormat.format(date) + string4 + "\n" + "From host   : " + this.client_host + "\n" + this.device_name + ": " + string + "\n" + "Duration    : " + Long.toString(l2 - l) + " (ms)\n";
        if (this.commands[n].out_type != 0) {
            string5 = string5 + "Out Argument(s):\n" + string3;
        }
        return string5;
    }

    public String read_attr(String string) throws DevHelperDevFailed {
        boolean bl;
        int n;
        String string2 = new String("");
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        boolean bl2 = false;
        for (n = 0; n < this.attr_configs.length && !string.equals(this.attr_configs[n].name); ++n) {
        }
        if (n >= this.attr_configs.length) {
            // empty if block
        }
        n2 = 0;
        do {
            bl = false;
            try {
                l = System.currentTimeMillis();
                DeviceAttribute deviceAttribute = this.device.read_attribute(string);
                l2 = System.currentTimeMillis();
                string2 = ExtractHelper.deviceattribute_to_string(deviceAttribute, this.attr_configs[n].writable, this.attr_configs[n].data_format, this.attr_configs[n].data_type);
            }
            catch (DevFailed devFailed) {
                if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl2)) {
                    bl = true;
                }
                throw new DevHelperDevFailed(devFailed);
            }
            if (n2 != 0 || !bl) continue;
            this.import_device();
            bl2 = true;
        } while (++n2 < 2 && bl);
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        String string3 = "";
        if (bl2) {
            string3 = "   WARNING: device re-imported";
        }
        String string4 = "\n###################################\n" + simpleDateFormat.format(date) + string3 + "\n" + "From host   : " + this.client_host + "\n" + this.device_name + ": " + string + "\n" + "Duration    : " + Long.toString(l2 - l) + " (ms)\n";
        string4 = string4 + "Out Argument(s):\n" + string2;
        return string4;
    }

    public String write_attr(String string, String string2) throws DevHelperDevFailed {
        boolean bl;
        int n;
        long l = 0L;
        long l2 = 0L;
        DeviceAttribute deviceAttribute = null;
        int n2 = 0;
        boolean bl2 = false;
        for (n = 0; n < this.attr_configs.length && !string.equals(this.attr_configs[n].name); ++n) {
        }
        if (n >= this.attr_configs.length) {
            this.import_device();
            for (n = 0; n < this.attr_configs.length && !string.equals(this.attr_configs[n].name); ++n) {
            }
            if (n >= this.attr_configs.length) {
                throw new DevHelperDevFailed(new String("unknown attribute for that device"), new String("DevHelper"), new String("unknown attribute even after a re-import of the device"));
            }
        }
        deviceAttribute = new DeviceAttribute(string, 0);
        ExtractHelper.string_to_deviceattribute(string2, deviceAttribute, this.attr_configs[n].data_format, this.attr_configs[n].data_type);
        n2 = 0;
        do {
            bl = false;
            try {
                l = System.currentTimeMillis();
                this.device.write_attribute(deviceAttribute);
                l2 = System.currentTimeMillis();
            }
            catch (DevFailed devFailed) {
                if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl2)) {
                    bl = true;
                }
                throw new DevHelperDevFailed(devFailed);
            }
            if (n2 != 0 || !bl) continue;
            this.import_device();
            bl2 = true;
        } while (++n2 < 2 && bl);
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        String string3 = "";
        if (bl2) {
            string3 = "   WARNING: device re-imported";
        }
        String string4 = "\n###################################\n" + simpleDateFormat.format(date) + string3 + "\n" + "From host   : " + this.client_host + "\n" + this.device_name + ": " + string + "\n" + "Duration    : " + Long.toString(l2 - l) + " (ms)\n";
        return string4;
    }

    public int get_timeout() throws DevHelperDevFailed {
        boolean bl;
        int n = 0;
        boolean bl2 = false;
        int n2 = -1;
        n = 0;
        do {
            bl = false;
            try {
                n2 = this.device.get_timeout_millis();
            }
            catch (DevFailed devFailed) {
                if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl2)) {
                    bl = true;
                }
                throw new DevHelperDevFailed(devFailed);
            }
            if (n != 0 || !bl) continue;
            this.import_device();
            bl2 = true;
        } while (++n < 2 && bl);
        return n2;
    }

    public int get_source() {
        DevSource devSource = this.device.get_source();
        switch (devSource.value()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 0: {
                return 2;
            }
        }
        return 1;
    }

    public void set_source(int n) {
        switch (n) {
            case 0: {
                this.device.set_source(DevSource.CACHE);
                break;
            }
            case 1: {
                this.device.set_source(DevSource.CACHE_DEV);
                break;
            }
            case 2: {
                this.device.set_source(DevSource.DEV);
            }
        }
    }

    public String set_timeout(String string) throws DevHelperDevFailed, NumberFormatException {
        boolean bl;
        int n = 0;
        boolean bl2 = false;
        long l = 0L;
        long l2 = 0L;
        int n2 = Integer.parseInt(string);
        n = 0;
        do {
            bl = false;
            try {
                l = System.currentTimeMillis();
                this.device.set_timeout_millis(n2);
                l2 = System.currentTimeMillis();
            }
            catch (DevFailed devFailed) {
                if (!(devFailed.errors[0].reason.toUpperCase().indexOf("COMM_FAILURE") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("OBJECT_NOT_EXIST") == -1 && devFailed.errors[0].reason.toUpperCase().indexOf("TRANSIENT") == -1 || bl2)) {
                    bl = true;
                }
                throw new DevHelperDevFailed(devFailed);
            }
            if (n != 0 || !bl) continue;
            this.import_device();
            bl2 = true;
        } while (++n < 2 && bl);
        String string2 = "";
        if (bl2) {
            string2 = "   WARNING: device re-imported";
        }
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        String string3 = "\n###################################\n" + simpleDateFormat.format(date) + string2 + "\n" + "From host   : " + this.client_host + "\n" + this.device_name + ": setting communication timeout" + "\n" + "Duration    : " + Long.toString(l2 - l) + " (ms)\n";
        string3 = string3 + "In  Argument(s):\n" + n2 + "\n";
        return string3;
    }
}

