/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.util;

import fr.esrf.tangoatk.util.BeanPropertyVerifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;

public class JarVerifier {
    static boolean error = false;

    public JarVerifier(String string) throws Exception {
        Iterator iterator = new Manifest(new File(string + "/META-INF/MANIFEST.MF")).getBeans();
        while (iterator.hasNext()) {
            Bean bean = (Bean)iterator.next();
            String string2 = bean.getName();
            File file = new File(string, string2 + ".class");
            if (!file.exists()) {
                System.err.println(string2 + " not found in jar");
                error = true;
            }
            string2 = string2.replace('/', '.');
            String string3 = string2 + "BeanInfo";
            String string4 = "Verifying " + string2;
            System.out.print(string4);
            int n = 0;
            while (n < 75 - string4.length()) {
                System.out.print(".");
                ++n;
            }
            if (new BeanPropertyVerifier(string2, string3).verify()) {
                System.out.println("Ok");
                continue;
            }
            System.out.println("Failed");
            error = true;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        new JarVerifier(stringArray[0]);
        if (error) {
            System.exit(1);
        }
        System.exit(0);
    }

    class Manifest {
        BufferedReader stream;

        public Manifest(File file) throws IOException {
            this.stream = new BufferedReader(new FileReader(file));
            while (!"".equals(this.stream.readLine())) {
            }
        }

        Iterator getBeans() {
            return new Iterator(this){
                String line;
                Bean bean;
                private final /* synthetic */ Manifest this$1;
                {
                    this.this$1 = manifest;
                }

                protected String getValue(String string) throws IOException {
                    while (this.line.startsWith(" ")) {
                        string = string + this.line.substring(1, this.line.length());
                        this.line = this.this$1.stream.readLine();
                    }
                    return string;
                }

                public Bean getBean() throws IOException {
                    String string = this.line.substring("Name: ".length(), this.line.length());
                    this.line = this.this$1.stream.readLine();
                    string = this.getValue(string);
                    if ("Java-Bean: True".equals(this.line.trim())) {
                        return Manifest.access$000(this.this$1).new Bean(string);
                    }
                    return null;
                }

                public boolean hasNext() {
                    try {
                        do {
                            this.line = this.this$1.stream.readLine();
                        } while (!this.line.startsWith("Name: "));
                        this.bean = this.getBean();
                        if (this.bean == null) {
                            return false;
                        }
                    }
                    catch (Exception exception) {
                        return false;
                    }
                    return true;
                }

                public Object next() {
                    return this.bean;
                }

                public void remove() {
                }
            };
        }

        static /* synthetic */ JarVerifier access$000(Manifest manifest) {
            return manifest.JarVerifier.this;
        }
    }

    class Bean {
        String name;

        Bean(String string) {
            this.name = string.substring(0, string.lastIndexOf(".class"));
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "Name: " + this.name + "\n" + "Java-Bean: True";
        }
    }
}

