/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.IStringSpectrum;
import fr.esrf.tangoatk.core.IStringSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.StringSpectrumHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class StringSpectrum
extends AAttribute
implements IStringSpectrum {
    StringSpectrumHelper stringSpectHelper = new StringSpectrumHelper(this);
    String[] stringValues = null;

    public void setStringSpectrumValue(String[] stringArray) {
        try {
            this.stringSpectHelper.insert(stringArray);
            this.writeAtt();
            this.refresh();
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
    }

    public String[] getStringSpectrumValue() {
        return this.stringValues;
    }

    public void addListener(IStringSpectrumListener iStringSpectrumListener) {
        this.stringSpectHelper.addStringSpectrumListener(iStringSpectrumListener);
        this.addStateListener(iStringSpectrumListener);
    }

    public void removeListener(IStringSpectrumListener iStringSpectrumListener) {
        this.stringSpectHelper.removeStringSpectrumListener(iStringSpectrumListener);
        this.removeStateListener(iStringSpectrumListener);
    }

    public void refresh() {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                this.readValueFromNetwork();
                this.stringValues = this.stringSpectHelper.extract();
                this.fireValueChanged(this.stringValues);
            }
            catch (DevFailed devFailed) {
                this.stringValues = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            this.stringValues = null;
            System.out.println("StringSpectrum.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("StringSpectrum.refresh()------------------------------------------------");
        }
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        block8: {
            ++this.periodicCount;
            DeviceAttribute deviceAttribute = null;
            try {
                deviceAttribute = tangoPeriodicEvent.getValue();
            }
            catch (DevFailed devFailed) {
                if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                    this.stringValues = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                } else {
                    this.stringValues = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                }
                return;
            }
            catch (Exception exception) {
                this.stringValues = null;
                System.out.println("StringSpectrum.periodic.getValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("StringSpectrum.periodic.getValue()------------------------------------------------");
                return;
            }
            if (deviceAttribute == null) break block8;
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.stringValues = deviceAttribute.extractStringArray();
                this.fireValueChanged(this.stringValues);
            }
            catch (DevFailed devFailed) {
                this.stringValues = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.stringValues = null;
                System.out.println("StringSpectrum.periodic.extractStringArray() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("StringSpectrum.periodic.extractStringArray()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        block8: {
            ++this.changeCount;
            DeviceAttribute deviceAttribute = null;
            try {
                deviceAttribute = tangoChangeEvent.getValue();
            }
            catch (DevFailed devFailed) {
                if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                    this.stringValues = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                } else {
                    this.stringValues = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                }
                return;
            }
            catch (Exception exception) {
                this.stringValues = null;
                System.out.println("StringSpectrum.change.getValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("StringSpectrum.change.getValue()------------------------------------------------");
                return;
            }
            if (deviceAttribute == null) break block8;
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.stringValues = deviceAttribute.extractStringArray();
                this.fireValueChanged(this.stringValues);
            }
            catch (DevFailed devFailed) {
                this.stringValues = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.stringValues = null;
                System.out.println("StringSpectrum.change.extractStringArray() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("StringSpectrum.change.extractStringArray()------------------------------------------------");
            }
        }
    }

    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(String[] stringArray) {
        this.propChanges.fireStringSpectrumEvent(this, stringArray, this.timeStamp);
    }

    public String getVersion() {
        return "$Id: StringSpectrum.java,v 1.6 2005/04/28 14:32:25 jlpons Exp $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

