/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeScalarHistory;
import fr.esrf.tangoatk.core.attribute.ANumberScalarHelper;
import fr.esrf.tangoatk.core.attribute.StringScalarHistory;
import java.util.Vector;

class StringAttributeHelper
extends ANumberScalarHelper {
    StringAttributeHelper(IAttribute iAttribute) {
        this.setAttribute(iAttribute);
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Double(Double.NaN), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Double(Double.NaN), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Double(Double.NaN), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Double(Double.NaN), bl);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Double(Double.NaN));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Double(Double.NaN));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Double(Double.NaN));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Double(Double.NaN));
    }

    void insert(double d) {
        this.attribute.getAttribute().insert(new Double(d).toString());
    }

    double getNumberScalarValue(DeviceAttribute deviceAttribute) {
        return Double.NaN;
    }

    double getNumberScalarSetPoint(DeviceAttribute deviceAttribute) {
        return Double.NaN;
    }

    protected StringScalarHistory[] getStringScalarAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        if (deviceDataHistoryArray.length <= 0) {
            return null;
        }
        Vector<StringScalarHistory> vector = new Vector<StringScalarHistory>();
        int n = 0;
        while (n < deviceDataHistoryArray.length) {
            StringScalarHistory stringScalarHistory = new StringScalarHistory();
            try {
                stringScalarHistory.setTimestamp(deviceDataHistoryArray[n].getTime());
            }
            catch (Exception exception) {
                stringScalarHistory.setTimestamp(0L);
            }
            try {
                AttrQuality attrQuality = deviceDataHistoryArray[n].getAttrQuality();
                if (0 == attrQuality.value()) {
                    stringScalarHistory.setState("VALID");
                } else if (1 == attrQuality.value()) {
                    stringScalarHistory.setState("INVALID");
                } else if (2 == attrQuality.value()) {
                    stringScalarHistory.setState("ALARM");
                } else if (4 == attrQuality.value()) {
                    stringScalarHistory.setState("WARNING");
                } else if (3 == attrQuality.value()) {
                    stringScalarHistory.setState("CHANGING");
                } else {
                    stringScalarHistory.setState("UNKNOWN");
                }
            }
            catch (Exception exception) {
                stringScalarHistory.setState("UNKNOWN");
            }
            try {
                stringScalarHistory.setValue(deviceDataHistoryArray[n].extractString());
            }
            catch (Exception exception) {
                stringScalarHistory.setValue(null);
            }
            vector.add(n, stringScalarHistory);
            ++n;
        }
        StringScalarHistory[] stringScalarHistoryArray = vector.toArray(new StringScalarHistory[0]);
        return stringScalarHistoryArray;
    }

    protected IAttributeScalarHistory[] getScalarAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        return this.getStringScalarAttHistory(deviceDataHistoryArray);
    }

    public String getStringScalarSetPoint(DeviceAttribute deviceAttribute) {
        String[] stringArray = null;
        try {
            stringArray = deviceAttribute.extractStringArray();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        if (stringArray == null) {
            return "???";
        }
        if (stringArray.length < 1) {
            return "???";
        }
        if (stringArray.length > 1) {
            return stringArray[1];
        }
        return stringArray[0];
    }

    public String getVersion() {
        return "$Id: StringAttributeHelper.java,v 1.7 2005/02/28 12:14:53 jlpons Exp $";
    }
}

