/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeScalarHistory;
import fr.esrf.tangoatk.core.INumberScalarHistory;
import fr.esrf.tangoatk.core.attribute.ANumberScalarHelper;
import fr.esrf.tangoatk.core.attribute.NumberScalarHistory;
import fr.esrf.tangoatk.core.attribute.ShortImageHelper;
import fr.esrf.tangoatk.core.attribute.ShortSpectrumHelper;
import java.util.Vector;

public class ShortScalarHelper
extends ANumberScalarHelper {
    ShortImageHelper imageHelper;

    public ShortScalarHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        super.init(iAttribute);
        this.spectrumHelper = new ShortSpectrumHelper(iAttribute);
        this.imageHelper = new ShortImageHelper(iAttribute);
    }

    void insert(double d) {
        this.attribute.getAttribute().insert((short)d);
    }

    double getNumberScalarValue(DeviceAttribute deviceAttribute) {
        try {
            return deviceAttribute.extractShortArray()[0];
        }
        catch (DevFailed devFailed) {
            return Double.NaN;
        }
    }

    double getNumberScalarSetPoint(DeviceAttribute deviceAttribute) {
        short[] sArray = null;
        try {
            sArray = deviceAttribute.extractShortArray();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        if (sArray == null) {
            return Double.NaN;
        }
        if (sArray.length < 1) {
            return Double.NaN;
        }
        if (sArray.length > 1) {
            return sArray[1];
        }
        return sArray[0];
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Short((short)d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Short((short)d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Short((short)d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Short((short)d));
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Short((short)d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Short((short)d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Short((short)d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Short((short)d), bl);
    }

    protected INumberScalarHistory[] getNumberScalarAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        if (deviceDataHistoryArray.length <= 0) {
            return null;
        }
        Vector<NumberScalarHistory> vector = new Vector<NumberScalarHistory>();
        int n = 0;
        while (n < deviceDataHistoryArray.length) {
            NumberScalarHistory numberScalarHistory = new NumberScalarHistory();
            try {
                numberScalarHistory.setTimestamp(deviceDataHistoryArray[n].getTime());
            }
            catch (Exception exception) {
                numberScalarHistory.setTimestamp(0L);
            }
            try {
                AttrQuality attrQuality = deviceDataHistoryArray[n].getAttrQuality();
                if (0 == attrQuality.value()) {
                    numberScalarHistory.setState("VALID");
                } else if (1 == attrQuality.value()) {
                    numberScalarHistory.setState("INVALID");
                } else if (2 == attrQuality.value()) {
                    numberScalarHistory.setState("ALARM");
                } else if (4 == attrQuality.value()) {
                    numberScalarHistory.setState("WARNING");
                } else if (3 == attrQuality.value()) {
                    numberScalarHistory.setState("CHANGING");
                } else {
                    numberScalarHistory.setState("UNKNOWN");
                }
            }
            catch (Exception exception) {
                numberScalarHistory.setState("UNKNOWN");
            }
            try {
                short s = deviceDataHistoryArray[n].extractShort();
                double d = s;
                numberScalarHistory.setValue(d);
            }
            catch (Exception exception) {
                numberScalarHistory.setValue(Double.NaN);
            }
            vector.add(n, numberScalarHistory);
            ++n;
        }
        INumberScalarHistory[] iNumberScalarHistoryArray = vector.toArray(new NumberScalarHistory[0]);
        return iNumberScalarHistoryArray;
    }

    protected IAttributeScalarHistory[] getScalarAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        return this.getNumberScalarAttHistory(deviceDataHistoryArray);
    }

    public String getVersion() {
        return "$Id: ShortScalarHelper.java,v 1.7 2005/02/28 12:14:53 jlpons Exp $";
    }
}

