/*
 * Decompiled with CFR 0.152.
 */
package atktuning;

import atktuning.TuningConfig;
import atktuning.TuningPanel;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MainPanel
extends JFrame
implements IErrorListener,
ISetErrorListener {
    private JPanel thePanel;
    private JScrollPane theView;
    private JMenuBar mainMenu;
    private Font theFont;
    private Font titleFont;
    private int nbPanel = 0;
    private TuningPanel[] panels;
    private boolean runFromShell;
    ErrorHistory errorHistory;
    private String appVersion = "AtkTuning 2.7";
    public AttributePolledList attList = null;

    public MainPanel(String filename) {
        this.runFromShell = false;
        this.initComponents(filename);
    }

    public MainPanel(String filename, boolean b) {
        this.runFromShell = b;
        this.initComponents(filename);
    }

    private void initComponents(String filename) {
        Splash splashScreen = null;
        try {
            int w;
            int i;
            this.errorHistory = new ErrorHistory();
            splashScreen = new Splash();
            splashScreen.setTitle(this.appVersion);
            splashScreen.setMessage("Reading " + filename + "...");
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.getContentPane().setLayout(null);
            this.setTitle(this.appVersion + "[" + filename + "]");
            String[][] list = this.readConfigFile(filename);
            this.nbPanel = list.length;
            this.theFont = new Font("Dialog", 0, 14);
            this.titleFont = new Font("Dialog", 1, 16);
            this.thePanel = new JPanel();
            this.thePanel.setBackground(this.getBackground());
            this.thePanel.setLayout(new FlowLayout());
            this.thePanel.setBorder(null);
            int max = 0;
            for (i = 0; i < this.nbPanel; ++i) {
                if (list[i].length <= max) continue;
                max = list[i].length;
            }
            this.attList = new AttributePolledList();
            this.attList.addErrorListener((IErrorListener)this.errorHistory);
            this.attList.addSetErrorListener((ISetErrorListener)this);
            IEntityFilter attfilter = new IEntityFilter(){

                public boolean keep(IEntity entity) {
                    if (entity instanceof INumberScalar) {
                        return true;
                    }
                    System.out.println(entity.getName() + " not supported.");
                    return false;
                }
            };
            this.attList.setFilter(attfilter);
            this.panels = new TuningPanel[this.nbPanel];
            for (i = 0; i < this.nbPanel; ++i) {
                splashScreen.setMessage("Panel " + (i + 1) + "/" + this.nbPanel + ":");
                TuningConfig cfg = new TuningConfig(list[i], this.runFromShell, splashScreen, (AttributeList)this.attList, this);
                this.panels[i] = new TuningPanel(cfg, this.theFont, this.titleFont, max * 32, this);
                this.thePanel.add(this.panels[i]);
            }
            this.attList.startRefresher();
            if (this.runFromShell) {
                DeviceFactory.getInstance().stopRefresher();
            }
            splashScreen.progress(100);
            this.mainMenu = new JMenuBar();
            JMenu jMenu1 = new JMenu();
            JMenu jMenu2 = new JMenu();
            JMenu jMenu3 = new JMenu();
            JMenuItem jMenuItem1 = new JMenuItem();
            JMenuItem jMenuItem2 = new JMenuItem();
            JMenuItem jMenuItem3 = new JMenuItem();
            jMenu1.setText("File");
            jMenu2.setText("Options");
            jMenu3.setText("Trends");
            jMenuItem1.setText("Exit");
            jMenuItem2.setText("Set refresh interval");
            jMenuItem3.setText("View errors");
            JMenuItem jTrendMenuItem = new JMenuItem();
            jTrendMenuItem.setText("Show trends");
            jTrendMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MainPanel.this.showTrendAll();
                }
            });
            jMenu3.add(jTrendMenuItem);
            jMenuItem1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MainPanel.this.exitForm();
                }
            });
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MainPanel.this.setRefreshInterval();
                }
            });
            jMenuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MainPanel.this.errorHistory.setVisible(true);
                }
            });
            jMenu1.add(jMenuItem1);
            jMenu2.add(jMenuItem2);
            jMenu2.add(jMenuItem3);
            this.mainMenu.add(jMenu1);
            this.mainMenu.add(jMenu2);
            this.mainMenu.add(jMenu3);
            this.setJMenuBar(this.mainMenu);
            this.theView = new JScrollPane(this.thePanel);
            this.theView.setHorizontalScrollBarPolicy(32);
            this.theView.setVerticalScrollBarPolicy(20);
            this.getContentPane().add(this.theView);
            this.addComponentListener(new ComponentListener(){

                public void componentHidden(ComponentEvent e) {
                }

                public void componentMoved(ComponentEvent e) {
                }

                public void componentResized(ComponentEvent e) {
                    MainPanel.this.placeComponents();
                }

                public void componentShown(ComponentEvent e) {
                    MainPanel.this.placeComponents();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    MainPanel.this.exitForm();
                }
            });
            this.pack();
            Dimension d = this.thePanel.getPreferredSize();
            int h = d.height + 85;
            if (h > 768) {
                h = 768;
            }
            if ((w = d.width + 30) > 1024) {
                w = 1024;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension scrsize = toolkit.getScreenSize();
            Dimension appsize = new Dimension(w, h);
            int x = (scrsize.width - appsize.width) / 2;
            int y = (scrsize.height - appsize.height) / 2;
            this.setBounds(x, y, appsize.width, appsize.height);
            Image image = toolkit.getImage(this.getClass().getResource("/atktuning/icon.gif"));
            if (image != null) {
                this.setIconImage(image);
            }
            splashScreen.hide();
            this.setVisible(true);
        }
        catch (Exception e) {
            splashScreen.hide();
            ATKException ae = new ATKException(e);
            ErrorPane.showErrorMessage(null, (String)"AtkTuning", (ATKException)ae);
        }
    }

    private void showTrendAll() {
        JFrame f = new JFrame();
        Trend graph = new Trend(f);
        f.setTitle("Trends");
        graph.setModel(this.attList);
        f.setContentPane((Container)graph);
        f.pack();
        f.setSize(640, 480);
        f.setVisible(true);
    }

    private void placeComponents() {
        Dimension d = this.getContentPane().getSize();
        this.theView.setBounds(5, 5, d.width - 10, d.height - 10);
        this.theView.revalidate();
    }

    private void setRefreshInterval() {
        if (this.nbPanel <= 0) {
            return;
        }
        int old_it = this.attList.getRefreshInterval();
        String i = JOptionPane.showInputDialog(this, "Enter refresh interval (ms)", new Integer(old_it));
        if (i != null) {
            try {
                int it = Integer.parseInt(i);
                this.attList.setRefreshInterval(it);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, i + " invalid nunber.", "Error", 0);
            }
        }
    }

    private String[][] readConfigFile(String filename) {
        FileReader f = null;
        Vector items = new Vector();
        try {
            f = new FileReader(filename);
        }
        catch (FileNotFoundException e) {
            this.fatalError(filename + " not found.");
        }
        String s = this.readLine(f);
        if (s != null) {
            Vector<String> attlist;
            if (s.startsWith("#")) {
                boolean eof = false;
                while (!eof) {
                    attlist = new Vector();
                    String title = s.substring(1);
                    attlist.add(title);
                    boolean eop = false;
                    while (!eop) {
                        s = this.readLine(f);
                        if (s != null) {
                            eop = s.startsWith("#");
                            if (eop) continue;
                            attlist.add(s);
                            continue;
                        }
                        eof = true;
                        eop = true;
                    }
                    items.add(attlist);
                }
            } else {
                attlist = new Vector<String>();
                attlist.add(s);
                while ((s = this.readLine(f)) != null) {
                    attlist.add(s);
                }
                items.add(attlist);
            }
        }
        try {
            f.close();
        }
        catch (IOException e) {
            System.out.println("Warning " + e.getMessage());
        }
        String[][] ret = new String[items.size()][];
        for (int i = 0; i < items.size(); ++i) {
            Vector lst = (Vector)items.get(i);
            ret[i] = new String[lst.size()];
            for (int j = 0; j < lst.size(); ++j) {
                ret[i][j] = (String)lst.get(j);
            }
        }
        return ret;
    }

    private String readLine(FileReader f) {
        int c = 0;
        String result = "";
        boolean eor = false;
        while (!eor) {
            boolean ok;
            try {
                c = f.read();
            }
            catch (IOException e) {
                this.fatalError(f.toString() + " " + e.getMessage());
            }
            boolean bl = ok = c >= 32;
            if (ok) {
                result = result + (char)c;
            }
            eor = c == -1 || !ok && result.length() > 0;
        }
        if (result.length() > 0) {
            return result;
        }
        return null;
    }

    public String getErrorSource(ErrorEvent evt) {
        Object o = evt.getSource();
        if (o instanceof IEntity) {
            IEntity src = (IEntity)o;
            return "Error from " + src.getName();
        }
        if (o instanceof Device) {
            Device src = (Device)o;
            return "Error from " + src.getName();
        }
        if (o instanceof String) {
            return "Error from " + (String)o;
        }
        return "Error from unkown source :" + evt.getSource();
    }

    public void errorChange(ErrorEvent evt) {
        this.setErrorOccured(evt);
    }

    public void setErrorOccured(ErrorEvent evt) {
        JOptionPane.showMessageDialog(this, evt.getError().getMessage(), this.getErrorSource(evt), 0);
    }

    private void fatalError(String message) {
        JOptionPane.showMessageDialog(null, message, "Fatal Error", 0);
        this.exitForm();
    }

    private void exitForm() {
        if (this.runFromShell) {
            System.exit(0);
        } else {
            if (this.attList != null) {
                this.attList.stopRefresher();
                this.attList = null;
            }
            this.hide();
            this.dispose();
        }
    }

    public void printParams() {
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: AtkTuning [-?] config_filename");
            System.exit(0);
        }
        if ("-?".equals(args[0])) {
            System.out.println("Usage: AtkTuning [-?] config_filename");
            System.out.println("  The config file is a list of tango attributes, each line is");
            System.out.println("  an attribute name (ex: eas/test-api/1/Long_attr).");
            System.out.println("  AtkTuning supports only number scalar attributes.");
            System.out.println("  The first line of the config file is the panel title.");
            System.out.println("  Sine the version 2.0, AtkTuning also supports multiple panels");
            System.out.println("  Configuration file examples:");
            System.out.println("   Version1                      Version2 (AtkTunig >2.0)");
            System.out.println("  Test panel                     #Test panel1");
            System.out.println("  jlp/test/1/att_un              jlp/test/1/att_un");
            System.out.println("  jlp/test/1/att_deux            jlp/test/1/att_deux");
            System.out.println("  jlp/test/1/att_trois           #Test panel 2");
            System.out.println("  jlp/test/1/att_quatre          jlp/test/1/att_trois");
            System.out.println("                                 jlp/test/2/att_un");
            System.exit(0);
        }
        new MainPanel(args[0], true);
    }
}

