/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeScalarHistory;
import fr.esrf.tangoatk.core.INumberScalarHistory;
import fr.esrf.tangoatk.core.attribute.ANumberScalarHelper;
import fr.esrf.tangoatk.core.attribute.NumberScalarHistory;
import fr.esrf.tangoatk.core.attribute.UShortImageHelper;
import fr.esrf.tangoatk.core.attribute.UShortSpectrumHelper;
import java.util.Vector;

public class UShortScalarHelper
extends ANumberScalarHelper {
    UShortImageHelper imageHelper;

    public UShortScalarHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        super.init(iAttribute);
        this.spectrumHelper = new UShortSpectrumHelper(iAttribute);
        this.imageHelper = new UShortImageHelper(iAttribute);
    }

    void insert(double d) {
        this.attribute.getAttribute().insert_us((int)d);
    }

    double getNumberScalarValue(DeviceAttribute deviceAttribute) {
        try {
            return deviceAttribute.extractUShortArray()[0];
        }
        catch (DevFailed devFailed) {
            return Double.NaN;
        }
    }

    double getNumberScalarSetPoint(DeviceAttribute deviceAttribute) {
        int[] nArray = null;
        try {
            nArray = deviceAttribute.extractUShortArray();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        if (nArray == null) {
            return Double.NaN;
        }
        if (nArray.length < 1) {
            return Double.NaN;
        }
        if (nArray.length > 1) {
            return nArray[1];
        }
        return nArray[0];
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Integer((int)d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Integer((int)d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Integer((int)d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Integer((int)d));
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Integer((int)d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Integer((int)d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Integer((int)d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Integer((int)d), bl);
    }

    protected INumberScalarHistory[] getNumberScalarAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        if (deviceDataHistoryArray.length <= 0) {
            return null;
        }
        Vector<NumberScalarHistory> vector = new Vector<NumberScalarHistory>();
        int n = 0;
        while (n < deviceDataHistoryArray.length) {
            NumberScalarHistory numberScalarHistory = new NumberScalarHistory();
            try {
                numberScalarHistory.setTimestamp(deviceDataHistoryArray[n].getTime());
            }
            catch (Exception exception) {
                numberScalarHistory.setTimestamp(0L);
            }
            try {
                AttrQuality attrQuality = deviceDataHistoryArray[n].getAttrQuality();
                if (0 == attrQuality.value()) {
                    numberScalarHistory.setState("VALID");
                } else if (1 == attrQuality.value()) {
                    numberScalarHistory.setState("INVALID");
                } else if (2 == attrQuality.value()) {
                    numberScalarHistory.setState("ALARM");
                } else if (4 == attrQuality.value()) {
                    numberScalarHistory.setState("WARNING");
                } else if (3 == attrQuality.value()) {
                    numberScalarHistory.setState("CHANGING");
                } else {
                    numberScalarHistory.setState("UNKNOWN");
                }
            }
            catch (Exception exception) {
                numberScalarHistory.setState("UNKNOWN");
            }
            try {
                short s = deviceDataHistoryArray[n].extractUShort();
                double d = s;
                numberScalarHistory.setValue(d);
            }
            catch (Exception exception) {
                numberScalarHistory.setValue(Double.NaN);
            }
            vector.add(n, numberScalarHistory);
            ++n;
        }
        INumberScalarHistory[] iNumberScalarHistoryArray = vector.toArray(new NumberScalarHistory[0]);
        return iNumberScalarHistoryArray;
    }

    protected IAttributeScalarHistory[] getScalarAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        return this.getNumberScalarAttHistory(deviceDataHistoryArray);
    }

    public String getVersion() {
        return "$Id: UShortScalarHelper.java,v 1.1 2005/06/15 09:42:08 jlpons Exp $";
    }
}

